/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.jndi.deployers.resource.provider;

import java.util.Collection;
import java.util.HashSet;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.jndi.deployers.resolver.EJBBinderResolutionResult;
import org.jboss.ejb3.jndi.deployers.resolver.EJBBinderResolver;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.switchboard.impl.resource.LinkRefResource;
import org.jboss.switchboard.javaee.jboss.environment.JBossJavaEEResourceType;
import org.jboss.switchboard.spi.Resource;

public abstract class AbstractEJBResourceProvider {
    protected EJBBinderResolver ejbBinderResolver;

    public AbstractEJBResourceProvider(EJBBinderResolver ejbBinderResolver) {
        this.ejbBinderResolver = ejbBinderResolver;
    }

    protected Resource provideJndiNameBasedResource(DeploymentUnit unit, JBossJavaEEResourceType jbossJavaEEResourceRef) {
        String lookupName = jbossJavaEEResourceRef.getLookupName();
        if (lookupName != null && !lookupName.trim().isEmpty()) {
            return new LinkRefResource(lookupName, null, true);
        }
        String mappedName = jbossJavaEEResourceRef.getMappedName();
        if (mappedName != null && !mappedName.trim().isEmpty()) {
            return new LinkRefResource(mappedName, null, true);
        }
        String jndiName = jbossJavaEEResourceRef.getJNDIName();
        if (jndiName != null && !jndiName.trim().isEmpty()) {
            return new LinkRefResource(jndiName, null, true);
        }
        return null;
    }

    protected Collection<?> getInvocationDependencies(EJBBinderResolutionResult binderResolutionResult) {
        HashSet<String> invocationDependencies = new HashSet<String>();
        JBossEnterpriseBeanMetaData enterpriseBean = binderResolutionResult.getBeanMetadata();
        invocationDependencies.add(enterpriseBean.getContainerName());
        if (this.isEJB31SessionBean(enterpriseBean)) {
            JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)enterpriseBean;
            if (sessionBean.isSingleton()) {
                String singletonBeanJndiBinder = enterpriseBean.getContainerName() + ",type=singleton-bean-jndi-binder";
                invocationDependencies.add(singletonBeanJndiBinder);
            }
            String resolvedBusinessInterface = binderResolutionResult.getResolvedBusinessInterface();
            if (sessionBean.isNoInterfaceBean() && sessionBean.getEjbClass().equals(resolvedBusinessInterface)) {
                String nointerfaceViewJndiBinder = enterpriseBean.getContainerName() + ",type=nointerface-view-jndi-binder";
                invocationDependencies.add(nointerfaceViewJndiBinder);
            }
        }
        return invocationDependencies;
    }

    private boolean isEJB31SessionBean(JBossEnterpriseBeanMetaData enterpriseBean) {
        if (!enterpriseBean.getJBossMetaData().isEJB31()) {
            return false;
        }
        if (!enterpriseBean.isSession()) {
            return false;
        }
        return enterpriseBean instanceof JBossSessionBean31MetaData;
    }
}

