/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.ejb3.timer.schedule.IncrementValue;
import org.jboss.ejb3.timer.schedule.IntegerBasedExpression;
import org.jboss.ejb3.timer.schedule.ListValue;
import org.jboss.ejb3.timer.schedule.RangeValue;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionType;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionTypeUtil;
import org.jboss.ejb3.timer.schedule.SingleValue;

public class Hour
extends IntegerBasedExpression {
    public static final Integer MAX_HOUR = 23;
    public static final Integer MIN_HOUR = 0;
    private SortedSet<Integer> hours = new TreeSet<Integer>();
    private ScheduleExpressionType expressionType;

    public Hour(String value) {
        this.expressionType = ScheduleExpressionTypeUtil.getType(value);
        Set<Integer> hrs = null;
        switch (this.expressionType) {
            case RANGE: {
                RangeValue range = new RangeValue(value);
                hrs = this.processRangeValue(range);
                this.hours.addAll(hrs);
                break;
            }
            case LIST: {
                ListValue list = new ListValue(value);
                hrs = this.processListValue(list);
                this.hours.addAll(hrs);
                break;
            }
            case SINGLE_VALUE: {
                SingleValue singleValue = new SingleValue(value);
                Integer hour = this.processSingleValue(singleValue);
                this.hours.add(hour);
                break;
            }
            case INCREMENT: {
                IncrementValue incrValue = new IncrementValue(value);
                hrs = this.processIncrement(incrValue);
                this.hours.addAll(hrs);
                break;
            }
            case WILDCARD: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for hour: " + value);
            }
        }
    }

    public Calendar getNextHour(Calendar current) {
        GregorianCalendar next = new GregorianCalendar(current.getTimeZone());
        next.setTime(current.getTime());
        Integer currentHour = current.get(11);
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            return current;
        }
        Integer nextHour = this.hours.first();
        for (Integer hour : this.hours) {
            if (currentHour.equals(hour)) {
                nextHour = currentHour;
                break;
            }
            if (hour <= currentHour) continue;
            nextHour = hour;
            break;
        }
        if (nextHour < currentHour) {
            ((Calendar)next).add(5, 1);
        }
        next.set(11, nextHour);
        return next;
    }

    public int getFirst() {
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            return new GregorianCalendar().get(11);
        }
        return this.hours.first();
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_HOUR;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_HOUR;
    }
}

