/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.ejb3.timer.schedule.ListValue;
import org.jboss.ejb3.timer.schedule.MixedValueTypeExpression;
import org.jboss.ejb3.timer.schedule.RangeValue;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionType;
import org.jboss.ejb3.timer.schedule.ScheduleExpressionTypeUtil;
import org.jboss.ejb3.timer.schedule.SingleValue;

public class Month
extends MixedValueTypeExpression {
    public static final Integer MAX_MONTH = 12;
    public static final Integer MIN_MONTH = 1;
    private static final Map<String, Integer> MONTH_ALIAS = new HashMap<String, Integer>();
    private static final int OFFSET;
    private SortedSet<Integer> months = new TreeSet<Integer>();
    private SortedSet<Integer> offsetAdjustedMonths = new TreeSet<Integer>();
    private ScheduleExpressionType expressionType;

    public Month(String value) {
        this.expressionType = ScheduleExpressionTypeUtil.getType(value);
        Set<Integer> mths = null;
        switch (this.expressionType) {
            case RANGE: {
                RangeValue range = new RangeValue(value);
                mths = this.processRangeValue(range);
                this.months.addAll(mths);
                break;
            }
            case LIST: {
                ListValue list = new ListValue(value);
                mths = this.processListValue(list);
                this.months.addAll(mths);
                break;
            }
            case SINGLE_VALUE: {
                SingleValue singleValue = new SingleValue(value);
                Integer month = this.processSingleValue(singleValue);
                this.months.add(month);
                break;
            }
            case WILDCARD: {
                break;
            }
            case INCREMENT: {
                throw new IllegalArgumentException("Increment type expression is not allowed for month value. Invalid value: " + value);
            }
        }
        if (OFFSET != 0) {
            for (Integer month : this.months) {
                this.offsetAdjustedMonths.add(month - OFFSET);
            }
        } else {
            this.offsetAdjustedMonths = this.months;
        }
    }

    @Override
    protected Map<String, Integer> getAliases() {
        return MONTH_ALIAS;
    }

    @Override
    protected Integer getMaxValue() {
        return MAX_MONTH;
    }

    @Override
    protected Integer getMinValue() {
        return MIN_MONTH;
    }

    public Calendar getNextMonth(Calendar current) {
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            return current;
        }
        GregorianCalendar next = new GregorianCalendar(current.getTimeZone());
        next.setTime(current.getTime());
        Integer currentMonth = current.get(2);
        Integer nextMonth = this.offsetAdjustedMonths.first();
        for (Integer month : this.offsetAdjustedMonths) {
            if (currentMonth.equals(month) && this.hasDateForMonth(next.get(5), month, next.get(1))) {
                nextMonth = currentMonth;
            }
            if (month <= currentMonth || !this.hasDateForMonth(next.get(5), month, next.get(1))) continue;
            nextMonth = month;
            break;
        }
        if (nextMonth < currentMonth) {
            int date = next.get(5);
            int nextYear = current.get(1) + 1;
            if (nextMonth == 1 && date == 29) {
                for (int i = 0; i < 5; ++i) {
                    if (this.hasDateForMonth(date, nextMonth, nextYear)) {
                        next.set(2, nextMonth);
                        next.set(1, nextYear);
                        return next;
                    }
                    ++nextYear;
                }
                return null;
            }
            if (this.hasDateForMonth(date, nextMonth, nextYear)) {
                next.set(2, nextMonth);
                next.set(1, nextYear);
                return next;
            }
            return null;
        }
        next.set(2, nextMonth);
        return next;
    }

    private boolean hasDateForMonth(int date, int month, int year) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, 1);
        int maximumPossibleDateForTheMonth = ((Calendar)cal).getActualMaximum(5);
        return date <= maximumPossibleDateForTheMonth;
    }

    public int getFirst() {
        if (this.expressionType == ScheduleExpressionType.WILDCARD) {
            return new GregorianCalendar().get(2);
        }
        return this.months.first();
    }

    static {
        MONTH_ALIAS.put("Jan", 1);
        MONTH_ALIAS.put("Feb", 2);
        MONTH_ALIAS.put("Mar", 3);
        MONTH_ALIAS.put("Apr", 4);
        MONTH_ALIAS.put("May", 5);
        MONTH_ALIAS.put("Jun", 6);
        MONTH_ALIAS.put("Jul", 7);
        MONTH_ALIAS.put("Aug", 8);
        MONTH_ALIAS.put("Sep", 9);
        MONTH_ALIAS.put("Oct", 10);
        MONTH_ALIAS.put("Nov", 11);
        MONTH_ALIAS.put("Dec", 12);
        OFFSET = MONTH_ALIAS.get("Jan") - 0;
    }
}

