/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timer.schedule;

import java.util.ArrayList;

public class RangeValue {
    public static final String RANGE_SEPARATOR = "-";
    private String rangeStart;
    private String rangeEnd;

    public RangeValue(String range) {
        String[] values = RangeValue.getRangeValues(range);
        if (values == null || values.length != 2) {
            throw new IllegalArgumentException("Invalid range value: " + range);
        }
        this.rangeStart = values[0];
        this.rangeEnd = values[1];
    }

    public String getStart() {
        return this.rangeStart;
    }

    public String getEnd() {
        return this.rangeEnd;
    }

    public static boolean accepts(String value) {
        String[] rangeValues = RangeValue.getRangeValues(value);
        return rangeValues != null && rangeValues.length == 2;
    }

    private static String[] getRangeValues(String val) {
        if (val == null) {
            return null;
        }
        String trimmedVal = val.trim();
        int indexOfRangeSeparator = RangeValue.getIndexOfRangeSeparator(trimmedVal);
        if (indexOfRangeSeparator == -1) {
            return null;
        }
        String[] leftAndRightValues = new String[2];
        if (indexOfRangeSeparator == 0 || indexOfRangeSeparator == trimmedVal.length() - 1) {
            return null;
        }
        String leftSideValue = trimmedVal.substring(0, indexOfRangeSeparator);
        if ((leftSideValue = leftSideValue.trim()).isEmpty() || leftSideValue.contains(RANGE_SEPARATOR)) {
            return null;
        }
        String rightSideValue = trimmedVal.substring(indexOfRangeSeparator + 1, trimmedVal.length());
        if ((rightSideValue = rightSideValue.trim()).isEmpty() || rightSideValue.contains(RANGE_SEPARATOR)) {
            return null;
        }
        leftAndRightValues[0] = leftSideValue;
        leftAndRightValues[1] = rightSideValue;
        return leftAndRightValues;
    }

    private static int getIndexOfRangeSeparator(String val) {
        int indexOfRangeSeparator;
        if (val == null || val.isEmpty() || !val.contains(RANGE_SEPARATOR)) {
            return -1;
        }
        ArrayList<Integer> indexesOfRangeSeparator = new ArrayList<Integer>();
        int currentIndex = 0;
        int i = 0;
        while (i < val.length() && (indexOfRangeSeparator = val.indexOf(RANGE_SEPARATOR, currentIndex)) != -1) {
            indexesOfRangeSeparator.add(indexOfRangeSeparator);
            i = currentIndex = indexOfRangeSeparator + 1;
        }
        switch (indexesOfRangeSeparator.size()) {
            case 0: {
                return -1;
            }
            case 1: {
                return (Integer)indexesOfRangeSeparator.get(0);
            }
            case 2: 
            case 3: {
                return (Integer)indexesOfRangeSeparator.get(1);
            }
        }
        return -1;
    }
}

