/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2;

import java.util.UUID;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import org.jboss.ejb3.timerservice.mk2.TimerServiceImpl;
import org.jboss.ejb3.timerservice.mk2.TimerServiceRegistry;

public class TimerHandleImpl
implements TimerHandle {
    private static final long serialVersionUID = 1L;
    private String timedObjectId;
    private UUID id;
    private transient TimerServiceImpl service;

    public TimerHandleImpl() {
    }

    public TimerHandleImpl(UUID id, String timedObjectId, TimerServiceImpl service) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (timedObjectId == null) {
            throw new IllegalArgumentException("Timed objectid cannot be null");
        }
        if (service == null) {
            throw new IllegalArgumentException("Timer service cannot be null");
        }
        this.timedObjectId = timedObjectId;
        this.id = id;
        this.service = service;
    }

    public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (this.service == null) {
            this.service = TimerServiceRegistry.getTimerService(this.timedObjectId);
            if (this.service == null) {
                throw new EJBException("Timerservice with timedObjectId: " + this.timedObjectId + " is not registered");
            }
        }
        return this.service.getTimer(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimerHandleImpl)) {
            return false;
        }
        TimerHandleImpl other = (TimerHandleImpl)obj;
        if (this == other) {
            return true;
        }
        return this.id.equals(other.id) && this.timedObjectId.equals(other.timedObjectId);
    }
}

