/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerHandle;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.timer.schedule.CalendarBasedTimeout;
import org.jboss.ejb3.timerservice.extension.TimerService;
import org.jboss.ejb3.timerservice.mk2.CalendarTimer;
import org.jboss.ejb3.timerservice.mk2.TimerImpl;
import org.jboss.ejb3.timerservice.mk2.TimerState;
import org.jboss.ejb3.timerservice.mk2.persistence.CalendarTimerEntity;
import org.jboss.ejb3.timerservice.mk2.persistence.TimeoutMethod;
import org.jboss.ejb3.timerservice.mk2.persistence.TimerEntity;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.logging.Logger;

public class TimerServiceImpl
implements TimerService {
    private static Logger logger = Logger.getLogger(TimerServiceImpl.class);
    private TimedObjectInvoker invoker;
    private EntityManager em;
    private TransactionManager transactionManager;
    private ScheduledExecutorService executor;
    private Map<TimerHandle, TimerImpl> timers = new HashMap<TimerHandle, TimerImpl>();

    public TimerServiceImpl(TimedObjectInvoker invoker, EntityManager em, TransactionManager transactionManager, ScheduledExecutorService executor) {
        if (invoker == null) {
            throw new IllegalArgumentException("Invoker cannot be null");
        }
        if (em == null) {
            throw new IllegalArgumentException("EntityManager cannot be null");
        }
        if (transactionManager == null) {
            throw new IllegalArgumentException("Transaction manager cannot be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor cannot be null");
        }
        this.invoker = invoker;
        this.em = em;
        this.transactionManager = transactionManager;
        this.executor = executor;
    }

    public Timer createCalendarTimer(ScheduleExpression schedule) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createCalendarTimer(schedule, null);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        Serializable info = timerConfig == null ? null : timerConfig.getInfo();
        boolean persistent = timerConfig == null ? true : timerConfig.isPersistent();
        return this.createCalendarTimer(schedule, info, persistent, null, null);
    }

    public Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initialExpiration cannot be null while creating a timer");
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException("initialExpiration.getTime() cannot be negative while creating a timer");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration cannot be negative while creating a timer");
        }
        return this.createTimer(initialExpiration, intervalDuration, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createIntervalTimer(new Date(initialDuration), intervalDuration, timerConfig);
    }

    public Timer createSingleActionTimer(Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException("expiration cannot be null while creating a single action timer");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration.getTime() cannot be negative while creating a single action timer");
        }
        return this.createTimer(expiration, 0L, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public Timer createSingleActionTimer(long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration cannot be negative while creating single action timer");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), 0L, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("Duration cannot negative while creating the timer");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), 0L, info, true);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException("Expiration date cannot be null while creating a timer");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration.getTime() cannot be negative while creating a timer");
        }
        return this.createTimer(expiration, 0L, info, true);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("Initial duration cannot be negative while creating timer");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("Interval cannot be negative while creating timer");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + initialDuration), intervalDuration, info, true);
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("intial expiration date cannot be null while creating a timer");
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration.getTime() cannot be negative while creating a timer");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("interval duration cannot be negative while creating timer");
        }
        return this.createTimer(initialExpiration, intervalDuration, info, true);
    }

    public org.jboss.ejb3.timerservice.extension.Timer getAutoTimer(ScheduleExpression schedule, String timeoutMethodName, String[] methodParams) {
        return this.createCalendarTimer(schedule, null, true, timeoutMethodName, methodParams);
    }

    public org.jboss.ejb3.timerservice.extension.Timer getAutoTimer(ScheduleExpression schedule, TimerConfig timerConfig, String timeoutMethodName, String[] methodParams) {
        return this.createCalendarTimer(schedule, timerConfig.getInfo(), timerConfig.isPersistent(), timeoutMethodName, methodParams);
    }

    public Collection<Timer> getTimers() throws IllegalStateException, EJBException {
        HashSet<Timer> activeTimers = new HashSet<Timer>();
        for (TimerImpl timer : this.timers.values()) {
            if (timer == null || !timer.isActive()) continue;
            activeTimers.add((Timer)timer);
        }
        return activeTimers;
    }

    private Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info, boolean persistent) {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initial expiration is null");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("interval duration is negative");
        }
        UUID uuid = UUID.randomUUID();
        TimerImpl timer = new TimerImpl(uuid, this, initialExpiration, intervalDuration, info, persistent);
        if (persistent) {
            TimerEntity entity = timer.getPersistentState();
            this.em.persist((Object)entity);
        }
        this.startTimer(timer);
        return timer;
    }

    private org.jboss.ejb3.timerservice.extension.Timer createCalendarTimer(ScheduleExpression schedule, Serializable info, boolean persistent, String timeoutMethod, String[] methodParams) {
        if (schedule == null) {
            throw new IllegalArgumentException("schedule is null");
        }
        CalendarBasedTimeout calendarTimeout = new CalendarBasedTimeout(schedule);
        if (calendarTimeout.getFirstTimeout() == null) {
            throw new IllegalStateException("The schedule " + schedule + " doesn't have a timeout in future from now " + new Date());
        }
        UUID uuid = UUID.randomUUID();
        CalendarTimer timer = new CalendarTimer(uuid, this, calendarTimeout, info, persistent, timeoutMethod, methodParams);
        if (persistent) {
            TimerEntity entity = timer.getPersistentState();
            this.em.persist((Object)entity);
        }
        this.startTimer(timer);
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTimer(TimerImpl timer) {
        Map<TimerHandle, TimerImpl> map = this.timers;
        synchronized (map) {
            this.timers.put(timer.getHandle(), timer);
        }
    }

    protected ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public TimedObjectInvoker getInvoker() {
        return this.invoker;
    }

    public Timer getTimer(TimerHandle handle) {
        TimerImpl timer = this.timers.get(handle);
        if (timer != null && timer.isActive()) {
            return timer;
        }
        return null;
    }

    protected Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTimer(TimerImpl txtimer) {
        Map<TimerHandle, TimerImpl> map = this.timers;
        synchronized (map) {
            this.timers.remove(txtimer.getHandle());
        }
    }

    void retryTimeout(TimerImpl txtimer) {
        try {
            logger.warn((Object)"retryTimeout is NYI");
            throw new RuntimeException("NYI");
        }
        catch (Exception e) {
            logger.error((Object)("Retry timeout failed for timer: " + txtimer), (Throwable)e);
            return;
        }
    }

    public void persistTimer(TimerImpl timer) {
        if (timer == null || !timer.isPersistent()) {
            return;
        }
        TimerEntity timerEntity = timer.getPersistentState();
        Transaction previousTx = null;
        try {
            previousTx = this.transactionManager.getTransaction();
            if (previousTx != null) {
                this.transactionManager.suspend();
            }
            this.transactionManager.begin();
            this.em.joinTransaction();
            TimerEntity mergedTimerEntity = (TimerEntity)this.em.merge((Object)timerEntity);
            this.em.persist((Object)mergedTimerEntity);
        }
        catch (Throwable t) {
            this.setRollbackOnly();
            throw new RuntimeException(t);
        }
        finally {
            this.restorePreviousTx(previousTx);
        }
    }

    public void suspendTimers() {
        Collection<TimerImpl> timers = this.timers.values();
        for (TimerImpl timer : timers) {
            timer.suspend();
        }
    }

    public void restoreTimers() {
        String timedObjectId = this.getInvoker().getTimedObjectId();
        boolean thisMethodStartedTx = this.startTxIfNone();
        ArrayList<TimerImpl> restorableTimers = new ArrayList<TimerImpl>();
        try {
            HashSet<TimerState> ineligibleTimerStates = new HashSet<TimerState>();
            ineligibleTimerStates.add(TimerState.CANCELED);
            ineligibleTimerStates.add(TimerState.EXPIRED);
            ineligibleTimerStates.add(TimerState.CANCELED_IN_TX);
            this.em.joinTransaction();
            Query restorableTimersQuery = this.em.createQuery("from TimerEntity t where t.timedObjectId = :timedObjectId and t.timerState not in (:timerStates)");
            restorableTimersQuery.setParameter("timedObjectId", (Object)timedObjectId);
            restorableTimersQuery.setParameter("timerStates", ineligibleTimerStates);
            List persistedTimers = restorableTimersQuery.getResultList();
            for (TimerEntity persistedTimer : persistedTimers) {
                TimerImpl activeTimer = null;
                if (persistedTimer.isCalendarTimer()) {
                    CalendarTimerEntity calendarTimerEntity = (CalendarTimerEntity)persistedTimer;
                    activeTimer = new CalendarTimer(calendarTimerEntity, this);
                } else {
                    activeTimer = new TimerImpl(persistedTimer, this);
                }
                restorableTimers.add(activeTimer);
            }
        }
        catch (Throwable t) {
            this.setRollbackOnly();
            throw new RuntimeException(t);
        }
        finally {
            if (thisMethodStartedTx) {
                this.endTransaction();
            }
        }
        logger.debug((Object)("Found " + restorableTimers.size() + " active timers for timedObjectId: " + timedObjectId));
        for (TimerImpl activeTimer : restorableTimers) {
            this.startTimer(activeTimer);
            logger.debug((Object)("Started timer: " + activeTimer));
        }
    }

    protected void startTimer(TimerImpl timer) {
        this.registerTimerWithTx(timer);
        this.startInTx(timer);
    }

    protected void registerTimerWithTx(TimerImpl timer) {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            try {
                tx.registerSynchronization((Synchronization)new TimerTransactionSynchronization(timer));
            }
            catch (RollbackException e) {
                throw new EJBException((Exception)((Object)e));
            }
            catch (SystemException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
    }

    protected void startInTx(TimerImpl timer) {
        if (this.getTransaction() != null) {
            timer.setTimerState(TimerState.STARTED_IN_TX);
        } else {
            timer.scheduleTimeout();
            timer.setTimerState(TimerState.ACTIVE);
        }
        this.persistTimer(timer);
    }

    private org.jboss.ejb3.timerservice.extension.Timer getExistingAutoTimer(ScheduleExpression schedule, TimerConfig timerConfig, String timeoutMethodName, String[] methodParams) {
        return null;
    }

    private boolean doSchedulesMatch(ScheduleExpression schedule, ScheduleExpression otherScheduleExpression) {
        return true;
    }

    private boolean doesTimeoutMethodMatch(TimeoutMethod timeoutMethod, String timeoutMethodName, String[] methodParams) {
        if (!timeoutMethod.getMethodName().equals(timeoutMethodName)) {
            return false;
        }
        String[] timeoutMethodParams = timeoutMethod.getMethodParams();
        if (timeoutMethodParams == null && methodParams == null) {
            return true;
        }
        return this.methodParamsMatch(timeoutMethodParams, methodParams);
    }

    private boolean doesTimerConfigMatch(TimerConfig timerConfig) {
        return true;
    }

    private boolean isEitherParamNull(Object param1, Object param2) {
        if (param1 != null && param2 == null) {
            return true;
        }
        return param2 != null && param1 == null;
    }

    private boolean methodParamsMatch(String[] methodParams, String[] otherMethodParams) {
        if (this.isEitherParamNull(methodParams, otherMethodParams)) {
            return false;
        }
        if (methodParams.length != otherMethodParams.length) {
            return false;
        }
        for (int i = 0; i < methodParams.length; ++i) {
            if (methodParams[i].equals(otherMethodParams[i])) continue;
            return false;
        }
        return true;
    }

    private boolean startTxIfNone() {
        try {
            Transaction currentTx = this.transactionManager.getTransaction();
            if (currentTx == null) {
                this.transactionManager.begin();
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not start transaction", t);
        }
    }

    private void setRollbackOnly() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (IllegalStateException ise) {
            logger.error((Object)"Could set transaction to rollback only", (Throwable)ise);
        }
        catch (SystemException se) {
            logger.error((Object)"Could set transaction to rollback only", (Throwable)se);
        }
    }

    private void endTransaction() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx == null) {
                throw new IllegalStateException("Transaction cannot be ended since no transaction is in progress");
            }
            if (tx.getStatus() == 1) {
                this.transactionManager.rollback();
            } else {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not end transaction", e);
        }
    }

    private void restorePreviousTx(Transaction previousTx) {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx == null) {
                throw new IllegalStateException("Transaction cannot be ended since no transaction is in progress");
            }
            if (tx.getStatus() == 1) {
                this.transactionManager.rollback();
            } else {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not end transaction", e);
        }
        finally {
            try {
                this.transactionManager.resume(previousTx);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not resume previous transaction " + previousTx, e);
            }
        }
    }

    private class TimerTransactionSynchronization
    implements Synchronization {
        private TimerImpl timer;

        public TimerTransactionSynchronization(TimerImpl timer) {
            if (timer == null) {
                throw new IllegalStateException("Timer cannot be null");
            }
            this.timer = timer;
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                logger.debug((Object)("commit: " + this));
                TimerState timerState = this.timer.getState();
                switch (timerState) {
                    case STARTED_IN_TX: {
                        this.timer.scheduleTimeout();
                        this.timer.setTimerState(TimerState.ACTIVE);
                        TimerServiceImpl.this.persistTimer(this.timer);
                        break;
                    }
                    case CANCELED_IN_TX: {
                        this.timer.cancel();
                        break;
                    }
                    case IN_TIMEOUT: 
                    case RETRY_TIMEOUT: {
                        if (this.timer.getInterval() == 0L) {
                            this.timer.setTimerState(TimerState.EXPIRED);
                            this.timer.cancel();
                            break;
                        }
                        this.timer.setTimerState(TimerState.ACTIVE);
                        TimerServiceImpl.this.persistTimer(this.timer);
                    }
                }
            } else if (status == 4) {
                logger.debug((Object)("rollback: " + this));
                TimerState timerState = this.timer.getState();
                switch (timerState) {
                    case STARTED_IN_TX: {
                        this.timer.cancel();
                        break;
                    }
                    case CANCELED_IN_TX: {
                        this.timer.setTimerState(TimerState.ACTIVE);
                        TimerServiceImpl.this.persistTimer(this.timer);
                        break;
                    }
                    case IN_TIMEOUT: {
                        this.timer.setTimerState(TimerState.RETRY_TIMEOUT);
                        TimerServiceImpl.this.persistTimer(this.timer);
                        logger.debug((Object)("retry: " + this.timer));
                        TimerServiceImpl.this.retryTimeout(this.timer);
                        break;
                    }
                    case RETRY_TIMEOUT: {
                        if (this.timer.getInterval() == 0L) {
                            this.timer.setTimerState(TimerState.EXPIRED);
                            this.timer.cancel();
                            break;
                        }
                        this.timer.setTimerState(TimerState.ACTIVE);
                        TimerServiceImpl.this.persistTimer(this.timer);
                    }
                }
            }
        }

        public void beforeCompletion() {
            TimerState timerState = this.timer.getState();
            switch (timerState) {
                case CANCELED_IN_TX: {
                    TimerServiceImpl.this.removeTimer(this.timer);
                    break;
                }
                case IN_TIMEOUT: 
                case RETRY_TIMEOUT: {
                    if (this.timer.getInterval() != 0L) break;
                    TimerServiceImpl.this.removeTimer(this.timer);
                }
            }
        }
    }
}

