/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2.persistence;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.jboss.ejb3.timerservice.mk2.TimerImpl;
import org.jboss.ejb3.timerservice.mk2.TimerState;

@Entity
@Table(name="timer")
@Inheritance(strategy=InheritanceType.JOINED)
public class TimerEntity
implements Serializable {
    @Id
    private UUID id;
    @Column(nullable=false)
    private String timedObjectId;
    @Column(nullable=false)
    private Date initialDate;
    private long interval;
    private Date nextDate;
    private Date previousRun;
    @Lob
    private Serializable info;
    private TimerState timerState;

    public TimerEntity() {
    }

    public TimerEntity(TimerImpl timer) {
        this.id = timer.getId();
        this.info = timer.getInfo();
        this.initialDate = timer.getInitialExpiration();
        this.interval = timer.getInterval();
        this.nextDate = timer.getNextTimeout();
        this.previousRun = timer.getPreviousRun();
        this.timerState = timer.getState();
        this.timedObjectId = timer.getTimedObjectId();
    }

    public UUID getId() {
        return this.id;
    }

    public String getTimedObjectId() {
        return this.timedObjectId;
    }

    public Date getInitialDate() {
        return this.initialDate;
    }

    public long getInterval() {
        return this.interval;
    }

    public Serializable getInfo() {
        return this.info;
    }

    public Date getNextDate() {
        return this.nextDate;
    }

    public void setNextDate(Date nextDate) {
        this.nextDate = nextDate;
    }

    public Date getPreviousRun() {
        return this.previousRun;
    }

    public void setPreviousRun(Date previousRun) {
        this.previousRun = previousRun;
    }

    public TimerState getTimerState() {
        return this.timerState;
    }

    public void setTimerState(TimerState timerState) {
        this.timerState = timerState;
    }

    public boolean isCalendarTimer() {
        return false;
    }
}

