/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.ejb.EJBException;
import javax.ejb.NoMoreTimeoutsException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerHandle;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.ejb3.timerservice.extension.Timer;
import org.jboss.ejb3.timerservice.mk2.TimerHandleImpl;
import org.jboss.ejb3.timerservice.mk2.TimerServiceImpl;
import org.jboss.ejb3.timerservice.mk2.TimerState;
import org.jboss.ejb3.timerservice.mk2.persistence.TimerEntity;
import org.jboss.ejb3.timerservice.mk2.task.TimerTask;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.logging.Logger;

public class TimerImpl
implements Timer {
    private static final Logger logger = Logger.getLogger(TimerImpl.class);
    protected UUID id;
    protected TimerState timerState;
    protected TimerServiceImpl timerService;
    protected TimedObjectInvoker timedObjectInvoker;
    protected Serializable info;
    protected boolean persistent;
    protected TimerHandleImpl handle;
    protected Date initialExpiration;
    protected long intervalDuration;
    protected Date nextExpiration;
    protected ScheduledFuture<?> future;
    protected Date previousRun;
    protected TimerEntity persistentState;

    public TimerImpl(UUID id, TimerServiceImpl service, Date initialExpiry, long intervalDuration, Serializable info, boolean persistent) {
        this(id, service, initialExpiry, intervalDuration, initialExpiry, info, persistent);
    }

    public TimerImpl(UUID id, TimerServiceImpl service, Date initialExpiry, long intervalDuration, Date nextEpiry, Serializable info, boolean persistent) {
        assert (service != null) : "service is null";
        assert (id != null) : "id is null";
        this.id = id;
        this.timerService = service;
        this.timedObjectInvoker = service.getInvoker();
        this.info = info;
        this.persistent = persistent;
        this.initialExpiration = initialExpiry;
        this.intervalDuration = intervalDuration;
        this.nextExpiration = nextEpiry;
        this.previousRun = null;
        this.handle = new TimerHandleImpl(this.id, this.timedObjectInvoker.getTimedObjectId(), service);
        this.setTimerState(TimerState.CREATED);
    }

    public TimerImpl(TimerEntity persistedTimer, TimerServiceImpl service) {
        this(persistedTimer.getId(), service, persistedTimer.getInitialDate(), persistedTimer.getInterval(), persistedTimer.getNextDate(), null, true);
        this.previousRun = persistedTimer.getPreviousRun();
        this.info = this.deserialize(persistedTimer.getInfo());
    }

    public UUID getId() {
        return this.id;
    }

    public boolean isCalendarTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        return false;
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        Transaction currentTx;
        this.assertTimerState();
        if (this.timerState != TimerState.EXPIRED) {
            this.setTimerState(TimerState.CANCELED);
        }
        if ((currentTx = this.timerService.getTransaction()) == null) {
            this.cancelTimer();
        } else {
            this.registerTimerCancellationWithTx(currentTx);
        }
        this.timerService.persistTimer(this);
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        if (!this.persistent) {
            throw new IllegalStateException("EJB3.1 Spec 18.2.6 Timer handles are only available for persistent timers.");
        }
        return this.handle;
    }

    public TimerHandle getTimerHandle() {
        return this.handle;
    }

    public boolean isPersistent() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        return this.persistent;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        return this.info;
    }

    public Serializable getTimerInfo() {
        return this.info;
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        return this.nextExpiration;
    }

    public Date getNextExpiration() {
        return this.nextExpiration;
    }

    public void setNextTimeout(Date next) {
        this.nextExpiration = next;
    }

    public ScheduleExpression getSchedule() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        throw new IllegalStateException("Timer " + this + " is not a calendar based timer");
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimerState();
        if (this.nextExpiration == null) {
            throw new NoMoreTimeoutsException("No more timeouts for timer " + this);
        }
        long currentTimeInMillis = System.currentTimeMillis();
        long nextTimeoutInMillis = this.nextExpiration.getTime();
        return nextTimeoutInMillis - currentTimeInMillis;
    }

    public boolean isAutoTimer() {
        return false;
    }

    protected void cancelTimer() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    public Date getInitialExpiration() {
        return this.initialExpiration;
    }

    public long getInterval() {
        return this.intervalDuration;
    }

    public String getTimedObjectId() {
        return this.timerService.getInvoker().getTimedObjectId();
    }

    public TimerServiceImpl getTimerService() {
        return this.timerService;
    }

    public boolean isActive() {
        return !this.isCanceled() && !this.isExpired();
    }

    public boolean isCanceled() {
        return this.timerState == TimerState.CANCELED;
    }

    public boolean isExpired() {
        return this.timerState == TimerState.EXPIRED;
    }

    public boolean isInRetry() {
        return this.timerState == TimerState.RETRY_TIMEOUT;
    }

    public Date getPreviousRun() {
        return this.previousRun;
    }

    public void setPreviousRun(Date previousRun) {
        this.previousRun = previousRun;
    }

    public TimerState getState() {
        return this.timerState;
    }

    protected void assertTimerState() {
        if (this.timerState == TimerState.EXPIRED) {
            throw new NoSuchObjectLocalException("Timer has expired");
        }
        if (this.timerState == TimerState.CANCELED) {
            throw new NoSuchObjectLocalException("Timer was canceled");
        }
    }

    public void expireTimer() {
        logger.debug((Object)("expireTimer: " + this));
        this.setTimerState(TimerState.EXPIRED);
        this.timerService.removeTimer(this);
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.timerService.persistTimer(this);
    }

    public void setTimerState(TimerState state) {
        this.timerState = state;
    }

    public TimerEntity getPersistentState() {
        if (!this.persistent) {
            throw new IllegalStateException("Timer " + this + " is not persistent");
        }
        if (this.persistentState == null) {
            this.persistentState = this.createPersistentState();
        } else {
            this.persistentState.setNextDate(this.nextExpiration);
            this.persistentState.setPreviousRun(this.previousRun);
            this.persistentState.setTimerState(this.timerState);
        }
        return this.persistentState;
    }

    public void suspend() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    public void scheduleTimeout() {
        if (this.nextExpiration == null) {
            logger.info((Object)"Next expiration is null. No tasks will be scheduled");
            return;
        }
        TimerTask<?> timerTask = this.getTimerTask();
        long delay = this.nextExpiration.getTime() - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        if (this.intervalDuration > 0L) {
            logger.debug((Object)("Scheduling timer " + this + " at fixed rate, starting at " + delay + " milli seconds from now with repeated interval=" + this.intervalDuration));
            this.future = this.timerService.getExecutor().scheduleAtFixedRate(timerTask, delay, this.intervalDuration, TimeUnit.MILLISECONDS);
        } else {
            logger.debug((Object)("Scheduling a single action timer " + this + " starting at " + delay + " milli seconds from now"));
            this.future = this.getTimerService().getExecutor().schedule(timerTask, delay, TimeUnit.MILLISECONDS);
        }
    }

    protected TimerEntity createPersistentState() {
        return new TimerEntity(this);
    }

    protected TimerTask<?> getTimerTask() {
        return new TimerTask<TimerImpl>(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.handle == null) {
            return false;
        }
        if (!(obj instanceof TimerImpl)) {
            return false;
        }
        TimerImpl otherTimer = (TimerImpl)obj;
        return this.handle.equals(otherTimer.getTimerHandle());
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[id=");
        sb.append(this.id);
        sb.append(" ");
        sb.append("timedObjectId=");
        if (this.timedObjectInvoker == null) {
            sb.append("null");
        } else {
            sb.append(this.timedObjectInvoker.getTimedObjectId());
        }
        sb.append(" ");
        sb.append("auto-timer?:");
        sb.append(this.isAutoTimer());
        sb.append(" ");
        sb.append("persistent?:");
        sb.append(this.persistent);
        sb.append(" ");
        sb.append("timerService=");
        sb.append(this.timerService);
        sb.append(" ");
        sb.append("initialExpiration=");
        sb.append(this.initialExpiration);
        sb.append(" ");
        sb.append("intervalDuration(in milli sec)=");
        sb.append(this.intervalDuration);
        sb.append(" ");
        sb.append("nextExpiration=");
        sb.append(this.nextExpiration);
        sb.append(" ");
        sb.append("timerState=");
        sb.append((Object)this.timerState);
        return sb.toString();
    }

    private void registerTimerCancellationWithTx(Transaction tx) {
        try {
            tx.registerSynchronization((Synchronization)new TimerCancellationTransactionSynchronization(this));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not register with tx for timer cancellation: ", e);
        }
    }

    private Serializable deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStreamWithTCCL ois = new ObjectInputStreamWithTCCL(bais);
            return (Serializable)ois.readObject();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not deserialize info in timer", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not deserialize info in timer", cnfe);
        }
    }

    private class TimerCancellationTransactionSynchronization
    implements Synchronization {
        private TimerImpl timer;

        public TimerCancellationTransactionSynchronization(TimerImpl timer) {
            if (timer == null) {
                throw new IllegalStateException("Timer cannot be null");
            }
            this.timer = timer;
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                logger.debug((Object)("commit timer cancellation: " + this.timer));
                TimerState timerState = this.timer.getState();
                switch (timerState) {
                    case CANCELED: 
                    case IN_TIMEOUT: 
                    case RETRY_TIMEOUT: {
                        this.timer.cancelTimer();
                    }
                }
            } else if (status == 4) {
                logger.debug((Object)("rollback timer cancellation: " + this.timer));
                TimerState timerState = this.timer.getState();
                switch (timerState) {
                    case CANCELED: {
                        this.timer.setTimerState(TimerState.ACTIVE);
                    }
                }
            }
        }

        public void beforeCompletion() {
        }
    }

    private static final class ObjectInputStreamWithTCCL
    extends ObjectInputStream {
        public ObjectInputStreamWithTCCL(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            String className = v.getName();
            Class<?> resolvedClass = null;
            logger.trace((Object)("Attempting to locate class [" + className + "]"));
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                resolvedClass = tccl.loadClass(className);
                logger.trace((Object)"Class resolved through context class loader");
            }
            catch (ClassNotFoundException e) {
                logger.trace((Object)"Asking super to resolve");
                resolvedClass = super.resolveClass(v);
            }
            return resolvedClass;
        }
    }
}

