/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.mk2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerHandle;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.context.CurrentInvocationContext;
import org.jboss.ejb3.context.spi.InvocationContext;
import org.jboss.ejb3.timer.schedule.CalendarBasedTimeout;
import org.jboss.ejb3.timerservice.extension.TimerService;
import org.jboss.ejb3.timerservice.mk2.CalendarTimer;
import org.jboss.ejb3.timerservice.mk2.TimerHandleImpl;
import org.jboss.ejb3.timerservice.mk2.TimerImpl;
import org.jboss.ejb3.timerservice.mk2.TimerState;
import org.jboss.ejb3.timerservice.mk2.persistence.CalendarTimerEntity;
import org.jboss.ejb3.timerservice.mk2.persistence.TimeoutMethod;
import org.jboss.ejb3.timerservice.mk2.persistence.TimerEntity;
import org.jboss.ejb3.timerservice.mk2.task.TimerTask;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.spi.TimerServiceInvocationContext;
import org.jboss.logging.Logger;

public class TimerServiceImpl
implements TimerService {
    private static Logger logger = Logger.getLogger(TimerServiceImpl.class);
    private TimedObjectInvoker invoker;
    private EntityManagerFactory emf;
    private TransactionManager transactionManager;
    private ScheduledExecutorService executor;
    private Map<TimerHandle, TimerImpl> nonPersistentTimers = new HashMap<TimerHandle, TimerImpl>();
    private Map<TimerHandle, TimerImpl> persistentWaitingOnTxCompletionTimers = new HashMap<TimerHandle, TimerImpl>();
    private ThreadLocal<EntityManager> transactionScopedEntityManager = new ThreadLocal();
    private Map<TimerHandle, Future<?>> scheduledTimerFutures = new HashMap();

    public TimerServiceImpl(TimedObjectInvoker invoker, EntityManagerFactory emf, TransactionManager transactionManager, ScheduledExecutorService executor) {
        if (invoker == null) {
            throw new IllegalArgumentException("Invoker cannot be null");
        }
        if (emf == null) {
            throw new IllegalArgumentException("EntityManagerFactory cannot be null");
        }
        if (transactionManager == null) {
            throw new IllegalArgumentException("Transaction manager cannot be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor cannot be null");
        }
        this.invoker = invoker;
        this.emf = emf;
        this.transactionManager = transactionManager;
        this.executor = executor;
    }

    public Timer createCalendarTimer(ScheduleExpression schedule) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createCalendarTimer(schedule, null);
    }

    public Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        Serializable info = timerConfig == null ? null : timerConfig.getInfo();
        boolean persistent = timerConfig == null ? true : timerConfig.isPersistent();
        return this.createCalendarTimer(schedule, info, persistent, null);
    }

    public Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initialExpiration cannot be null while creating a timer");
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException("initialExpiration.getTime() cannot be negative while creating a timer");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration cannot be negative while creating a timer");
        }
        return this.createTimer(initialExpiration, intervalDuration, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createIntervalTimer(new Date(initialDuration), intervalDuration, timerConfig);
    }

    public Timer createSingleActionTimer(Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException("expiration cannot be null while creating a single action timer");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration.getTime() cannot be negative while creating a single action timer");
        }
        return this.createTimer(expiration, 0L, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public Timer createSingleActionTimer(long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration cannot be negative while creating single action timer");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), 0L, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("Duration cannot negative while creating the timer");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), 0L, info, true);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException("Expiration date cannot be null while creating a timer");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration.getTime() cannot be negative while creating a timer");
        }
        return this.createTimer(expiration, 0L, info, true);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("Initial duration cannot be negative while creating timer");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("Interval cannot be negative while creating timer");
        }
        return this.createTimer(new Date(System.currentTimeMillis() + initialDuration), intervalDuration, info, true);
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("intial expiration date cannot be null while creating a timer");
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration.getTime() cannot be negative while creating a timer");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("interval duration cannot be negative while creating timer");
        }
        return this.createTimer(initialExpiration, intervalDuration, info, true);
    }

    public org.jboss.ejb3.timerservice.extension.Timer getAutoTimer(ScheduleExpression schedule, Method timeoutMethod) {
        return this.createCalendarTimer(schedule, null, true, timeoutMethod);
    }

    public org.jboss.ejb3.timerservice.extension.Timer getAutoTimer(ScheduleExpression schedule, TimerConfig timerConfig, Method timeoutMethod) {
        return this.createCalendarTimer(schedule, timerConfig.getInfo(), timerConfig.isPersistent(), timeoutMethod);
    }

    public Collection<Timer> getTimers() throws IllegalStateException, EJBException {
        if (this.isLifecycleCallbackInvocation() && !this.isSingletonBeanInvocation()) {
            throw new IllegalStateException("getTimers() method invocation is not allowed during lifecycle callback of non-singleton EJBs");
        }
        HashSet<Timer> activeTimers = new HashSet<Timer>();
        for (TimerImpl timer : this.nonPersistentTimers.values()) {
            if (timer == null || !timer.isActive()) continue;
            activeTimers.add((Timer)timer);
        }
        for (TimerImpl timer : this.persistentWaitingOnTxCompletionTimers.values()) {
            if (timer == null || !timer.isActive()) continue;
            activeTimers.add((Timer)timer);
        }
        activeTimers.addAll(this.getActiveTimers());
        return activeTimers;
    }

    private Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info, boolean persistent) {
        if (this.isLifecycleCallbackInvocation() && !this.isSingletonBeanInvocation()) {
            throw new IllegalStateException("Creation of timers is not allowed during lifecycle callback of non-singleton EJBs");
        }
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initial expiration is null");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("interval duration is negative");
        }
        UUID uuid = UUID.randomUUID();
        TimerImpl timer = new TimerImpl(uuid.toString(), this, initialExpiration, intervalDuration, info, persistent);
        if (persistent) {
            this.persistTimer(timer);
        }
        this.startTimer(timer);
        this.addTimer(timer);
        return timer;
    }

    private org.jboss.ejb3.timerservice.extension.Timer createCalendarTimer(ScheduleExpression schedule, Serializable info, boolean persistent, Method timeoutMethod) {
        if (this.isLifecycleCallbackInvocation() && !this.isSingletonBeanInvocation()) {
            throw new IllegalStateException("Creation of timers is not allowed during lifecycle callback of non-singleton EJBs");
        }
        if (schedule == null) {
            throw new IllegalArgumentException("schedule is null");
        }
        CalendarBasedTimeout calendarTimeout = new CalendarBasedTimeout(schedule);
        UUID uuid = UUID.randomUUID();
        CalendarTimer timer = new CalendarTimer(uuid.toString(), this, calendarTimeout, info, persistent, timeoutMethod);
        if (persistent) {
            this.persistTimer(timer);
        }
        this.startTimer(timer);
        this.addTimer(timer);
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTimer(TimerImpl timer) {
        if (!timer.persistent) {
            Map<TimerHandle, TimerImpl> map = this.nonPersistentTimers;
            synchronized (map) {
                this.nonPersistentTimers.put(timer.getTimerHandle(), timer);
            }
        }
        Map<TimerHandle, TimerImpl> map = this.persistentWaitingOnTxCompletionTimers;
        synchronized (map) {
            this.persistentWaitingOnTxCompletionTimers.put(timer.getTimerHandle(), timer);
        }
    }

    protected ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public TimedObjectInvoker getInvoker() {
        return this.invoker;
    }

    public org.jboss.ejb3.timerservice.extension.Timer getTimer(TimerHandle handle) {
        TimerImpl timer = this.nonPersistentTimers.get(handle);
        if (timer != null) {
            return timer;
        }
        timer = this.persistentWaitingOnTxCompletionTimers.get(handle);
        if (timer != null) {
            return timer;
        }
        TimerHandleImpl timerHandle = (TimerHandleImpl)handle;
        return this.getPersistedTimer(timerHandle);
    }

    protected Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTimer(TimerImpl timer) {
        if (!timer.persistent) {
            Map<TimerHandle, TimerImpl> map = this.nonPersistentTimers;
            synchronized (map) {
                this.nonPersistentTimers.remove(timer.getTimerHandle());
            }
        }
        Map<TimerHandle, TimerImpl> map = this.persistentWaitingOnTxCompletionTimers;
        synchronized (map) {
            this.persistentWaitingOnTxCompletionTimers.remove(timer.getTimerHandle());
        }
    }

    void retryTimeout(TimerImpl txtimer) {
        try {
            logger.warn((Object)"retryTimeout is NYI");
            throw new RuntimeException("NYI");
        }
        catch (Exception e) {
            logger.error((Object)("Retry timeout failed for timer: " + txtimer), (Throwable)e);
            return;
        }
    }

    public void persistTimer(TimerImpl timer) {
        if (timer == null || !timer.persistent) {
            return;
        }
        TimerEntity timerEntity = timer.getPersistentState();
        Transaction previousTx = null;
        boolean newTxStarted = false;
        try {
            previousTx = this.transactionManager.getTransaction();
            if (previousTx == null) {
                this.startNewTx();
                newTxStarted = true;
            }
            EntityManager em = this.getCurrentEntityManager();
            TimerEntity mergedTimerEntity = (TimerEntity)em.merge((Object)timerEntity);
            em.persist((Object)mergedTimerEntity);
        }
        catch (Throwable t) {
            this.setRollbackOnly();
            throw new RuntimeException(t);
        }
        finally {
            if (newTxStarted) {
                this.endTx();
            }
        }
    }

    public void suspendTimers() {
        Collection<Timer> timers = this.getTimers();
        for (Timer timer : timers) {
            if (!(timer instanceof TimerImpl)) continue;
            ((TimerImpl)timer).suspend();
        }
    }

    public void restoreTimers() {
        List<TimerImpl> restorableTimers = this.getActiveTimers();
        logger.debug((Object)("Found " + restorableTimers.size() + " active timers for timedObjectId: " + this.invoker.getTimedObjectId()));
        for (TimerImpl activeTimer : restorableTimers) {
            this.startTimer(activeTimer);
            logger.debug((Object)("Started timer: " + activeTimer));
            this.persistTimer(activeTimer);
        }
    }

    protected void startTimer(TimerImpl timer) {
        this.registerTimerWithTx(timer);
        this.startInTx(timer);
    }

    protected void registerTimerWithTx(TimerImpl timer) {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            try {
                tx.registerSynchronization((Synchronization)new TimerCreationTransactionSynchronization(timer));
            }
            catch (RollbackException e) {
                throw new EJBException((Exception)((Object)e));
            }
            catch (SystemException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
    }

    protected void startInTx(TimerImpl timer) {
        timer.setTimerState(TimerState.ACTIVE);
        this.persistTimer(timer);
        if (this.getTransaction() == null) {
            timer.scheduleTimeout();
        }
    }

    protected boolean isLifecycleCallbackInvocation() {
        InvocationContext currentInvocationContext = null;
        try {
            currentInvocationContext = CurrentInvocationContext.get();
        }
        catch (IllegalStateException ise) {
            return false;
        }
        Method invokedMethod = currentInvocationContext.getMethod();
        return invokedMethod == null;
    }

    protected void scheduleTimeout(TimerImpl timer) {
        long intervalDuration;
        Date nextExpiration = timer.getNextExpiration();
        if (nextExpiration == null) {
            logger.info((Object)("Next expiration is null. No tasks will be scheduled for timer " + timer));
            return;
        }
        TimerTask<?> timerTask = timer.getTimerTask();
        long delay = nextExpiration.getTime() - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        if ((intervalDuration = timer.getInterval()) > 0L) {
            logger.debug((Object)("Scheduling timer " + timer + " at fixed rate, starting at " + delay + " milli seconds from now with repeated interval=" + intervalDuration));
            ScheduledFuture<?> future = this.executor.scheduleAtFixedRate(timerTask, delay, intervalDuration, TimeUnit.MILLISECONDS);
            this.scheduledTimerFutures.put(timer.getTimerHandle(), future);
        } else {
            logger.debug((Object)("Scheduling a single action timer " + timer + " starting at " + delay + " milli seconds from now"));
            ScheduledFuture<?> future = this.executor.schedule(timerTask, delay, TimeUnit.MILLISECONDS);
            this.scheduledTimerFutures.put(timer.getTimerHandle(), future);
        }
    }

    protected void cancelTimeout(TimerImpl timer) {
        TimerHandle handle = timer.getTimerHandle();
        Future<?> scheduleFuture = this.scheduledTimerFutures.get(handle);
        if (scheduleFuture != null) {
            scheduleFuture.cancel(false);
        }
    }

    private boolean isSingletonBeanInvocation() {
        InvocationContext currentInvocationContext = null;
        try {
            currentInvocationContext = CurrentInvocationContext.get();
            if (currentInvocationContext instanceof TimerServiceInvocationContext) {
                TimerServiceInvocationContext timerserviceInvocationCtx = (TimerServiceInvocationContext)currentInvocationContext;
                return timerserviceInvocationCtx.isSingleton();
            }
            return false;
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    private TimerImpl getPersistedTimer(TimerHandleImpl timerHandle) {
        String id = timerHandle.getId();
        String timedObjectId = timerHandle.getTimedObjectId();
        EntityManager em = this.emf.createEntityManager();
        Query query = em.createQuery("from TimerEntity t where t.id = :id and t.timedObjectId = :timedObjectId");
        query.setParameter("id", (Object)id);
        query.setParameter("timedObjectId", (Object)timedObjectId);
        List timers = query.getResultList();
        if (timers == null || timers.isEmpty()) {
            return null;
        }
        if (timers.size() > 1) {
            throw new EJBException("More than one timer found for TimerHandle: " + timerHandle);
        }
        TimerEntity timerEntity = (TimerEntity)timers.get(0);
        if (timerEntity.isCalendarTimer()) {
            return new CalendarTimer((CalendarTimerEntity)timerEntity, this);
        }
        return new TimerImpl(timerEntity, this);
    }

    private List<TimerImpl> getActiveTimers() {
        String timedObjectId = this.getInvoker().getTimedObjectId();
        HashSet<TimerState> ineligibleTimerStates = new HashSet<TimerState>();
        ineligibleTimerStates.add(TimerState.CANCELED);
        ineligibleTimerStates.add(TimerState.EXPIRED);
        EntityManager em = this.emf.createEntityManager();
        Query activeTimersQuery = em.createQuery("from TimerEntity t where t.timedObjectId = :timedObjectId and t.timerState not in (:timerStates)");
        activeTimersQuery.setParameter("timedObjectId", (Object)timedObjectId);
        activeTimersQuery.setParameter("timerStates", ineligibleTimerStates);
        List persistedTimers = activeTimersQuery.getResultList();
        ArrayList<TimerImpl> activeTimers = new ArrayList<TimerImpl>();
        for (TimerEntity persistedTimer : persistedTimers) {
            TimerImpl activeTimer = null;
            if (persistedTimer.isCalendarTimer()) {
                CalendarTimerEntity calendarTimerEntity = (CalendarTimerEntity)persistedTimer;
                activeTimer = new CalendarTimer(calendarTimerEntity, this);
            } else {
                activeTimer = new TimerImpl(persistedTimer, this);
            }
            activeTimers.add(activeTimer);
        }
        return activeTimers;
    }

    private Serializable clone(Serializable info) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(info);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object clonedInfo = objectInputStream.readObject();
        return (Serializable)clonedInfo;
    }

    private org.jboss.ejb3.timerservice.extension.Timer getExistingAutoTimer(ScheduleExpression schedule, TimerConfig timerConfig, String timeoutMethodName, String[] methodParams) {
        return null;
    }

    private boolean doSchedulesMatch(ScheduleExpression schedule, ScheduleExpression otherScheduleExpression) {
        return true;
    }

    private boolean doesTimeoutMethodMatch(TimeoutMethod timeoutMethod, String timeoutMethodName, String[] methodParams) {
        if (!timeoutMethod.getMethodName().equals(timeoutMethodName)) {
            return false;
        }
        String[] timeoutMethodParams = timeoutMethod.getMethodParams();
        if (timeoutMethodParams == null && methodParams == null) {
            return true;
        }
        return this.methodParamsMatch(timeoutMethodParams, methodParams);
    }

    private boolean doesTimerConfigMatch(TimerConfig timerConfig) {
        return true;
    }

    private boolean isEitherParamNull(Object param1, Object param2) {
        if (param1 != null && param2 == null) {
            return true;
        }
        return param2 != null && param1 == null;
    }

    private boolean methodParamsMatch(String[] methodParams, String[] otherMethodParams) {
        if (this.isEitherParamNull(methodParams, otherMethodParams)) {
            return false;
        }
        if (methodParams.length != otherMethodParams.length) {
            return false;
        }
        for (int i = 0; i < methodParams.length; ++i) {
            if (methodParams[i].equals(otherMethodParams[i])) continue;
            return false;
        }
        return true;
    }

    private void setRollbackOnly() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (IllegalStateException ise) {
            logger.error((Object)"Ignoring exception during setRollbackOnly: ", (Throwable)ise);
        }
        catch (SystemException se) {
            logger.error((Object)"Ignoring exception during setRollbackOnly: ", (Throwable)se);
        }
    }

    private void startNewTx() {
        try {
            this.transactionManager.begin();
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not start transaction", t);
        }
    }

    private void endTx() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx == null) {
                throw new IllegalStateException("Transaction cannot be ended since no transaction is in progress");
            }
            if (tx.getStatus() == 1) {
                this.transactionManager.rollback();
            } else if (tx.getStatus() == 0) {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not end transaction", e);
        }
    }

    private EntityManager getCurrentEntityManager() throws Exception {
        EntityManager em = this.transactionScopedEntityManager.get();
        if (em != null) {
            return em;
        }
        Transaction tx = this.transactionManager.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction in progress. Cannot create an entity manager");
        }
        em = this.emf.createEntityManager();
        em.joinTransaction();
        this.transactionScopedEntityManager.set(em);
        tx.registerSynchronization((Synchronization)new EntityManagerTransactionSynchronization());
        return em;
    }

    private class EntityManagerTransactionSynchronization
    implements Synchronization {
        private EntityManagerTransactionSynchronization() {
        }

        public void afterCompletion(int status) {
            EntityManager em = (EntityManager)TimerServiceImpl.this.transactionScopedEntityManager.get();
            TimerServiceImpl.this.transactionScopedEntityManager.remove();
            if (em != null) {
                try {
                    em.close();
                }
                catch (Exception e) {
                    logger.debug((Object)"Ignoring exception during entity manager close: ", (Throwable)e);
                }
            }
        }

        public void beforeCompletion() {
        }
    }

    private class TimerCreationTransactionSynchronization
    implements Synchronization {
        private TimerImpl timer;

        public TimerCreationTransactionSynchronization(TimerImpl timer) {
            if (timer == null) {
                throw new IllegalStateException("Timer cannot be null");
            }
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            TimerState timerState;
            if (this.timer.persistent) {
                Map map = TimerServiceImpl.this.persistentWaitingOnTxCompletionTimers;
                synchronized (map) {
                    TimerServiceImpl.this.persistentWaitingOnTxCompletionTimers.remove(this.timer.getTimerHandle());
                }
            }
            if (status == 3) {
                logger.debug((Object)("commit timer creation: " + this.timer));
                timerState = this.timer.getState();
                switch (timerState) {
                    case ACTIVE: {
                        this.timer.scheduleTimeout();
                    }
                }
            } else if (status == 4) {
                logger.debug((Object)("Rolling back timer creation: " + this.timer));
                timerState = this.timer.getState();
                switch (timerState) {
                    case ACTIVE: {
                        this.timer.setTimerState(TimerState.CANCELED);
                    }
                }
            }
        }

        public void beforeCompletion() {
        }
    }
}

