/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.impl.ConcurrentBitSet;

public class TestConcurrentBitSet {
    @Test
    public void testBitsSet() {
        int i;
        ConcurrentBitSet bst = new ConcurrentBitSet(50001, 4);
        Assert.assertEquals((long)0L, (long)bst.getAndSetNextClearBit());
        Assert.assertEquals((long)12501L, (long)bst.getAndSetNextClearBit());
        Assert.assertEquals((long)25002L, (long)bst.getAndSetNextClearBit());
        Assert.assertEquals((long)37503L, (long)bst.getAndSetNextClearBit());
        Assert.assertEquals((long)1L, (long)bst.getAndSetNextClearBit());
        Assert.assertEquals((long)5L, (long)bst.getBitsSet());
        bst.clear(1);
        Assert.assertEquals((long)4L, (long)bst.getBitsSet());
        bst.clear(12501);
        try {
            bst.clear(30000);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)bst.getBitsSet());
        for (i = 0; i < bst.getTotalBits() - 3; ++i) {
            Assert.assertTrue((bst.getAndSetNextClearBit() != -1 ? 1 : 0) != 0);
        }
        bst.clear(5);
        bst.clear(12505);
        bst.clear(25505);
        bst.clear(37505);
        for (i = 0; i < 4; ++i) {
            int bit = bst.getAndSetNextClearBit();
            Assert.assertTrue((bit < bst.getTotalBits() && bit > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSegmentUse() {
        ConcurrentBitSet bst = new ConcurrentBitSet(50001, 4);
        Assert.assertEquals((long)0L, (long)bst.getAndSetNextClearBit(0));
        Assert.assertEquals((long)1L, (long)bst.getAndSetNextClearBit(0));
        Assert.assertEquals((long)2L, (long)bst.getAndSetNextClearBit(4));
    }

    @Test
    public void testCompactBitSet() {
        ConcurrentBitSet bst = new ConcurrentBitSet(100000, 1);
        bst.setCompact(true);
        for (int i = 0; i < 100000; ++i) {
            Assert.assertEquals((long)i, (long)bst.getAndSetNextClearBit());
        }
        bst.clear(50);
        bst.clear(500);
        bst.clear(5000);
        Assert.assertEquals((long)50L, (long)bst.getAndSetNextClearBit());
    }

    @Test
    public void testCompactHighest() {
        int i;
        ConcurrentBitSet bst = new ConcurrentBitSet(524288, 1);
        bst.setCompact(true);
        for (i = 0; i < bst.getTotalBits(); ++i) {
            bst.getAndSetNextClearBit();
        }
        Assert.assertEquals((long)(bst.getTotalBits() - 1), (long)bst.getHighestBitSet(0));
        Assert.assertEquals((long)(bst.getTotalBits() - 1), (long)bst.getHighestBitSet(1));
        for (i = bst.getTotalBits() - 20; i < bst.getTotalBits(); ++i) {
            bst.clear(i);
        }
        Assert.assertEquals((long)(bst.getTotalBits() - 21), (long)bst.compactHighestBitSet(0));
        for (i = bst.getTotalBits() - 20; i < bst.getTotalBits(); ++i) {
            bst.getAndSetNextClearBit();
        }
        Assert.assertEquals((long)-1L, (long)bst.getAndSetNextClearBit());
        for (i = 20; i < bst.getTotalBits(); ++i) {
            bst.clear(i);
        }
        Assert.assertEquals((long)(bst.getTotalBits() - 1), (long)bst.getHighestBitSet(0));
        Assert.assertEquals((long)19L, (long)bst.compactHighestBitSet(0));
    }

    @Test
    public void testCompactHighestEmpty() {
        ConcurrentBitSet bst = new ConcurrentBitSet(524288, 1);
        bst.setCompact(true);
        bst.getAndSetNextClearBit();
        bst.clear(0);
        Assert.assertEquals((long)-1L, (long)bst.compactHighestBitSet(0));
    }
}

