/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.CommandContext;
import org.teiid.PolicyDecider;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.dqp.internal.process.AuthorizationValidationVisitor;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataRolePolicyDecider;
import org.teiid.dqp.internal.process.DefaultAuthorizationValidator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.TempTableTestHarness;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.AbstractValidationVisitor;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;

public class TestAuthorizationValidationVisitor {
    public static final String CONN_ID = "connID";
    private org.teiid.query.util.CommandContext context;
    private static DataPolicyMetadata exampleAuthSvc1;
    private static DataPolicyMetadata exampleAuthSvc2;

    @Before
    public void setup() {
        this.context = new org.teiid.query.util.CommandContext();
        this.context.setDQPWorkContext(new DQPWorkContext());
        this.context.setSession(this.context.getDQPWorkContext().getSession());
    }

    @BeforeClass
    public static void oneTimeSetup() {
        exampleAuthSvc1 = TestAuthorizationValidationVisitor.exampleAuthSvc1();
        exampleAuthSvc2 = TestAuthorizationValidationVisitor.exampleAuthSvc2();
    }

    static DataPolicyMetadata.PermissionMetaData addResource(DataPolicy.PermissionType type, boolean flag, String resource) {
        DataPolicyMetadata.PermissionMetaData p = new DataPolicyMetadata.PermissionMetaData();
        p.setResourceName(resource);
        switch (type) {
            case CREATE: {
                p.setAllowCreate(Boolean.valueOf(flag));
                break;
            }
            case DELETE: {
                p.setAllowDelete(Boolean.valueOf(flag));
                break;
            }
            case READ: {
                p.setAllowRead(Boolean.valueOf(flag));
                break;
            }
            case UPDATE: {
                p.setAllowUpdate(Boolean.valueOf(flag));
                break;
            }
            case ALTER: {
                p.setAllowAlter(Boolean.valueOf(flag));
                break;
            }
            case EXECUTE: {
                p.setAllowExecute(Boolean.valueOf(flag));
                break;
            }
            case LANGUAGE: {
                p.setAllowLanguage(Boolean.valueOf(flag));
            }
        }
        return p;
    }

    static DataPolicyMetadata.PermissionMetaData addResource(DataPolicy.PermissionType type, String resource) {
        return TestAuthorizationValidationVisitor.addResource(type, true, resource);
    }

    private static DataPolicyMetadata exampleAuthSvc1() {
        DataPolicyMetadata svc = new DataPolicyMetadata();
        svc.setName("test");
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.DELETE, "pm1.g1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm1.g1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm1.g1.e1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, false, "pm1.g1.e2")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm1.g1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm1.g1.e1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm1.g1.e2")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm1.g1.e3")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm1.g1.e4")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.UPDATE, "pm1.g1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.UPDATE, false, "pm1.g1.e1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.UPDATE, "pm1.g1.e2")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.UPDATE, "pm1.g1.e3")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.UPDATE, "pm1.g1.e4")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.EXECUTE, "pm1.sp1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm1.g2")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, false, "pm1.g2.e1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm1.g2.e2")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm1.g2.e3")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm1.g2.e4")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.UPDATE, "pm1.g2")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.UPDATE, false, "pm1.g2.e1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.UPDATE, "pm1.g2.e2")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.UPDATE, "pm1.g2.e3")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.UPDATE, "pm1.g2.e4")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.DELETE, "pm1.g4")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.DELETE, "pm1.g4.e1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.DELETE, "pm1.g4.e2")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm1.sq1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm1.xyz")});
        svc.setAllowCreateTemporaryTables(Boolean.valueOf(true));
        return svc;
    }

    private static DataPolicyMetadata exampleAuthSvc2() {
        DataPolicyMetadata svc = new DataPolicyMetadata();
        svc.setName("test");
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm1.g2")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm1.g2")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm1.g1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm2.g1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm2.g2.e1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm3.g2.e1")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "pm3.g2.e2")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "xmltest.doc1")});
        svc.setAllowCreateTemporaryTables(Boolean.valueOf(false));
        return svc;
    }

    private DataPolicyMetadata examplePolicyBQT() {
        DataPolicyMetadata svc = new DataPolicyMetadata();
        svc.setName("test");
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.ALTER, "VQT.SmallA_2589")});
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.CREATE, "bqt1")});
        svc.setAllowCreateTemporaryTables(Boolean.valueOf(true));
        return svc;
    }

    private void helpTest(String sql, QueryMetadataInterface metadata, String[] expectedInaccesible, VDBMetaData vdb, DataPolicyMetadata ... roles) throws QueryParserException, QueryResolverException, TeiidComponentException {
        QueryParser parser = QueryParser.getQueryParser();
        Command command = parser.parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        DataRolePolicyDecider dataRolePolicyDecider = this.createPolicyDecider(metadata, vdb, roles);
        AuthorizationValidationVisitor visitor = new AuthorizationValidationVisitor((PolicyDecider)dataRolePolicyDecider, (CommandContext)this.context);
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata, (AbstractValidationVisitor)visitor);
        if (report.hasItems()) {
            ValidatorFailure firstFailure = (ValidatorFailure)report.getItems().iterator().next();
            HashSet<String> expected = new HashSet<String>(Arrays.asList(expectedInaccesible));
            HashSet<String> actual = new HashSet<String>();
            for (LanguageObject obj : firstFailure.getInvalidObjects()) {
                if (obj instanceof ElementSymbol) {
                    actual.add(((ElementSymbol)obj).getName());
                    continue;
                }
                actual.add(obj.toString());
            }
            Assert.assertEquals(expected, actual);
        } else if (expectedInaccesible.length > 0) {
            Assert.fail((String)"Expected inaccessible objects, but got none.");
        }
    }

    private DataRolePolicyDecider createPolicyDecider(QueryMetadataInterface metadata, VDBMetaData vdb, DataPolicyMetadata ... roles) {
        vdb.addAttchment(QueryMetadataInterface.class, (Object)metadata);
        HashMap<String, DataPolicyMetadata> policies = new HashMap<String, DataPolicyMetadata>();
        for (DataPolicyMetadata dataPolicyMetadata : roles) {
            policies.put(dataPolicyMetadata.getName(), dataPolicyMetadata);
        }
        vdb.setDataPolicies(new ArrayList(policies.values()));
        this.context.getDQPWorkContext().setPolicies(policies);
        this.context.getSession().setVdb(vdb);
        this.context.setMetadata(metadata);
        DataRolePolicyDecider dataRolePolicyDecider = new DataRolePolicyDecider();
        dataRolePolicyDecider.setAllowFunctionCallsByDefault(false);
        return dataRolePolicyDecider;
    }

    @Test
    public void testProcRelational() throws Exception {
        this.helpTest("select * from sp1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
        this.helpTest("select * from pm1.sp1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
        this.helpTest("select * from sp1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"sp1"}, RealMetadataFactory.example1VDB(), exampleAuthSvc2);
    }

    @Test
    public void testTemp() throws Exception {
        this.helpTest("create local temporary table x (y string)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
        this.helpTest("create local temporary table x (y string)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"x"}, RealMetadataFactory.example1VDB(), exampleAuthSvc2);
    }

    @Test
    public void testFunction() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        this.helpTest("SELECT e1 FROM pm1.g1 where xyz() > 0", (QueryMetadataInterface)metadata, new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
        this.helpTest("SELECT e1, curdate() FROM pm1.g2 where xyz() > 0", (QueryMetadataInterface)metadata, new String[]{"xyz()"}, RealMetadataFactory.example1VDB(), exampleAuthSvc2);
    }

    @Test
    public void testEverythingAccessible() throws Exception {
        this.helpTest("SELECT e1 FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testAccessibleCombination() throws Exception {
        DataPolicyMetadata svc = new DataPolicyMetadata();
        svc.setName("test");
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm1")});
        DataPolicyMetadata.PermissionMetaData p = TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm1.g1");
        p.setAllowRead(Boolean.valueOf(false));
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{p});
        DataPolicyMetadata svc1 = new DataPolicyMetadata();
        svc1.setName("test1");
        svc1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm1")});
        this.helpTest("SELECT e1 FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), svc, svc1);
        svc1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{p});
        this.helpTest("SELECT e1 FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm1.g1.e1", "pm1.g1"}, RealMetadataFactory.example1VDB(), svc, svc1);
    }

    @Test
    public void testEverythingAccessible1() throws Exception {
        this.helpTest("SELECT e1 FROM (select e1 from pm1.g1) x", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testEverythingAccessible2() throws Exception {
        this.helpTest("SELECT lookup('pm1.g1', 'e1', 'e1', '1'), e1 FROM (select e1 from pm1.g1) x", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testInaccesibleElement() throws Exception {
        this.helpTest("SELECT e2 FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm1.g1.e2"}, RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testInaccesibleElement2() throws Exception {
        this.helpTest("SELECT lookup('pm1.g1', 'e1', 'e2', '1')", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm1.g1.e2"}, RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testInaccesibleGroup() throws Exception {
        this.helpTest("SELECT e1 FROM pm1.g2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm1.g2", "pm1.g2.e1"}, RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testInsert() throws Exception {
        this.helpTest("INSERT INTO pm1.g1 (e1, e2, e3, e4) VALUES ('x', 5, {b'true'}, 1.0)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testInsertInaccessible() throws Exception {
        this.helpTest("INSERT INTO pm1.g2 (e1, e2, e3, e4) VALUES ('x', 5, {b'true'}, 1.0)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm1.g2.e1"}, RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testUpdate() throws Exception {
        this.helpTest("UPDATE pm1.g1 SET e2 = 5", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testUpdateCriteriaInaccessibleForRead() throws Exception {
        this.helpTest("UPDATE pm1.g2 SET e2 = 5 WHERE e1 = 'x'", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm1.g2.e1"}, RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testUpdateCriteriaInaccessibleForRead1() throws Exception {
        this.helpTest("UPDATE pm1.g2 SET e2 = cast(e1 as integer)", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm1.g2.e1"}, RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testUpdateElementInaccessibleForUpdate() throws Exception {
        this.helpTest("UPDATE pm1.g1 SET e1 = 5 WHERE e1 = 'x'", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm1.g1.e1"}, RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testDelete() throws Exception {
        this.helpTest("DELETE FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testDeleteCriteriaInaccesibleForRead() throws Exception {
        this.helpTest("DELETE FROM pm1.g2 WHERE e1 = 'x'", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm1.g2.e1"}, RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testDeleteInaccesibleGroup() throws Exception {
        this.helpTest("DELETE FROM pm1.g3", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm1.g3"}, RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testProc() throws Exception {
        this.helpTest("EXEC pm1.sq1()", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testProcInaccesible() throws Exception {
        this.helpTest("EXEC pm1.sq2('xyz')", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm1.sq2"}, RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testSelectIntoEverythingAccessible() throws Exception {
        this.helpTest("SELECT e1, e2, e3, e4 INTO pm1.g2 FROM pm2.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc2);
    }

    @Test
    public void testSelectIntoTarget_e1_NotAccessible() throws Exception {
        this.helpTest("SELECT e1, e2, e3, e4 INTO pm2.g2 FROM pm2.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm2.g2", "pm2.g2.e2", "pm2.g2.e4", "pm2.g2.e3"}, RealMetadataFactory.example1VDB(), exampleAuthSvc2);
    }

    @Test
    public void testSelectIntoTarget_e1e2_NotAccessible() throws Exception {
        this.helpTest("SELECT e1, e2, e3, e4 INTO pm3.g2 FROM pm2.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm3.g2", "pm3.g2.e4", "pm3.g2.e3"}, RealMetadataFactory.example1VDB(), exampleAuthSvc2);
    }

    @Test
    public void testTempTableSelectInto() throws Exception {
        this.helpTest("SELECT e1 INTO #temp FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
        this.helpTest("SELECT e1 INTO #temp FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"#temp"}, RealMetadataFactory.example1VDB(), exampleAuthSvc2);
        this.helpTest("SELECT e1 INTO #temp FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc2, exampleAuthSvc1);
    }

    @Test
    public void testCommonTable() throws Exception {
        this.helpTest("WITH X AS (SELECT e1 from pm1.g2) SELECT e1 from x", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc2);
    }

    @Test
    public void testTempTableSelectInto1() throws Exception {
        this.helpTest("SELECT e1, e2 INTO #temp FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm1.g1.e2"}, RealMetadataFactory.example1VDB(), exampleAuthSvc1);
    }

    @Test
    public void testTempTableInsert() throws Exception {
        this.helpTest("insert into #temp (e1, e2, e3, e4) values ('1', '2', '3', '4')", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), exampleAuthSvc1);
        this.helpTest("insert into #temp (e1, e2, e3, e4) values ('1', '2', '3', '4')", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"#temp"}, RealMetadataFactory.example1VDB(), exampleAuthSvc2);
    }

    @Test
    public void testAlter() throws Exception {
        this.helpTest("alter view SmallA_2589 as select * from bqt1.smalla", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SmallA_2589"}, RealMetadataFactory.exampleBQTVDB(), exampleAuthSvc1);
        this.helpTest("alter view SmallA_2589 as select * from bqt1.smalla", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[0], RealMetadataFactory.exampleBQTVDB(), this.examplePolicyBQT());
        this.helpTest("alter trigger on SmallA_2589 INSTEAD OF UPDATE enabled", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SmallA_2589"}, RealMetadataFactory.exampleBQTVDB(), exampleAuthSvc1);
        this.helpTest("alter trigger on SmallA_2589 INSTEAD OF UPDATE enabled", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[0], RealMetadataFactory.exampleBQTVDB(), this.examplePolicyBQT());
    }

    @Test
    public void testObjectTable() throws Exception {
        this.helpTest("select * from objecttable(language 'javascript' 'teiid_context' columns x string 'teiid_row.userName') as x", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"OBJECTTABLE(LANGUAGE 'javascript' 'teiid_context' COLUMNS x string 'teiid_row.userName') AS x"}, RealMetadataFactory.exampleBQTVDB(), exampleAuthSvc1);
        DataPolicyMetadata policy = TestAuthorizationValidationVisitor.exampleAuthSvc1();
        policy.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.LANGUAGE, "javascript")});
        this.helpTest("select * from objecttable(language 'javascript' 'teiid_context' columns x string 'teiid_row.userName') as x", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[0], RealMetadataFactory.exampleBQTVDB(), policy);
    }

    @Test
    public void testCreateForeignTemp() throws Exception {
        DataPolicyMetadata dpm = TestAuthorizationValidationVisitor.exampleAuthSvc1();
        dpm.setAllowCreateTemporaryTables(Boolean.valueOf(false));
        this.helpTest("create foreign temporary table x (id string) on bqt1", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"x"}, RealMetadataFactory.exampleBQTVDB(), dpm);
        this.helpTest("create foreign temporary table x (id string) on bqt1", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[0], RealMetadataFactory.exampleBQTVDB(), this.examplePolicyBQT());
        TempTableTestHarness harness = new TempTableTestHarness();
        harness.setUp((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new HardcodedDataManager());
        harness.execute("create foreign temporary table x (id string) on bqt1", new List[]{Arrays.asList(0)});
        this.helpTest("insert into x (id) values ('a')", (QueryMetadataInterface)harness.getMetadata(), new String[]{"x.id"}, RealMetadataFactory.exampleBQTVDB(), dpm);
        this.helpTest("insert into x (id) values ('a')", (QueryMetadataInterface)harness.getMetadata(), new String[0], RealMetadataFactory.exampleBQTVDB(), this.examplePolicyBQT());
        this.helpTest("select * from x", (QueryMetadataInterface)harness.getMetadata(), new String[]{"x.id"}, RealMetadataFactory.exampleBQTVDB(), this.examplePolicyBQT());
    }

    @Test
    public void testGrantAll() throws Exception {
        DataPolicyMetadata svc = new DataPolicyMetadata();
        svc.setGrantAll(true);
        this.helpTest("create foreign temporary table x (id string) on bqt1", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[0], RealMetadataFactory.exampleBQTVDB(), svc);
    }

    @Test
    public void testPruneSelectAll() throws Exception {
        String sql = "select * from pm1.g1";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        DataPolicyMetadata svc = new DataPolicyMetadata();
        svc.setName("test");
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm1")});
        DataPolicyMetadata.PermissionMetaData p = TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm1.g1.e1");
        p.setAllowRead(Boolean.valueOf(false));
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{p});
        DataRolePolicyDecider dataRolePolicyDecider = this.createPolicyDecider((QueryMetadataInterface)metadata, RealMetadataFactory.example1VDB(), svc);
        DefaultAuthorizationValidator dav = new DefaultAuthorizationValidator();
        dav.setPolicyDecider((PolicyDecider)dataRolePolicyDecider);
        this.context.setSessionVariable("ignore_unauthorized_asterisk", (Object)"true");
        QueryParser parser = QueryParser.getQueryParser();
        Command command = parser.parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)4L, (long)command.getProjectedSymbols().size());
        boolean modified = dav.validate(new String[0], command, (QueryMetadataInterface)metadata, this.context, AuthorizationValidator.CommandType.USER);
        Assert.assertTrue((boolean)modified);
        Assert.assertEquals((long)3L, (long)command.getProjectedSymbols().size());
        p = TestAuthorizationValidationVisitor.addResource(DataPolicy.PermissionType.READ, "pm1.g1");
        p.setAllowRead(Boolean.valueOf(false));
        svc.addPermission(new DataPolicyMetadata.PermissionMetaData[]{p});
        command = parser.parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)4L, (long)command.getProjectedSymbols().size());
        try {
            dav.validate(new String[0], command, (QueryMetadataInterface)metadata, this.context, AuthorizationValidator.CommandType.USER);
            Assert.fail();
        }
        catch (QueryValidatorException queryValidatorException) {
            // empty catch block
        }
    }

    @Test
    public void testInheritedGrantAll() throws Exception {
        String sql = "select * from pm1.g1";
        DataPolicyMetadata svc = new DataPolicyMetadata();
        svc.setName("test");
        svc.setGrantAll(true);
        svc.setSchemas(Collections.singleton("pm1"));
        this.helpTest(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0], RealMetadataFactory.example1VDB(), svc);
        sql = "select e1 from pm2.g1";
        this.helpTest(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"pm2.g1.e1", "pm2.g1"}, RealMetadataFactory.example1VDB(), svc);
    }
}

