/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.sql.Clob;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.query.util.CommandContext;

public class TestFunctionMethods {
    @BeforeClass
    public static void oneTimeSetup() {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-0600"));
    }

    @AfterClass
    public static void oneTimeTearDown() {
        TimestampWithTimezone.resetCalendar(null);
    }

    @Test
    public void testUnescape() {
        Assert.assertEquals((Object)"a\t\n\n%6", (Object)FunctionMethods.unescape((String)"a\\t\\n\\012\\456"));
    }

    @Test
    public void testUnescape1() {
        Assert.assertEquals((Object)"a\u45aa'", (Object)FunctionMethods.unescape((String)"a\\u45Aa'"));
    }

    @Test
    public void testIso8601Week() {
        Assert.assertEquals((long)53L, (long)FunctionMethods.week((Date)TimestampUtil.createDate((int)105, (int)0, (int)1)));
    }

    @Test
    public void testIso8601Week1() {
        Assert.assertEquals((long)52L, (long)FunctionMethods.week((Date)TimestampUtil.createDate((int)106, (int)0, (int)1)));
    }

    @Test
    public void testDayOfWeek() {
        Assert.assertEquals((long)2L, (long)FunctionMethods.dayOfWeek((Date)TimestampUtil.createDate((int)111, (int)10, (int)28)));
    }

    @Test
    public void testTimestampDiffTimeStamp_ErrorUsingEndDate2304() throws Exception {
        Assert.assertEquals((Object)106753L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_DAY", (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)0, (int)1).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)404, (int)3, (int)13).getTime()), (boolean)false));
    }

    @Test
    public void testTimestampDiffTimeStamp_ErrorUsingEndDate2304a() throws Exception {
        Assert.assertEquals((Object)32244L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_DAY", (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)0, (int)1).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)200, (int)3, (int)13).getTime()), (boolean)true));
    }

    @Test
    public void testTimestampDiffCalendarBasedHour() throws Exception {
        Assert.assertEquals((Object)2562072L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_HOUR", (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)0, (int)1).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)404, (int)3, (int)13).getTime()), (boolean)true));
    }

    @Test
    public void testTimestampDiffCalendarBasedHour1() throws Exception {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("America/New York"));
        try {
            Assert.assertEquals((Object)2472L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_HOUR", (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)0, (int)1).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)3, (int)13).getTime()), (boolean)true));
        }
        finally {
            TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-0600"));
        }
    }

    @Test
    public void testTimestampDiffCalendarBasedMonth() throws Exception {
        Assert.assertEquals((Object)1L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_MONTH", (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)0, (int)10).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)1, (int)1).getTime()), (boolean)true));
    }

    @Test
    public void testTimestampDiffCalendarBasedWeek() throws Exception {
        Assert.assertEquals((Object)1L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_WEEK", (Timestamp)new Timestamp(TimestampUtil.createDate((int)113, (int)2, (int)2).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)113, (int)2, (int)3).getTime()), (boolean)true));
    }

    @Test
    public void testTimestampDiffCalendarBasedWeek1() throws Exception {
        Assert.assertEquals((Object)0L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_WEEK", (Timestamp)new Timestamp(TimestampUtil.createDate((int)113, (int)2, (int)3).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)113, (int)2, (int)4).getTime()), (boolean)true));
    }

    @Test
    public void testTimestampDiffCalendarBasedWeek2() throws Exception {
        Assert.assertEquals((Object)0L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_WEEK", (Timestamp)new Timestamp(TimestampUtil.createDate((int)113, (int)2, (int)4).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)113, (int)2, (int)3).getTime()), (boolean)true));
    }

    @Test
    public void regexpReplaceOkay() throws Exception {
        Assert.assertEquals((Object)"fooXbaz", (Object)FunctionMethods.regexpReplace(null, (String)"foobarbaz", (String)"b..", (String)"X"));
        Assert.assertEquals((Object)"fooXX", (Object)FunctionMethods.regexpReplace(null, (String)"foobarbaz", (String)"b..", (String)"X", (String)"g"));
        Assert.assertEquals((Object)"fooXarYXazY", (Object)FunctionMethods.regexpReplace(null, (String)"foobarbaz", (String)"b(..)", (String)"X$1Y", (String)"g"));
        Assert.assertEquals((Object)"fooBXRbXz", (Object)FunctionMethods.regexpReplace(null, (String)"fooBARbaz", (String)"a", (String)"X", (String)"gi"));
        Assert.assertEquals((Object)"xxbye Wxx", (Object)FunctionMethods.regexpReplace((CommandContext)TestProcessor.createCommandContext(), (String)"Goodbye World", (String)"[g-o].", (String)"x", (String)"gi"));
        Assert.assertEquals((Object)new ClobType((Clob)new ClobImpl("xxbye Wxx")), (Object)FunctionMethods.regexpReplace((CommandContext)TestProcessor.createCommandContext(), (ClobType)new ClobType((Clob)new ClobImpl("Goodbye World")), (String)"[g-o].", (String)"x", (String)"gi"));
    }

    @Test(expected=FunctionExecutionException.class)
    public void regexpInvalidFlagsBad() throws Exception {
        FunctionMethods.regexpReplace(null, (String)"foobarbaz", (String)"b..", (String)"X", (String)"y");
    }

    @Test(expected=FunctionExecutionException.class)
    public void testAbsIntBounds() throws FunctionExecutionException {
        FunctionMethods.abs((int)Integer.MIN_VALUE);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testAbsLongBounds() throws FunctionExecutionException {
        FunctionMethods.abs((long)Long.MIN_VALUE);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testPlusLongBounds() throws FunctionExecutionException {
        FunctionMethods.plus((long)Long.MIN_VALUE, (long)-1L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testPlusLongBounds1() throws FunctionExecutionException {
        FunctionMethods.plus((long)Long.MAX_VALUE, (long)1L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testPlusIntBounds() throws FunctionExecutionException {
        FunctionMethods.plus((int)Integer.MIN_VALUE, (int)-1);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testPlusIntBounds1() throws FunctionExecutionException {
        FunctionMethods.plus((int)Integer.MAX_VALUE, (int)1);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMinusIntBounds1() throws FunctionExecutionException {
        FunctionMethods.minus((int)Integer.MAX_VALUE, (int)-1);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMinusLongBounds() throws FunctionExecutionException {
        FunctionMethods.minus((long)Long.MIN_VALUE, (long)1L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMinusLongBounds1() throws FunctionExecutionException {
        FunctionMethods.minus((long)Long.MAX_VALUE, (long)-1L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMinusIntBounds() throws FunctionExecutionException {
        FunctionMethods.minus((int)Integer.MIN_VALUE, (int)1);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testDivideIntBounds() throws FunctionExecutionException {
        FunctionMethods.divide((int)Integer.MIN_VALUE, (int)-1);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testDivedLongBounds() throws FunctionExecutionException {
        FunctionMethods.divide((long)Long.MIN_VALUE, (long)-1L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMultLongBounds() throws FunctionExecutionException {
        FunctionMethods.multiply((long)Long.MIN_VALUE, (long)-1L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMultLongBounds1() throws FunctionExecutionException {
        FunctionMethods.multiply((long)Long.MAX_VALUE, (long)2L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMultLongBounds2() throws FunctionExecutionException {
        FunctionMethods.multiply((long)Long.MIN_VALUE, (long)-2L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMultIntBounds() throws FunctionExecutionException {
        FunctionMethods.multiply((int)Integer.MIN_VALUE, (int)-1);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMultIntBounds1() throws FunctionExecutionException {
        FunctionMethods.multiply((int)Integer.MAX_VALUE, (int)2);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMultIntBounds2() throws FunctionExecutionException {
        FunctionMethods.multiply((int)Integer.MIN_VALUE, (int)-2);
    }

    @Test
    public void testHashes() throws Exception {
        Assert.assertEquals((Object)"900150983CD24FB0D6963F7D28E17F72", (Object)PropertiesUtils.toHex((byte[])FunctionMethods.md5((String)"abc").getBytesDirect()));
        Assert.assertEquals((Object)"A9993E364706816ABA3E25717850C26C9CD0D89D", (Object)PropertiesUtils.toHex((byte[])FunctionMethods.sha1((String)"abc").getBytesDirect()));
        Assert.assertEquals((Object)"BA7816BF8F01CFEA414140DE5DAE2223B00361A396177A9CB410FF61F20015AD", (Object)PropertiesUtils.toHex((byte[])FunctionMethods.sha2_256((String)"abc").getBytesDirect()));
        Assert.assertEquals((Object)"DDAF35A193617ABACC417349AE20413112E6FA4E89A97EA20A9EEEE64B55D39A2192992A274FC1A836BA3C23A3FEEBBD454D4423643CE80E2A9AC94FA54CA49F", (Object)PropertiesUtils.toHex((byte[])FunctionMethods.sha2_512((String)"abc").getBytesDirect()));
    }

    @Test
    public void testEncryptDecrypt() throws Exception {
        String key = "redhat";
        String data = "jboss teiid";
        BinaryType encryptedBytes = FunctionMethods.aes_encrypt((BinaryType)new BinaryType(data.getBytes("UTF-8")), (BinaryType)new BinaryType(key.getBytes("UTF-8")));
        BinaryType decryptedBytes = FunctionMethods.aes_decrypt((BinaryType)encryptedBytes, (BinaryType)new BinaryType(key.getBytes("UTF-8")));
        Assert.assertArrayEquals((byte[])data.getBytes("UTF-8"), (byte[])decryptedBytes.getBytesDirect());
    }

    @Test
    public void testUpperLowerClob() throws Exception {
        char[] val = new char[]{'W', 'z', '\u0093', '\ud801', '\udc37'};
        Assert.assertEquals((Object)new String(val).toUpperCase(), (Object)ClobType.getString((Clob)FunctionMethods.upperCase((ClobType)new ClobType(ClobImpl.createClob((char[])val)))));
        Assert.assertEquals((Object)new String(val).toLowerCase(), (Object)ClobType.getString((Clob)FunctionMethods.lowerCase((ClobType)new ClobType(ClobImpl.createClob((char[])val)))));
    }
}

