/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.rewriter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Table;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.FakeFunctionMetadataSource;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.CorrelatedReferenceCollectorVisitor;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestQueryRewriter {
    private static final String TRUE_STR = "1 = 1";
    private static final String FALSE_STR = "1 = 0";
    private Map<ElementSymbol, Integer> elements;
    private List<List<? extends Object>> tuples;

    private Criteria parseCriteria(String critStr, QueryMetadataInterface metadata) {
        try {
            Criteria crit = QueryParser.getQueryParser().parseCriteria(critStr);
            QueryResolver.resolveCriteria((Criteria)crit, (QueryMetadataInterface)metadata);
            return crit;
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    private Criteria helpTestRewriteCriteria(String original, String expected) {
        try {
            return this.helpTestRewriteCriteria(original, expected, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Criteria helpTestRewriteCriteria(String original, String expected, boolean rewrite) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Criteria expectedCrit = this.parseCriteria(expected, (QueryMetadataInterface)metadata);
        if (rewrite) {
            QueryResolver.resolveCriteria((Criteria)expectedCrit, (QueryMetadataInterface)metadata);
            expectedCrit = QueryRewriter.rewriteCriteria((Criteria)expectedCrit, null, (QueryMetadataInterface)metadata);
        }
        return this.helpTestRewriteCriteria(original, expectedCrit, (QueryMetadataInterface)metadata);
    }

    @Before
    public void setUp() {
        this.elements = null;
        this.tuples = new ArrayList<List<? extends Object>>();
    }

    private Criteria helpTestRewriteCriteria(String original, String expectedCrit, QueryMetadataInterface metadata) {
        return this.helpTestRewriteCriteria(original, this.parseCriteria(expectedCrit, metadata), metadata);
    }

    private Criteria helpTestRewriteCriteria(String original, Criteria expectedCrit, QueryMetadataInterface metadata) {
        Criteria origCrit = this.parseCriteria(original, metadata);
        Criteria actual = null;
        try {
            ArrayList<Boolean> booleanVals = new ArrayList<Boolean>(this.tuples.size());
            for (List<? extends Object> tuple : this.tuples) {
                booleanVals.add(new Evaluator(this.elements, null, null).evaluate(origCrit, tuple));
            }
            actual = QueryRewriter.rewriteCriteria((Criteria)origCrit, null, (QueryMetadataInterface)metadata);
            Assert.assertEquals((String)"Did not rewrite correctly: ", (Object)expectedCrit, (Object)actual);
            for (int i = 0; i < this.tuples.size(); ++i) {
                Assert.assertEquals((String)this.tuples.get(i).toString(), booleanVals.get(i), (Object)new Evaluator(this.elements, null, null).evaluate(actual, this.tuples.get(i)));
            }
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
        return actual;
    }

    private Expression helpTestRewriteExpression(String original, String expected, QueryMetadataInterface metadata) throws TeiidComponentException, TeiidProcessingException {
        Expression actualExp = QueryParser.getQueryParser().parseExpression(original);
        ResolverVisitor.resolveLanguageObject((LanguageObject)actualExp, (QueryMetadataInterface)metadata);
        CommandContext context = new CommandContext();
        context.setBufferManager(BufferManagerFactory.getStandaloneBufferManager());
        actualExp = QueryRewriter.rewriteExpression((Expression)actualExp, (CommandContext)context, (QueryMetadataInterface)metadata);
        if (expected != null) {
            Expression expectedExp = QueryParser.getQueryParser().parseExpression(expected);
            ResolverVisitor.resolveLanguageObject((LanguageObject)expectedExp, (QueryMetadataInterface)metadata);
            Assert.assertEquals((Object)expectedExp, (Object)actualExp);
        }
        return actualExp;
    }

    private String getRewritenProcedure(String procedure, String userUpdateStr, Table.TriggerEvent procedureType) throws TeiidComponentException, TeiidProcessingException {
        TransformationMetadata metadata = RealMetadataFactory.exampleUpdateProc(procedureType, procedure);
        return this.getRewritenProcedure(userUpdateStr, (QueryMetadataInterface)metadata);
    }

    private String getRewritenProcedure(String userUpdateStr, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        ProcedureContainer userCommand = (ProcedureContainer)QueryParser.getQueryParser().parseCommand(userUpdateStr);
        QueryResolver.resolveCommand((Command)userCommand, (QueryMetadataInterface)metadata);
        Command proc = QueryResolver.expandCommand((ProcedureContainer)userCommand, (QueryMetadataInterface)metadata, null);
        QueryRewriter.rewrite((Command)userCommand, (QueryMetadataInterface)metadata, null);
        Command result = QueryRewriter.rewrite((Command)proc, (QueryMetadataInterface)metadata, null);
        return result.toString();
    }

    static Command helpTestRewriteCommand(String original, String expected) {
        try {
            return TestQueryRewriter.helpTestRewriteCommand(original, expected, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public static Command helpTestRewriteCommand(String original, String expected, QueryMetadataInterface metadata) throws TeiidException {
        return TestQueryRewriter.helpTestRewriteCommand(original, expected, metadata, new CommandContext());
    }

    public static Command helpTestRewriteCommand(String original, String expected, QueryMetadataInterface metadata, CommandContext cc) throws TeiidException {
        Command command = QueryParser.getQueryParser().parseCommand(original);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        Command rewriteCommand = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)metadata, (CommandContext)cc);
        if (rewriteCommand instanceof Insert && ((Insert)rewriteCommand).isUpsert()) {
            rewriteCommand = QueryRewriter.rewriteAsUpsertProcedure((Insert)((Insert)rewriteCommand), (QueryMetadataInterface)metadata, (CommandContext)cc);
        }
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)expected, (Object)rewriteCommand.toString());
        return rewriteCommand;
    }

    @Test
    public void testRewriteUnknown() {
        this.helpTestRewriteCriteria("pm1.g1.e1 = '1' and '1' = convert(null, string)", FALSE_STR);
    }

    @Test
    public void testRewriteUnknown1() {
        this.helpTestRewriteCriteria("pm1.g1.e1 = '1' or '1' = convert(null, string)", "pm1.g1.e1 = '1'");
    }

    @Test
    public void testRewriteUnknown2() {
        this.helpTestRewriteCriteria("not('1' = convert(null, string))", "null <> null");
    }

    @Test
    public void testRewriteUnknown3() {
        this.helpTestRewriteCriteria("pm1.g1.e1 like convert(null, string))", "null <> null");
    }

    @Test
    public void testRewriteUnknown4() {
        this.helpTestRewriteCriteria("null in ('a', 'b', 'c')", "null <> null");
    }

    @Test
    public void testRewriteUnknown5() {
        this.helpTestRewriteCriteria("(null <> null) and 1 = 0", FALSE_STR);
    }

    @Test
    public void testRewriteUnknown6() {
        this.helpTestRewriteCriteria("not(pm1.g1.e1 = '1' and '1' = convert(null, string))", "pm1.g1.e1 <> '1'");
    }

    @Test
    public void testRewriteUnknown7() {
        this.helpTestRewriteCriteria("not(pm1.g1.e1 = '1' or '1' = convert(null, string))", FALSE_STR);
    }

    @Test
    public void testRewriteUnknown8() {
        this.helpTestRewriteCriteria("pm1.g1.e1 in (2, null)", "pm1.g1.e1 = '2'");
    }

    @Test
    public void testRewriteUnknown9() {
        this.helpTestRewriteCriteria("pm1.g1.e1 not in (2, null)", FALSE_STR);
    }

    @Test
    public void testRewriteUnknown10() {
        this.helpTestRewriteCriteria("pm1.g1.e1 <> 'a' and pm1.g1.e2 <> null", FALSE_STR);
    }

    @Test
    public void testRewriteUnknown11() {
        TestQueryRewriter.helpTestRewriteCommand("update pm1.g1 set e3 = pm1.g1.e1 <> 'a' and pm1.g1.e2 <> null", "UPDATE pm1.g1 SET e3 = (pm1.g1.e1 <> 'a') AND (null <> null)");
    }

    @Test
    public void testRewriteInCriteriaWithRepeats() {
        this.helpTestRewriteCriteria("pm1.g1.e1 in ('1', '1', '2')", "pm1.g1.e1 IN ('1', '2')");
    }

    @Test
    public void testRewriteInCriteriaWithSingleValue() {
        this.helpTestRewriteCriteria("pm1.g1.e1 in ('1')", "pm1.g1.e1 = '1'");
    }

    @Test
    public void testRewriteInCriteriaWithSingleValue1() {
        this.helpTestRewriteCriteria("pm1.g1.e1 not in ('1')", "pm1.g1.e1 != '1'");
    }

    @Test
    public void testRewriteInCriteriaWithConvert() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) not in ('x')", "pm1.g1.e2 IS NOT NULL");
    }

    @Test
    public void testRewriteInCriteriaWithNoValues() throws Exception {
        ElementSymbol e1 = new ElementSymbol("e1");
        e1.setGroupSymbol(new GroupSymbol("g1"));
        SetCriteria crit = new SetCriteria((Expression)e1, (Collection)Collections.EMPTY_LIST);
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)crit, null, null);
        Assert.assertEquals((Object)QueryRewriter.FALSE_CRITERIA, (Object)actual);
        crit.setNegated(true);
        actual = QueryRewriter.rewriteCriteria((Criteria)crit, null, null);
        Assert.assertEquals((Object)QueryRewriter.TRUE_CRITERIA, (Object)actual);
    }

    @Test
    public void testRewriteInNotHashable() throws Exception {
        Constant c = new Constant((Object)new FakeObject(0));
        SetCriteria crit = new SetCriteria((Expression)c, new ArrayList());
        crit.getValues().add(new Constant((Object)new FakeObject(1)));
        crit.getValues().add(new Constant((Object)new FakeObject(2)));
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)crit, null, null);
        Assert.assertEquals((Object)QueryRewriter.TRUE_CRITERIA, (Object)actual);
    }

    @Test
    public void testRewriteBetweenCriteria1() {
        this.helpTestRewriteCriteria("pm1.g1.e1 BETWEEN 1000 AND 2000", "(pm1.g1.e1 >= '1000') AND (pm1.g1.e1 <= '2000')");
    }

    @Test
    public void testRewriteBetweenCriteria2() {
        this.helpTestRewriteCriteria("pm1.g1.e1 NOT BETWEEN 1000 AND 2000", "(pm1.g1.e1 < '1000') OR (pm1.g1.e1 > '2000')");
    }

    @Test
    public void testRewriteCrit1() {
        this.helpTestRewriteCriteria("concat('a','b') = 'ab'", TRUE_STR);
    }

    @Test
    public void testRewriteCrit2() {
        this.helpTestRewriteCriteria("'x' = pm1.g1.e1", "(pm1.g1.e1 = 'x')");
    }

    @Test
    public void testRewriteCrit3() {
        this.helpTestRewriteCriteria("pm1.g1.e1 = convert('a', string)", "pm1.g1.e1 = 'a'");
    }

    @Test
    public void testRewriteCrit4() {
        this.helpTestRewriteCriteria("pm1.g1.e1 = CONVERT('a', string)", "pm1.g1.e1 = 'a'");
    }

    @Test
    public void testRewriteCrit5() {
        this.helpTestRewriteCriteria("pm1.g1.e1 in ('a')", "pm1.g1.e1 = 'a'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit6() {
        this.helpTestRewriteCriteria("1 = convert(pm1.g1.e1,integer) + 10", "pm1.g1.e1 = '-9'");
    }

    @Test
    public void testRewriteCrit7() {
        this.helpTestRewriteCriteria("((pm1.g1.e1 = 1) and (pm1.g1.e1 = 1))", "pm1.g1.e1 = '1'");
    }

    @Test
    public void testRewriteMatchCritEscapeChar1() {
        this.helpTestRewriteCriteria("pm1.g1.e1 LIKE 'x_' ESCAPE '\\'", "pm1.g1.e1 LIKE 'x_'");
    }

    @Test
    public void testRewriteMatchCritEscapeChar2() {
        this.helpTestRewriteCriteria("pm1.g1.e1 LIKE '#%x' ESCAPE '#'", "pm1.g1.e1 LIKE '#%x' ESCAPE '#'");
    }

    @Test
    public void testRewriteMatchCritEscapeChar3() {
        this.helpTestRewriteCriteria("pm1.g1.e1 LIKE '#%x'", "pm1.g1.e1 LIKE '#%x'");
    }

    @Test
    public void testRewriteMatchCritEscapeChar4() {
        this.helpTestRewriteCriteria("pm1.g1.e1 LIKE pm1.g1.e1 ESCAPE '#'", "pm1.g1.e1 LIKE pm1.g1.e1 ESCAPE '#'");
    }

    @Test
    public void testRewriteMatchCritEscapeChar5() throws Exception {
        MatchCriteria mcrit = new MatchCriteria((Expression)new ElementSymbol("pm1.g1.e1"), (Expression)new Constant(null, DataTypeManager.DefaultDataClasses.STRING), '#');
        CompareCriteria expected = QueryRewriter.UNKNOWN_CRITERIA;
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)mcrit, null, null);
        Assert.assertEquals((String)"Did not get expected rewritten criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testRewriteMatchCrit1() {
        this.helpTestRewriteCriteria("pm1.g1.e1 LIKE 'x' ESCAPE '\\'", "pm1.g1.e1 = 'x'");
    }

    @Test
    public void testRewriteMatchCrit2() {
        this.helpTestRewriteCriteria("pm1.g1.e1 NOT LIKE 'x'", "pm1.g1.e1 <> 'x'");
    }

    @Test
    public void testRewriteMatchCrit3() {
        this.helpTestRewriteCriteria("pm1.g1.e1 NOT LIKE '%'", FALSE_STR);
    }

    @Test
    public void testRewriteCritTimestampCreate1() {
        this.helpTestRewriteCriteria("timestampCreate(pm3.g1.e2, pm3.g1.e3) = {ts'2004-11-23 09:25:00'}", "(pm3.g1.e2 = {d'2004-11-23'}) AND (pm3.g1.e3 = {t'09:25:00'})");
    }

    @Test
    public void testRewriteCritTimestampCreate2() {
        this.helpTestRewriteCriteria("{ts'2004-11-23 09:25:00'} = timestampCreate(pm3.g1.e2, pm3.g1.e3)", "(pm3.g1.e2 = {d'2004-11-23'}) AND (pm3.g1.e3 = {t'09:25:00'})");
    }

    @Test
    public void testRewriteCritSwap1() {
        this.helpTestRewriteCriteria("'x' = pm1.g1.e1", "pm1.g1.e1 = 'x'");
    }

    @Test
    public void testRewriteCritSwap2() {
        this.helpTestRewriteCriteria("'x' <> pm1.g1.e1", "pm1.g1.e1 <> 'x'");
    }

    @Test
    public void testRewriteCritSwap3() {
        this.helpTestRewriteCriteria("'x' < pm1.g1.e1", "pm1.g1.e1 > 'x'");
    }

    @Test
    public void testRewriteCritSwap4() {
        this.helpTestRewriteCriteria("'x' <= pm1.g1.e1", "pm1.g1.e1 >= 'x'");
    }

    @Test
    public void testRewriteCritSwap5() {
        this.helpTestRewriteCriteria("'x' > pm1.g1.e1", "pm1.g1.e1 < 'x'");
    }

    @Test
    public void testRewriteCritSwap6() {
        this.helpTestRewriteCriteria("'x' >= pm1.g1.e1", "pm1.g1.e1 <= 'x'");
    }

    @Test
    public void testRewriteCritExpr_op1() {
        this.helpTestRewriteCriteria("pm1.g1.e2 + 5 = 10", "pm1.g1.e2 = 5");
    }

    @Test
    public void testRewriteCritExpr_op2() {
        this.helpTestRewriteCriteria("pm1.g1.e2 - 5 = 10", "pm1.g1.e2 = 15");
    }

    @Test
    public void testRewriteCritExpr_op3() {
        this.helpTestRewriteCriteria("pm1.g1.e2 * 5 = 10", "pm1.g1.e2 = 2");
    }

    @Test
    public void testRewriteCritExpr_op4() {
        this.helpTestRewriteCriteria("pm1.g1.e2 / 5 = 10", "pm1.g1.e2 = 50");
    }

    @Test
    public void testRewriteCritExpr_signFlip1() {
        this.helpTestRewriteCriteria("pm1.g1.e2 * -5 > 10", "pm1.g1.e2 < -2");
    }

    @Test
    public void testRewriteCritExpr_signFlip2() {
        this.helpTestRewriteCriteria("pm1.g1.e2 * -5 >= 10", "pm1.g1.e2 <= -2");
    }

    @Test
    public void testRewriteCritExpr_signFlip3() {
        this.helpTestRewriteCriteria("pm1.g1.e2 * -5 < 10", "pm1.g1.e2 > -2");
    }

    @Test
    public void testRewriteCritExpr_signFlip4() {
        this.helpTestRewriteCriteria("pm1.g1.e2 * -5 <= 10", "pm1.g1.e2 >= -2");
    }

    @Test
    public void testRewriteCritExpr_backwards1() {
        this.helpTestRewriteCriteria("5 + pm1.g1.e2 <= 10", "pm1.g1.e2 <= 5");
    }

    @Test
    public void testRewriteCritExpr_backwards2() {
        this.helpTestRewriteCriteria("-5 * pm1.g1.e2 <= 10", "pm1.g1.e2 >= -2");
    }

    @Test
    public void testRewriteCritExpr_unhandled1() {
        this.helpTestRewriteCriteria("5 / pm1.g1.e2 <= 10", "5 / pm1.g1.e2 <= 10");
    }

    @Test
    public void testRewriteCritExpr_unhandled2() {
        this.helpTestRewriteCriteria("5 - pm1.g1.e2 <= 10", "5 - pm1.g1.e2 <= 10");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseDate() {
        this.helpTestRewriteCriteria("PARSEDATE(pm3.g1.e1, 'yyyyMMdd') = {d'2003-05-01'}", "pm3.g1.e1 = '20030501'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseDate1() {
        this.helpTestRewriteCriteria("PARSEDATE(pm3.g1.e1, 'yyyyMM') = {d'2003-05-01'}", "pm3.g1.e1 = '200305'");
    }

    @Ignore(value="we're no longer considering parsedate directly")
    @Test
    public void testRewriteCrit_parseDate2() {
        this.helpTestRewriteCriteria("PARSEDATE(pm3.g1.e1, 'yyyyMM') = {d'2003-05-02'}", FALSE_STR);
    }

    @Ignore(value="Should be moved to the validator")
    @Test
    public void testRewriteCrit_invalidParseDate() {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria("PARSEDATE(pm3.g1.e1, '''') = {d'2003-05-01'}", (QueryMetadataInterface)metadata);
        try {
            QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null);
            Assert.fail((String)"Expected failure");
        }
        catch (TeiidException e) {
            Assert.assertEquals((Object)"Error Code:ERR.015.001.0003 Message:Error simplifying criteria: PARSEDATE(pm3.g1.e1, '''') = {d'2003-05-01'}", (Object)e.getMessage());
        }
    }

    @Test
    public void testRewriteParseDateCast() {
        this.helpTestRewriteCriteria("PARSEDATE(bqt1.smalla.timestampvalue, 'yyyy-MM-dd') = {d'2011-01-10'}", "convert(bqt1.smalla.timestampvalue, date) = {d'2011-01-10'}", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testRewriteParseDateCastString() {
        this.helpTestRewriteCriteria("PARSEDATE(bqt1.smalla.stringkey, 'yyyy-MM-dd') = {d'2011-01-10'}", "convert(parsetimestamp(bqt1.smalla.stringkey, 'yyyy-MM-dd'), date) = {d'2011-01-10'}", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testRewriteParseTimeCast() {
        this.helpTestRewriteCriteria("PARSETIME(bqt1.smalla.timestampvalue, 'hh:mm:ss') = {t'12:00:00'}", "convert(bqt1.smalla.timestampvalue, time) = {t'12:00:00'}", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testRewriteFormatDateCast() {
        this.helpTestRewriteCriteria("FormatDATE(bqt1.smalla.datevalue, 'yyyy-MM-dd') = {d'2011-01-10'}", "bqt1.smalla.datevalue = {d'2011-01-10'}", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testRewriteFormatTimeCast() {
        this.helpTestRewriteCriteria("FormatTIME(bqt1.smalla.timevalue, 'hh:mm:ss') = {t'12:00:00'}", "bqt1.smalla.timevalue = {t'12:00:00'}", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseTime() {
        this.helpTestRewriteCriteria("PARSETIME(pm3.g1.e1, 'HH mm ss') = {t'13:25:04'}", "pm3.g1.e1 = '13 25 04'");
    }

    @Test
    public void testRewriteCrit_parseTimestamp() {
        this.helpTestRewriteCriteria("PARSETimestamp(pm3.g1.e1, 'yyyy dd mm') = {ts'2003-05-01 13:25:04.5'}", FALSE_STR);
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseTimestamp1() {
        this.helpTestRewriteCriteria("PARSETimestamp(pm3.g1.e1, 'yyyy dd mm') = {ts'2003-01-01 00:25:00.0'}", "pm3.g1.e1 = '2003 01 25'");
    }

    @Test
    public void testRewriteCrit_parseTimestamp2() {
        this.helpTestRewriteCriteria("PARSETimestamp(CONVERT(pm3.g1.e2, string), 'yyyy-MM-dd') = {ts'2003-05-01 13:25:04.5'}", FALSE_STR);
    }

    @Test
    public void testRewriteCrit_parseTimestamp3() {
        this.helpTestRewriteCriteria("PARSETimestamp(pm3.g1.e1, 'yyyy dd mm') <> {ts'2003-05-01 13:25:04.5'}", "pm3.g1.e1 is not null");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseTimestamp4() {
        this.helpTestRewriteCriteria("PARSETimestamp(CONVERT(pm3.g1.e2, string), 'yyyy-MM-dd') = {ts'2003-05-01 00:00:00.0'}", "pm3.g1.e2 = {d'2003-05-01'}");
    }

    @Test
    public void testRewriteCrit_parseTimestamp_notEquality() {
        this.helpTestRewriteCriteria("PARSETimestamp(pm3.g1.e1, 'yyyy dd mm') > {ts'2003-05-01 13:25:04.5'}", "PARSETimestamp(pm3.g1.e1, 'yyyy dd mm') > {ts'2003-05-01 13:25:04.5'}");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseTimestamp_decompose() {
        this.helpTestRewriteCriteria("PARSETIMESTAMP(CONCAT(FORMATDATE(pm3.g1.e2, 'yyyyMMdd'), FORMATTIME(pm3.g1.e3, 'HHmmss')), 'yyyyMMddHHmmss') = PARSETIMESTAMP('19690920183045', 'yyyyMMddHHmmss')", "(pm3.g1.e2 = {d'1969-09-20'}) AND (pm3.g1.e3 = {t'18:30:45'})");
    }

    @Test
    public void testRewriteCrit_timestampCreate_decompose() {
        this.helpTestRewriteCriteria("timestampCreate(pm3.g1.e2, pm3.g1.e3) = PARSETIMESTAMP('19690920183045', 'yyyyMMddHHmmss')", "(pm3.g1.e2 = {d'1969-09-20'}) AND (pm3.g1.e3 = {t'18:30:45'})");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseInteger() {
        this.helpTestRewriteCriteria("parseInteger(pm1.g1.e1, '#,##0') = 1234", "pm1.g1.e1 = '1,234'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseLong() {
        this.helpTestRewriteCriteria("parseLong(pm1.g1.e1, '#,##0') = convert(1234, long)", "pm1.g1.e1 = '1,234'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseBigInteger() {
        this.helpTestRewriteCriteria("parseBigInteger(pm1.g1.e1, '#,##0') = convert(1234, biginteger)", "pm1.g1.e1 = '1,234'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseFloat() {
        this.helpTestRewriteCriteria("parseFloat(pm1.g1.e1, '#,##0.###') = convert(1234.123, float)", "pm1.g1.e1 = '1,234.123'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseDouble() {
        this.helpTestRewriteCriteria("parseDouble(pm1.g1.e1, '$#,##0.00') = convert(1234.5, double)", "pm1.g1.e1 = '$1,234.50'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCrit_parseBigDecimal() {
        this.helpTestRewriteCriteria("parseBigDecimal(pm1.g1.e1, '#,##0.###') = convert(1234.1234, bigdecimal)", "pm1.g1.e1 = '1,234.123'");
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatDate() {
        this.helpTestRewriteCriteria("formatDate(pm3.g1.e2, 'yyyyMMdd') = '20030501'", "pm3.g1.e2 = {d'2003-05-01'}");
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatTime() {
        this.helpTestRewriteCriteria("formatTime(pm3.g1.e3, 'HH mm ss') = '13 25 04'", "pm3.g1.e3 = {t'13:25:04'}");
    }

    @Test
    public void testRewriteCrit_formatTimestamp() {
        this.helpTestRewriteCriteria("formatTimestamp(pm3.g1.e4, 'MM dd, yyyy - HH:mm:ss') = '05 01, 1974 - 07:00:00'", "formatTimestamp(pm3.g1.e4, 'MM dd, yyyy - HH:mm:ss') = '05 01, 1974 - 07:00:00'");
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatTimestamp1() {
        this.helpTestRewriteCriteria("formatTimestamp(pm3.g1.e4, 'MM dd, yyyy - HH:mm:ss.S') = '05 01, 1974 - 07:00:00.0'", "pm3.g1.e4 = {ts'1974-05-01 07:00:00.0'}");
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatInteger() {
        this.helpTestRewriteCriteria("formatInteger(pm1.g1.e2, '#,##0') = '1,234'", "pm1.g1.e2 = 1234");
    }

    @Test
    public void testRewriteCrit_formatInteger1() throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        this.helpTestRewriteCriteria("formatInteger(pm1.g1.e2, '#5') = '105'", "formatbigdecimal(convert(pm1.g1.e2, bigdecimal), '#5') = '105'", true);
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatLong() {
        this.helpTestRewriteCriteria("formatLong(convert(pm1.g1.e2, long), '#,##0') = '1,234,567,890,123'", FALSE_STR);
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatLong1() {
        this.helpTestRewriteCriteria("formatLong(convert(pm1.g1.e2, long), '#,##0') = '1,234,567,890'", "pm1.g1.e2 = 1234567890");
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatTimestampInvert() {
        String original = "formatTimestamp(pm3.g1.e4, 'MM dd, yyyy - HH:mm:ss.S') = ?";
        String expected = "pm3.g1.e4 = parseTimestamp(?, 'MM dd, yyyy - HH:mm:ss.S')";
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteCrit_plusInvert() {
        String original = "pm1.g1.e2 + 1.1 = ?";
        String expected = "convert(pm1.g1.e2, bigdecimal) = ? - 1.1";
        this.helpTestRewriteCriteria(original, expected);
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatBigInteger() throws Exception {
        String original = "formatBigInteger(convert(pm1.g1.e2, biginteger), '#,##0') = '1,234,567,890'";
        String expected = "pm1.g1.e2 = 1234567890";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria(original, (QueryMetadataInterface)metadata);
        Criteria expectedCrit = this.parseCriteria(expected, (QueryMetadataInterface)metadata);
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null);
        Assert.assertEquals((String)"Did not rewrite correctly: ", (Object)expectedCrit, (Object)actual);
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatFloat() throws Exception {
        String original = "formatFloat(convert(pm1.g1.e4, float), '#,##0.###') = '1,234.123'";
        String expected = "pm1.g1.e4 = 1234.123046875";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria(original, (QueryMetadataInterface)metadata);
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null);
        Assert.assertEquals((String)"Did not rewrite correctly: ", (Object)expected, (Object)actual.toString());
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatDouble() throws Exception {
        String original = "formatDouble(convert(pm1.g1.e4, double), '$#,##0.00') = '$1,234.50'";
        String expected = "pm1.g1.e4 = '1234.5'";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria(original, (QueryMetadataInterface)metadata);
        Criteria expectedCrit = this.parseCriteria(expected, (QueryMetadataInterface)metadata);
        ((CompareCriteria)expectedCrit).setRightExpression((Expression)new Constant((Object)new Double(1234.5)));
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null);
        Assert.assertEquals((String)"Did not rewrite correctly: ", (Object)expectedCrit, (Object)actual);
    }

    @Ignore(value="Cannot deterime if the format is narrowing")
    @Test
    public void testRewriteCrit_formatBigDecimal() throws Exception {
        String original = "formatBigDecimal(convert(pm1.g1.e4, bigdecimal), '#,##0.###') = '1,234.5'";
        String expected = "pm1.g1.e4 = 1234.5";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria(original, (QueryMetadataInterface)metadata);
        Criteria expectedCrit = this.parseCriteria(expected, (QueryMetadataInterface)metadata);
        Criteria actual = QueryRewriter.rewriteCriteria((Criteria)origCrit, null, null);
        Assert.assertEquals((String)"Did not rewrite correctly: ", (Object)expectedCrit, (Object)actual);
    }

    @Test
    public void testRewriteCritTimestampDiffDate1() {
        this.helpTestRewriteCriteria("timestampdiff(SQL_TSI_DAY, {d'2003-05-15'}, {d'2003-05-17'} ) = 2", TRUE_STR);
    }

    @Test
    public void testRewriteCritTimestampDiffDate2() {
        this.helpTestRewriteCriteria("timestampdiff(SQL_TSI_DAY, {d'2003-06-02'}, {d'2003-05-17'} ) = -16", TRUE_STR);
    }

    @Test
    public void testRewriteCritTimestampDiffDate3() {
        this.helpTestRewriteCriteria("timestampdiff(SQL_TSI_QUARTER, {d'2002-01-25'}, {d'2003-06-01'} ) = 5", TRUE_STR);
    }

    @Test
    public void testRewriteCritTimestampDiffTime1() {
        this.helpTestRewriteCriteria("timestampdiff(SQL_TSI_HOUR, {t'03:04:45'}, {t'05:05:36'} ) = 2", TRUE_STR);
    }

    @Test
    public void testRewriteCritTimestampDiffTime1_ignorecase() {
        this.helpTestRewriteCriteria("timestampdiff(SQL_tsi_HOUR, {t'03:04:45'}, {t'05:05:36'} ) = 2", TRUE_STR);
    }

    @Test
    public void testRewriteOr1() {
        this.helpTestRewriteCriteria("(5 = 5) OR (0 = 1)", TRUE_STR);
    }

    @Test
    public void testRewriteOr2() {
        this.helpTestRewriteCriteria("(0 = 1) OR (5 = 5)", TRUE_STR);
    }

    @Test
    public void testRewriteOr3() {
        this.helpTestRewriteCriteria("(1 = 1) OR (5 = 5)", TRUE_STR);
    }

    @Test
    public void testRewriteOr4() {
        this.helpTestRewriteCriteria("(0 = 1) OR (4 = 5)", FALSE_STR);
    }

    @Test
    public void testRewriteOr5() {
        this.helpTestRewriteCriteria("(0 = 1) OR (4 = 5) OR (pm1.g1.e1 = 'x')", "(pm1.g1.e1 = 'x')");
    }

    @Test
    public void testRewriteOr6() {
        this.helpTestRewriteCriteria("(0 = 1) OR (4 = 5) OR (pm1.g1.e1 = 'x') OR (pm1.g1.e1 = 'y')", "pm1.g1.e1 IN ('x', 'y')");
    }

    @Test
    public void testRewriteOr7() {
        this.helpTestRewriteCriteria("(pm1.g1.e1 = 'x') OR (pm1.g1.e1 = 'y')", "pm1.g1.e1 IN ('x', 'y')");
    }

    @Test
    public void testRewriteAnd1() {
        this.helpTestRewriteCriteria("(5 = 5) AND (0 = 1)", FALSE_STR);
    }

    @Test
    public void testRewriteAnd2() {
        this.helpTestRewriteCriteria("(0 = 1) AND (5 = 5)", FALSE_STR);
    }

    @Test
    public void testRewriteAnd3() {
        this.helpTestRewriteCriteria("(1 = 1) AND (5 = 5)", TRUE_STR);
    }

    @Test
    public void testRewriteAnd4() {
        this.helpTestRewriteCriteria("(0 = 1) AND (4 = 5)", FALSE_STR);
    }

    @Test
    public void testRewriteAnd5() {
        this.helpTestRewriteCriteria("(1 = 1) AND (5 = 5) AND (pm1.g1.e1 = 'x')", "(pm1.g1.e1 = 'x')");
    }

    @Test
    public void testRewriteAnd6() {
        this.helpTestRewriteCriteria("(1 = 1) AND (5 = 5) AND (pm1.g1.e1 = 'x')", "(pm1.g1.e1 = 'x')");
    }

    @Test
    public void testRewriteAnd7() {
        this.helpTestRewriteCriteria("(pm1.g1.e1 = 'x') AND (lower(pm1.g1.e1) = 'y')", "(pm1.g1.e1 = 'x') AND (lcase(pm1.g1.e1) = 'y')");
    }

    @Test
    public void testRewriteMixed1() {
        this.helpTestRewriteCriteria("((1=1) AND (1=1)) OR ((1=1) AND (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed2() {
        this.helpTestRewriteCriteria("((1=2) AND (1=1)) OR ((1=1) AND (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed3() {
        this.helpTestRewriteCriteria("((1=1) AND (1=2)) OR ((1=1) AND (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed4() {
        this.helpTestRewriteCriteria("((1=1) AND (1=1)) OR ((1=2) AND (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed5() {
        this.helpTestRewriteCriteria("((1=1) AND (1=1)) OR ((1=1) AND (1=2))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed6() {
        this.helpTestRewriteCriteria("((1=2) AND (1=1)) OR ((1=2) AND (1=1))", FALSE_STR);
    }

    @Test
    public void testRewriteMixed7() {
        this.helpTestRewriteCriteria("((1=1) AND (1=2)) OR ((1=1) AND (1=2))", FALSE_STR);
    }

    @Test
    public void testRewriteMixed8() {
        this.helpTestRewriteCriteria("((1=2) AND (1=2)) OR ((1=2) AND (1=2))", FALSE_STR);
    }

    @Test
    public void testRewriteMixed9() {
        this.helpTestRewriteCriteria("((1=1) OR (1=1)) AND ((1=1) OR (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed10() {
        this.helpTestRewriteCriteria("((1=2) OR (1=1)) AND ((1=1) OR (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed11() {
        this.helpTestRewriteCriteria("((1=1) OR (1=2)) AND ((1=1) OR (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed12() {
        this.helpTestRewriteCriteria("((1=1) OR (1=1)) AND ((1=2) OR (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed13() {
        this.helpTestRewriteCriteria("((1=1) OR (1=1)) AND ((1=1) OR (1=2))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed14() {
        this.helpTestRewriteCriteria("((1=2) OR (1=1)) AND ((1=2) OR (1=1))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed15() {
        this.helpTestRewriteCriteria("((1=1) OR (1=2)) AND ((1=1) OR (1=2))", TRUE_STR);
    }

    @Test
    public void testRewriteMixed16() {
        this.helpTestRewriteCriteria("((1=2) OR (1=2)) AND ((1=2) OR (1=2))", FALSE_STR);
    }

    @Test
    public void testRewriteNot1() {
        this.helpTestRewriteCriteria("NOT (1=1)", FALSE_STR);
    }

    @Test
    public void testRewriteNot2() {
        this.helpTestRewriteCriteria("NOT (1=2)", TRUE_STR);
    }

    @Test
    public void testRewriteNot3() {
        this.helpTestRewriteCriteria("NOT (pm1.g1.e1='x')", "pm1.g1.e1 <> 'x'");
    }

    @Test
    public void testRewriteDefect1() {
        this.helpTestRewriteCriteria("(('DE' = 'LN') AND (null > '2002-01-01')) OR (('DE' = 'DE') AND (pm1.g1.e1 > '9000000'))", "(pm1.g1.e1 > '9000000')");
    }

    @Test
    public void testRewriteQueryCriteriaAlwaysTrue() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 WHERE 0 = 0", "SELECT e1 FROM pm1.g1");
    }

    @Test
    public void testSubquery1() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM (SELECT e1 FROM pm1.g1 WHERE (1 - 1) = (0 + 0)) AS x", "SELECT e1 FROM (SELECT e1 FROM pm1.g1) AS x");
    }

    @Test
    public void testExistsSubquery() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 WHERE EXISTS (SELECT e1 FROM pm1.g2)", "SELECT e1 FROM pm1.g1 WHERE EXISTS (SELECT e1 FROM pm1.g2 LIMIT 1)");
    }

    @Test
    public void testCompareSubqueryANY() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 WHERE '3' = ANY (SELECT e1 FROM pm1.g2)", "SELECT e1 FROM pm1.g1 WHERE '3' IN (SELECT e1 FROM pm1.g2)");
    }

    @Test
    public void testCompareSubquery() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 WHERE '3' = SOME (SELECT e1 FROM pm1.g2)", "SELECT e1 FROM pm1.g1 WHERE '3' IN (SELECT e1 FROM pm1.g2)");
    }

    @Test
    public void testCompareSubqueryUnknown() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 WHERE null = SOME (SELECT e1 FROM pm1.g2)", "SELECT e1 FROM pm1.g1 WHERE null IN (SELECT e1 FROM pm1.g2 LIMIT 1)");
    }

    @Test
    public void testINClauseSubquery() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 WHERE '3' IN (SELECT e1 FROM pm1.g2)", "SELECT e1 FROM pm1.g1 WHERE '3' IN (SELECT e1 FROM pm1.g2)");
    }

    @Test
    public void testRewriteLookupFunction1() {
        String criteria = "lookup('pm1.g1','e1', 'e2', 1) = 'ab'";
        CompareCriteria expected = (CompareCriteria)this.parseCriteria(criteria, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        this.helpTestRewriteCriteria(criteria, (Criteria)expected, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testRewriteLookupFunction1b() {
        this.helpTestRewriteCriteria("lookup('pm1.g1','e1', 'e2', pm1.g1.e2) = 'ab'", "lookup('pm1.g1','e1', 'e2', pm1.g1.e2) = 'ab'");
    }

    @Test
    public void testRewriteLookupFunctionCompoundCriteria() {
        String criteria = "LOOKUP('pm1.g1','e1', 'e2', 1) IS NULL AND pm1.g1.e1='1'";
        CompoundCriteria expected = (CompoundCriteria)this.parseCriteria(criteria, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        this.helpTestRewriteCriteria("LOOKUP('pm1.g1','e1', 'e2', 1) IS NULL AND pm1.g1.e1=1", (Criteria)expected, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testSelectWithNoFrom() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT 5", "SELECT 5");
    }

    @Test
    public void testStoredProcedure_9822() throws Exception {
        QueryParser parser = new QueryParser();
        Command command = parser.parseCommand("exec pm1.sp4(5)");
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        Command rewriteCommand = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)metadata, null);
        Collection parameters = ((StoredProcedure)rewriteCommand).getParameters();
        for (SPParameter param : parameters) {
            if (param.getParameterType() != 1 && param.getParameterType() != 3) continue;
            Assert.assertTrue((boolean)(param.getExpression() instanceof Constant));
        }
    }

    @Test
    public void testRewriteFunctionThrowsEvaluationError() {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria("5 / 0 = 5", (QueryMetadataInterface)metadata);
        try {
            QueryRewriter.rewriteCriteria((Criteria)origCrit, null, (QueryMetadataInterface)metadata);
            Assert.fail((String)"Expected QueryValidatorException due to divide by 0");
        }
        catch (TeiidException e) {
            Assert.assertEquals((Object)"TEIID30328 Unable to evaluate (5 / 0): TEIID30384 Error while evaluating function /", (Object)e.getMessage());
        }
    }

    @Test
    public void testRewriteConvertThrowsEvaluationError() {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Criteria origCrit = this.parseCriteria("convert('x', integer) = 0", (QueryMetadataInterface)metadata);
        try {
            QueryRewriter.rewriteCriteria((Criteria)origCrit, null, (QueryMetadataInterface)metadata);
            Assert.fail((String)"Expected QueryValidatorException due to invalid string");
        }
        catch (TeiidException e) {
            Assert.assertEquals((Object)"TEIID30328 Unable to evaluate convert('x', integer): TEIID30384 Error while evaluating function convert", (Object)e.getMessage());
        }
    }

    @Test
    public void testRewriteCase1954() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) = '3'", "pm1.g1.e2 = 3");
    }

    @Test
    public void testRewriteCase1954a() {
        this.helpTestRewriteCriteria("cast(pm1.g1.e2 as string) = '3'", "pm1.g1.e2 = 3");
    }

    @Test
    public void testRewriteCase1954b() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        CompareCriteria expected = new CompareCriteria();
        ElementSymbol leftElement = new ElementSymbol("pm1.g1.e4");
        Constant constant = new Constant((Object)new Double(3.0), DataTypeManager.DefaultDataClasses.DOUBLE);
        expected.setLeftExpression((Expression)leftElement);
        expected.setRightExpression((Expression)constant);
        QueryResolver.resolveCriteria((Criteria)expected, (QueryMetadataInterface)metadata);
        this.helpTestRewriteCriteria("convert(pm1.g1.e4, string) = '3.0'", (Criteria)expected, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteCase1954c() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e1, string) = 'x'", "pm1.g1.e1 = 'x'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteCase1954d() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e1, timestamp) = {ts '2005-01-03 00:00:00.0'}", "pm1.g1.e1 = '2005-01-03 00:00:00.0'");
    }

    @Test
    public void testRewriteCase1954e() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e4, integer) = 2", "convert(pm1.g1.e4, integer) = 2");
    }

    @Test
    public void testRewriteCase1954f() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) = 'x'", FALSE_STR);
    }

    @Test
    public void testRewriteCase1954f1() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) != 'x'", "pm1.g1.e2 is not null");
    }

    @Test
    public void testRewriteCase1954Set() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) in ('2', '3')", "pm1.g1.e2 IN (2,3)");
    }

    @Test
    public void testRewriteCase1954SetA() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) in ('2', 'x')", "pm1.g1.e2 = 2");
    }

    @Test
    public void testRewriteCase1954SetB() {
        this.helpTestRewriteCriteria("cast(pm1.g1.e2 as string) in ('2', '3')", "pm1.g1.e2 IN (2,3)");
    }

    @Test
    public void testRewriteCase1954SetC() {
        this.helpTestRewriteCriteria("concat(pm1.g1.e2, 'string') in ('2', '3')", "concat(convert(pm1.g1.e2, string), 'string') in ('2', '3')");
    }

    @Test
    public void testRewriteCase1954SetD() {
        this.helpTestRewriteCriteria("convert(pm1.g1.e2, string) in ('2', pm1.g1.e1)", "convert(pm1.g1.e2, string) in ('2', pm1.g1.e1)");
    }

    @Test
    public void testRewriteCaseExpr1() {
        this.helpTestRewriteCriteria("case when 0=0 then 1 else 2 end = 1", TRUE_STR);
    }

    @Test
    public void testRewriteCaseExpr1a() {
        this.helpTestRewriteCriteria("case when pm1.g1.e1 = 'a' then 3 when 0=0 then 1 when 1=1 then 4 else 2 end = 1", "CASE WHEN pm1.g1.e1 = 'a' THEN 3 WHEN 1 = 1 THEN 1 END = 1");
    }

    @Test
    public void testRewriteCaseExpr2() {
        this.helpTestRewriteCriteria("case when 0=1 then 1 else 2 end = 1", FALSE_STR);
    }

    @Test
    public void testRewriteCaseExpr3() {
        this.helpTestRewriteCriteria("case when 0 = pm1.g1.e2 then 1 else 2 end = 1", "CASE WHEN pm1.g1.e2 = 0 THEN 1 ELSE 2 END = 1");
    }

    @Test
    public void testRewriteCaseExpr4() {
        this.helpTestRewriteCriteria("lookup('pm1.g1', 'e2', 'e1', case when 1=1 then pm1.g1.e1 end) = 0", "lookup('pm1.g1', 'e2', 'e1', pm1.g1.e1) = 0");
    }

    @Test
    public void testRewriteCaseExpr5() {
        this.helpTestRewriteCriteria("case when 0=1 then 1 when 0 = pm1.g1.e2 then 2 else 3 end = 1", "CASE WHEN pm1.g1.e2 = 0 THEN 2 ELSE 3 END = 1");
    }

    @Test
    public void testRewriteCaseExprForCase5413aFrom502() {
        this.helpTestRewriteCriteria("pm1.g2.e1 = case when 0 = pm1.g1.e2 then 2 else 2 end", "pm1.g2.e1 = '2'");
    }

    @Test
    public void testRewriteCaseExprForCase5413bFrom502() {
        this.helpTestRewriteCriteria("case when 0 = pm1.g1.e2 then null else null end IS NULL", TRUE_STR);
    }

    @Test
    public void testRewriteConstantAgg2() throws Exception {
        TestQueryRewriter.helpTestRewriteCommand("select count(2) from pm1.g1 group by e1", "SELECT COUNT(2) FROM pm1.g1 GROUP BY e1");
    }

    @Test
    public void testRewriteCaseExprForCase5413a() {
        this.helpTestRewriteCriteria("pm1.g2.e1 = case when 0 = pm1.g1.e2 then 2 else 2 end", "pm1.g2.e1 = '2'");
    }

    @Test
    public void testRewriteCaseExprForCase5413b() {
        this.helpTestRewriteCriteria("case when 0 = pm1.g1.e2 then null else null end IS NULL", TRUE_STR);
    }

    @Test
    public void testRewriteSearchedCaseExpr1() {
        this.helpTestRewriteCriteria("case 0 when 0 then 1 else 2 end = 1", TRUE_STR);
    }

    @Test
    public void testRewriteSearchedCaseExpr2() {
        this.helpTestRewriteCriteria("case 0 when 1 then 1 else 2 end = 1", FALSE_STR);
    }

    @Test
    public void testRewriteSearchedCaseExpr3() {
        this.helpTestRewriteCriteria("case 0 when pm1.g1.e2 then 1 else 2 end = 1", "CASE WHEN pm1.g1.e2 = 0 THEN 1 ELSE 2 END = 1");
    }

    @Test
    public void testRewriteSearchedCaseExpr4() {
        String criteria = "lookup('pm1.g1', 'e2', 'e1', '2') = 0";
        CompareCriteria expected = (CompareCriteria)this.parseCriteria(criteria, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        this.helpTestRewriteCriteria("lookup('pm1.g1', 'e2', 'e1', case 0 when 1 then pm1.g1.e1 else 2 end) = 0", (Criteria)expected, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testRewriteSearchedCaseExpr5() {
        this.helpTestRewriteCriteria("case 0 when 1 then 1 when pm1.g1.e2 then 2 else 3 end = 1", "CASE WHEN pm1.g1.e2 = 0 THEN 2 ELSE 3 END = 1");
    }

    @Test
    public void testDefect16879_1() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodestring(e1, 'a, b') FROM pm1.g1", "SELECT CASE WHEN e1 = 'a' THEN 'b' ELSE e1 END FROM pm1.g1");
    }

    @Test
    public void testDefect16879_2() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodestring(e1, 'a, b, c, d') FROM pm1.g1", "SELECT CASE WHEN e1 = 'a' THEN 'b' WHEN e1 = 'c' THEN 'd' ELSE e1 END FROM pm1.g1");
    }

    @Test
    public void testDefect16879_3() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodeinteger(e1, 'a, b') FROM pm1.g1", "SELECT convert(CASE WHEN e1 = 'a' THEN 'b' ELSE e1 END, integer) FROM pm1.g1");
    }

    @Test
    public void testDefect16879_4() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodeinteger(e1, 'a, b, c, d') FROM pm1.g1", "SELECT convert(CASE WHEN e1 = 'a' THEN 'b' WHEN e1 = 'c' THEN 'd' ELSE e1 END, integer) FROM pm1.g1");
    }

    @Test
    public void testDefect16879_5() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodeinteger(e1, 'null, b, c, d') FROM pm1.g1", "SELECT convert(CASE WHEN e1 IS NULL THEN 'b' WHEN e1 = 'c' THEN 'd' ELSE e1 END, integer) FROM pm1.g1");
    }

    @Test
    public void testDefect16879_6() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodeinteger(e1, 'a, b, null, d') FROM pm1.g1", "SELECT convert(CASE WHEN e1 = 'a' THEN 'b' WHEN e1 IS NULL THEN 'd' ELSE e1 END, integer) FROM pm1.g1");
    }

    @Test
    public void testDefect16879_7() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT decodeinteger(e1, 'a, b, null, d, e') FROM pm1.g1", "SELECT convert(CASE WHEN e1 = 'a' THEN 'b' WHEN e1 IS NULL THEN 'd' ELSE 'e' END, integer) FROM pm1.g1");
    }

    @Test
    public void testCaseExpressionThatResolvesToNull() {
        String sqlBefore = "SELECT CASE 'x' WHEN 'Old Inventory System' THEN NULL WHEN 'New Inventory System' THEN NULL END";
        String sqlAfter = "SELECT null";
        Command cmd = TestQueryRewriter.helpTestRewriteCommand(sqlBefore, sqlAfter);
        Expression es = (Expression)cmd.getProjectedSymbols().get(0);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)es.getType());
    }

    @Test
    public void testRewriteExec() throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand("exec pm1.sq2(session_id())");
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        CommandContext context = new CommandContext();
        context.setConnectionID("1");
        Command rewriteCommand = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CommandContext)context);
        Assert.assertEquals((Object)"EXEC pm1.sq2('1')", (Object)rewriteCommand.toString());
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteNestedFunctions() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 where convert(parsedate(e1, 'yyyy-MM-dd'), string) = '2006-07-01'", "SELECT e1 FROM pm1.g1 WHERE e1 = '2006-07-01'");
    }

    @Ignore(value="It's not generally possible to invert a narrowing conversion")
    @Test
    public void testRewriteWithReference() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT e1 FROM pm1.g1 where parsetimestamp(e1, 'yyyy-MM-dd') != ?", "SELECT e1 FROM pm1.g1 WHERE e1 <> formattimestamp(?, 'yyyy-MM-dd')");
    }

    @Test
    public void testRewiteJoinCriteria() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT pm1.g1.e1 FROM pm1.g1 inner join pm1.g2 on (pm1.g1.e1 = null)", "SELECT pm1.g1.e1 FROM pm1.g1 INNER JOIN pm1.g2 ON 1 = 0");
    }

    @Test
    public void testRewiteCompoundCriteria() {
        this.helpTestRewriteCriteria("(pm1.g1.e1 = 1 and pm1.g1.e2 = 2) and (pm1.g1.e3 = 1 and pm1.g1.e4 = 2.0e0)", "(pm1.g1.e1 = '1') AND (pm1.g1.e2 = 2) AND (pm1.g1.e3 = TRUE) AND (pm1.g1.e4 = 2.0e0)");
    }

    @Test
    public void testRewriteWhile1() throws Exception {
        String procedure = "FOR EACH ROW\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "while (1 = 0)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select vm1.g1.e1 from vm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userQuery = "Insert into vm1.g1 (e1, e2) values ('String', 1)";
        String rewritProc = "FOR EACH ROW\n";
        rewritProc = rewritProc + "BEGIN ATOMIC\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, Table.TriggerEvent.INSERT);
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRewriteProcedureWithCount() throws Exception {
        String procedure = "FOR EACH ROW\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select count(*) from pm1.g1;\n";
        procedure = procedure + "END\n";
        String userQuery = "Insert into vm1.g1 (e1, e2) values ('String', 1)";
        String rewritProc = "FOR EACH ROW\n";
        rewritProc = rewritProc + "BEGIN ATOMIC\n";
        rewritProc = rewritProc + "SELECT COUNT(*) FROM pm1.g1;\n";
        rewritProc = rewritProc + "END";
        String procReturned = this.getRewritenProcedure(procedure, userQuery, Table.TriggerEvent.INSERT);
        Assert.assertEquals((String)"Rewritten command was not expected", (Object)rewritProc, (Object)procReturned);
    }

    @Test
    public void testRemoveEmptyLoop() {
        String procedure1 = "CREATE virtual PROCEDURE  ";
        procedure1 = procedure1 + "BEGIN\n";
        procedure1 = procedure1 + "loop on (select e1 from pm1.g1) as myCursor\n";
        procedure1 = procedure1 + "begin\n";
        procedure1 = procedure1 + "end\n";
        procedure1 = procedure1 + "select e1 from pm1.g1;\n";
        procedure1 = procedure1 + "END";
        String expected = "BEGIN\nSELECT e1 FROM pm1.g1;\nEND";
        TestQueryRewriter.helpTestRewriteCommand(procedure1, expected);
    }

    @Test
    public void testRetainAtomic() {
        String procedure1 = "CREATE virtual PROCEDURE ";
        procedure1 = procedure1 + "if (true)\n";
        procedure1 = procedure1 + "begin atomic\n";
        procedure1 = procedure1 + "select e1 from pm1.g1;\n";
        procedure1 = procedure1 + "end\n";
        String expected = "BEGIN\nBEGIN ATOMIC\nSELECT e1 FROM pm1.g1;\nEND\nEND";
        TestQueryRewriter.helpTestRewriteCommand(procedure1, expected);
    }

    @Test
    public void testExceptionHandling() {
        String procedure1 = "CREATE virtual PROCEDURE begin ";
        procedure1 = procedure1 + "select 1/0;\n";
        procedure1 = procedure1 + "exception e\n";
        procedure1 = procedure1 + "end\n";
        String expected = "BEGIN\nRAISE 'org.teiid.api.exception.query.ExpressionEvaluationException: TEIID30328 Unable to evaluate (1 / 0): TEIID30384 Error while evaluating function /';\nEXCEPTION e\nEND";
        TestQueryRewriter.helpTestRewriteCommand(procedure1, expected);
    }

    @Test
    public void testRewriteDeclare() {
        String procedure1 = "CREATE virtual PROCEDURE  ";
        procedure1 = procedure1 + "BEGIN\n";
        procedure1 = procedure1 + "declare integer x = 1 + 1;\n";
        procedure1 = procedure1 + "END";
        String expected = "BEGIN\nDECLARE integer x = 2;\nEND";
        TestQueryRewriter.helpTestRewriteCommand(procedure1, expected);
    }

    @Test
    public void testRewriteUnionJoin() {
        String sql = "select pm1.g1.e1 from pm1.g1 union join pm1.g2 where g1.e1 = 1";
        String expected = "SELECT pm1.g1.e1 FROM pm1.g1 FULL OUTER JOIN pm1.g2 ON 1 = 0 WHERE g1.e1 = '1'";
        TestQueryRewriter.helpTestRewriteCommand(sql, expected);
    }

    @Test
    public void testRewriteNonNullDependentFunction() {
        this.helpTestRewriteCriteria("pm1.g1.e1 = concat(null, pm1.g1.e2)", "null <> null");
    }

    @Test
    public void testRewriteInWithNull() {
        this.helpTestRewriteCriteria("convert(null, string) in (pm1.g1.e1, pm1.g1.e2)", "null <> null");
    }

    @Test
    public void testRewriteCorrelatedSubqueryInHaving() throws Exception {
        String sql = "select pm1.g1.e1 from pm1.g1 group by pm1.g1.e1 having pm1.g1.e1 in (select pm1.g1.e1 from pm1.g2)";
        String expected = "SELECT pm1.g1.e1 FROM pm1.g1 GROUP BY pm1.g1.e1 HAVING pm1.g1.e1 IN (SELECT pm1.g1.e1 FROM pm1.g2)";
        Query query = (Query)TestQueryRewriter.helpTestRewriteCommand(sql, expected);
        LinkedList refs = new LinkedList();
        GroupSymbol gs = new GroupSymbol("pm1.g1");
        ResolverUtil.resolveGroup((GroupSymbol)gs, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        CorrelatedReferenceCollectorVisitor.collectReferences((LanguageObject)query.getHaving(), Arrays.asList(gs), refs, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals((long)1L, (long)refs.size());
    }

    @Test
    public void testRewriteSelectInto() {
        String sql = "select distinct pm1.g1.e1 into #temp from pm1.g1";
        String expected = "INSERT INTO #temp (e1) SELECT DISTINCT pm1.g1.e1 FROM pm1.g1";
        TestQueryRewriter.helpTestRewriteCommand(sql, expected);
    }

    @Test
    public void testRewriteSelectInto1() {
        String sql = "select distinct e2, e2, e3, e4 into pm1.g1 from pm1.g2";
        String expected = "INSERT INTO pm1.g1 (e1, e2, e3, e4) SELECT convert(X.e2, string) AS e1, X.e2_0 AS e2, X.e3, X.e4 FROM (SELECT DISTINCT e2, e2 AS e2_0, e3, e4 FROM pm1.g2) AS X";
        TestQueryRewriter.helpTestRewriteCommand(sql, expected);
    }

    @Test
    public void testUnionQueryNullInOneBranch() throws Exception {
        this.verifyProjectedTypesOnUnionBranches("SELECT e1, e2 FROM pm1.g1 UNION ALL SELECT e1, null FROM pm1.g2", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER});
    }

    @Test
    public void testUnionQueryNullInOneBranch2() throws Exception {
        this.verifyProjectedTypesOnUnionBranches("SELECT e1, e2 FROM pm1.g1 UNION ALL SELECT e1, e2 FROM pm1.g2 UNION ALL SELECT e1, null FROM pm1.g2", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER});
    }

    @Test
    public void testUnionQueryNullInOneBranch3() throws Exception {
        this.verifyProjectedTypesOnUnionBranches("SELECT e1, null FROM pm1.g1 UNION ALL SELECT e1, null FROM pm1.g2 UNION ALL SELECT e1, e2 FROM pm1.g2", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER});
    }

    @Test
    public void testUnionQueryNullInAllBranches() throws Exception {
        this.verifyProjectedTypesOnUnionBranches("SELECT e1, null FROM pm1.g1 UNION ALL SELECT e1, null FROM pm1.g2 UNION ALL SELECT e1, null FROM pm1.g2", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
    }

    @Test
    public void testUnionQueryWithTypeConversion() throws Exception {
        this.verifyProjectedTypesOnUnionBranches("SELECT e1 FROM pm1.g1 UNION ALL SELECT e2 FROM pm1.g2", new Class[]{DataTypeManager.DefaultDataClasses.STRING});
    }

    private void verifyProjectedTypesOnUnionBranches(String unionQuery, Class<?>[] types) throws TeiidComponentException, TeiidProcessingException {
        SetQuery union = (SetQuery)QueryParser.getQueryParser().parseCommand(unionQuery);
        QueryResolver.resolveCommand((Command)union, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        union = (SetQuery)QueryRewriter.rewrite((Command)union, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null);
        for (QueryCommand query : union.getQueryCommands()) {
            List projSymbols = query.getProjectedSymbols();
            for (int i = 0; i < projSymbols.size(); ++i) {
                Assert.assertEquals((String)("Found type mismatch at column " + i), types[i], (Object)((Expression)projSymbols.get(i)).getType());
            }
        }
    }

    @Test
    public void testSelectIntoWithOrderByAndTypeConversion() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "CREATE local temporary table temp (x string, y integer, z integer);\n";
        procedure = procedure + "Select pm1.g1.e2, 1 as x, 2 as x into temp from pm1.g1 order by pm1.g1.e2 limit 1;\n";
        procedure = procedure + "Select x from temp;\n";
        procedure = procedure + "END\n";
        TestQueryRewriter.helpTestRewriteCommand(procedure, "BEGIN\nCREATE LOCAL TEMPORARY TABLE temp (x string, y integer, z integer);\nINSERT INTO temp (x, y, z) SELECT convert(X.e2, string) AS x, X.x AS y, X.x_0 AS z FROM (SELECT pm1.g1.e2, 1 AS x, 2 AS x_0 FROM pm1.g1 ORDER BY pm1.g1.e2 LIMIT 1) AS X;\nSELECT x FROM temp;\nEND");
    }

    @Test
    public void testRewriteNot() {
        this.helpTestRewriteCriteria("not(not(pm1.g1.e1 = 1 + 1))", "pm1.g1.e1 = '2'");
    }

    @Test
    public void testRewriteQueryWithNoFrom() {
        String sql = "select 1 as a order by a";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT 1 AS a");
    }

    @Test
    public void testVirtualRightOuterJoinSwap() throws Exception {
        String sql = "SELECT sa.IntKey AS sa_IntKey, mb.IntKey AS mb_IntKey FROM (select intkey from BQT1.smalla) sa RIGHT OUTER JOIN (select BQT1.mediumb.intkey from BQT1.mediumb) mb ON sa.IntKey = mb.IntKey";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT sa.IntKey AS sa_IntKey, mb.IntKey AS mb_IntKey FROM (SELECT BQT1.mediumb.intkey FROM BQT1.mediumb) AS mb LEFT OUTER JOIN (SELECT intkey FROM BQT1.smalla) AS sa ON sa.IntKey = mb.IntKey", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testVirtualRightOuterJoinSwap1() throws Exception {
        String sql = "SELECT sa.IntKey AS sa_IntKey, mb.IntKey AS mb_IntKey FROM ((select intkey from BQT1.smalla) sa inner join BQT1.smallb on sa.intkey = smallb.intkey) RIGHT OUTER JOIN (select BQT1.mediumb.intkey from BQT1.mediumb) mb ON sa.IntKey = mb.IntKey";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT sa.IntKey AS sa_IntKey, mb.IntKey AS mb_IntKey FROM (SELECT BQT1.mediumb.intkey FROM BQT1.mediumb) AS mb LEFT OUTER JOIN ((SELECT intkey FROM BQT1.smalla) AS sa INNER JOIN BQT1.smallb ON sa.intkey = smallb.intkey) ON sa.IntKey = mb.IntKey", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testRewriteConcat2() {
        this.helpTestRewriteCriteria("sys.concat2('a','b') = 'ab'", TRUE_STR);
    }

    @Test
    public void testRewriteConcat2_1() {
        this.helpTestRewriteCriteria("concat2(null, null) is null", TRUE_STR);
    }

    @Test
    public void testRewriteConcat2_2() throws Exception {
        this.helpTestRewriteCriteria("concat2(pm1.g1.e1, null) = 'xyz'", "pm1.g1.e1 = 'xyz'", true);
    }

    @Test
    public void testRewriteConcat2_4() throws Exception {
        this.helpTestRewriteCriteria("concat2('a', pm1.g1.e1) = 'xyz'", "concat2('a', pm1.g1.e1) = 'xyz'");
    }

    @Test
    public void testRewriteFromUnixTime() throws Exception {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
        try {
            this.helpTestRewriteCriteria("from_unixtime(pm1.g1.e2) = '1992-12-01 07:00:00'", "from_unixtime(pm1.g1.e2) = {ts'1992-12-01 07:00:00.0'}");
        }
        finally {
            TimestampWithTimezone.resetCalendar(null);
        }
    }

    @Test
    public void testRewriteFromUnixTime_1() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
        try {
            this.helpTestRewriteExpression("from_unixtime(pm1.g1.e2)", "from_unixtime(pm1.g1.e2)", (QueryMetadataInterface)metadata);
        }
        finally {
            TimestampWithTimezone.resetCalendar(null);
        }
    }

    @Test
    public void testRewriteFromUnixTime_2() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
        try {
            this.helpTestRewriteExpression("from_unixtime(1500000000)", "{ts'2017-07-13 20:40:00.0'}", (QueryMetadataInterface)metadata);
        }
        finally {
            TimestampWithTimezone.resetCalendar(null);
        }
    }

    @Test
    public void testRewriteNullIf() throws Exception {
        this.helpTestRewriteCriteria("nullif(pm1.g1.e2, pm1.g1.e4) = 1", "CASE WHEN pm1.g1.e2 = pm1.g1.e4 THEN convert(null, double) ELSE pm1.g1.e2 END = 1.0", true);
    }

    @Test
    public void testRewriteCoalesce() throws Exception {
        this.helpTestRewriteCriteria("coalesce(convert(pm1.g1.e2, double), pm1.g1.e4) = 1", "ifnull(convert(pm1.g1.e2, double), pm1.g1.e4) = 1", true);
    }

    @Test
    public void testAggregateWithBetweenInCaseInSelect() {
        String sqlBefore = "SELECT MAX(CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END) FROM pm1.g1";
        String sqlAfter = "SELECT MAX(CASE WHEN (e2 >= 3) AND (e2 <= 5) THEN e2 ELSE -1 END) FROM pm1.g1";
        TestQueryRewriter.helpTestRewriteCommand(sqlBefore, sqlAfter);
    }

    @Test
    public void testBetweenInCaseInSelect() {
        String sqlBefore = "SELECT CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END FROM pm1.g1";
        String sqlAfter = "SELECT CASE WHEN (e2 >= 3) AND (e2 <= 5) THEN e2 ELSE -1 END FROM pm1.g1";
        TestQueryRewriter.helpTestRewriteCommand(sqlBefore, sqlAfter);
    }

    @Test
    public void testBetweenInCase() {
        String sqlBefore = "SELECT e1 FROM pm1.g1 WHERE e3 = CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END";
        String sqlAfter = "SELECT e1 FROM pm1.g1 WHERE convert(e3, integer) = CASE WHEN (e2 >= 3) AND (e2 <= 5) THEN e2 ELSE -1 END";
        TestQueryRewriter.helpTestRewriteCommand(sqlBefore, sqlAfter);
    }

    @Test
    public void testRewriteNullHandling() {
        String original = "pm1.g1.e1 like '%'";
        String expected = "pm1.g1.e1 is not null";
        this.addTestData();
        this.helpTestRewriteCriteria(original, expected);
    }

    private void addTestData() {
        this.elements = new HashMap<ElementSymbol, Integer>();
        this.elements.put(new ElementSymbol("pm1.g1.e1"), 0);
        this.elements.put(new ElementSymbol("pm1.g1.e2"), 1);
        this.elements.put(new ElementSymbol("pm1.g1.e3"), 2);
        for (String s : Arrays.asList("a", null, "*")) {
            for (Integer i : Arrays.asList(1, null, 6)) {
                for (Boolean b : Arrays.asList(true, false, null)) {
                    this.tuples.add(Arrays.asList(s, i, b));
                }
            }
        }
    }

    @Test
    public void testRewriteNullHandling1() {
        String original = "not(pm1.g1.e1 like '%' or pm1.g1.e1 = '1')";
        String expected = FALSE_STR;
        this.addTestData();
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling2() {
        String original = "not(pm1.g1.e1 like '%' and pm1.g1.e1 = '1')";
        String expected = "pm1.g1.e1 <> '1'";
        this.addTestData();
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling3() {
        String original = "pm1.g1.e1 like '%' or pm1.g1.e1 = '1'";
        String expected = "(pm1.g1.e1 IS NOT NULL) OR (pm1.g1.e1 = '1')";
        this.addTestData();
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling4() {
        String original = "not((pm1.g1.e1 like '%' or pm1.g1.e3 = true) and pm1.g1.e2 < 5)";
        String expected = "pm1.g1.e2 >= 5";
        this.addTestData();
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling4a() {
        String original = "not(not((pm1.g1.e1 like '%' or pm1.g1.e3 = true) and pm1.g1.e2 < 5))";
        String expected = "((pm1.g1.e1 IS NOT NULL) OR (pm1.g1.e3 = TRUE)) AND (pm1.g1.e2 < 5)";
        this.addTestData();
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling5() {
        String original = "not((pm1.g1.e1 not like '%' or pm1.g1.e3 = true) and pm1.g1.e2 < 5)";
        String expected = "((pm1.g1.e1 IS NOT NULL) AND (pm1.g1.e3 <> TRUE)) OR (pm1.g1.e2 >= 5)";
        this.addTestData();
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling6() {
        String original = "not((pm1.g1.e1 not like '%' and pm1.g1.e3 = true) or pm1.g1.e2 < 5)";
        String expected = "((pm1.g1.e1 IS NOT NULL) OR (pm1.g1.e3 <> TRUE)) AND (pm1.g1.e2 >= 5)";
        this.addTestData();
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling7() {
        String original = "not(not(pm1.g1.e1 not like '%' and pm1.g1.e3 = true) or pm1.g1.e2 < 5)";
        String expected = FALSE_STR;
        this.addTestData();
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteNullHandling7a() {
        String original = "not(not(pm1.g1.e1 like '*%' and pm1.g1.e3 = true) or pm1.g1.e2 < 5)";
        String expected = "(pm1.g1.e1 LIKE '*%') AND (pm1.g1.e3 = TRUE) AND (pm1.g1.e2 >= 5)";
        this.addTestData();
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteChar() {
        String original = "convert(pm1.g1.e1, char) = '100'";
        String expected = FALSE_STR;
        this.helpTestRewriteCriteria(original, expected);
    }

    @Test
    public void testRewriteBigDecimal() {
        String original = "convert(BQT1.SmallA.LongNum, bigdecimal) = '22.0'";
        CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("BQT1.SmallA.LongNum"), 1, (Expression)new Constant((Object)new Long(22L)));
        this.helpTestRewriteCriteria(original, (Criteria)crit, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testRewriteWideningIn() {
        String original = "convert(BQT1.SmallA.TimestampValue, time) in ({t'10:00:00'}, {t'11:00:00'})";
        this.helpTestRewriteCriteria(original, this.parseCriteria("convert(BQT1.SmallA.TimestampValue, time) in ({t'10:00:00'}, {t'11:00:00'})", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached()), (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
    }

    @Test
    public void testRewriteParseDate() {
        String original = "parsedate(BQT1.SmallA.stringkey, 'yymmdd') = {d'1970-01-01'}";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        this.helpTestRewriteCriteria(original, this.parseCriteria("convert(parsetimestamp(BQT1.SmallA.stringkey, 'yymmdd'), date) = {d'1970-01-01'}", (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteFormatTime() {
        String original = "formattime(BQT1.SmallA.timevalue, 'hh:mm') = '08:02'";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        this.helpTestRewriteCriteria(original, this.parseCriteria("formattimestamp(convert(BQT1.SmallA.timevalue, timestamp), 'hh:mm') = '08:02'", (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteTimestampAdd() {
        String original = "timestampadd(SQL_TSI_SECOND, 1, BQT1.SmallA.timevalue) = {t'08:02:00'}";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        this.helpTestRewriteCriteria(original, this.parseCriteria("convert(timestampadd(SQL_TSI_SECOND, 1, convert(BQT1.SmallA.timevalue, timestamp)), time) = {t'08:02:00'}", (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteXmlElement() throws Exception {
        String original = "xmlserialize(document xmlelement(name a, xmlattributes('b' as c)) as string)";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        this.helpTestRewriteExpression(original, "'<a c=\"b\"></a>'", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteXmlElement1() throws Exception {
        String original = "xmlelement(name a, xmlattributes(1+1 as c), BQT1.SmallA.timevalue)";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        this.helpTestRewriteExpression(original, "XMLELEMENT(NAME a, XMLATTRIBUTES(2 AS c), BQT1.SmallA.timevalue)", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteXmlSerialize() throws Exception {
        String original = "xmlserialize(document xmlelement(name a, xmlattributes('b' as c)) as string)";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        this.helpTestRewriteExpression(original, "'<a c=\"b\"></a>'", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteXmlTable() throws Exception {
        String original = "select * from xmltable('/' passing 1 + 1 as a columns x string default curdate()) as x";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        TestQueryRewriter.helpTestRewriteCommand(original, "SELECT x.x FROM XMLTABLE('/' PASSING 2 AS a COLUMNS x string DEFAULT convert(curdate(), string)) AS x", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteQueryString() throws Exception {
        String original = "querystring('path', 'value' as \"&x\", ' & ' as y, null as z)";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        this.helpTestRewriteExpression(original, "'path?%26x=value&y=%20%26%20'", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteExpressionCriteria() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e3", "pm1.g1.e3 = true");
    }

    @Test
    public void testRewritePredicateOptimization() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 in (1, 2, 3) and pm1.g1.e2 in (2, 3, 4)", "pm1.g1.e2 in (2, 3)");
    }

    @Test
    public void testRewritePredicateOptimization1() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 < 5 and pm1.g1.e2 = 2", "pm1.g1.e2 = 2");
    }

    @Test
    public void testRewritePredicateOptimization2() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 < 5 and pm1.g1.e2 = 6", FALSE_STR);
    }

    @Test
    public void testRewritePredicateOptimization2a() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 < 5 and pm1.g1.e2 = 2", "pm1.g1.e2 = 2");
    }

    @Test
    public void testRewritePredicateOptimization3() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 in (1, 2) and pm1.g1.e2 = 6", FALSE_STR);
    }

    @Test
    public void testRewritePredicateOptimization4() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 in (1, 2) and pm1.g1.e2 is null", FALSE_STR);
    }

    @Test
    public void testRewritePredicateOptimization5() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 <> 5 and pm1.g1.e2 in (2, 3, 5)", "pm1.g1.e2 in (2, 3)");
    }

    @Test
    public void testRewritePredicateOptimization6() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 = 5 and pm1.g1.e2 in (5, 6)", "pm1.g1.e2 = 5");
    }

    @Test
    public void testRewritePredicateOptimization6a() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 in (5, 6) and pm1.g1.e2 = 5", "pm1.g1.e2 = 5");
    }

    @Ignore(value="TODO")
    @Test
    public void testRewritePredicateOptimization7() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 > 5 and pm1.g1.e2 < 2", FALSE_STR);
    }

    @Test
    public void testRewritePredicateOptimization8() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 = 2 and pm1.g1.e2 > 1", "pm1.g1.e2 = 2");
    }

    @Test
    public void testRewritePredicateOptimization8a() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 in (0, 2) and pm1.g1.e2 > 1", "pm1.g1.e2 = 2");
    }

    @Test
    public void testRewritePredicateOptimization9() throws Exception {
        this.helpTestRewriteCriteria("not(pm1.g1.e2 = 2 and pm1.g1.e2 = 3)", "(pm1.g1.e2 <> 2) OR (pm1.g1.e2 <> 3)");
    }

    @Test
    public void testRewritePredicateOptimizationOr() throws Exception {
        this.helpTestRewriteCriteria("pm1.g1.e2 in (5, 6) or pm1.g1.e2 = 2", "pm1.g1.e2 IN (2, 5, 6)");
    }

    @Test
    public void testRewriteCritSubqueryNegate() {
        this.helpTestRewriteCriteria("not(pm1.g1.e1 > SOME (select 'a' from pm1.g2))", "pm1.g1.e1 <= ALL (SELECT 'a' FROM pm1.g2)");
    }

    @Test
    public void testRewriteCritSubqueryFalse() {
        this.helpTestRewriteCriteria("exists(select 1 from pm1.g1 where 1=0)", FALSE_STR);
    }

    @Test
    public void testRewriteCritSubqueryFalse1() {
        this.helpTestRewriteCriteria("not(pm1.g1.e1 > SOME (select 'a' from pm1.g1 where 1=0))", TRUE_STR);
    }

    @Test
    public void testRewriteCritSubqueryFalse2() {
        this.helpTestRewriteCriteria("pm1.g1.e1 < ALL (select 'a' from pm1.g1 where 1=0)", TRUE_STR);
    }

    @Test
    public void testRewriteCritSubqueryFalse3() {
        this.helpTestRewriteCriteria("pm1.g1.e1 not in (select 'a' from pm1.g1 where 1=0)", TRUE_STR);
    }

    @Test
    public void testUDFParse() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource()));
        String sql = "parsedate_(pm1.g1.e1) = {d'2001-01-01'}";
        this.helpTestRewriteCriteria(sql, this.parseCriteria(sql, (QueryMetadataInterface)metadata), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testRewriteNestedConvert() throws Exception {
        this.helpTestRewriteExpression("cast(cast(pm1.g1.e3 as integer) as long)", "cast(pm1.g1.e3 as long)", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testRewriteNestedConvert1() throws Exception {
        this.helpTestRewriteExpression("cast(cast(pm1.g1.e3 as integer) as string)", "convert(convert(pm1.g1.e3, integer), string)", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testRewriteNestedConvert2() throws Exception {
        this.helpTestRewriteExpression("cast(cast(pm1.g1.e3 as string) as clob)", "convert(convert(pm1.g1.e3, string), clob)", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testRewriteConstantAgg() throws Exception {
        TestQueryRewriter.helpTestRewriteCommand("select max(1) from pm1.g1 group by e1", "SELECT 1 FROM pm1.g1 GROUP BY e1");
    }

    @Test
    public void testRewriteTrim() throws Exception {
        this.helpTestRewriteExpression("trim(pm1.g1.e1)", "rtrim(ltrim(pm1.g1.e1))", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testRewriteTrim1() throws Exception {
        this.helpTestRewriteExpression("trim(leading from pm1.g1.e1)", "ltrim(pm1.g1.e1)", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testRewriteXmlSerialize1() throws Exception {
        this.helpTestRewriteExpression("xmlserialize(DOCUMENT cast (pm1.g1.e1 as xml) as clob version '2.0')", "XMLSERIALIZE(DOCUMENT convert(pm1.g1.e1, xml) AS clob VERSION '2.0' INCLUDING XMLDECLARATION)", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testRewriteMerge() throws Exception {
        String ddl = "CREATE foreign table x (y string primary key)";
        TransformationMetadata metadata = RealMetadataFactory.fromDDL(ddl, "x", "phy");
        TestQueryRewriter.helpTestRewriteCommand("merge into x (y) values (1)", "BEGIN ATOMIC\nDECLARE integer VARIABLES.ROWS_UPDATED = 0;\nLOOP ON (SELECT X.expr1 AS y FROM (SELECT '1' AS expr1) AS X) AS X1\nBEGIN\nIF(EXISTS (SELECT 1 FROM x WHERE y = X1.y LIMIT 1))\nBEGIN\nEND\nELSE\nBEGIN\nINSERT INTO x (y) VALUES (X1.y);\nEND\nVARIABLES.ROWS_UPDATED = (VARIABLES.ROWS_UPDATED + 1);\nEND\nSELECT VARIABLES.ROWS_UPDATED;\nEND", (QueryMetadataInterface)metadata);
    }

    @Test
    public void testUnknownRewrite() throws Exception {
        String sql = "SELECT 1 = null";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT UNKNOWN");
    }

    @Test
    public void testWithInliningUnused() throws Exception {
        String sql = "with a as (select 1) select 2";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT 2");
    }

    @Test
    public void testWithInliningChained() throws Exception {
        String sql = "with a (x) as (select x from (select 1 as x) as b), b as (select * from a) select * from b";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT b.x FROM (SELECT a.x FROM (SELECT x FROM (SELECT 1 AS x) AS b) AS a) AS b");
    }

    @Test
    public void testWithInliningRecursive() throws Exception {
        String sql = "with a as (select 1 as col union all select col + 1 from a) select * from a";
        TestQueryRewriter.helpTestRewriteCommand(sql, "WITH a (col) AS (SELECT 1 AS col UNION ALL SELECT (col + 1) FROM a) SELECT a.col FROM a");
    }

    @Test
    public void testWithScalar() throws Exception {
        String sql = "with a as (select 1 as col) select * from a, a as other";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT a.col, other.col FROM (SELECT 1 AS col) AS a, (SELECT 1 AS col) AS other");
    }

    @Test
    public void testWithMultiple() throws Exception {
        String sql = "with a as (select e1 from pm1.g1) select * from a, a as other";
        TestQueryRewriter.helpTestRewriteCommand(sql, "WITH a (e1) AS (SELECT e1 FROM pm1.g1) SELECT a.e1, other.e1 FROM a, a AS other");
    }

    @Test
    public void testRewriteWithRedefinedName() throws Exception {
        String sql = "with a as (select e1 from pm1.g1) select * from (select 1 as x) as a";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT a.x FROM (SELECT 1 AS x) AS a");
    }

    @Test
    public void testDeepReplacement() throws Exception {
        String sql = "with a as (select e1 from pm1.g1) select (select e1 from a) from pm1.g2";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT (SELECT e1 FROM (SELECT e1 FROM pm1.g1) AS a LIMIT 2) FROM pm1.g2");
    }

    @Test
    public void testRewriteCritBooleanExpression() {
        this.helpTestRewriteCriteria("not (pm1.g1.e3)", "pm1.g1.e3 <> TRUE");
    }

    @Test
    public void testRewriteSubstringZeroIndex() throws TeiidComponentException, TeiidProcessingException {
        this.helpTestRewriteExpression("substring(pm1.g1.e1, 0, 5)", "substring(pm1.g1.e1, 1, 5)", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testDontRewriteSubstring() throws TeiidComponentException, TeiidProcessingException {
        this.helpTestRewriteExpression("substring(pm1.g1.e1, pm1.g1.e2, 5)", "substring(pm1.g1.e1, pm1.g1.e2, 5)", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    @Test
    public void testRewriteSubstringNegativeIndex() throws TeiidComponentException, TeiidProcessingException {
        this.helpTestRewriteExpression("substring(pm1.g1.e1, -1, 5)", "null", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    private static final class FakeObject
    implements Comparable<FakeObject> {
        private int hashCode;

        public FakeObject(int hashCode) {
            this.hashCode = hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            return true;
        }

        @Override
        public int compareTo(FakeObject o) {
            return 0;
        }
    }
}

