/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.core.CorePlugin;

public abstract class Streamable<T>
implements Externalizable {
    private static final long serialVersionUID = -8252488562134729374L;
    private static AtomicInteger counter = new AtomicInteger();
    public static final String ENCODING = "UTF-8";
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final String FORCE_STREAMING = "FORCE_STREAMING";
    public static final int STREAMING_BATCH_SIZE_IN_BYTES = 102400;
    private String referenceStreamId = String.valueOf(counter.getAndIncrement());
    protected transient T reference;
    protected long length = -1L;

    public Streamable() {
    }

    public Streamable(T reference) {
        if (reference == null) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("Streamable.isNUll"));
        }
        this.reference = reference;
    }

    public long getLength() {
        return this.length;
    }

    public T getReference() {
        return this.reference;
    }

    public void setReference(T reference) {
        this.reference = reference;
    }

    public String getReferenceStreamId() {
        return this.referenceStreamId;
    }

    public String toString() {
        if (this.reference == null) {
            return super.toString();
        }
        return this.reference.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.length = in.readLong();
        this.referenceStreamId = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.length);
        out.writeObject(this.referenceStreamId);
    }
}

