/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Streamable;

public final class XMLType
extends Streamable<SQLXML>
implements SQLXML {
    private static final long serialVersionUID = -7922647237095135723L;
    private transient Type type = Type.UNKNOWN;
    private String encoding;

    public XMLType() {
    }

    public XMLType(SQLXML xml) {
        super(xml);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return ((SQLXML)this.reference).getBinaryStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return ((SQLXML)this.reference).getCharacterStream();
    }

    @Override
    public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
        return ((SQLXML)this.reference).getSource(sourceClass);
    }

    @Override
    public String getString() throws SQLException {
        return ((SQLXML)this.reference).getString();
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        return ((SQLXML)this.reference).setBinaryStream();
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        return ((SQLXML)this.reference).setCharacterStream();
    }

    @Override
    public void setString(String value) throws SQLException {
        ((SQLXML)this.reference).setString(value);
    }

    @Override
    public void free() throws SQLException {
        ((SQLXML)this.reference).free();
    }

    @Override
    public <T extends Result> T setResult(Class<T> resultClass) throws SQLException {
        return ((SQLXML)this.reference).setResult(resultClass);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        try {
            this.encoding = (String)in.readObject();
        }
        catch (OptionalDataException e) {
            this.encoding = "UTF-8";
        }
        try {
            this.type = (Type)((Object)in.readObject());
        }
        catch (OptionalDataException e) {
            this.type = Type.UNKNOWN;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.encoding == null) {
            this.encoding = XMLType.getEncoding(this);
        }
        out.writeObject(this.encoding);
        out.writeObject((Object)this.type);
    }

    public static String getEncoding(SQLXML xml) {
        try {
            Charset cs;
            if (xml instanceof XMLType) {
                XMLType type = (XMLType)xml;
                if (type.encoding != null) {
                    return type.encoding;
                }
                xml = (SQLXML)type.reference;
            }
            if (xml instanceof SQLXMLImpl && (cs = ((SQLXMLImpl)xml).getCharset()) != null) {
                return cs.displayName();
            }
            return XMLType.getEncoding(xml.getBinaryStream());
        }
        catch (SQLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEncoding(InputStream is) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(is);
            String string = reader.getEncoding();
            return string;
        }
        catch (XMLStreamException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    public static enum Type {
        UNKNOWN,
        DOCUMENT,
        CONTENT,
        ELEMENT,
        COMMENT,
        PI,
        TEXT;

    }
}

