/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.util.Collection;
import java.util.Map;
import org.teiid.core.CorePlugin;

public final class Assertion {
    private Assertion() {
    }

    public static final void assertTrue(boolean condition) {
        Assertion.assertTrue(condition, null);
    }

    public static final void assertTrue(boolean condition, String msgKey) {
        if (!condition) {
            String msg = msgKey != null ? msgKey : CorePlugin.Util.getString("Assertion.Assertion_failed");
            Assertion.failed(msg);
        }
    }

    public static final void failed(String msg) {
        throw new AssertionError((Object)msg);
    }

    public static final void isEqual(boolean value1, boolean value2) {
        Assertion.isEqual(value1, value2, null);
    }

    public static final void isEqual(boolean value1, boolean value2, String message) {
        if (value1 != value2) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isEqual", new Boolean(value1), new Boolean(value2));
            Assertion.failed(msg);
        }
    }

    public static final void isNotEqual(boolean value1, boolean value2) {
        Assertion.isNotEqual(value1, value2, null);
    }

    public static final void isNotEqual(boolean value1, boolean value2, String message) {
        if (value1 == value2) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNotEqual", new Boolean(value1), new Boolean(value2));
            Assertion.failed(msg);
        }
    }

    public static final void isEqual(int value1, int value2) {
        Assertion.isEqual(value1, value2, null);
    }

    public static final void isEqual(int value1, int value2, String message) {
        if (value1 != value2) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isEqual", new Integer(value1), new Integer(value2));
            Assertion.failed(msg);
        }
    }

    public static final void isNotEqual(int value1, int value2) {
        Assertion.isNotEqual(value1, value2, null);
    }

    public static final void isNotEqual(int value1, int value2, String message) {
        if (value1 == value2) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNotEqual", new Integer(value1), new Integer(value2));
            Assertion.failed(msg);
        }
    }

    public static final void isNonNegative(int value) {
        Assertion.isNonNegative(value, null);
    }

    public static final void isNonNegative(int value, String message) {
        if (value < 0) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNonNegative", new Integer(value));
            Assertion.failed(msg);
        }
    }

    public static final void isNonPositive(int value) {
        Assertion.isNonPositive(value, null);
    }

    public static final void isNonPositive(int value, String message) {
        if (value > 0) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNonPositive", new Integer(value));
            Assertion.failed(msg);
        }
    }

    public static final void isNegative(int value) {
        Assertion.isNegative(value, null);
    }

    public static final void isNegative(int value, String message) {
        if (value >= 0) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNegative", new Integer(value));
            Assertion.failed(msg);
        }
    }

    public static final void isPositive(int value) {
        Assertion.isPositive(value, null);
    }

    public static final void isPositive(int value, String message) {
        if (value <= 0) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isPositive", new Integer(value));
            Assertion.failed(msg);
        }
    }

    public static final void isEqual(long value1, long value2) {
        Assertion.isEqual(value1, value2, null);
    }

    public static final void isEqual(long value1, long value2, String message) {
        if (value1 != value2) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isEqual", new Long(value1), new Long(value2));
            Assertion.failed(msg);
        }
    }

    public static final void isNotEqual(long value1, long value2) {
        Assertion.isNotEqual(value1, value2, null);
    }

    public static final void isNotEqual(long value1, long value2, String message) {
        if (value1 == value2) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNotEqual", new Long(value1), new Long(value2));
            Assertion.failed(msg);
        }
    }

    public static final void isNonNegative(long value) {
        Assertion.isNonNegative(value, null);
    }

    public static final void isNonNegative(long value, String message) {
        if (value < 0L) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNonNegative", new Long(value));
            Assertion.failed(msg);
        }
    }

    public static final void isNonPositive(long value) {
        Assertion.isNonPositive(value, null);
    }

    public static final void isNonPositive(long value, String message) {
        if (value > 0L) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNonPositive", new Long(value));
            Assertion.failed(msg);
        }
    }

    public static final void isNegative(long value) {
        Assertion.isNegative(value, null);
    }

    public static final void isNegative(long value, String message) {
        if (value >= 0L) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNegative", new Long(value));
            Assertion.failed(msg);
        }
    }

    public static final void isPositive(long value) {
        Assertion.isPositive(value, null);
    }

    public static final void isPositive(long value, String message) {
        if (value <= 0L) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isPositive", new Long(value));
            Assertion.failed(msg);
        }
    }

    public static final void isNotZeroLength(String value) {
        Assertion.isNotZeroLength(value, null);
    }

    public static final void isNotZeroLength(String value, String message) {
        Assertion.isNotNull(value);
        if (value.length() == 0) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNotZeroLength");
            Assertion.failed(msg);
        }
    }

    public static final void isNull(Object value) {
        Assertion.isNull(value, null);
    }

    public static final void isNull(Object value, String message) {
        if (value != null) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNull");
            Assertion.failed(msg);
        }
    }

    public static final void isNotNull(Object value) {
        Assertion.isNotNull(value, null);
    }

    public static final void isNotNull(Object value, String message) {
        if (value == null) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNotNull");
            Assertion.failed(msg);
        }
    }

    public static final void isIdentical(Object object1, Object object2) {
        Assertion.isIdentical(object1, object2, null);
    }

    public static final void isIdentical(Object object1, Object object2, String message) {
        if (object1 != object2) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isIdentical", object1, object2);
            Assertion.failed(msg);
        }
    }

    public static final void isEqual(Object object1, Object object2) {
        Assertion.isEqual(object1, object2, null);
    }

    public static final void isEqual(Object object1, Object object2, String message) {
        if (object1 == null) {
            if (object2 != null) {
                String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isEqual", object1, object2);
                Assertion.failed(msg);
            }
        } else {
            String msg;
            if (object2 == null) {
                msg = message != null ? message : CorePlugin.Util.getString("Assertion.isEqual", object1, object2);
                Assertion.failed(msg);
            }
            if (!object1.equals(object2)) {
                msg = message != null ? message : CorePlugin.Util.getString("Assertion.isEqual", object1, object2);
                Assertion.failed(msg);
            }
        }
    }

    public static final Object isInstanceOf(Object object, Class expectedClass, String name) {
        if (object == null) {
            return null;
        }
        Class<?> objClass = object.getClass();
        if (!expectedClass.isAssignableFrom(objClass)) {
            Object[] params = new Object[]{name, expectedClass, objClass.getName()};
            String msg = CorePlugin.Util.getString("Assertion.invalidClassMessage", params);
            throw new ClassCastException(msg);
        }
        return object;
    }

    public static final void isNotEmpty(Collection collection) {
        Assertion.isNotEmpty(collection, null);
    }

    public static final void isNotEmpty(Collection collection, String message) {
        Assertion.isNotNull(collection);
        if (collection.isEmpty()) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNotEmpty_Collection");
            Assertion.failed(msg);
        }
    }

    public static final void isNotEmpty(Map map) {
        Assertion.isNotEmpty(map, null);
    }

    public static final void isNotEmpty(Map map, String message) {
        Assertion.isNotNull(map);
        if (map.isEmpty()) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNotEmpty_Map");
            Assertion.failed(msg);
        }
    }

    public static final void contains(Collection collection, Object value) {
        Assertion.contains(collection, value, null);
    }

    public static final void contains(Collection collection, Object value, String message) {
        Assertion.isNotNull(collection);
        if (!collection.contains(value)) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.contains_Collection");
            Assertion.failed(msg);
        }
    }

    public static final void containsKey(Map map, Object key) {
        Assertion.containsKey(map, key, null);
    }

    public static final void containsKey(Map map, Object key, String message) {
        Assertion.isNotNull(map);
        if (!map.containsKey(key)) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.contains_Map");
            Assertion.failed(msg);
        }
    }
}

