/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.DQPPlugin;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.ExecutionContextImpl;
import org.teiid.dqp.internal.datamgr.LanguageBridgeFactory;
import org.teiid.dqp.internal.datamgr.ProcedureBatchHandler;
import org.teiid.dqp.internal.datamgr.RuntimeMetadataImpl;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.language.Call;
import org.teiid.language.QueryExpression;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;

public class ConnectorWorkItem
implements ConnectorWork {
    private AtomicRequestID id;
    private ConnectorManager manager;
    private AtomicRequestMessage requestMsg;
    private ExecutionFactory connector;
    private QueryMetadataInterface queryMetadata;
    private Object connection;
    private Object connectionFactory;
    private ExecutionContextImpl securityContext;
    private volatile ResultSetExecution execution;
    private ProcedureBatchHandler procedureBatchHandler;
    private org.teiid.language.Command translatedCommand;
    private Class<?>[] schema;
    private List<Integer> convertToRuntimeType;
    private boolean[] convertToDesiredRuntimeType;
    private boolean lastBatch;
    private int rowCount;
    private boolean error;
    private AtomicBoolean isCancelled = new AtomicBoolean();

    ConnectorWorkItem(AtomicRequestMessage message, ConnectorManager manager) {
        this.id = message.getAtomicRequestID();
        this.requestMsg = message;
        this.manager = manager;
        AtomicRequestID requestID = this.requestMsg.getAtomicRequestID();
        this.securityContext = new ExecutionContextImpl(this.requestMsg.getWorkContext().getVdbName(), this.requestMsg.getWorkContext().getVdbVersion(), this.requestMsg.getExecutionPayload(), this.requestMsg.getWorkContext().getSessionId(), this.requestMsg.getConnectorName(), this.requestMsg.getRequestID().toString(), Integer.toString(requestID.getNodeID()), Integer.toString(requestID.getExecutionId()));
        this.securityContext.setUser(this.requestMsg.getWorkContext().getSubject());
        this.securityContext.setBatchSize(this.requestMsg.getFetchSize());
        this.connector = manager.getExecutionFactory();
        VDBMetaData vdb = this.requestMsg.getWorkContext().getVDB();
        this.queryMetadata = (QueryMetadataInterface)vdb.getAttachment(QueryMetadataInterface.class);
        this.queryMetadata = new TempMetadataAdapter(this.queryMetadata, new TempMetadataStore());
        this.securityContext.setTransactional(this.requestMsg.isTransactional());
    }

    public AtomicRequestID getId() {
        return this.id;
    }

    @Override
    public void cancel() {
        try {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Processing CANCEL request"});
            if (this.isCancelled.compareAndSet(false, true)) {
                this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.CANCEL, -1);
                if (this.execution != null) {
                    this.execution.cancel();
                }
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{DQPPlugin.Util.getString("DQPCore.The_atomic_request_has_been_cancelled", new Object[]{this.id})});
            }
        }
        catch (TranslatorException e) {
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (Throwable)e, (String)DQPPlugin.Util.getString("Cancel_request_failed", new Object[]{this.id}));
        }
    }

    @Override
    public AtomicResultsMessage more() throws TranslatorException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Processing MORE request"});
        try {
            return this.handleBatch();
        }
        catch (Throwable t) {
            throw this.handleError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void close() {
        block24: {
            block20: {
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Processing Close :", this.requestMsg.getCommand()});
                if (!this.error) {
                    this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.END, this.rowCount);
                }
                if (this.execution == null) break block20;
                this.execution.close();
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Closed execution"});
            }
            try {
                this.connector.closeConnection(this.connection, this.connectionFactory);
            }
            catch (Throwable e) {
                LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e, (String)e.getMessage());
            }
            finally {
                this.manager.removeState(this.id);
            }
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Closed connection"});
            break block24;
            catch (Throwable e) {
                try {
                    LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e, (String)e.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        this.connector.closeConnection(this.connection, this.connectionFactory);
                    }
                    catch (Throwable e2) {
                        LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e2, (String)e2.getMessage());
                    }
                    finally {
                        this.manager.removeState(this.id);
                    }
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Closed connection"});
                    throw throwable;
                }
                try {
                    this.connector.closeConnection(this.connection, this.connectionFactory);
                }
                catch (Throwable e3) {
                    LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e3, (String)e3.getMessage());
                }
                finally {
                    this.manager.removeState(this.id);
                }
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Closed connection"});
            }
        }
    }

    private TranslatorException handleError(Throwable t) {
        if (t instanceof DataNotAvailableException) {
            throw (DataNotAvailableException)t;
        }
        this.error = true;
        if (t instanceof RuntimeException && t.getCause() != null) {
            t = t.getCause();
        }
        this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.ERROR, null);
        String msg = DQPPlugin.Util.getString("ConnectorWorker.process_failed", new Object[]{this.id});
        if (this.isCancelled.get()) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{msg});
        } else if (t instanceof TranslatorException || t instanceof TeiidProcessingException) {
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (Throwable)t, (String)msg);
        } else {
            LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)t, (String)msg);
        }
        if (t instanceof TranslatorException) {
            return (TranslatorException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        return new TranslatorException(t);
    }

    @Override
    public AtomicResultsMessage execute() throws TranslatorException, BlockedException {
        if (this.isCancelled()) {
            throw new TranslatorException("Request canceled");
        }
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.requestMsg.getAtomicRequestID(), "Processing NEW request:", this.requestMsg.getCommand()});
        try {
            this.connectionFactory = this.manager.getConnectionFactory();
            this.connection = this.connector.getConnection(this.connectionFactory);
            Command command = this.requestMsg.getCommand();
            List<SingleElementSymbol> symbols = this.requestMsg.getCommand().getProjectedSymbols();
            this.schema = new Class[symbols.size()];
            this.convertToDesiredRuntimeType = new boolean[symbols.size()];
            this.convertToRuntimeType = new ArrayList<Integer>(symbols.size());
            for (int i = 0; i < this.schema.length; ++i) {
                SingleElementSymbol symbol = symbols.get(i);
                this.schema[i] = symbol.getType();
                this.convertToDesiredRuntimeType[i] = true;
                this.convertToRuntimeType.add(i);
            }
            LanguageBridgeFactory factory = new LanguageBridgeFactory(this.queryMetadata);
            this.translatedCommand = factory.translate(command);
            RuntimeMetadataImpl rmd = new RuntimeMetadataImpl(this.queryMetadata);
            final Execution exec = this.connector.createExecution(this.translatedCommand, (ExecutionContext)this.securityContext, (RuntimeMetadata)rmd, this.connection);
            if (this.translatedCommand instanceof Call) {
                Assertion.isInstanceOf((Object)this.execution, ProcedureExecution.class, (String)"Call Executions are expected to be ProcedureExecutions");
                this.execution = (ProcedureExecution)exec;
                StoredProcedure proc = (StoredProcedure)command;
                if (proc.returnParameters()) {
                    this.procedureBatchHandler = new ProcedureBatchHandler((Call)this.translatedCommand, (ProcedureExecution)this.execution);
                }
            } else if (this.translatedCommand instanceof QueryExpression) {
                Assertion.isInstanceOf((Object)this.execution, ResultSetExecution.class, (String)"QueryExpression Executions are expected to be ResultSetExecutions");
                this.execution = (ResultSetExecution)exec;
            } else {
                Assertion.isInstanceOf((Object)this.execution, UpdateExecution.class, (String)"Update Executions are expected to be UpdateExecutions");
                this.execution = new ResultSetExecution(){
                    private int[] results;
                    private int index;

                    public void cancel() throws TranslatorException {
                        exec.cancel();
                    }

                    public void close() {
                        exec.close();
                    }

                    public void execute() throws TranslatorException {
                        exec.execute();
                    }

                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                        if (this.results == null) {
                            this.results = ((UpdateExecution)exec).getUpdateCounts();
                        }
                        if (this.index < this.results.length) {
                            return Arrays.asList(this.results[this.index++]);
                        }
                        return null;
                    }
                };
            }
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.requestMsg.getAtomicRequestID(), "Obtained execution"});
            this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.NEW, null);
            this.execution.execute();
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Executed command"});
            return this.handleBatch();
        }
        catch (Throwable t) {
            throw this.handleError(t);
        }
    }

    protected AtomicResultsMessage handleBatch() throws TranslatorException {
        List row;
        ArrayList<List> rows;
        block11: {
            Assertion.assertTrue((!this.lastBatch ? 1 : 0) != 0);
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Sending results from connector"});
            int batchSize = 0;
            rows = new ArrayList<List>(batchSize / 4);
            try {
                while (batchSize < this.requestMsg.getFetchSize()) {
                    row = this.execution.next();
                    if (row == null) {
                        this.lastBatch = true;
                        break;
                    }
                    if (row.size() != this.schema.length) {
                        throw new AssertionError((Object)("Inproper results returned.  Expected " + this.schema.length + " columns, but was " + row.size()));
                    }
                    ++this.rowCount;
                    ++batchSize;
                    if (this.procedureBatchHandler != null) {
                        row = this.procedureBatchHandler.padRow(row);
                    }
                    this.correctTypes(row);
                    rows.add(row);
                    if (this.requestMsg.getMaxResultRows() <= -1 || this.rowCount < this.requestMsg.getMaxResultRows()) continue;
                    if (this.rowCount == this.requestMsg.getMaxResultRows() && !this.requestMsg.isExceptionOnMaxRows()) {
                        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Exceeded max, returning", this.requestMsg.getMaxResultRows()});
                        this.lastBatch = true;
                        break;
                    }
                    if (this.rowCount <= this.requestMsg.getMaxResultRows() || !this.requestMsg.isExceptionOnMaxRows()) continue;
                    String msg = DQPPlugin.Util.getString("ConnectorWorker.MaxResultRowsExceed", new Object[]{this.requestMsg.getMaxResultRows()});
                    throw new TranslatorException(msg);
                }
            }
            catch (DataNotAvailableException e) {
                if (rows.size() != 0) break block11;
                throw e;
            }
        }
        if (this.lastBatch) {
            if (this.procedureBatchHandler != null && (row = this.procedureBatchHandler.getParameterRow()) != null) {
                this.correctTypes(row);
                rows.add(row);
                ++this.rowCount;
            }
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Obtained last batch, total row count:", this.rowCount});
        }
        int currentRowCount = rows.size();
        if (!this.lastBatch && currentRowCount == 0) {
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (String)DQPPlugin.Util.getString("ConnectorWorker.zero_size_non_last_batch", new Object[]{this.requestMsg.getConnectorName()}));
        }
        AtomicResultsMessage response = ConnectorWorkItem.createResultsMessage(rows.toArray(new List[currentRowCount]), this.requestMsg.getCommand().getProjectedSymbols());
        response.setSupportsImplicitClose(!this.securityContext.keepExecutionAlive());
        response.setTransactional(this.securityContext.isTransactional());
        response.setWarnings(this.securityContext.getWarnings());
        if (this.lastBatch) {
            response.setFinalRow(this.rowCount);
        }
        return response;
    }

    private void correctTypes(List row) throws TranslatorException {
        int i;
        for (i = this.convertToRuntimeType.size() - 1; i >= 0; --i) {
            int index = this.convertToRuntimeType.get(i);
            Object value = row.get(index);
            if (value == null) continue;
            Object result = DataTypeManager.convertToRuntimeType(value);
            if (DataTypeManager.isLOB(result.getClass())) {
                this.securityContext.keepExecutionAlive(true);
            }
            if (value == result && !DataTypeManager.DefaultDataClasses.OBJECT.equals(this.schema[index])) {
                this.convertToRuntimeType.remove(i);
                continue;
            }
            row.set(index, result);
        }
        for (i = 0; i < row.size(); ++i) {
            if (this.convertToDesiredRuntimeType[i]) {
                Object result;
                Object value = row.get(i);
                if (value == null) continue;
                try {
                    result = DataTypeManager.transformValue(value, value.getClass(), this.schema[i]);
                }
                catch (TransformationException e) {
                    throw new TranslatorException((Throwable)e);
                }
                if (value == result) {
                    this.convertToDesiredRuntimeType[i] = false;
                    continue;
                }
                row.set(i, result);
                continue;
            }
            row.set(i, DataTypeManager.getCanonicalValue(row.get(i)));
        }
    }

    public static AtomicResultsMessage createResultsMessage(List[] batch, List columnSymbols) {
        String[] dataTypes = TupleBuffer.getTypeNames(columnSymbols);
        return new AtomicResultsMessage(batch, dataTypes);
    }

    boolean isCancelled() {
        return this.isCancelled.get();
    }

    public String toString() {
        return this.id.toString();
    }
}

