/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.internal.datamgr.RuntimeMetadataImpl;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.Argument;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.DerivedTable;
import org.teiid.language.Exists;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Function;
import org.teiid.language.GroupBy;
import org.teiid.language.In;
import org.teiid.language.InsertValueSource;
import org.teiid.language.IsNull;
import org.teiid.language.IteratorValueSource;
import org.teiid.language.Join;
import org.teiid.language.Like;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Not;
import org.teiid.language.QueryExpression;
import org.teiid.language.SearchedCase;
import org.teiid.language.SearchedWhenClause;
import org.teiid.language.Select;
import org.teiid.language.SetClause;
import org.teiid.language.SetQuery;
import org.teiid.language.SortSpecification;
import org.teiid.language.SubqueryComparison;
import org.teiid.language.SubqueryIn;
import org.teiid.language.TableReference;
import org.teiid.language.Update;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.translator.TranslatorException;

public class LanguageBridgeFactory {
    private RuntimeMetadataImpl metadataFactory = null;

    public LanguageBridgeFactory(QueryMetadataInterface metadata) {
        if (metadata != null) {
            this.metadataFactory = new RuntimeMetadataImpl(metadata);
        }
    }

    public Command translate(org.teiid.query.sql.lang.Command command) {
        if (command == null) {
            return null;
        }
        if (command instanceof Query) {
            return this.translate((Query)command);
        }
        if (command instanceof org.teiid.query.sql.lang.SetQuery) {
            return this.translate((org.teiid.query.sql.lang.SetQuery)command);
        }
        if (command instanceof Insert) {
            return this.translate((Insert)command);
        }
        if (command instanceof org.teiid.query.sql.lang.Update) {
            return this.translate((org.teiid.query.sql.lang.Update)command);
        }
        if (command instanceof Delete) {
            return this.translate((Delete)command);
        }
        if (command instanceof StoredProcedure) {
            return this.translate((StoredProcedure)command);
        }
        if (command instanceof BatchedUpdateCommand) {
            return this.translate((BatchedUpdateCommand)command);
        }
        throw new AssertionError();
    }

    QueryExpression translate(QueryCommand command) {
        if (command instanceof Query) {
            return this.translate((Query)command);
        }
        return this.translate((org.teiid.query.sql.lang.SetQuery)command);
    }

    SetQuery translate(org.teiid.query.sql.lang.SetQuery union) {
        SetQuery result = new SetQuery();
        result.setAll(union.isAll());
        switch (union.getOperation()) {
            case UNION: {
                result.setOperation(SetQuery.Operation.UNION);
                break;
            }
            case INTERSECT: {
                result.setOperation(SetQuery.Operation.INTERSECT);
                break;
            }
            case EXCEPT: {
                result.setOperation(SetQuery.Operation.EXCEPT);
            }
        }
        result.setLeftQuery(this.translate(union.getLeftQuery()));
        result.setRightQuery(this.translate(union.getRightQuery()));
        result.setOrderBy(this.translate(union.getOrderBy()));
        result.setLimit(this.translate(union.getLimit()));
        return result;
    }

    Select translate(Query query) {
        List symbols = query.getSelect().getSymbols();
        ArrayList<DerivedColumn> translatedSymbols = new ArrayList<DerivedColumn>(symbols.size());
        for (SingleElementSymbol symbol : symbols) {
            String alias = null;
            if (symbol instanceof AliasSymbol) {
                alias = symbol.getOutputName();
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            ColumnReference iExp = null;
            if (symbol instanceof ElementSymbol) {
                iExp = this.translate((ElementSymbol)symbol);
            } else if (symbol instanceof AggregateSymbol) {
                iExp = this.translate((AggregateSymbol)symbol);
            } else if (symbol instanceof ExpressionSymbol) {
                iExp = this.translate(((ExpressionSymbol)symbol).getExpression());
            }
            DerivedColumn selectSymbol = new DerivedColumn(alias, (org.teiid.language.Expression)iExp);
            translatedSymbols.add(selectSymbol);
        }
        ArrayList<TableReference> items = null;
        if (query.getFrom() != null) {
            List clauses = query.getFrom().getClauses();
            items = new ArrayList<TableReference>(clauses.size());
            Iterator i = clauses.iterator();
            while (i.hasNext()) {
                items.add(this.translate((FromClause)i.next()));
            }
        }
        Select q = new Select(translatedSymbols, query.getSelect().isDistinct(), items, this.translate(query.getCriteria()), this.translate(query.getGroupBy()), this.translate(query.getHaving()), this.translate(query.getOrderBy()));
        q.setLimit(this.translate(query.getLimit()));
        return q;
    }

    public TableReference translate(FromClause clause) {
        if (clause == null) {
            return null;
        }
        if (clause instanceof JoinPredicate) {
            return this.translate((JoinPredicate)clause);
        }
        if (clause instanceof SubqueryFromClause) {
            return this.translate((SubqueryFromClause)clause);
        }
        if (clause instanceof UnaryFromClause) {
            return this.translate((UnaryFromClause)clause);
        }
        throw new AssertionError();
    }

    Join translate(JoinPredicate join) {
        List crits = join.getJoinCriteria();
        Criteria crit = null;
        if (crits.size() == 1) {
            crit = (Criteria)crits.get(0);
        } else if (crits.size() > 1) {
            crit = new CompoundCriteria(crits);
        }
        Join.JoinType joinType = Join.JoinType.INNER_JOIN;
        if (join.getJoinType().equals(JoinType.JOIN_INNER)) {
            joinType = Join.JoinType.INNER_JOIN;
        } else if (join.getJoinType().equals(JoinType.JOIN_LEFT_OUTER)) {
            joinType = Join.JoinType.LEFT_OUTER_JOIN;
        } else if (join.getJoinType().equals(JoinType.JOIN_RIGHT_OUTER)) {
            joinType = Join.JoinType.RIGHT_OUTER_JOIN;
        } else if (join.getJoinType().equals(JoinType.JOIN_FULL_OUTER)) {
            joinType = Join.JoinType.FULL_OUTER_JOIN;
        } else if (join.getJoinType().equals(JoinType.JOIN_CROSS)) {
            joinType = Join.JoinType.CROSS_JOIN;
        }
        return new Join(this.translate(join.getLeftClause()), this.translate(join.getRightClause()), joinType, this.translate(crit));
    }

    TableReference translate(SubqueryFromClause clause) {
        return new DerivedTable(this.translate((QueryCommand)clause.getCommand()), clause.getOutputName());
    }

    NamedTable translate(UnaryFromClause clause) {
        return this.translate(clause.getGroup());
    }

    public Condition translate(Criteria criteria) {
        if (criteria == null) {
            return null;
        }
        if (criteria instanceof CompareCriteria) {
            return this.translate((CompareCriteria)criteria);
        }
        if (criteria instanceof CompoundCriteria) {
            return this.translate((CompoundCriteria)criteria);
        }
        if (criteria instanceof ExistsCriteria) {
            return this.translate((ExistsCriteria)criteria);
        }
        if (criteria instanceof IsNullCriteria) {
            return this.translate((IsNullCriteria)criteria);
        }
        if (criteria instanceof MatchCriteria) {
            return this.translate((MatchCriteria)criteria);
        }
        if (criteria instanceof NotCriteria) {
            return this.translate((NotCriteria)criteria);
        }
        if (criteria instanceof SetCriteria) {
            return this.translate((SetCriteria)criteria);
        }
        if (criteria instanceof SubqueryCompareCriteria) {
            return this.translate((SubqueryCompareCriteria)criteria);
        }
        if (criteria instanceof SubquerySetCriteria) {
            return this.translate((SubquerySetCriteria)criteria);
        }
        throw new AssertionError();
    }

    Comparison translate(CompareCriteria criteria) {
        Comparison.Operator operator = Comparison.Operator.EQ;
        switch (criteria.getOperator()) {
            case 1: {
                operator = Comparison.Operator.EQ;
                break;
            }
            case 2: {
                operator = Comparison.Operator.NE;
                break;
            }
            case 3: {
                operator = Comparison.Operator.LT;
                break;
            }
            case 5: {
                operator = Comparison.Operator.LE;
                break;
            }
            case 4: {
                operator = Comparison.Operator.GT;
                break;
            }
            case 6: {
                operator = Comparison.Operator.GE;
            }
        }
        return new Comparison(this.translate(criteria.getLeftExpression()), this.translate(criteria.getRightExpression()), operator);
    }

    AndOr translate(CompoundCriteria criteria) {
        List<Criteria> nestedCriteria = criteria.getCriteria();
        int size = nestedCriteria.size();
        AndOr.Operator op = criteria.getOperator() == 0 ? AndOr.Operator.AND : AndOr.Operator.OR;
        AndOr result = new AndOr(this.translate(nestedCriteria.get(size - 2)), this.translate(nestedCriteria.get(size - 1)), op);
        for (int i = nestedCriteria.size() - 3; i >= 0; --i) {
            result = new AndOr(this.translate(nestedCriteria.get(i)), (Condition)result, op);
        }
        return result;
    }

    Exists translate(ExistsCriteria criteria) {
        return new Exists(this.translate((QueryCommand)criteria.getCommand()));
    }

    IsNull translate(IsNullCriteria criteria) {
        return new IsNull(this.translate(criteria.getExpression()), criteria.isNegated());
    }

    Like translate(MatchCriteria criteria) {
        Character escapeChar = null;
        if (criteria.getEscapeChar() != '\u0000') {
            escapeChar = new Character(criteria.getEscapeChar());
        }
        return new Like(this.translate(criteria.getLeftExpression()), this.translate(criteria.getRightExpression()), escapeChar, criteria.isNegated());
    }

    In translate(SetCriteria criteria) {
        Collection expressions = criteria.getValues();
        ArrayList<org.teiid.language.Expression> translatedExpressions = new ArrayList<org.teiid.language.Expression>();
        Iterator i = expressions.iterator();
        while (i.hasNext()) {
            translatedExpressions.add(this.translate((Expression)i.next()));
        }
        return new In(this.translate(criteria.getExpression()), translatedExpressions, criteria.isNegated());
    }

    SubqueryComparison translate(SubqueryCompareCriteria criteria) {
        SubqueryComparison.Quantifier quantifier = SubqueryComparison.Quantifier.ALL;
        switch (criteria.getPredicateQuantifier()) {
            case 4: {
                quantifier = SubqueryComparison.Quantifier.ALL;
                break;
            }
            case 3: {
                quantifier = SubqueryComparison.Quantifier.SOME;
                break;
            }
            case 2: {
                quantifier = SubqueryComparison.Quantifier.SOME;
            }
        }
        Comparison.Operator operator = Comparison.Operator.EQ;
        switch (criteria.getOperator()) {
            case 1: {
                operator = Comparison.Operator.EQ;
                break;
            }
            case 2: {
                operator = Comparison.Operator.NE;
                break;
            }
            case 3: {
                operator = Comparison.Operator.LT;
                break;
            }
            case 5: {
                operator = Comparison.Operator.LE;
                break;
            }
            case 4: {
                operator = Comparison.Operator.GT;
                break;
            }
            case 6: {
                operator = Comparison.Operator.GE;
            }
        }
        return new SubqueryComparison(this.translate(criteria.getLeftExpression()), operator, quantifier, this.translate((QueryCommand)criteria.getCommand()));
    }

    SubqueryIn translate(SubquerySetCriteria criteria) {
        return new SubqueryIn(this.translate(criteria.getExpression()), criteria.isNegated(), this.translate((QueryCommand)criteria.getCommand()));
    }

    Not translate(NotCriteria criteria) {
        return new Not(this.translate(criteria.getCriteria()));
    }

    public GroupBy translate(org.teiid.query.sql.lang.GroupBy groupBy) {
        if (groupBy == null) {
            return null;
        }
        List items = groupBy.getSymbols();
        ArrayList<org.teiid.language.Expression> translatedItems = new ArrayList<org.teiid.language.Expression>();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            translatedItems.add(this.translate((Expression)i.next()));
        }
        return new GroupBy(translatedItems);
    }

    public org.teiid.language.OrderBy translate(OrderBy orderBy) {
        if (orderBy == null) {
            return null;
        }
        List<OrderByItem> items = orderBy.getOrderByItems();
        ArrayList<SortSpecification> translatedItems = new ArrayList<SortSpecification>();
        for (int i = 0; i < items.size(); ++i) {
            SingleElementSymbol symbol = items.get(i).getSymbol();
            SortSpecification.Ordering direction = items.get(i).isAscending() ? SortSpecification.Ordering.ASC : SortSpecification.Ordering.DESC;
            SortSpecification orderByItem = null;
            orderByItem = symbol instanceof AliasSymbol || !items.get(i).isUnrelated() ? new SortSpecification(direction, (org.teiid.language.Expression)new ColumnReference(null, symbol.getOutputName(), null, symbol.getType())) : new SortSpecification(direction, this.translate(symbol));
            orderByItem.setNullOrdering(items.get(i).getNullOrdering());
            translatedItems.add(orderByItem);
        }
        return new org.teiid.language.OrderBy(translatedItems);
    }

    public org.teiid.language.Expression translate(Expression expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof Constant) {
            return this.translate((Constant)expr);
        }
        if (expr instanceof org.teiid.query.sql.symbol.Function) {
            return this.translate((org.teiid.query.sql.symbol.Function)expr);
        }
        if (expr instanceof ScalarSubquery) {
            return this.translate((ScalarSubquery)expr);
        }
        if (expr instanceof SearchedCaseExpression) {
            return this.translate((SearchedCaseExpression)expr);
        }
        if (expr instanceof SingleElementSymbol) {
            return this.translate((SingleElementSymbol)expr);
        }
        if (expr instanceof Criteria) {
            return this.translate((Criteria)expr);
        }
        throw new AssertionError();
    }

    Literal translate(Constant constant) {
        Literal result = new Literal(constant.getValue(), constant.getType());
        result.setBindValue(constant.isMultiValued());
        result.setMultiValued(constant.isMultiValued());
        return result;
    }

    Function translate(org.teiid.query.sql.symbol.Function function) {
        Expression[] args = function.getArgs();
        ArrayList<org.teiid.language.Expression> params = new ArrayList<org.teiid.language.Expression>(args.length);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.add(this.translate(args[i]));
            }
        }
        return new Function(function.getName(), params, function.getType());
    }

    SearchedCase translate(SearchedCaseExpression expr) {
        ArrayList<SearchedWhenClause> whens = new ArrayList<SearchedWhenClause>();
        for (int i = 0; i < expr.getWhenCount(); ++i) {
            whens.add(new SearchedWhenClause(this.translate(expr.getWhenCriteria(i)), this.translate(expr.getThenExpression(i))));
        }
        return new SearchedCase(whens, this.translate(expr.getElseExpression()), expr.getType());
    }

    org.teiid.language.Expression translate(ScalarSubquery ss) {
        return new org.teiid.language.ScalarSubquery(this.translate((QueryCommand)ss.getCommand()));
    }

    org.teiid.language.Expression translate(SingleElementSymbol symbol) {
        if (symbol == null) {
            return null;
        }
        if (symbol instanceof ElementSymbol) {
            return this.translate((ElementSymbol)symbol);
        }
        if (symbol instanceof AggregateSymbol) {
            return this.translate((AggregateSymbol)symbol);
        }
        if (symbol instanceof ExpressionSymbol) {
            return this.translate((ExpressionSymbol)symbol);
        }
        throw new AssertionError();
    }

    org.teiid.language.Expression translate(AliasSymbol symbol) {
        return this.translate(symbol.getSymbol());
    }

    ColumnReference translate(ElementSymbol symbol) {
        ColumnReference element = new ColumnReference(this.translate(symbol.getGroupSymbol()), symbol.getOutputName(), null, symbol.getType());
        if (element.getTable().getMetadataObject() == null) {
            return element;
        }
        Object mid = symbol.getMetadataID();
        if (!(mid instanceof TempMetadataID)) {
            element.setMetadataObject(this.metadataFactory.getElement(mid));
        }
        return element;
    }

    AggregateFunction translate(AggregateSymbol symbol) {
        return new AggregateFunction(symbol.getAggregateFunction().name(), symbol.isDistinct(), this.translate(symbol.getExpression()), symbol.getType());
    }

    org.teiid.language.Expression translate(ExpressionSymbol symbol) {
        return this.translate(symbol.getExpression());
    }

    org.teiid.language.Insert translate(Insert insert) {
        List elements = insert.getVariables();
        ArrayList<ColumnReference> translatedElements = new ArrayList<ColumnReference>();
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            translatedElements.add(this.translate((ElementSymbol)i.next()));
        }
        QueryExpression valueSource = null;
        if (insert.getQueryExpression() != null) {
            valueSource = this.translate(insert.getQueryExpression());
        } else if (insert.getTupleSource() != null) {
            final TupleSource ts = insert.getTupleSource();
            valueSource = new IteratorValueSource(new Iterator<List<?>>(){
                List<?> next;

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public List<?> next() {
                    if (this.hasNext()) {
                        List<?> result = this.next;
                        this.next = null;
                        return result;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    try {
                        this.next = ts.nextTuple();
                    }
                    catch (TeiidException e) {
                        throw new TeiidRuntimeException((Throwable)e);
                    }
                    return this.next != null;
                }
            }, elements.size());
        } else {
            List values = insert.getValues();
            ArrayList<org.teiid.language.Expression> translatedValues = new ArrayList<org.teiid.language.Expression>();
            Iterator i2 = values.iterator();
            while (i2.hasNext()) {
                translatedValues.add(this.translate((Expression)i2.next()));
            }
            valueSource = new ExpressionValueSource(translatedValues);
        }
        return new org.teiid.language.Insert(this.translate(insert.getGroup()), translatedElements, (InsertValueSource)valueSource);
    }

    Update translate(org.teiid.query.sql.lang.Update update) {
        return new Update(this.translate(update.getGroup()), this.translate(update.getChangeList()), this.translate(update.getCriteria()));
    }

    List<SetClause> translate(SetClauseList setClauseList) {
        ArrayList<SetClause> clauses = new ArrayList<SetClause>(setClauseList.getClauses().size());
        for (org.teiid.query.sql.lang.SetClause setClause : setClauseList.getClauses()) {
            clauses.add(this.translate(setClause));
        }
        return clauses;
    }

    SetClause translate(org.teiid.query.sql.lang.SetClause setClause) {
        return new SetClause(this.translate(setClause.getSymbol()), this.translate(setClause.getValue()));
    }

    org.teiid.language.Delete translate(Delete delete) {
        org.teiid.language.Delete deleteImpl = new org.teiid.language.Delete(this.translate(delete.getGroup()), this.translate(delete.getCriteria()));
        return deleteImpl;
    }

    Call translate(StoredProcedure sp) {
        Procedure proc = null;
        if (sp.getProcedureID() != null) {
            try {
                proc = this.metadataFactory.getProcedure(sp.getGroup().getName());
            }
            catch (TranslatorException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }
        Class returnType = null;
        List<SPParameter> parameters = sp.getParameters();
        ArrayList<Argument> translatedParameters = new ArrayList<Argument>();
        block9: for (SPParameter param : parameters) {
            Argument.Direction direction = Argument.Direction.IN;
            switch (param.getParameterType()) {
                case 1: {
                    direction = Argument.Direction.IN;
                    break;
                }
                case 3: {
                    direction = Argument.Direction.INOUT;
                    break;
                }
                case 2: {
                    direction = Argument.Direction.OUT;
                    break;
                }
                case 5: {
                    continue block9;
                }
                case 4: {
                    returnType = param.getClassType();
                }
            }
            ProcedureParameter metadataParam = this.metadataFactory.getParameter(param);
            Literal value = (Literal)this.translate(param.getExpression());
            Argument arg = new Argument(direction, value, param.getClassType(), metadataParam);
            translatedParameters.add(arg);
        }
        Call call = new Call(this.removeSchemaName(sp.getProcedureName()), translatedParameters, proc);
        call.setReturnType(returnType);
        return call;
    }

    public NamedTable translate(GroupSymbol symbol) {
        String alias = null;
        String fullGroup = symbol.getOutputName();
        if (symbol.getOutputDefinition() != null) {
            alias = symbol.getOutputName();
            fullGroup = symbol.getOutputDefinition();
        }
        fullGroup = this.removeSchemaName(fullGroup);
        NamedTable group = new NamedTable(fullGroup, alias, null);
        if (symbol.getMetadataID() instanceof TempMetadataID) {
            return group;
        }
        try {
            group.setMetadataObject(this.metadataFactory.getGroup(symbol.getMetadataID()));
        }
        catch (QueryMetadataException e) {
            throw new TeiidRuntimeException((Throwable)((Object)e));
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        return group;
    }

    private String removeSchemaName(String fullGroup) {
        int index = fullGroup.indexOf(".");
        if (index > 0) {
            fullGroup = fullGroup.substring(index + 1);
        }
        return fullGroup;
    }

    BatchedUpdates translate(BatchedUpdateCommand command) {
        List updates = command.getUpdateCommands();
        ArrayList<Command> translatedUpdates = new ArrayList<Command>(updates.size());
        Iterator i = updates.iterator();
        while (i.hasNext()) {
            translatedUpdates.add(this.translate((org.teiid.query.sql.lang.Command)i.next()));
        }
        return new BatchedUpdates(translatedUpdates);
    }

    org.teiid.language.Limit translate(Limit limit) {
        if (limit == null) {
            return null;
        }
        int rowOffset = 0;
        if (limit.getOffset() != null) {
            Literal c1 = (Literal)this.translate(limit.getOffset());
            rowOffset = (Integer)c1.getValue();
        }
        Literal c2 = (Literal)this.translate(limit.getRowLimit());
        int rowLimit = (Integer)c2.getValue();
        return new org.teiid.language.Limit(rowOffset, rowLimit);
    }
}

