/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.SourceWarning;
import org.teiid.client.lob.LobChunk;
import org.teiid.client.metadata.ParameterInfo;
import org.teiid.client.util.ResultsReceiver;
import org.teiid.client.xa.XATransactionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.DQPPlugin;
import org.teiid.dqp.internal.process.AbstractWorkItem;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.LobWorkItem;
import org.teiid.dqp.internal.process.Request;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.ThreadReuseExecutor;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class RequestWorkItem
extends AbstractWorkItem
implements ThreadReuseExecutor.PrioritizedRunnable {
    private ProcessingState state = ProcessingState.NEW;
    private TransactionState transactionState = TransactionState.NONE;
    protected final DQPCore dqpCore;
    final RequestMessage requestMsg;
    final RequestID requestID;
    private Request request;
    private final int processorTimeslice;
    private SessionAwareCache.CacheID cid;
    private final TransactionService transactionService;
    private final DQPWorkContext dqpWorkContext;
    boolean active;
    private volatile QueryProcessor processor;
    private BatchCollector collector;
    private Command originalCommand;
    private AnalysisRecord analysisRecord;
    private TransactionContext transactionContext;
    TupleBuffer resultsBuffer;
    private boolean returnsUpdateCount;
    private Throwable processingException;
    private Map<AtomicRequestID, DataTierTupleSource> connectorInfo = new ConcurrentHashMap<AtomicRequestID, DataTierTupleSource>(4);
    private List<TeiidException> warnings = new LinkedList<TeiidException>();
    private volatile boolean doneProducingBatches;
    private volatile boolean isClosed;
    private volatile boolean isCanceled;
    private volatile boolean closeRequested;
    private ResultsReceiver<ResultsMessage> resultsReceiver;
    private int begin;
    private int end;
    private TupleBatch savedBatch;
    private Map<Integer, LobWorkItem> lobStreams = new ConcurrentHashMap<Integer, LobWorkItem>(4);
    private long processingTimestamp = System.currentTimeMillis();

    public RequestWorkItem(DQPCore dqpCore, RequestMessage requestMsg, Request request, ResultsReceiver<ResultsMessage> receiver, RequestID requestID, DQPWorkContext workContext) {
        this.requestMsg = requestMsg;
        this.requestID = requestID;
        this.processorTimeslice = dqpCore.getProcessorTimeSlice();
        this.transactionService = dqpCore.getTransactionService();
        this.dqpCore = dqpCore;
        this.request = request;
        this.dqpWorkContext = workContext;
        this.requestResults(1, requestMsg.getFetchSize(), receiver);
    }

    private boolean isForwardOnly() {
        return this.cid == null && this.requestMsg.getCursorType() == 1003;
    }

    synchronized void requestResults(int beginRow, int endRow, ResultsReceiver<ResultsMessage> receiver) {
        if (this.resultsReceiver != null) {
            throw new IllegalStateException("Results already requested");
        }
        this.resultsReceiver = receiver;
        this.begin = beginRow;
        this.end = endRow;
    }

    @Override
    protected boolean isDoneProcessing() {
        return this.isClosed;
    }

    @Override
    protected void resumeProcessing() {
        if (this.doneProducingBatches && !this.closeRequested && !this.isCanceled) {
            this.run();
        } else {
            this.dqpCore.addWork(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process() {
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Request Thread", this.requestID, "with state", this.state});
        try {
            if (this.state == ProcessingState.NEW) {
                this.state = ProcessingState.PROCESSING;
                this.processNew();
                if (this.isCanceled) {
                    this.processingException = new TeiidProcessingException(QueryExecPlugin.Util.getString("QueryProcessor.request_cancelled", new Object[]{this.requestID}));
                    this.state = ProcessingState.CLOSE;
                }
            }
            this.resume();
            if (this.state == ProcessingState.PROCESSING) {
                this.processMore();
                if (this.closeRequested) {
                    this.state = ProcessingState.CLOSE;
                }
            }
        }
        catch (BlockedException e) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Request Thread", this.requestID, "- processor blocked"});
        }
        catch (QueryProcessor.ExpiredTimeSliceException e) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Request Thread", this.requestID, "- time slice expired"});
            this.moreWork();
        }
        catch (Throwable e) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)e, (Object[])new Object[]{"Request Thread", this.requestID, "- error occurred"});
            if (!this.isCanceled()) {
                this.dqpCore.logMMCommand(this, CommandLogMessage.Event.ERROR, null);
                if (e instanceof TeiidProcessingException) {
                    Throwable cause;
                    for (cause = e; cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
                    }
                    StackTraceElement elem = cause.getStackTrace()[0];
                    LogManager.logWarning((String)"org.teiid.PROCESSOR", (String)DQPPlugin.Util.getString("ProcessWorker.processing_error", new Object[]{e.getMessage(), this.requestID, e.getClass().getName(), elem}));
                } else {
                    LogManager.logError((String)"org.teiid.PROCESSOR", (Throwable)e, (String)DQPPlugin.Util.getString("ProcessWorker.error", new Object[]{this.requestID}));
                }
            }
            this.processingException = e;
            this.state = ProcessingState.CLOSE;
        }
        finally {
            if (this.state == ProcessingState.CLOSE && !this.isClosed) {
                this.attemptClose();
            } else if (this.isClosed) {
                if (this.processingException == null) {
                    this.processingException = new IllegalStateException("Request is already closed");
                }
                this.sendError();
            }
            this.suspend();
        }
    }

    private void resume() throws XATransactionException {
        if (this.transactionState == TransactionState.ACTIVE && this.transactionContext.getTransaction() != null) {
            this.transactionService.resume(this.transactionContext);
        }
    }

    private void suspend() {
        try {
            this.transactionService.suspend(this.transactionContext);
        }
        catch (XATransactionException e) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)e, (Object[])new Object[]{"Error suspending active transaction"});
        }
    }

    protected void processMore() throws BlockedException, TeiidException {
        if (!this.doneProducingBatches) {
            this.processor.getContext().setTimeSliceEnd(System.currentTimeMillis() + (long)this.processorTimeslice);
            this.sendResultsIfNeeded(null);
            this.collector.collectTuples();
        }
        if (this.doneProducingBatches) {
            if (this.transactionState == TransactionState.ACTIVE) {
                for (DataTierTupleSource connectorRequest : this.connectorInfo.values()) {
                    if (!connectorRequest.isTransactional()) continue;
                    connectorRequest.fullyCloseSource();
                }
                this.transactionState = TransactionState.DONE;
                if (this.transactionContext.getTransactionType() == TransactionContext.Scope.REQUEST) {
                    this.transactionService.commit(this.transactionContext);
                } else {
                    this.suspend();
                }
            }
            this.sendResultsIfNeeded(null);
        } else {
            this.moreWork(false);
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"############# PW EXITING on " + this.requestID + " - reenqueueing for more processing ###########"});
            }
        }
    }

    protected void attemptClose() {
        int rowcount = -1;
        if (this.resultsBuffer != null) {
            if (this.processor != null) {
                this.processor.closeProcessing();
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Removing tuplesource for the request " + this.requestID});
                }
                rowcount = this.resultsBuffer.getRowCount();
                if (this.cid == null || !this.doneProducingBatches) {
                    this.resultsBuffer.remove();
                }
                for (DataTierTupleSource connectorRequest : this.connectorInfo.values()) {
                    connectorRequest.fullyCloseSource();
                }
            }
            this.resultsBuffer = null;
            for (LobWorkItem lobWorkItem : this.lobStreams.values()) {
                lobWorkItem.close();
            }
        }
        if (this.transactionState == TransactionState.ACTIVE) {
            this.transactionState = TransactionState.DONE;
            if (this.transactionContext.getTransactionType() == TransactionContext.Scope.REQUEST) {
                try {
                    this.transactionService.rollback(this.transactionContext);
                }
                catch (XATransactionException e1) {
                    LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e1, (String)DQPPlugin.Util.getString("ProcessWorker.failed_rollback"));
                }
            } else {
                this.suspend();
            }
        }
        this.isClosed = true;
        this.dqpCore.removeRequest(this);
        if (this.processingException != null) {
            this.sendError();
        } else {
            this.dqpCore.logMMCommand(this, CommandLogMessage.Event.END, rowcount);
        }
    }

    protected void processNew() throws TeiidProcessingException, TeiidComponentException {
        CachedResults cr;
        SessionAwareCache<CachedResults> rsCache = this.dqpCore.getRsCache();
        ParseInfo pi = Request.createParseInfo(this.requestMsg);
        SessionAwareCache.CacheID cacheId = new SessionAwareCache.CacheID(this.dqpWorkContext, pi, this.requestMsg.getCommandString());
        cacheId.setParameters(this.requestMsg.getParameterValues());
        if (rsCache != null && (cr = rsCache.get(cacheId)) != null && (this.requestMsg.useResultSetCache() || cr.getHint() != null)) {
            this.resultsBuffer = cr.getResults();
            this.analysisRecord = cr.getAnalysisRecord();
            this.request.initMetadata();
            this.originalCommand = cr.getCommand(this.requestMsg.getCommandString(), this.request.metadata, pi);
            this.request.validateAccess(this.originalCommand);
            this.doneProducingBatches();
            return;
        }
        this.request.processRequest();
        this.originalCommand = this.request.userCommand;
        if ((this.requestMsg.useResultSetCache() || this.originalCommand.getCacheHint() != null) && rsCache != null && this.originalCommand.areResultsCachable()) {
            this.cid = cacheId;
        }
        this.processor = this.request.processor;
        this.resultsBuffer = this.processor.createTupleBuffer();
        if (this.cid != null && this.originalCommand.getCacheHint() != null) {
            this.resultsBuffer.setPrefersMemory(this.originalCommand.getCacheHint().getPrefersMemory());
        }
        this.collector = new BatchCollector(this.processor, this.resultsBuffer){

            @Override
            protected void flushBatchDirect(TupleBatch batch, boolean add) throws TeiidComponentException, TeiidProcessingException {
                boolean added = false;
                if (RequestWorkItem.this.cid != null || RequestWorkItem.this.resultsBuffer.isLobs()) {
                    super.flushBatchDirect(batch, add);
                    added = true;
                }
                if (batch.getTerminationFlag()) {
                    RequestWorkItem.this.doneProducingBatches();
                }
                if (RequestWorkItem.this.doneProducingBatches && RequestWorkItem.this.cid != null) {
                    int determinismLevel = RequestWorkItem.this.processor.getContext().getDeterminismLevel();
                    CachedResults cr = new CachedResults();
                    cr.setCommand(RequestWorkItem.this.originalCommand);
                    cr.setAnalysisRecord(RequestWorkItem.this.analysisRecord);
                    cr.setResults(RequestWorkItem.this.resultsBuffer);
                    if (determinismLevel > 3) {
                        LogManager.logInfo((String)"org.teiid.PROCESSOR", (String)DQPPlugin.Util.getString("RequestWorkItem.cache_nondeterministic", new Object[]{RequestWorkItem.this.originalCommand}));
                    }
                    RequestWorkItem.this.dqpCore.getRsCache().put(RequestWorkItem.this.cid, determinismLevel, cr, RequestWorkItem.this.originalCommand.getCacheHint() != null ? RequestWorkItem.this.originalCommand.getCacheHint().getTtl() : null);
                }
                add = RequestWorkItem.this.sendResultsIfNeeded(batch);
                if (!added) {
                    super.flushBatchDirect(batch, add);
                }
            }
        };
        this.resultsBuffer = this.collector.getTupleBuffer();
        this.resultsBuffer.setForwardOnly(this.isForwardOnly());
        this.analysisRecord = this.request.analysisRecord;
        this.analysisRecord.setQueryPlan(this.processor.getProcessorPlan().getDescriptionProperties());
        this.transactionContext = this.request.transactionContext;
        if (this.transactionContext != null && this.transactionContext.getTransactionType() != TransactionContext.Scope.NONE) {
            this.transactionState = TransactionState.ACTIVE;
        }
        if (this.requestMsg.isNoExec()) {
            this.doneProducingBatches();
            this.resultsBuffer.close();
            this.cid = null;
        }
        this.returnsUpdateCount = this.request.returnsUpdateCount;
        this.request = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendResultsIfNeeded(TupleBatch batch) throws TeiidComponentException {
        ResultsMessage response = null;
        ResultsReceiver<ResultsMessage> receiver = null;
        boolean result = true;
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            StoredProcedure proc;
            List<Exception> currentWarnings22;
            if (this.resultsReceiver == null || this.begin > (batch != null ? batch.getEndRow() : this.resultsBuffer.getRowCount()) && !this.doneProducingBatches || this.transactionState == TransactionState.ACTIVE) {
                return result;
            }
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"[RequestWorkItem.sendResultsIfNeeded] requestID:", this.requestID, "resultsID:", this.resultsBuffer, "done:", this.doneProducingBatches});
            }
            boolean fromBuffer = false;
            if (batch == null || !batch.containsRow(this.begin)) {
                batch = this.savedBatch != null && this.savedBatch.containsRow(this.begin) ? this.savedBatch : this.resultsBuffer.getBatch(this.begin);
                this.savedBatch = null;
                fromBuffer = true;
            }
            int count = this.end - this.begin + 1;
            if (batch.getRowCount() > count) {
                int beginRow = Math.min(this.begin, batch.getEndRow() - count + 1);
                int endRow = Math.min(beginRow + count - 1, batch.getEndRow());
                boolean last = false;
                if (endRow == batch.getEndRow()) {
                    last = batch.getTerminationFlag();
                } else if (fromBuffer && this.isForwardOnly()) {
                    this.savedBatch = batch;
                }
                List<List> memoryRows = batch.getTuples();
                batch = new TupleBatch(beginRow, memoryRows.subList(beginRow - batch.getBeginRow(), endRow - batch.getBeginRow() + 1));
                batch.setTerminationFlag(last);
            } else if (!fromBuffer) {
                boolean bl = result = !this.isForwardOnly();
            }
            int finalRowCount = this.resultsBuffer.isFinal() ? this.resultsBuffer.getRowCount() : (batch.getTerminationFlag() ? batch.getEndRow() : -1);
            response = this.createResultsMessage(batch.getAllTuples(), this.originalCommand.getProjectedSymbols());
            response.setFirstRow(batch.getBeginRow());
            response.setLastRow(batch.getEndRow());
            response.setUpdateResult(this.returnsUpdateCount);
            response.setFinalRow(finalRowCount);
            ArrayList<Exception> responseWarnings = new ArrayList<Exception>();
            if (this.processor != null && (currentWarnings22 = this.processor.getAndClearWarnings()) != null) {
                responseWarnings.addAll(currentWarnings22);
            }
            List<TeiidException> currentWarnings22 = this.warnings;
            synchronized (currentWarnings22) {
                responseWarnings.addAll(this.warnings);
                this.warnings.clear();
            }
            response.setWarnings(responseWarnings);
            if (this.originalCommand instanceof StoredProcedure && (proc = (StoredProcedure)this.originalCommand).returnParameters()) {
                response.setParameters(RequestWorkItem.getParameterInfo(proc));
            }
            receiver = this.resultsReceiver;
            this.resultsReceiver = null;
        }
        receiver.receiveResults((Object)response);
        return result;
    }

    public ResultsMessage createResultsMessage(List[] batch, List columnSymbols) {
        String[] columnNames = new String[columnSymbols.size()];
        String[] dataTypes = new String[columnSymbols.size()];
        for (int i = 0; i < columnSymbols.size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)columnSymbols.get(i);
            columnNames[i] = SingleElementSymbol.getShortName(symbol.getOutputName());
            dataTypes[i] = DataTypeManager.getDataTypeName((Class)symbol.getType());
        }
        ResultsMessage result = new ResultsMessage(this.requestMsg, batch, columnNames, dataTypes);
        this.setAnalysisRecords(result);
        return result;
    }

    private void setAnalysisRecords(ResultsMessage response) {
        if (this.analysisRecord != null) {
            if (this.requestMsg.getShowPlan() != RequestMessage.ShowPlan.OFF) {
                if (this.processor != null) {
                    this.analysisRecord.setQueryPlan(this.processor.getProcessorPlan().getDescriptionProperties());
                }
                response.setPlanDescription(this.analysisRecord.getQueryPlan());
                response.setAnnotations(this.analysisRecord.getAnnotations());
            }
            if (this.requestMsg.getShowPlan() == RequestMessage.ShowPlan.DEBUG) {
                response.setDebugLog(this.analysisRecord.getDebugLog());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError() {
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            if (this.resultsReceiver == null) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)this.processingException, (Object[])new Object[]{"Unable to send error to client as results were already sent.", this.requestID});
                return;
            }
        }
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)this.processingException, (Object[])new Object[]{"Sending error to client", this.requestID});
        ResultsMessage response = new ResultsMessage(this.requestMsg);
        response.setException(this.processingException);
        this.setAnalysisRecords(response);
        this.resultsReceiver.receiveResults((Object)response);
    }

    private static List<ParameterInfo> getParameterInfo(StoredProcedure procedure) {
        ArrayList<ParameterInfo> paramInfos = new ArrayList<ParameterInfo>();
        for (SPParameter param : procedure.getParameters()) {
            ParameterInfo info = new ParameterInfo(param.getParameterType(), param.getResultSetColumns().size());
            paramInfos.add(info);
        }
        return paramInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLobChunkRequest(String id, int streamRequestId, ResultsReceiver<LobChunk> chunckReceiver) {
        LobWorkItem workItem = null;
        Map<Integer, LobWorkItem> map = this.lobStreams;
        synchronized (map) {
            workItem = this.lobStreams.get(new Integer(streamRequestId));
            if (workItem == null) {
                workItem = new LobWorkItem(this, this.dqpCore, id, streamRequestId);
                this.lobStreams.put(new Integer(streamRequestId), workItem);
            }
        }
        workItem.setResultsReceiver(chunckReceiver);
        this.dqpCore.addWork((Runnable)((Object)workItem));
    }

    public void removeLobStream(int streamRequestId) {
        this.lobStreams.remove(new Integer(streamRequestId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestCancel() throws TeiidComponentException {
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            if (this.isCanceled) {
                return false;
            }
            this.isCanceled = true;
        }
        if (this.processor != null) {
            this.processor.requestCanceled();
        }
        try {
            for (DataTierTupleSource connectorRequest : this.connectorInfo.values()) {
                connectorRequest.cancelRequest();
            }
        }
        finally {
            block19: {
                try {
                    if (this.transactionService == null) break block19;
                    try {
                        this.transactionService.cancelTransactions(this.requestID.getConnectionID(), true);
                    }
                    catch (XATransactionException err) {
                        throw new TeiidComponentException((Throwable)err);
                    }
                }
                finally {
                    this.moreWork();
                }
            }
        }
        return true;
    }

    public boolean requestAtomicRequestCancel(AtomicRequestID ari) throws TeiidComponentException {
        if (!this.requestMsg.supportsPartialResults()) {
            return this.requestCancel();
        }
        DataTierTupleSource connectorRequest = this.connectorInfo.get(ari);
        if (connectorRequest != null) {
            connectorRequest.cancelRequest();
            return true;
        }
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Connector request not found. AtomicRequestID=", ari});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestClose() throws TeiidComponentException {
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            if (this.state == ProcessingState.CLOSE || this.closeRequested) {
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Request already closing" + this.requestID});
                }
                return;
            }
        }
        this.closeRequested = true;
        if (!this.doneProducingBatches) {
            this.requestCancel();
        }
        this.moreWork();
    }

    public void requestMore(int batchFirst, int batchLast, ResultsReceiver<ResultsMessage> receiver) {
        this.requestResults(batchFirst, batchLast, receiver);
        this.moreWork();
    }

    public void closeAtomicRequest(AtomicRequestID atomicRequestId) {
        this.connectorInfo.remove(atomicRequestId);
        LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"closed atomic-request:", atomicRequestId});
    }

    public void addConnectorRequest(AtomicRequestID atomicRequestId, DataTierTupleSource connInfo) {
        this.connectorInfo.put(atomicRequestId, connInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceFailureDetails(SourceWarning details) {
        List<TeiidException> list = this.warnings;
        synchronized (list) {
            this.warnings.add((TeiidException)details);
        }
    }

    boolean isCanceled() {
        return this.isCanceled;
    }

    Command getOriginalCommand() throws TeiidProcessingException {
        if (this.originalCommand == null) {
            if (this.processingException != null) {
                throw new TeiidProcessingException(this.processingException);
            }
            throw new IllegalStateException("Original command is not available");
        }
        return this.originalCommand;
    }

    void setOriginalCommand(Command originalCommand) {
        this.originalCommand = originalCommand;
    }

    TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    Collection<DataTierTupleSource> getConnectorRequests() {
        return new LinkedList<DataTierTupleSource>(this.connectorInfo.values());
    }

    DataTierTupleSource getConnectorRequest(AtomicRequestID id) {
        return this.connectorInfo.get(id);
    }

    public List<TeiidException> getWarnings() {
        return this.warnings;
    }

    @Override
    public String toString() {
        return this.requestID.toString();
    }

    @Override
    public DQPWorkContext getDqpWorkContext() {
        return this.dqpWorkContext;
    }

    public long getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    @Override
    public void release() {
        try {
            this.requestCancel();
        }
        catch (TeiidComponentException e) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (String)("Failed to cancel " + this.requestID));
        }
    }

    private void doneProducingBatches() {
        this.doneProducingBatches = true;
        this.dqpCore.finishProcessing(this);
    }

    @Override
    public int getPriority() {
        return this.closeRequested || this.isCanceled ? 0 : 1000;
    }

    @Override
    public long getCreationTime() {
        return this.processingTimestamp;
    }

    private static enum TransactionState {
        NONE,
        ACTIVE,
        DONE;

    }

    private static enum ProcessingState {
        NEW,
        PROCESSING,
        CLOSE;

    }
}

