/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.teiid.api.exception.query.InvalidFunctionException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionForm;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.metadata.FunctionMethod;
import org.teiid.query.function.metadata.FunctionParameter;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;

public class FunctionLibrary {
    public static final String CONVERT = "convert";
    public static final String CAST = "cast";
    public static final String LOOKUP = "lookup";
    public static final String USER = "user";
    public static final String ENV = "env";
    public static final String CONTEXT = "context";
    public static final String ROWLIMIT = "rowlimit";
    public static final String ROWLIMITEXCEPTION = "rowlimitexception";
    public static final String DECODESTRING = "decodestring";
    public static final String DECODEINTEGER = "decodeinteger";
    public static final String COMMAND_PAYLOAD = "commandpayload";
    public static final String CONCAT = "CONCAT";
    public static final String CONCAT2 = "CONCAT2";
    public static final String CONCAT_OPERATOR = "||";
    public static final String SUBSTRING = "substring";
    public static final String NVL = "NVL";
    public static final String IFNULL = "IFNULL";
    public static final String FROM_UNIXTIME = "from_unixtime";
    public static final String TIMESTAMPADD = "timestampadd";
    public static final String PARSETIME = "parsetime";
    public static final String PARSEDATE = "parsedate";
    public static final String FORMATTIME = "formattime";
    public static final String FORMATDATE = "formatdate";
    public static final String NULLIF = "nullif";
    public static final String COALESCE = "coalesce";
    public static final String SPACE = "space";
    private FunctionTree systemFunctions;
    private FunctionTree userFunctions;

    public FunctionLibrary(FunctionTree systemFuncs, FunctionTree userFuncs) {
        this.systemFunctions = systemFuncs;
        this.userFunctions = userFuncs;
    }

    public List getFunctionCategories() {
        HashSet<String> categories = new HashSet<String>();
        categories.addAll(this.systemFunctions.getCategories());
        categories.addAll(this.userFunctions.getCategories());
        ArrayList categoryList = new ArrayList(categories);
        Collections.sort(categoryList);
        return categoryList;
    }

    public List getFunctionForms(String category) {
        ArrayList<FunctionForm> forms = new ArrayList<FunctionForm>();
        forms.addAll(this.systemFunctions.getFunctionForms(category));
        forms.addAll(this.userFunctions.getFunctionForms(category));
        Collections.sort(forms);
        return forms;
    }

    public FunctionForm findFunctionForm(String name, int numArgs) {
        FunctionForm form = this.systemFunctions.findFunctionForm(name, numArgs);
        if (form == null) {
            form = this.userFunctions.findFunctionForm(name, numArgs);
        }
        return form;
    }

    public FunctionDescriptor findFunction(String name, Class[] types) {
        FunctionDescriptor descriptor = this.systemFunctions.getFunction(name, types);
        if (descriptor == null) {
            descriptor = this.userFunctions.getFunction(name, types);
        }
        return descriptor;
    }

    public FunctionDescriptor[] determineNecessaryConversions(String name, Class<?> returnType, Class<?>[] types, boolean hasUnknownType) {
        if (types.length == 0) {
            return new FunctionDescriptor[0];
        }
        FunctionDescriptor[] results = null;
        LinkedList<FunctionMethod> functionMethods = new LinkedList<FunctionMethod>();
        functionMethods.addAll(this.systemFunctions.findFunctionMethods(name, types.length));
        functionMethods.addAll(this.userFunctions.findFunctionMethods(name, types.length));
        int bestScore = Integer.MAX_VALUE;
        boolean ambiguous = false;
        for (FunctionMethod nextMethod : functionMethods) {
            int i;
            int currentScore = 0;
            FunctionParameter[] methodTypes = nextMethod.getInputParameters();
            FunctionDescriptor[] currentSignature = new FunctionDescriptor[types.length];
            for (i = 0; i < types.length; ++i) {
                FunctionDescriptor fd;
                String tmpTypeName = methodTypes[Math.min(i, methodTypes.length - 1)].getType();
                Class targetType = DataTypeManager.getDataTypeClass((String)tmpTypeName);
                Class<?> sourceType = types[i];
                if (sourceType == null) {
                    currentSignature[i] = fd = this.findTypedConversionFunction(DataTypeManager.DefaultDataClasses.NULL, targetType);
                    ++currentScore;
                    continue;
                }
                try {
                    fd = this.getConvertFunctionDescriptor(sourceType, targetType);
                    if (fd == null) continue;
                    ++currentScore;
                    currentSignature[i] = fd;
                    continue;
                }
                catch (InvalidFunctionException e) {
                    break;
                }
            }
            if (i != types.length || currentScore > bestScore) continue;
            if (hasUnknownType) {
                if (returnType != null) {
                    try {
                        FunctionDescriptor fd = this.getConvertFunctionDescriptor(DataTypeManager.getDataTypeClass((String)nextMethod.getOutputParameter().getType()), returnType);
                        if (fd != null) {
                            ++currentScore;
                        }
                    }
                    catch (InvalidFunctionException e) {
                        currentScore += types.length + 1;
                    }
                }
                boolean bl = ambiguous = currentScore == bestScore;
            }
            if (currentScore >= bestScore) continue;
            if (currentScore == 0) {
                return currentSignature;
            }
            bestScore = currentScore;
            results = currentSignature;
        }
        if (ambiguous) {
            return null;
        }
        return results;
    }

    private FunctionDescriptor getConvertFunctionDescriptor(Class<?> sourceType, Class<?> targetType) throws InvalidFunctionException {
        String targetTypeName;
        String sourceTypeName = DataTypeManager.getDataTypeName(sourceType);
        if (sourceTypeName.equals(targetTypeName = DataTypeManager.getDataTypeName(targetType))) {
            return null;
        }
        if (!DataTypeManager.isImplicitConversion((String)sourceTypeName, (String)targetTypeName)) {
            throw new InvalidFunctionException();
        }
        FunctionDescriptor fd = this.findTypedConversionFunction(sourceType, targetType);
        if (fd == null) {
            throw new InvalidFunctionException();
        }
        return fd;
    }

    public FunctionDescriptor findTypedConversionFunction(Class sourceType, Class targetType) {
        FunctionDescriptor fd = this.findFunction(CONVERT, new Class[]{sourceType, DataTypeManager.DefaultDataClasses.STRING});
        if (fd != null) {
            return this.copyFunctionChangeReturnType(fd, targetType);
        }
        return null;
    }

    public FunctionDescriptor copyFunctionChangeReturnType(FunctionDescriptor fd, Class returnType) {
        if (fd != null) {
            FunctionDescriptor fdImpl = fd;
            FunctionDescriptor copy = (FunctionDescriptor)fdImpl.clone();
            copy.setReturnType(returnType);
            return copy;
        }
        return fd;
    }

    public static boolean isConvert(Function function) {
        Expression[] args = function.getArgs();
        String funcName = function.getName().toLowerCase();
        return args.length == 2 && (funcName.equalsIgnoreCase(CONVERT) || funcName.equalsIgnoreCase(CAST));
    }
}

