/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.function.metadata.FunctionCategoryConstants;
import org.teiid.query.function.metadata.FunctionMethod;
import org.teiid.query.function.metadata.FunctionParameter;
import org.teiid.query.function.source.SecuritySystemFunctions;
import org.teiid.query.function.source.XMLSystemFunctions;

public class SystemSource
implements FunctionMetadataSource,
FunctionCategoryConstants {
    private static final String FUNCTION_CLASS = FunctionMethods.class.getName();
    private static final String XML_FUNCTION_CLASS = XMLSystemFunctions.class.getName();
    private static final String SECURITY_FUNCTION_CLASS = SecuritySystemFunctions.class.getName();
    private List<FunctionMethod> functions = new ArrayList<FunctionMethod>();

    public SystemSource() {
        this.addArithmeticFunction("+", QueryPlugin.Util.getString("SystemSource.Add_desc"), "plus", QueryPlugin.Util.getString("SystemSource.Add_result_desc"));
        this.addArithmeticFunction("-", QueryPlugin.Util.getString("SystemSource.Subtract_desc"), "minus", QueryPlugin.Util.getString("SystemSource.Subtract_result_desc"));
        this.addArithmeticFunction("*", QueryPlugin.Util.getString("SystemSource.Multiply_desc"), "multiply", QueryPlugin.Util.getString("SystemSource.Multiply_result_desc"));
        this.addArithmeticFunction("/", QueryPlugin.Util.getString("SystemSource.Divide_desc"), "divide", QueryPlugin.Util.getString("SystemSource.Divide_result_desc"));
        this.addArithmeticFunction("mod", QueryPlugin.Util.getString("SystemSource.Mod_desc"), "mod", QueryPlugin.Util.getString("SystemSource.Mod_result_desc"));
        this.addAbsFunction();
        this.addRandFunction();
        this.addPowerFunction();
        this.addRoundFunction();
        this.addSignFunction();
        this.addSqrtFunction();
        this.addDoubleFunction("acos", QueryPlugin.Util.getString("SystemSource.Acos_desc"));
        this.addDoubleFunction("asin", QueryPlugin.Util.getString("SystemSource.Asin_desc"));
        this.addDoubleFunction("atan", QueryPlugin.Util.getString("SystemSource.Atan_desc"));
        this.addAtan2Function("atan2", QueryPlugin.Util.getString("SystemSource.Atan2_desc"));
        this.addDoubleFunction("cos", QueryPlugin.Util.getString("SystemSource.Cos_desc"));
        this.addDoubleFunction("cot", QueryPlugin.Util.getString("SystemSource.Cot_desc"));
        this.addDoubleFunction("degrees", QueryPlugin.Util.getString("SystemSource.Degrees_desc"));
        this.addPiFunction("pi", QueryPlugin.Util.getString("SystemSource.Pi_desc"));
        this.addDoubleFunction("radians", QueryPlugin.Util.getString("SystemSource.Radians_desc"));
        this.addDoubleFunction("sin", QueryPlugin.Util.getString("SystemSource.Sin_desc"));
        this.addDoubleFunction("tan", QueryPlugin.Util.getString("SystemSource.Tan_desc"));
        this.addDoubleFunction("log", QueryPlugin.Util.getString("SystemSource.Log_desc"));
        this.addDoubleFunction("log10", QueryPlugin.Util.getString("SystemSource.Log10_desc"));
        this.addDoubleFunction("ceiling", QueryPlugin.Util.getString("SystemSource.Ceiling_desc"));
        this.addDoubleFunction("exp", QueryPlugin.Util.getString("SystemSource.Exp_desc"));
        this.addDoubleFunction("floor", QueryPlugin.Util.getString("SystemSource.Floor_desc"));
        this.addBitFunction("bitand", QueryPlugin.Util.getString("SystemSource.Bitand_desc"), "bitand", 2, QueryPlugin.Util.getString("SystemSource.Bitand_result_desc"));
        this.addBitFunction("bitor", QueryPlugin.Util.getString("SystemSource.Bitor_desc"), "bitor", 2, QueryPlugin.Util.getString("SystemSource.Bitor_result_desc"));
        this.addBitFunction("bitxor", QueryPlugin.Util.getString("SystemSource.Bitxor_desc"), "bitxor", 2, QueryPlugin.Util.getString("SystemSource.Bitxor_result_desc"));
        this.addBitFunction("bitnot", QueryPlugin.Util.getString("SystemSource.Bitnot_desc"), "bitnot", 1, QueryPlugin.Util.getString("SystemSource.Bitnot_result_desc"));
        this.addConstantDateFunction("curdate", QueryPlugin.Util.getString("SystemSource.Curdate_desc"), "currentDate", "date");
        this.addConstantDateFunction("curtime", QueryPlugin.Util.getString("SystemSource.Curtime_desc"), "currentTime", "time");
        this.addConstantDateFunction("now", QueryPlugin.Util.getString("SystemSource.Now_desc"), "currentTimestamp", "timestamp");
        this.addDateFunction("dayname", "dayName", QueryPlugin.Util.getString("SystemSource.Dayname_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Dayname_result_ts_desc"), "string");
        this.addDateFunction("dayofmonth", "dayOfMonth", QueryPlugin.Util.getString("SystemSource.Dayofmonth_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Dayofmonth_result_ts_desc"), "integer");
        this.addDateFunction("dayofweek", "dayOfWeek", QueryPlugin.Util.getString("SystemSource.Dayofweek_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Dayofweek_result_ts_desc"), "integer");
        this.addDateFunction("dayofyear", "dayOfYear", QueryPlugin.Util.getString("SystemSource.Dayofyear_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Dayofyear_result_ts_desc"), "integer");
        this.addDateFunction("month", "month", QueryPlugin.Util.getString("SystemSource.Month_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Month_result_ts_desc"), "integer");
        this.addDateFunction("monthname", "monthName", QueryPlugin.Util.getString("SystemSource.Monthname_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Monthname_result_ts_desc"), "string");
        this.addDateFunction("week", "week", QueryPlugin.Util.getString("SystemSource.Week_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Week_result_ts_desc"), "integer");
        this.addDateFunction("year", "year", QueryPlugin.Util.getString("SystemSource.Year_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Year_result_ts_desc"), "integer");
        this.addTimeFunction("hour", "hour", QueryPlugin.Util.getString("SystemSource.Hour_result_t_desc"), QueryPlugin.Util.getString("SystemSource.Hour_result_ts_desc"), "integer");
        this.addTimeFunction("minute", "minute", QueryPlugin.Util.getString("SystemSource.Minute_result_t_desc"), QueryPlugin.Util.getString("SystemSource.Minute_result_ts_desc"), "integer");
        this.addTimeFunction("second", "second", QueryPlugin.Util.getString("SystemSource.Second_result_t_desc"), QueryPlugin.Util.getString("SystemSource.Second_result_ts_desc"), "integer");
        this.addQuarterFunction("quarter", "quarter", QueryPlugin.Util.getString("SystemSource.Quarter_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Quarter_result_ts_desc"), "integer");
        this.addTimestampAddFunction();
        this.addTimestampDiffFunction();
        this.addTimeZoneFunctions();
        this.addTimestampCreateFunction();
        this.addUnixTimeFunctions();
        this.addStringFunction("length", QueryPlugin.Util.getString("SystemSource.Length_result"), "length", "integer");
        this.addStringFunction("ucase", QueryPlugin.Util.getString("SystemSource.Ucase_result"), "upperCase", "string");
        this.addStringFunction("lcase", QueryPlugin.Util.getString("SystemSource.Lcase_result"), "lowerCase", "string");
        this.addStringFunction("lower", QueryPlugin.Util.getString("SystemSource.Lower_result"), "lowerCase", "string");
        this.addStringFunction("upper", QueryPlugin.Util.getString("SystemSource.Upper_result"), "upperCase", "string");
        this.addStringFunction("ltrim", QueryPlugin.Util.getString("SystemSource.Left_result"), "leftTrim", "string");
        this.addStringFunction("rtrim", QueryPlugin.Util.getString("SystemSource.Right_result"), "rightTrim", "string");
        this.addConcatFunction();
        this.addSubstringFunction();
        this.addLeftRightFunctions();
        this.addLocateFunction();
        this.addReplaceFunction();
        this.addAsciiFunction();
        this.addCharFunction();
        this.addInitCapFunction();
        this.addLpadFunction();
        this.addRpadFunction();
        this.addTranslateFunction();
        this.addRepeatFunction();
        this.addSpaceFunction();
        this.addInsertFunction();
        this.addClobFunction("ucase", QueryPlugin.Util.getString("SystemSource.UcaseClob_result"), "upperCase", "clob");
        this.addClobFunction("lcase", QueryPlugin.Util.getString("SystemSource.LcaseClob_result"), "lowerCase", "clob");
        this.addClobFunction("lower", QueryPlugin.Util.getString("SystemSource.LowerClob_result"), "lowerCase", "clob");
        this.addClobFunction("upper", QueryPlugin.Util.getString("SystemSource.UpperClob_result"), "upperCase", "clob");
        this.addToCharsFunction();
        this.addToBytesFunction();
        this.addConversionFunctions();
        this.addContextFunctions();
        this.addRowLimitFunctions();
        this.addRowLimitExceptionFunctions();
        this.addDecodeFunctions();
        this.addLookupFunctions();
        this.addUserFunction();
        this.addCurrentDatabaseFunction();
        this.addEnvFunction();
        this.addCommandPayloadFunctions();
        this.addIfNullFunctions();
        this.addFormatTimestampFunction();
        this.addFormatNumberFunctions();
        this.addParseTimestampFunction();
        this.addParseNumberFunctions();
        this.addXpathValueFunction();
        this.addXslTransformFunction();
        this.addXmlConcat();
        this.addXmlComment();
        this.addXmlPi();
        this.addSecurityFunctions();
        for (String type : DataTypeManager.getAllDataTypeNames()) {
            if (!DataTypeManager.isNonComparable((String)type)) {
                this.addTypedNullIfFunction(type);
            }
            this.addTypedCoalesceFunction(type);
        }
    }

    private void addSecurityFunctions() {
        this.functions.add(new FunctionMethod("hasRole", QueryPlugin.Util.getString("SystemSource.hasRole_description"), "Security", 1, SECURITY_FUNCTION_CLASS, "hasRole", new FunctionParameter[]{new FunctionParameter("roleType", "string", QueryPlugin.Util.getString("SystemSource.hasRole_param1")), new FunctionParameter("roleName", "string", QueryPlugin.Util.getString("SystemSource.hasRole_param2"))}, new FunctionParameter("result", "boolean", QueryPlugin.Util.getString("SystemSource.hasRole_result")), false, 2));
        this.functions.add(new FunctionMethod("hasRole", QueryPlugin.Util.getString("SystemSource.hasRole_description"), "Security", 1, SECURITY_FUNCTION_CLASS, "hasRole", new FunctionParameter[]{new FunctionParameter("roleName", "string", QueryPlugin.Util.getString("SystemSource.hasRole_param2"))}, new FunctionParameter("result", "boolean", QueryPlugin.Util.getString("SystemSource.hasRole_result")), false, 2));
    }

    private void addFormatNumberFunctions() {
        this.addFormatNumberFunction("formatinteger", QueryPlugin.Util.getString("SystemSource.Formatinteger_desc"), "format", "integer", "integer", QueryPlugin.Util.getString("SystemSource.Formatinteger_result_desc"));
        this.addFormatNumberFunction("formatlong", QueryPlugin.Util.getString("SystemSource.Formatlong_desc"), "format", "long", "long", QueryPlugin.Util.getString("SystemSource.Formatlong_result_desc"));
        this.addFormatNumberFunction("formatdouble", QueryPlugin.Util.getString("SystemSource.Formatdouble_desc"), "format", "double", "double", QueryPlugin.Util.getString("SystemSource.Formatdouble_result_desc"));
        this.addFormatNumberFunction("formatfloat", QueryPlugin.Util.getString("SystemSource.Formatfloat_desc"), "format", "float", "float", QueryPlugin.Util.getString("SystemSource.Formatfloat_result_desc"));
        this.addFormatNumberFunction("formatbiginteger", QueryPlugin.Util.getString("SystemSource.Formatbiginteger_desc"), "format", "biginteger", "biginteger", QueryPlugin.Util.getString("SystemSource.Formatbiginteger_result_desc"));
        this.addFormatNumberFunction("formatbigdecimal", QueryPlugin.Util.getString("SystemSource.Formatbigdecimal_desc"), "format", "bigdecimal", "bigdecimal", QueryPlugin.Util.getString("SystemSource.Formatbigdecimal_result_desc"));
    }

    private void addParseNumberFunctions() {
        this.addParseNumberFunction("parseinteger", QueryPlugin.Util.getString("SystemSource.Parseinteger_desc"), "parseInteger", "integer", "integer", QueryPlugin.Util.getString("SystemSource.Parseinteger_result_desc"));
        this.addParseNumberFunction("parselong", QueryPlugin.Util.getString("SystemSource.Parselong_desc"), "parseLong", "long", "long", QueryPlugin.Util.getString("SystemSource.Parselong_result_desc"));
        this.addParseNumberFunction("parsedouble", QueryPlugin.Util.getString("SystemSource.Parsedouble_desc"), "parseDouble", "double", "double", QueryPlugin.Util.getString("SystemSource.Parsedouble_result_desc"));
        this.addParseNumberFunction("parsefloat", QueryPlugin.Util.getString("SystemSource.Parsefloat_desc"), "parseFloat", "float", "float", QueryPlugin.Util.getString("SystemSource.Parsefloat_result_desc"));
        this.addParseNumberFunction("parsebiginteger", QueryPlugin.Util.getString("SystemSource.Parsebiginteger_desc"), "parseBigInteger", "biginteger", "biginteger", QueryPlugin.Util.getString("SystemSource.Parsebiginteger_result_desc"));
        this.addParseNumberFunction("parsebigdecimal", QueryPlugin.Util.getString("SystemSource.Parsebigdecimal_desc"), "parseBigDecimal", "bigdecimal", "bigdecimal", QueryPlugin.Util.getString("SystemSource.Parsebigdecimal_result_desc"));
    }

    private void addArithmeticFunction(String functionName, String description, String methodName, String resultsDescription) {
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, "integer");
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, "long");
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, "float");
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, "double");
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, "biginteger");
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, "bigdecimal");
    }

    private void addTypedArithmeticFunction(String functionName, String description, String methodName, String resultsDescription, String type) {
        this.functions.add(new FunctionMethod(functionName, description, "Numeric", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("op1", type, QueryPlugin.Util.getString("SystemSource.Arith_left_op")), new FunctionParameter("op2", type, QueryPlugin.Util.getString("SystemSource.Arith_right_op"))}, new FunctionParameter("result", type, resultsDescription)));
    }

    private void addAbsFunction() {
        this.addTypedAbsFunction("integer");
        this.addTypedAbsFunction("long");
        this.addTypedAbsFunction("float");
        this.addTypedAbsFunction("double");
        this.addTypedAbsFunction("biginteger");
        this.addTypedAbsFunction("bigdecimal");
    }

    private void addTypedAbsFunction(String type) {
        this.functions.add(new FunctionMethod("abs", QueryPlugin.Util.getString("SystemSource.Abs_desc"), "Numeric", FUNCTION_CLASS, "abs", new FunctionParameter[]{new FunctionParameter("number", type, QueryPlugin.Util.getString("SystemSource.Abs_arg"))}, new FunctionParameter("result", type, QueryPlugin.Util.getString("SystemSource.Abs_result_desc"))));
    }

    private void addRandFunction() {
        FunctionMethod rand = new FunctionMethod("rand", QueryPlugin.Util.getString("SystemSource.Rand_desc"), "Numeric", FUNCTION_CLASS, "rand", new FunctionParameter[]{new FunctionParameter("seed", "integer", QueryPlugin.Util.getString("SystemSource.Rand_arg"))}, new FunctionParameter("result", "double", QueryPlugin.Util.getString("SystemSource.Rand_result_desc")), 5);
        rand.setNullDependent(true);
        this.functions.add(rand);
        this.functions.add(new FunctionMethod("rand", QueryPlugin.Util.getString("SystemSource.Rand_desc"), "Numeric", FUNCTION_CLASS, "rand", new FunctionParameter[0], new FunctionParameter("result", "double", QueryPlugin.Util.getString("SystemSource.Rand_result_desc")), 5));
    }

    private void addDoubleFunction(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter("number", "double", QueryPlugin.Util.getString("SystemSource.Double_arg2"))}, new FunctionParameter("result", "double", description)));
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter("number", "bigdecimal", QueryPlugin.Util.getString("SystemSource.Double_arg2"))}, new FunctionParameter("result", "double", description)));
    }

    private void addAtan2Function(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter("number1", "double", QueryPlugin.Util.getString("SystemSource.Atan_arg1")), new FunctionParameter("number2", "double", QueryPlugin.Util.getString("SystemSource.Atan_arg2"))}, new FunctionParameter("result", "double", description)));
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter("number1", "bigdecimal", QueryPlugin.Util.getString("SystemSource.Atan_arg1")), new FunctionParameter("number2", "bigdecimal", QueryPlugin.Util.getString("SystemSource.Atan_arg2"))}, new FunctionParameter("result", "double", description)));
    }

    private void addPiFunction(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[0], new FunctionParameter("result", "double", description)));
    }

    private void addPowerFunction() {
        this.addTypedPowerFunction("double", "double");
        this.addTypedPowerFunction("biginteger", "integer");
        this.addTypedPowerFunction("bigdecimal", "integer");
    }

    private void addTypedPowerFunction(String baseType, String powerType) {
        this.functions.add(new FunctionMethod("power", QueryPlugin.Util.getString("SystemSource.Power_desc"), "Numeric", FUNCTION_CLASS, "power", new FunctionParameter[]{new FunctionParameter("base", baseType, QueryPlugin.Util.getString("SystemSource.Power_arg1")), new FunctionParameter("power", powerType, QueryPlugin.Util.getString("SystemSource.Power_arg2"))}, new FunctionParameter("result", baseType, QueryPlugin.Util.getString("SystemSource.Power_result_desc"))));
    }

    private void addRoundFunction() {
        this.addTypedRoundFunction("integer");
        this.addTypedRoundFunction("float");
        this.addTypedRoundFunction("double");
        this.addTypedRoundFunction("bigdecimal");
    }

    private void addTypedRoundFunction(String roundType) {
        this.functions.add(new FunctionMethod("round", QueryPlugin.Util.getString("SystemSource.Round_desc"), "Numeric", FUNCTION_CLASS, "round", new FunctionParameter[]{new FunctionParameter("number", roundType, QueryPlugin.Util.getString("SystemSource.Round_arg1")), new FunctionParameter("places", "integer", QueryPlugin.Util.getString("SystemSource.Round_arg2"))}, new FunctionParameter("result", roundType, QueryPlugin.Util.getString("SystemSource.Round_result_desc"))));
    }

    private void addSignFunction() {
        this.addTypedSignFunction("integer");
        this.addTypedSignFunction("long");
        this.addTypedSignFunction("float");
        this.addTypedSignFunction("double");
        this.addTypedSignFunction("biginteger");
        this.addTypedSignFunction("bigdecimal");
    }

    private void addTypedSignFunction(String type) {
        this.functions.add(new FunctionMethod("sign", QueryPlugin.Util.getString("SystemSource.Sign_desc"), "Numeric", FUNCTION_CLASS, "sign", new FunctionParameter[]{new FunctionParameter("number", type, QueryPlugin.Util.getString("SystemSource.Sign_arg1"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Sign_result_desc"))));
    }

    private void addSqrtFunction() {
        this.addTypedSqrtFunction("long");
        this.addTypedSqrtFunction("double");
        this.addTypedSqrtFunction("bigdecimal");
    }

    private void addTypedSqrtFunction(String type) {
        this.functions.add(new FunctionMethod("sqrt", QueryPlugin.Util.getString("SystemSource.Sqrt_desc"), "Numeric", FUNCTION_CLASS, "sqrt", new FunctionParameter[]{new FunctionParameter("number", type, QueryPlugin.Util.getString("SystemSource.Sqrt_arg1"))}, new FunctionParameter("result", "double", QueryPlugin.Util.getString("SystemSource.Sqrt_result_desc"))));
    }

    private void addConstantDateFunction(String name, String description, String methodName, String returnType) {
        this.functions.add(new FunctionMethod(name, description, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[0], new FunctionParameter("result", returnType, description), 4));
    }

    private void addDateFunction(String name, String methodName, String dateDesc, String timestampDesc, String returnType) {
        this.functions.add(new FunctionMethod(name, dateDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("date", "date", dateDesc)}, new FunctionParameter("result", returnType, dateDesc)));
        this.functions.add(new FunctionMethod(name, timestampDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("timestamp", "timestamp", timestampDesc)}, new FunctionParameter("result", returnType, timestampDesc)));
    }

    private void addQuarterFunction(String name, String methodName, String dateDesc, String timestampDesc, String returnType) {
        this.functions.add(new FunctionMethod(name, dateDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("date", "date", dateDesc)}, new FunctionParameter("result", returnType, dateDesc)));
        this.functions.add(new FunctionMethod(name, timestampDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("timestamp", "timestamp", timestampDesc)}, new FunctionParameter("result", returnType, timestampDesc)));
    }

    private void addTimestampAddFunction() {
        this.functions.add(new FunctionMethod("timestampadd", QueryPlugin.Util.getString("SystemSource.Timestampadd_d_desc"), "Datetime", 3, null, null, new FunctionParameter[]{new FunctionParameter("interval", "string", QueryPlugin.Util.getString("SystemSource.Timestampadd_d_arg1")), new FunctionParameter("count", "integer", QueryPlugin.Util.getString("SystemSource.Timestampadd_d_arg2")), new FunctionParameter("timestamp", "date", QueryPlugin.Util.getString("SystemSource.Timestampadd_d_arg3"))}, new FunctionParameter("result", "date", QueryPlugin.Util.getString("SystemSource.Timestampadd_d_result_desc"))));
        this.functions.add(new FunctionMethod("timestampadd", QueryPlugin.Util.getString("SystemSource.Timestampadd_t_desc"), "Datetime", 3, null, null, new FunctionParameter[]{new FunctionParameter("interval", "string", QueryPlugin.Util.getString("SystemSource.Timestampadd_t_arg1")), new FunctionParameter("count", "integer", QueryPlugin.Util.getString("SystemSource.Timestampadd_t_arg2")), new FunctionParameter("timestamp", "time", QueryPlugin.Util.getString("SystemSource.Timestampadd_t_arg3"))}, new FunctionParameter("result", "time", QueryPlugin.Util.getString("SystemSource.Timestampadd_t_result_desc"))));
        this.functions.add(new FunctionMethod("timestampadd", QueryPlugin.Util.getString("SystemSource.Timestampadd_ts_desc"), "Datetime", FUNCTION_CLASS, "timestampAdd", new FunctionParameter[]{new FunctionParameter("interval", "string", QueryPlugin.Util.getString("SystemSource.Timestampadd_ts_arg1")), new FunctionParameter("count", "integer", QueryPlugin.Util.getString("SystemSource.Timestampadd_ts_arg2")), new FunctionParameter("timestamp", "timestamp", QueryPlugin.Util.getString("SystemSource.Timestampadd_ts_arg3"))}, new FunctionParameter("result", "timestamp", QueryPlugin.Util.getString("SystemSource.Timestampadd_ts_result"))));
    }

    private void addTimestampDiffFunction() {
        this.functions.add(new FunctionMethod("timestampdiff", QueryPlugin.Util.getString("SystemSource.Timestampdiff_ts_desc"), "Datetime", FUNCTION_CLASS, "timestampDiff", new FunctionParameter[]{new FunctionParameter("interval", "string", QueryPlugin.Util.getString("SystemSource.Timestampdiff_ts_arg1")), new FunctionParameter("timestamp1", "timestamp", QueryPlugin.Util.getString("SystemSource.Timestampdiff_ts_arg2")), new FunctionParameter("timestamp2", "timestamp", QueryPlugin.Util.getString("SystemSource.Timestampdiff_ts_arg3"))}, new FunctionParameter("result", "long", QueryPlugin.Util.getString("SystemSource.Timestampdiff_ts_result_desc"))));
    }

    private void addTimestampCreateFunction() {
        this.functions.add(new FunctionMethod("timestampcreate", QueryPlugin.Util.getString("SystemSource.TimestampCreate_desc"), "Datetime", FUNCTION_CLASS, "timestampCreate", new FunctionParameter[]{new FunctionParameter("date", "date", QueryPlugin.Util.getString("SystemSource.TimestampCreate_arg1")), new FunctionParameter("time", "time", QueryPlugin.Util.getString("SystemSource.TimestampCreate_arg2"))}, new FunctionParameter("result", "timestamp", QueryPlugin.Util.getString("SystemSource.TimestampCreate_result_desc"))));
    }

    private void addTimeFunction(String name, String methodName, String timeDesc, String timestampDesc, String returnType) {
        this.functions.add(new FunctionMethod(name, timeDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("time", "time", timeDesc)}, new FunctionParameter("result", returnType, timeDesc)));
        this.functions.add(new FunctionMethod(name, timestampDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("timestamp", "timestamp", timestampDesc)}, new FunctionParameter("result", returnType, timestampDesc)));
    }

    private void addStringFunction(String name, String description, String methodName, String returnType) {
        this.functions.add(new FunctionMethod(name, description, "String", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Stringfunc_arg1"))}, new FunctionParameter("result", returnType, description)));
    }

    private void addClobFunction(String name, String description, String methodName, String returnType) {
        this.functions.add(new FunctionMethod(name, description, "String", 2, FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("clob", "clob", QueryPlugin.Util.getString("SystemSource.Clobfunc_arg1"))}, new FunctionParameter("result", returnType, description), false, 0));
    }

    private void addConcatFunction() {
        this.functions.add(new FunctionMethod("concat", QueryPlugin.Util.getString("SystemSource.Concat_desc"), "String", FUNCTION_CLASS, "concat", new FunctionParameter[]{new FunctionParameter("string1", "string", QueryPlugin.Util.getString("SystemSource.Concat_arg1")), new FunctionParameter("string2", "string", QueryPlugin.Util.getString("SystemSource.Concat_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Concat_result_desc"))));
        this.functions.add(new FunctionMethod("||", QueryPlugin.Util.getString("SystemSource.Concatop_desc"), "String", FUNCTION_CLASS, "concat", new FunctionParameter[]{new FunctionParameter("string1", "string", QueryPlugin.Util.getString("SystemSource.Concatop_arg1")), new FunctionParameter("string2", "string", QueryPlugin.Util.getString("SystemSource.Concatop_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Concatop_result_desc"))));
        FunctionMethod concat2 = new FunctionMethod("concat2", QueryPlugin.Util.getString("SystemSource.Concat_desc"), "String", 3, null, null, new FunctionParameter[]{new FunctionParameter("string1", "string", QueryPlugin.Util.getString("SystemSource.Concat_arg1")), new FunctionParameter("string2", "string", QueryPlugin.Util.getString("SystemSource.Concat_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Concat_result_desc")), true, 0);
        this.functions.add(concat2);
    }

    private void addSubstringFunction() {
        this.functions.add(new FunctionMethod("substring", QueryPlugin.Util.getString("SystemSource.Substring_desc"), "String", FUNCTION_CLASS, "substring", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Substring_arg1")), new FunctionParameter("index", "integer", QueryPlugin.Util.getString("SystemSource.Substring_arg2")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Substring_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Substring_result"))));
        this.functions.add(new FunctionMethod("substring", QueryPlugin.Util.getString("SystemSource.Susbstring2_desc"), "String", FUNCTION_CLASS, "substring", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Substring2_arg1")), new FunctionParameter("index", "integer", QueryPlugin.Util.getString("SystemSource.Substring2_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Substring2_result"))));
    }

    private void addLeftRightFunctions() {
        this.functions.add(new FunctionMethod("left", QueryPlugin.Util.getString("SystemSource.Left_desc"), "String", FUNCTION_CLASS, "left", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Left_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Left_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Left2_result"))));
        this.functions.add(new FunctionMethod("right", QueryPlugin.Util.getString("SystemSource.Right_desc"), "String", FUNCTION_CLASS, "right", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Right_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Right_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Right2_result"))));
    }

    private void addLocateFunction() {
        FunctionMethod func = new FunctionMethod("locate", QueryPlugin.Util.getString("SystemSource.Locate_desc"), "String", FUNCTION_CLASS, "locate", new FunctionParameter[]{new FunctionParameter("substring", "string", QueryPlugin.Util.getString("SystemSource.Locate_arg1")), new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Locate_arg2")), new FunctionParameter("index", "integer", QueryPlugin.Util.getString("SystemSource.Locate_arg3"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Locate_result")));
        func.setNullDependent(true);
        this.functions.add(func);
        this.functions.add(new FunctionMethod("locate", QueryPlugin.Util.getString("SystemSource.Locate2_desc"), "String", FUNCTION_CLASS, "locate", new FunctionParameter[]{new FunctionParameter("substring", "string", QueryPlugin.Util.getString("SystemSource.Locate2_arg1")), new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Locate2_arg2"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Locate2_result"))));
    }

    private void addReplaceFunction() {
        this.functions.add(new FunctionMethod("replace", QueryPlugin.Util.getString("SystemSource.Replace_desc"), "String", FUNCTION_CLASS, "replace", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Replace_arg1")), new FunctionParameter("substring", "string", QueryPlugin.Util.getString("SystemSource.Replace_arg2")), new FunctionParameter("replacement", "string", QueryPlugin.Util.getString("SystemSource.Replace_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Replace_result"))));
    }

    private void addRepeatFunction() {
        this.functions.add(new FunctionMethod("repeat", QueryPlugin.Util.getString("SystemSource.Repeat_desc"), "String", FUNCTION_CLASS, "repeat", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Repeat_arg1")), new FunctionParameter("count", "integer", QueryPlugin.Util.getString("SystemSource.Repeat_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Repeat_result"))));
    }

    private void addSpaceFunction() {
        this.functions.add(new FunctionMethod("space", QueryPlugin.Util.getString("SystemSource.Space_desc"), "String", 3, null, null, new FunctionParameter[]{new FunctionParameter("count", "integer", QueryPlugin.Util.getString("SystemSource.Space_arg1"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Space_result"))));
    }

    private void addInsertFunction() {
        this.functions.add(new FunctionMethod("insert", QueryPlugin.Util.getString("SystemSource.Insert_desc"), "String", FUNCTION_CLASS, "insert", new FunctionParameter[]{new FunctionParameter("str1", "string", QueryPlugin.Util.getString("SystemSource.Insert_arg1")), new FunctionParameter("start", "integer", QueryPlugin.Util.getString("SystemSource.Insert_arg2")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Insert_arg3")), new FunctionParameter("str2", "string", QueryPlugin.Util.getString("SystemSource.Insert_arg4"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Insert_result"))));
    }

    private void addToCharsFunction() {
        this.functions.add(new FunctionMethod("to_chars", QueryPlugin.Util.getString("SystemSource.encode_desc"), "Conversion", FUNCTION_CLASS, "toChars", new FunctionParameter[]{new FunctionParameter("value", "blob", QueryPlugin.Util.getString("SystemSource.encode_arg1")), new FunctionParameter("encoding", "string", QueryPlugin.Util.getString("SystemSource.encode_arg2"))}, new FunctionParameter("result", "clob", QueryPlugin.Util.getString("SystemSource.encode_result"))));
    }

    private void addToBytesFunction() {
        this.functions.add(new FunctionMethod("to_bytes", QueryPlugin.Util.getString("SystemSource.decode_desc"), "Conversion", FUNCTION_CLASS, "toBytes", new FunctionParameter[]{new FunctionParameter("value", "clob", QueryPlugin.Util.getString("SystemSource.decode_arg1")), new FunctionParameter("encoding", "string", QueryPlugin.Util.getString("SystemSource.decode_arg2"))}, new FunctionParameter("result", "blob", QueryPlugin.Util.getString("SystemSource.decode_result"))));
    }

    private void addAsciiFunction() {
        this.functions.add(new FunctionMethod("ascii", QueryPlugin.Util.getString("SystemSource.Ascii_desc"), "String", FUNCTION_CLASS, "ascii", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Ascii_arg1"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Ascii_result"))));
        this.functions.add(new FunctionMethod("ascii", QueryPlugin.Util.getString("SystemSource.Ascii2_desc"), "String", FUNCTION_CLASS, "ascii", new FunctionParameter[]{new FunctionParameter("char", "char", QueryPlugin.Util.getString("SystemSource.Ascii2_arg1"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Ascii2_result"))));
    }

    private void addCharFunction() {
        this.functions.add(new FunctionMethod("char", QueryPlugin.Util.getString("SystemSource.Char_desc"), "String", FUNCTION_CLASS, "chr", new FunctionParameter[]{new FunctionParameter("code", "integer", QueryPlugin.Util.getString("SystemSource.Char_arg1"))}, new FunctionParameter("result", "char", QueryPlugin.Util.getString("SystemSource.Char_result"))));
        this.functions.add(new FunctionMethod("chr", QueryPlugin.Util.getString("SystemSource.Chr_desc"), "String", FUNCTION_CLASS, "chr", new FunctionParameter[]{new FunctionParameter("code", "integer", QueryPlugin.Util.getString("SystemSource.Chr_arg1"))}, new FunctionParameter("result", "char", QueryPlugin.Util.getString("SystemSource.Chr_result"))));
    }

    private void addInitCapFunction() {
        this.functions.add(new FunctionMethod("initcap", QueryPlugin.Util.getString("SystemSource.Initcap_desc"), "String", FUNCTION_CLASS, "initCap", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Initcap_arg1"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Initcap_result"))));
    }

    private void addLpadFunction() {
        this.functions.add(new FunctionMethod("lpad", QueryPlugin.Util.getString("SystemSource.Lpad_desc"), "String", FUNCTION_CLASS, "lpad", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Lpad_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Lpad_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Lpad_result"))));
        this.functions.add(new FunctionMethod("lpad", QueryPlugin.Util.getString("SystemSource.Lpad3_desc"), "String", FUNCTION_CLASS, "lpad", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Lpad3_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Lpad3_arg2")), new FunctionParameter("char", "string", QueryPlugin.Util.getString("SystemSource.Lpad3_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Lpad3_result"))));
    }

    private void addRpadFunction() {
        this.functions.add(new FunctionMethod("rpad", QueryPlugin.Util.getString("SystemSource.Rpad1_desc"), "String", FUNCTION_CLASS, "rpad", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Rpad1_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Rpad1_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Rpad1_result"))));
        this.functions.add(new FunctionMethod("rpad", QueryPlugin.Util.getString("SystemSource.Rpad3_desc"), "String", FUNCTION_CLASS, "rpad", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Rpad3_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Rpad3_arg2")), new FunctionParameter("char", "string", QueryPlugin.Util.getString("SystemSource.Rpad3_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Rpad3_result"))));
    }

    private void addTranslateFunction() {
        this.functions.add(new FunctionMethod("translate", QueryPlugin.Util.getString("SystemSource.Translate_desc"), "String", FUNCTION_CLASS, "translate", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Translate_arg1")), new FunctionParameter("source", "string", QueryPlugin.Util.getString("SystemSource.Translate_arg2")), new FunctionParameter("destination", "string", QueryPlugin.Util.getString("SystemSource.Translate_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Translate_result"))));
    }

    private void addConversionFunctions() {
        for (String type : DataTypeManager.getAllDataTypeNames()) {
            this.addTypedConversionFunction("convert", type);
            this.addTypedConversionFunction("cast", type);
        }
    }

    private void addTypedConversionFunction(String name, String sourceType) {
        this.functions.add(new FunctionMethod(name, QueryPlugin.Util.getString("SystemSource.Convert_desc", new Object[]{sourceType}), "Conversion", FUNCTION_CLASS, "convert", new FunctionParameter[]{new FunctionParameter("value", sourceType, QueryPlugin.Util.getString("SystemSource.Convert_arg1")), new FunctionParameter("target", "string", QueryPlugin.Util.getString("SystemSource.Convert_arg2"))}, new FunctionParameter("result", "object", QueryPlugin.Util.getString("SystemSource.Convert_result"))));
    }

    private void addContextFunctions() {
        for (String contextType : DataTypeManager.getAllDataTypeNames()) {
            for (String exprType : DataTypeManager.getAllDataTypeNames()) {
                this.addTypedContextFunction(contextType, exprType);
            }
        }
    }

    private void addTypedContextFunction(String contextType, String exprType) {
        this.functions.add(new FunctionMethod("context", QueryPlugin.Util.getString("SystemSource.Context_desc"), "Miscellaneous", FUNCTION_CLASS, "context", new FunctionParameter[]{new FunctionParameter("context", contextType, QueryPlugin.Util.getString("SystemSource.Context_arg1")), new FunctionParameter("element", exprType, QueryPlugin.Util.getString("SystemSource.Context_arg2"))}, new FunctionParameter("result", exprType, QueryPlugin.Util.getString("SystemSource.Context_result"))));
    }

    private void addRowLimitFunctions() {
        for (String exprType : DataTypeManager.getAllDataTypeNames()) {
            this.functions.add(new FunctionMethod("rowlimit", QueryPlugin.Util.getString("SystemSource.Rowlimit_desc"), "Miscellaneous", FUNCTION_CLASS, "rowlimit", new FunctionParameter[]{new FunctionParameter("element", exprType, QueryPlugin.Util.getString("SystemSource.Rowlimit_arg1"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Rowlimit_result"))));
        }
    }

    private void addRowLimitExceptionFunctions() {
        for (String exprType : DataTypeManager.getAllDataTypeNames()) {
            this.functions.add(new FunctionMethod("rowlimitexception", QueryPlugin.Util.getString("SystemSource.RowlimitException_desc"), "Miscellaneous", FUNCTION_CLASS, "rowlimitexception", new FunctionParameter[]{new FunctionParameter("element", exprType, QueryPlugin.Util.getString("SystemSource.Rowlimit_arg1"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Rowlimit_result"))));
        }
    }

    private void addDecodeFunctions() {
        this.addDecodeFunction("decodeInteger", "integer");
        this.addDecodeFunction("decodeString", "string");
    }

    private void addDecodeFunction(String functionName, String resultType) {
        this.functions.add(new FunctionMethod(functionName, QueryPlugin.Util.getString("SystemSource.Decode1_desc"), "Miscellaneous", 3, null, null, new FunctionParameter[]{new FunctionParameter("input", "string", QueryPlugin.Util.getString("SystemSource.Decode1_arg1")), new FunctionParameter("decodeString", "string", QueryPlugin.Util.getString("SystemSource.Decode1_arg2"))}, new FunctionParameter("result", resultType, QueryPlugin.Util.getString("SystemSource.Decode1_result"))));
        this.functions.add(new FunctionMethod(functionName, QueryPlugin.Util.getString("SystemSource.Decode2_desc"), "Miscellaneous", 3, null, null, new FunctionParameter[]{new FunctionParameter("input", "string", QueryPlugin.Util.getString("SystemSource.Decode2_arg1")), new FunctionParameter("decodeString", "string", QueryPlugin.Util.getString("SystemSource.Decode2_arg2")), new FunctionParameter("delimiter", "string", QueryPlugin.Util.getString("SystemSource.Decode2_arg3"))}, new FunctionParameter("result", resultType, QueryPlugin.Util.getString("SystemSource.Decode2_result"))));
    }

    private void addLookupFunctions() {
        for (String keyValueType : DataTypeManager.getAllDataTypeNames()) {
            this.functions.add(new FunctionMethod("lookup", QueryPlugin.Util.getString("SystemSource.Lookup_desc"), "Miscellaneous", 1, FUNCTION_CLASS, "lookup", new FunctionParameter[]{new FunctionParameter("codetable", "string", QueryPlugin.Util.getString("SystemSource.Lookup_arg1")), new FunctionParameter("returnelement", "string", QueryPlugin.Util.getString("SystemSource.Lookup_arg2")), new FunctionParameter("keyelement", "string", QueryPlugin.Util.getString("SystemSource.Lookup_arg3")), new FunctionParameter("keyvalue", keyValueType, QueryPlugin.Util.getString("SystemSource.Lookup_arg4"))}, new FunctionParameter("result", "object", QueryPlugin.Util.getString("SystemSource.Lookup_result")), true, 1));
        }
    }

    private void addUserFunction() {
        this.functions.add(new FunctionMethod("user", QueryPlugin.Util.getString("SystemSource.User_desc"), "Miscellaneous", 1, FUNCTION_CLASS, "user", null, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.User_result")), false, 2));
    }

    private void addCurrentDatabaseFunction() {
        this.functions.add(new FunctionMethod("current_database", QueryPlugin.Util.getString("SystemSource.current_database_desc"), "Miscellaneous", 1, FUNCTION_CLASS, "current_database", null, new FunctionParameter("result", "string", QueryPlugin.Util.getString("current_database_result")), false, 1));
    }

    private void addEnvFunction() {
        this.functions.add(new FunctionMethod("env", QueryPlugin.Util.getString("SystemSource.Env_desc"), "Miscellaneous", 1, FUNCTION_CLASS, "env", new FunctionParameter[]{new FunctionParameter("variablename", "string", QueryPlugin.Util.getString("SystemSource.Env_varname"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Env_result")), false, 3));
    }

    private void addCommandPayloadFunctions() {
        this.functions.add(new FunctionMethod("commandpayload", QueryPlugin.Util.getString("SystemSource.CommandPayload_desc0"), "Miscellaneous", 1, FUNCTION_CLASS, "commandPayload", new FunctionParameter[0], new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.CommandPayload_result")), false, 4));
        this.functions.add(new FunctionMethod("commandpayload", QueryPlugin.Util.getString("SystemSource.CommandPayload_desc1"), "Miscellaneous", 1, FUNCTION_CLASS, "commandPayload", new FunctionParameter[]{new FunctionParameter("property", "string", QueryPlugin.Util.getString("SystemSource.CommandPayload_property"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.CommandPayload_result")), false, 4));
    }

    private void addIfNullFunctions() {
        for (String type : DataTypeManager.getAllDataTypeNames()) {
            this.addNvlFunction(type);
            this.addIfNullFunction(type);
        }
    }

    private void addNvlFunction(String valueType) {
        FunctionMethod nvl = new FunctionMethod("nvl", QueryPlugin.Util.getString("SystemSource.Nvl_desc"), "Miscellaneous", FUNCTION_CLASS, "ifnull", new FunctionParameter[]{new FunctionParameter("value", valueType, QueryPlugin.Util.getString("SystemSource.Nvl_arg1")), new FunctionParameter("valueIfNull", valueType, QueryPlugin.Util.getString("SystemSource.Nvl_arg2"))}, new FunctionParameter("result", valueType, QueryPlugin.Util.getString("SystemSource.Nvl_result")));
        nvl.setNullDependent(true);
        this.functions.add(nvl);
    }

    private void addIfNullFunction(String valueType) {
        FunctionMethod nvl = new FunctionMethod("ifnull", QueryPlugin.Util.getString("SystemSource.Ifnull_desc"), "Miscellaneous", FUNCTION_CLASS, "ifnull", new FunctionParameter[]{new FunctionParameter("value", valueType, QueryPlugin.Util.getString("SystemSource.Ifnull_arg1")), new FunctionParameter("valueIfNull", valueType, QueryPlugin.Util.getString("SystemSource.Ifnull_arg2"))}, new FunctionParameter("result", valueType, QueryPlugin.Util.getString("SystemSource.Ifnull_result")));
        nvl.setNullDependent(true);
        this.functions.add(nvl);
    }

    private void addFormatTimestampFunction() {
        this.functions.add(new FunctionMethod("formattimestamp", QueryPlugin.Util.getString("SystemSource.Formattimestamp_desc"), "Conversion", FUNCTION_CLASS, "format", new FunctionParameter[]{new FunctionParameter("timestamp", "timestamp", QueryPlugin.Util.getString("SystemSource.Formattimestamp_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Formattimestamp_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Formattimestamp_result_desc"))));
        this.functions.add(new FunctionMethod("formatdate", QueryPlugin.Util.getString("SystemSource.Formatdate_desc"), "Conversion", 3, null, null, new FunctionParameter[]{new FunctionParameter("date", "date", QueryPlugin.Util.getString("SystemSource.Formatdate_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Formatdate_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Formatdate_result_desc"))));
        this.functions.add(new FunctionMethod("formattime", QueryPlugin.Util.getString("SystemSource.Formattime_desc"), "Conversion", 3, null, null, new FunctionParameter[]{new FunctionParameter("time", "time", QueryPlugin.Util.getString("SystemSource.Formattime_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Formattime_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Formattime_result_desc"))));
    }

    private void addParseTimestampFunction() {
        this.functions.add(new FunctionMethod("parsetimestamp", QueryPlugin.Util.getString("SystemSource.Parsetimestamp_desc"), "Conversion", FUNCTION_CLASS, "parseTimestamp", new FunctionParameter[]{new FunctionParameter("timestamp", "string", QueryPlugin.Util.getString("SystemSource.Parsetimestamp_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Parsetimestamp_arg2"))}, new FunctionParameter("result", "timestamp", QueryPlugin.Util.getString("SystemSource.Parsetimestamp_result_desc"))));
        this.functions.add(new FunctionMethod("parsetime", QueryPlugin.Util.getString("SystemSource.Parsetime_desc"), "Conversion", 3, null, null, new FunctionParameter[]{new FunctionParameter("time", "string", QueryPlugin.Util.getString("SystemSource.Parsetime_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Parsetime_arg2"))}, new FunctionParameter("result", "time", QueryPlugin.Util.getString("SystemSource.Parsetime_result_desc"))));
        this.functions.add(new FunctionMethod("parsedate", QueryPlugin.Util.getString("SystemSource.Parsedate_desc"), "Conversion", 3, null, null, new FunctionParameter[]{new FunctionParameter("date", "string", QueryPlugin.Util.getString("SystemSource.Parsedate_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Parsedate_arg2"))}, new FunctionParameter("result", "date", QueryPlugin.Util.getString("SystemSource.Parsedate_result_desc"))));
    }

    private void addFormatNumberFunction(String functionName, String description, String methodName, String inputParam, String dataType, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(inputParam, dataType, QueryPlugin.Util.getString("SystemSource.Formatnumber_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Formatnumber_arg2"))}, new FunctionParameter("result", "string", resultDesc)));
    }

    private void addParseNumberFunction(String functionName, String description, String methodName, String inputParam, String dataType, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(inputParam, "string", QueryPlugin.Util.getString("SystemSource.Parsenumber_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Parsenumber_arg2"))}, new FunctionParameter("result", dataType, resultDesc)));
    }

    private void addBitFunction(String functionName, String description, String methodName, int parameters, String resultDescription) {
        FunctionParameter[] paramArray = null;
        if (parameters == 1) {
            paramArray = new FunctionParameter[]{new FunctionParameter("integer", "integer", QueryPlugin.Util.getString("SystemSource.Bitfunc_arg1"))};
        } else if (parameters == 2) {
            paramArray = new FunctionParameter[]{new FunctionParameter("integer1", "integer", QueryPlugin.Util.getString("SystemSource.Bitfunc2_arg1")), new FunctionParameter("integer2", "integer", QueryPlugin.Util.getString("SystemSource.Bitfunc2_arg2"))};
        }
        this.functions.add(new FunctionMethod(functionName, description, "Numeric", FUNCTION_CLASS, methodName, paramArray, new FunctionParameter("result", "integer", resultDescription)));
    }

    private void addXpathValueFunction() {
        this.functions.add(new FunctionMethod("xpathvalue", QueryPlugin.Util.getString("SystemSource.xpathvalue_description"), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter("document", "string", QueryPlugin.Util.getString("SystemSource.xpath_param1")), new FunctionParameter("xpath", "string", QueryPlugin.Util.getString("SystemSource.xpath_param2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.xpathvalue_result"))));
        this.functions.add(new FunctionMethod("xpathvalue", QueryPlugin.Util.getString("SystemSource.xpathvalue_description"), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter("document", "clob", QueryPlugin.Util.getString("SystemSource.xpath_param1")), new FunctionParameter("xpath", "string", QueryPlugin.Util.getString("SystemSource.xpath_param2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.xpathvalue_result"))));
        this.functions.add(new FunctionMethod("xpathvalue", QueryPlugin.Util.getString("SystemSource.xpathvalue_description"), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter("document", "xml", QueryPlugin.Util.getString("SystemSource.xpath_param1")), new FunctionParameter("xpath", "string", QueryPlugin.Util.getString("SystemSource.xpath_param2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.xpathvalue_result"))));
    }

    private void addXslTransformFunction() {
        for (String type1 : Arrays.asList("string", "xml", "clob")) {
            for (String type2 : Arrays.asList("string", "xml", "clob")) {
                this.functions.add(new FunctionMethod("xsltransform", QueryPlugin.Util.getString("SystemSource.xsltransform_description"), "XML", XML_FUNCTION_CLASS, "xslTransform", new FunctionParameter[]{new FunctionParameter("document", type1, QueryPlugin.Util.getString("SystemSource.xsltransform_param1")), new FunctionParameter("xsl", type2, QueryPlugin.Util.getString("SystemSource.xsltransform_param2"))}, new FunctionParameter("result", "clob", QueryPlugin.Util.getString("SystemSource.xsltransform_result"))));
            }
        }
    }

    private void addXmlComment() {
        this.functions.add(new FunctionMethod("xmlcomment", QueryPlugin.Util.getString("SystemSource.xmlcomment_description"), "XML", XML_FUNCTION_CLASS, "xmlComment", new FunctionParameter[]{new FunctionParameter("value", "string", QueryPlugin.Util.getString("SystemSource.xmlcomment_param2"))}, new FunctionParameter("result", "xml", QueryPlugin.Util.getString("SystemSource.xmlcomment_result"))));
    }

    private void addXmlPi() {
        this.functions.add(new FunctionMethod("xmlpi", QueryPlugin.Util.getString("SystemSource.xmlpi_description"), "XML", XML_FUNCTION_CLASS, "xmlPi", new FunctionParameter[]{new FunctionParameter("name", "string", QueryPlugin.Util.getString("SystemSource.xmlpi_param1"))}, new FunctionParameter("result", "xml", QueryPlugin.Util.getString("SystemSource.xmlpi_result"))));
        this.functions.add(new FunctionMethod("xmlpi", QueryPlugin.Util.getString("SystemSource.xmlpi_description"), "XML", XML_FUNCTION_CLASS, "xmlPi", new FunctionParameter[]{new FunctionParameter("name", "string", QueryPlugin.Util.getString("SystemSource.xmlpi_param1")), new FunctionParameter("value", "string", QueryPlugin.Util.getString("SystemSource.xmlpi_param2"))}, new FunctionParameter("result", "xml", QueryPlugin.Util.getString("SystemSource.xmlpi_result"))));
    }

    private void addXmlConcat() {
        this.functions.add(new FunctionMethod("xmlconcat", QueryPlugin.Util.getString("SystemSource.xmlconcat_description"), "XML", 0, XML_FUNCTION_CLASS, "xmlConcat", new FunctionParameter[]{new FunctionParameter("param1", "xml", QueryPlugin.Util.getString("SystemSource.xmlconcat_param1")), new FunctionParameter("param2", "xml", QueryPlugin.Util.getString("SystemSource.xmlconcat_param2"), true)}, new FunctionParameter("result", "xml", QueryPlugin.Util.getString("SystemSource.xmlconcat_result")), true, 0));
    }

    private void addTimeZoneFunctions() {
        this.functions.add(new FunctionMethod("modifytimezone", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_description"), "Datetime", FUNCTION_CLASS, "modifyTimeZone", new FunctionParameter[]{new FunctionParameter("timestamp", "timestamp", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_param1")), new FunctionParameter("startTimeZone", "string", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_param2")), new FunctionParameter("endTimeZone", "string", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_param3"))}, new FunctionParameter("result", "timestamp", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_result"))));
        this.functions.add(new FunctionMethod("modifytimezone", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_description"), "Datetime", FUNCTION_CLASS, "modifyTimeZone", new FunctionParameter[]{new FunctionParameter("timestamp", "timestamp", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_param1")), new FunctionParameter("endTimeZone", "string", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_param3"))}, new FunctionParameter("result", "timestamp", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_result"))));
    }

    private void addUnixTimeFunctions() {
        this.functions.add(new FunctionMethod("from_unixtime", QueryPlugin.Util.getString("SystemSource.from_unixtime_description"), "Datetime", 3, null, null, new FunctionParameter[]{new FunctionParameter("unix_timestamp", "integer", QueryPlugin.Util.getString("SystemSource.from_unixtime_param1"))}, new FunctionParameter("result", "timestamp", QueryPlugin.Util.getString("SystemSource.from_unixtime_result")), false, 0));
    }

    private void addTypedNullIfFunction(String type) {
        this.functions.add(new FunctionMethod("nullif", QueryPlugin.Util.getString("SystemSource.nullif_description"), "Miscellaneous", 3, null, null, new FunctionParameter[]{new FunctionParameter("op1", type, QueryPlugin.Util.getString("SystemSource.nullif_param1")), new FunctionParameter("op2", type, QueryPlugin.Util.getString("SystemSource.nullif_param1"))}, new FunctionParameter("result", type, QueryPlugin.Util.getString("SystemSource.nullif_result")), true, 0));
    }

    private void addTypedCoalesceFunction(String type) {
        this.functions.add(new FunctionMethod("coalesce", QueryPlugin.Util.getString("SystemSource.coalesce_description"), "Miscellaneous", 0, FUNCTION_CLASS, "coalesce", new FunctionParameter[]{new FunctionParameter("op1", type, QueryPlugin.Util.getString("SystemSource.coalesce_param1")), new FunctionParameter("op2", type, QueryPlugin.Util.getString("SystemSource.coalesce_param1")), new FunctionParameter("op3", type, QueryPlugin.Util.getString("SystemSource.coalesce_param1"), true)}, new FunctionParameter("result", type, QueryPlugin.Util.getString("SystemSource.coalesce_result")), true, 0));
    }

    @Override
    public Collection<FunctionMethod> getFunctionMethods() {
        return this.functions;
    }

    @Override
    public Class<?> getInvocationClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }
}

