/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.capabilities;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;

public class BasicSourceCapabilities
implements SourceCapabilities,
Serializable {
    private SourceCapabilities.Scope scope = SourceCapabilities.Scope.SCOPE_GLOBAL;
    private Map capabilityMap = new HashMap();
    private Map functionMap = new HashMap();
    private Map propertyMap = new HashMap();

    @Override
    public boolean supportsCapability(SourceCapabilities.Capability capability) {
        Boolean supports = (Boolean)this.capabilityMap.get((Object)capability);
        return supports == null ? false : supports;
    }

    @Override
    public boolean supportsFunction(String functionName) {
        Boolean supports = (Boolean)this.functionMap.get(functionName);
        return supports == null ? false : supports;
    }

    public void setCapabilitySupport(SourceCapabilities.Capability capability, boolean supports) {
        if (supports && capability == SourceCapabilities.Capability.QUERY_AGGREGATES) {
            this.capabilityMap.put(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
            this.capabilityMap.put(SourceCapabilities.Capability.QUERY_HAVING, true);
        } else {
            this.capabilityMap.put(capability, supports);
        }
    }

    public void setFunctionSupport(String function, boolean supports) {
        this.functionMap.put(function, supports);
    }

    @Override
    public SourceCapabilities.Scope getScope() {
        return this.scope;
    }

    public void setScope(SourceCapabilities.Scope scope) {
        this.scope = scope;
    }

    public String toString() {
        return "BasicSourceCapabilities<" + (Object)((Object)this.scope) + ", caps=" + this.capabilityMap + ", funcs=" + this.functionMap + ">";
    }

    public void setSourceProperty(SourceCapabilities.Capability propertyName, Object value) {
        this.propertyMap.put(propertyName, value);
    }

    @Override
    public Object getSourceProperty(SourceCapabilities.Capability propertyName) {
        return this.propertyMap.get((Object)propertyName);
    }
}

