/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public class RuleChooseJoinStrategy
implements OptimizerRule {
    private static AtomicInteger EXPRESSION_INDEX = new AtomicInteger(0);

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, TeiidComponentException {
        for (PlanNode joinNode : NodeEditor.findAllNodes(plan, 8, 2)) {
            RuleChooseJoinStrategy.chooseJoinStrategy(joinNode, metadata);
        }
        return plan;
    }

    static void chooseJoinStrategy(PlanNode joinNode, QueryMetadataInterface metadata) {
        JoinType jtype = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jtype.equals(JoinType.JOIN_CROSS)) {
            return;
        }
        PlanNode leftChild = joinNode.getFirstChild();
        if ((leftChild = FrameUtil.findJoinSourceNode(leftChild)) == null) {
            return;
        }
        PlanNode rightChild = joinNode.getLastChild();
        if ((rightChild = FrameUtil.findJoinSourceNode(rightChild)) == null) {
            return;
        }
        Set<GroupSymbol> leftGroups = leftChild.getGroups();
        Set<GroupSymbol> rightGroups = rightChild.getGroups();
        ArrayList<Expression> leftExpressions = new ArrayList<Expression>();
        ArrayList<Expression> rightExpressions = new ArrayList<Expression>();
        List crits = (List)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        ArrayList<Criteria> nonEquiJoinCriteria = new ArrayList<Criteria>();
        for (Criteria theCrit : crits) {
            Set<GroupSymbol> critGroups = GroupsUsedByElementsVisitor.getGroups(theCrit);
            if (leftGroups.containsAll(critGroups) || rightGroups.containsAll(critGroups)) {
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            if (!(theCrit instanceof CompareCriteria)) {
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            CompareCriteria crit = (CompareCriteria)theCrit;
            if (crit.getOperator() != 1) {
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            if (crit.isOptional()) continue;
            Expression leftExpr = crit.getLeftExpression();
            Expression rightExpr = crit.getRightExpression();
            Set<GroupSymbol> leftExprGroups = GroupsUsedByElementsVisitor.getGroups(leftExpr);
            Set<GroupSymbol> rightExprGroups = GroupsUsedByElementsVisitor.getGroups(rightExpr);
            if (leftGroups.isEmpty() || rightGroups.isEmpty()) {
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            if (leftGroups.containsAll(leftExprGroups) && rightGroups.containsAll(rightExprGroups)) {
                leftExpressions.add(leftExpr);
                rightExpressions.add(rightExpr);
                continue;
            }
            if (rightGroups.containsAll(leftExprGroups) && leftGroups.containsAll(rightExprGroups)) {
                leftExpressions.add(rightExpr);
                rightExpressions.add(leftExpr);
                continue;
            }
            nonEquiJoinCriteria.add(theCrit);
        }
        if (!leftExpressions.isEmpty()) {
            joinNode.setProperty(NodeConstants.Info.LEFT_EXPRESSIONS, RuleChooseJoinStrategy.createExpressionSymbols(leftExpressions));
            joinNode.setProperty(NodeConstants.Info.RIGHT_EXPRESSIONS, RuleChooseJoinStrategy.createExpressionSymbols(rightExpressions));
            joinNode.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.MERGE);
            joinNode.setProperty(NodeConstants.Info.NON_EQUI_JOIN_CRITERIA, nonEquiJoinCriteria);
        } else if (nonEquiJoinCriteria.isEmpty()) {
            joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, nonEquiJoinCriteria);
            if (joinNode.getProperty(NodeConstants.Info.JOIN_TYPE) == JoinType.JOIN_INNER) {
                joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_CROSS);
            }
        }
    }

    private static List<SingleElementSymbol> createExpressionSymbols(List<Expression> expressions) {
        HashMap<Expression, ExpressionSymbol> uniqueExpressions = new HashMap<Expression, ExpressionSymbol>();
        ArrayList<SingleElementSymbol> result = new ArrayList<SingleElementSymbol>();
        for (Expression expression : expressions) {
            if (expression instanceof SingleElementSymbol) {
                result.add((SingleElementSymbol)expression);
                continue;
            }
            ExpressionSymbol expressionSymbol = (ExpressionSymbol)uniqueExpressions.get(expression);
            if (expressionSymbol == null) {
                expressionSymbol = new ExpressionSymbol("$" + EXPRESSION_INDEX.getAndIncrement(), expression);
                expressionSymbol.setDerivedExpression(true);
                uniqueExpressions.put(expression, expressionSymbol);
            }
            result.add(expressionSymbol);
        }
        return result;
    }

    public String toString() {
        return "ChooseJoinStrategy";
    }
}

