/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.util.CommandContext;

public class RulePushLimit
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        List<PlanNode> limitNodes = NodeEditor.findAllNodes(plan, 2048);
        boolean pushRaiseNull = false;
        while (!limitNodes.isEmpty()) {
            PlanNode childProject;
            PlanNode limitNode = limitNodes.get(0);
            Expression limit = (Expression)limitNode.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
            if (limit instanceof Constant && new Integer(0).equals(((Constant)limit).getValue()) && (childProject = NodeEditor.findNodePreOrder(limitNode, 16)) != null && childProject.getProperty(NodeConstants.Info.INTO_GROUP) == null) {
                FrameUtil.replaceWithNullNode(limitNode.getFirstChild());
                PlanNode projectNode = NodeFactory.getNewNode(16);
                projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, childProject.getProperty(NodeConstants.Info.PROJECT_COLS));
                limitNode.getFirstChild().addAsParent(projectNode);
                pushRaiseNull = true;
                limitNodes.remove(limitNode);
                continue;
            }
            if (NodeEditor.findAllNodes(limitNode, 2).isEmpty()) {
                limitNodes.remove(limitNode);
                continue;
            }
            while (this.canPushLimit(plan, limitNode, limitNodes, metadata, capabilitiesFinder)) {
                plan = RuleRaiseAccess.performRaise(plan, limitNode.getFirstChild(), limitNode);
            }
            limitNodes.remove(limitNode);
        }
        if (pushRaiseNull) {
            rules.push(RuleConstants.RAISE_NULL);
        }
        return plan;
    }

    boolean canPushLimit(PlanNode rootNode, PlanNode limitNode, List<PlanNode> limitNodes, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        PlanNode child = limitNode.getFirstChild();
        if (child == null || child.getChildCount() == 0) {
            return false;
        }
        switch (child.getType()) {
            case 2048: {
                Expression minLimit = RulePushLimit.getMinValue((Expression)limitNode.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT), (Expression)child.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT));
                Expression offSet = RulePushLimit.getSum((Expression)limitNode.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT), (Expression)child.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT), metadata.getFunctionLibrary());
                NodeEditor.removeChildNode(limitNode, child);
                limitNode.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, minLimit);
                limitNode.setProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT, offSet);
                limitNodes.remove(child);
                return this.canPushLimit(rootNode, limitNode, limitNodes, metadata, capFinder);
            }
            case 512: {
                if (!SetQuery.Operation.UNION.equals(child.getProperty(NodeConstants.Info.SET_OPERATION))) {
                    return false;
                }
                LinkedList<PlanNode> grandChildren = new LinkedList<PlanNode>(child.getChildren());
                for (PlanNode grandChild : grandChildren) {
                    PlanNode newLimit = NodeFactory.getNewNode(2048);
                    Expression limit = (Expression)limitNode.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
                    Expression offset = (Expression)limitNode.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
                    newLimit.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, RulePushLimit.getSum(limit, offset, metadata.getFunctionLibrary()));
                    grandChild.addAsParent(newLimit);
                    limitNodes.add(newLimit);
                }
                return false;
            }
            case 2: {
                RulePushLimit.raiseAccessOverLimit(rootNode, child, metadata, capFinder, limitNode);
                return false;
            }
            case 16: {
                return child.getProperty(NodeConstants.Info.INTO_GROUP) == null;
            }
            case 4: 
            case 32: 
            case 128: {
                return true;
            }
        }
        return false;
    }

    static PlanNode raiseAccessOverLimit(PlanNode rootNode, PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode parentNode) throws QueryMetadataException, TeiidComponentException {
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return null;
        }
        List<PlanNode> setops = NodeEditor.findAllNodes(accessNode, 512, 128);
        if (!setops.isEmpty()) {
            return null;
        }
        Expression limit = (Expression)parentNode.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
        if (limit != null && !CapabilitiesUtil.supportsRowLimit(modelID, metadata, capFinder)) {
            return null;
        }
        Expression offset = (Expression)parentNode.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
        if (offset != null && !CapabilitiesUtil.supportsRowOffset(modelID, metadata, capFinder)) {
            if (limit != null) {
                parentNode.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, null);
                PlanNode pushedLimit = NodeFactory.getNewNode(2048);
                pushedLimit.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, RulePushLimit.getSum(limit, offset, metadata.getFunctionLibrary()));
                if (accessNode.getChildCount() == 0) {
                    accessNode.addFirstChild(pushedLimit);
                } else {
                    accessNode.getFirstChild().addAsParent(pushedLimit);
                }
            }
            return null;
        }
        return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
    }

    static Expression getSum(Expression expr1, Expression expr2, FunctionLibrary functionLibrary) {
        if (expr1 == null) {
            return expr2;
        }
        if (expr2 == null) {
            return expr1;
        }
        Function newExpr = new Function("+", new Expression[]{expr1, expr2});
        newExpr.setFunctionDescriptor(functionLibrary.findFunction("+", new Class[]{DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.INTEGER}));
        newExpr.setType(newExpr.getFunctionDescriptor().getReturnType());
        return newExpr;
    }

    static Expression getMinValue(Expression expr1, Expression expr2) {
        if (expr1 == null) {
            return expr2;
        }
        if (expr2 == null) {
            return expr1;
        }
        CompareCriteria crit = new CompareCriteria(expr1, 3, expr2);
        SearchedCaseExpression sce = new SearchedCaseExpression(Arrays.asList(crit), Arrays.asList(expr1));
        sce.setElseExpression(expr2);
        return sce;
    }

    public String toString() {
        return "PushLimit";
    }
}

