/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.optimizer.xml.ReferenceBindingReplacerVisitor;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.AllInGroupSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.util.CommandContext;

public class QueryUtil {
    static Command getQuery(QueryNode queryNode) throws QueryPlannerException {
        Command query = queryNode.getCommand();
        if (query == null) {
            try {
                query = QueryParser.getQueryParser().parseCommand(queryNode.getQuery());
            }
            catch (QueryParserException e) {
                throw new QueryPlannerException((Throwable)((Object)e), QueryExecPlugin.Util.getString("ERR.015.004.0054", new Object[]{queryNode.getGroupName(), queryNode.getQuery()}));
            }
        }
        return query;
    }

    static void resolveQuery(Command query, TempMetadataAdapter metadata) throws TeiidComponentException, QueryPlannerException {
        try {
            QueryResolver.resolveCommand(query, Collections.EMPTY_MAP, metadata, AnalysisRecord.createNonRecordingRecord());
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)((Object)e), e.getMessage());
        }
    }

    static Command rewriteQuery(Command query, QueryMetadataInterface metadata, CommandContext context) throws QueryPlannerException, TeiidComponentException {
        try {
            return QueryRewriter.rewrite(query, metadata, context);
        }
        catch (TeiidProcessingException e) {
            throw new QueryPlannerException(e, e.getMessage());
        }
    }

    static QueryNode getQueryNode(String groupName, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        QueryNode queryNode = null;
        try {
            GroupSymbol gs = new GroupSymbol(groupName);
            ResolverUtil.resolveGroup(gs, metadata);
            queryNode = metadata.getVirtualPlan(gs.getMetadataID());
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)((Object)e), "ERR.015.004.0029", QueryExecPlugin.Util.getString("ERR.015.004.0029", new Object[]{groupName}));
        }
        return queryNode;
    }

    static Query wrapQuery(FromClause fromClause, String groupName) {
        Select select = new Select();
        select.addSymbol(new AllInGroupSymbol(groupName + ".*"));
        Query query = new Query();
        query.setSelect(select);
        From from = new From();
        from.addClause(fromClause);
        query.setFrom(from);
        return query;
    }

    public static GroupSymbol createResolvedGroup(String groupName, QueryMetadataInterface metadata) throws TeiidComponentException {
        GroupSymbol group = new GroupSymbol(groupName);
        return QueryUtil.createResolvedGroup(group, metadata);
    }

    public static GroupSymbol createResolvedGroup(GroupSymbol group, QueryMetadataInterface metadata) throws TeiidComponentException {
        try {
            ResolverUtil.resolveGroup(group, metadata);
            return group;
        }
        catch (QueryResolverException e) {
            throw new TeiidComponentException((Throwable)((Object)e));
        }
    }

    static Command getQueryFromQueryNode(String groupName, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        QueryNode queryNode = QueryUtil.getQueryNode(groupName, planEnv.getGlobalMetadata());
        Command command = QueryUtil.getQuery(queryNode);
        return command;
    }

    static void handleBindings(LanguageObject object, QueryNode planNode, XMLPlannerEnvironment planEnv) throws QueryResolverException, QueryPlannerException, QueryMetadataException, TeiidComponentException {
        List parsedBindings = QueryUtil.parseBindings(planNode, planEnv);
        if (!parsedBindings.isEmpty()) {
            ReferenceBindingReplacerVisitor.replaceReferences(object, parsedBindings);
        }
    }

    static List parseBindings(QueryNode planNode, XMLPlannerEnvironment planEnv) throws TeiidComponentException {
        List bindingsCol = planNode.getBindings();
        if (bindingsCol == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ElementSymbol> parsedBindings = new ArrayList<ElementSymbol>(bindingsCol.size());
        Iterator bindings = bindingsCol.iterator();
        while (bindings.hasNext()) {
            try {
                ElementSymbol binding = (ElementSymbol)QueryParser.getQueryParser().parseExpression((String)bindings.next());
                parsedBindings.add(binding);
            }
            catch (QueryParserException err) {
                throw new TeiidComponentException((Throwable)((Object)err));
            }
        }
        return parsedBindings;
    }

    static Map createSymbolMap(GroupSymbol oldGroup, String newGroup, Collection projectedElements) {
        HashMap<Symbol, Symbol> symbolMap = new HashMap<Symbol, Symbol>();
        symbolMap.put(oldGroup, new GroupSymbol(newGroup));
        for (ElementSymbol element : projectedElements) {
            symbolMap.put(element, new ElementSymbol(newGroup + "." + element.getShortName()));
        }
        return symbolMap;
    }

    static List getReferences(Command command) {
        ArrayList<Reference> boundList = new ArrayList<Reference>();
        for (Reference ref : ReferenceCollectorVisitor.getReferences(command)) {
            ElementSymbol expr = ref.getExpression();
            if (!(expr instanceof ElementSymbol)) continue;
            ElementSymbol elem = expr;
            if (!command.getExternalGroupContexts().getGroups().contains(elem.getGroupSymbol())) continue;
            boundList.add(ref);
        }
        return boundList;
    }
}

