/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.xml.QueryUtil;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.visitor.StaticSymbolMappingVisitor;

public class XMLQueryPlanner {
    static void prePlanQueries(MappingDocument doc, final XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        MappingVisitor queryPlanVisitor = new MappingVisitor(){

            @Override
            public void visit(MappingBaseNode baseNode) {
                try {
                    List stagingTables = baseNode.getStagingTables();
                    for (String tableName : stagingTables) {
                        XMLQueryPlanner.planStagingTable(tableName, planEnv);
                    }
                    if (baseNode instanceof MappingSourceNode) {
                        XMLQueryPlanner.planQueries((MappingSourceNode)baseNode, planEnv);
                    }
                }
                catch (Exception e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
        };
        XMLQueryPlanner.planWalk(doc, queryPlanVisitor);
    }

    static void optimizeQueries(MappingDocument doc, final XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        MappingVisitor queryPlanVisitor = new MappingVisitor(){

            @Override
            public void visit(MappingSourceNode sourceNode) {
                try {
                    ResultSetInfo rsInfo = sourceNode.getResultSetInfo();
                    if (rsInfo.isJoinedWithParent()) {
                        return;
                    }
                    Query command = (Query)rsInfo.getCommand();
                    XMLQueryPlanner.prepareQuery(sourceNode, planEnv, command);
                    QueryUtil.rewriteQuery(command, planEnv.getGlobalMetadata(), planEnv.context);
                    ProcessorPlan queryPlan = XMLQueryPlanner.optimizePlan(command, planEnv);
                    rsInfo.setPlan(queryPlan);
                }
                catch (Exception e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
        };
        XMLQueryPlanner.planWalk(doc, queryPlanVisitor);
    }

    private static void planWalk(MappingDocument doc, MappingVisitor visitor) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        try {
            Navigator walker = new Navigator(true, visitor);
            doc.acceptVisitor(walker);
        }
        catch (TeiidRuntimeException e) {
            if (e.getCause() instanceof QueryPlannerException) {
                throw (QueryPlannerException)((Object)e.getCause());
            }
            if (e.getCause() instanceof QueryMetadataException) {
                throw (QueryMetadataException)((Object)e.getCause());
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            throw e;
        }
    }

    static void planQueries(MappingSourceNode sourceNode, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        ResultSetInfo rsInfo = sourceNode.getResultSetInfo();
        Query rsQuery = (Query)rsInfo.getCommand();
        rsQuery.setOrderBy(rsInfo.getOrderBy());
        Criteria crit = rsInfo.getCriteria();
        try {
            if (crit != null) {
                XMLQueryPlanner.planQueryWithCriteria(sourceNode, planEnv);
            }
        }
        catch (QueryResolverException e) {
            throw new TeiidComponentException((Throwable)((Object)e));
        }
        if (rsInfo.getUserRowLimit() != -1) {
            int limit = rsInfo.getUserRowLimit();
            if (rsInfo.exceptionOnRowlimit()) {
                ++limit;
            }
            rsQuery.setLimit(new Limit(null, new Constant(new Integer(limit))));
        }
        rsInfo.setCommand(rsQuery);
    }

    static ProcessorPlan optimizePlan(Command query, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        TempMetadataAdapter metadata = planEnv.getGlobalMetadata();
        ProcessorPlan plan = QueryOptimizer.optimizePlan(query, metadata, planEnv.idGenerator, planEnv.capFinder, planEnv.analysisRecord, planEnv.context);
        return plan;
    }

    static void prepareQuery(MappingSourceNode sourceNode, XMLPlannerEnvironment planEnv, QueryCommand rsQuery) throws TeiidComponentException, QueryPlannerException {
        Collection externalGroups = XMLQueryPlanner.getExternalGroups(sourceNode);
        rsQuery.setExternalGroupContexts(new GroupContext(null, externalGroups));
        QueryUtil.resolveQuery(rsQuery, planEnv.getGlobalMetadata());
    }

    private static Collection getExternalGroups(MappingSourceNode sourceNode) {
        HashSet<GroupSymbol> externalGroups = new HashSet<GroupSymbol>();
        for (MappingSourceNode parentSource = sourceNode.getParentSourceNode(); parentSource != null; parentSource = parentSource.getParentSourceNode()) {
            externalGroups.add(new GroupSymbol(parentSource.getActualResultSetName()));
        }
        return externalGroups;
    }

    private static boolean getResultSets(MappingSourceNode contextNode, Set criteriaSourceNodes, LinkedHashSet allResultSets) {
        boolean singleParentage = true;
        for (MappingSourceNode node : criteriaSourceNodes) {
            LinkedList rsStack = XMLQueryPlanner.getResultSetStack(contextNode, node);
            if (allResultSets.containsAll(rsStack)) continue;
            if (!rsStack.containsAll(allResultSets)) {
                singleParentage = false;
            }
            allResultSets.addAll(rsStack);
        }
        return singleParentage;
    }

    private static LinkedList getResultSetStack(MappingSourceNode contextNode, MappingBaseNode node) {
        LinkedList<MappingBaseNode> rsStack = new LinkedList<MappingBaseNode>();
        while (node != null && node != contextNode) {
            if (node instanceof MappingSourceNode) {
                rsStack.add(0, node);
            }
            node = node.getParentNode();
        }
        return rsStack;
    }

    private static void planQueryWithCriteria(MappingSourceNode contextNode, XMLPlannerEnvironment planEnv) throws QueryPlannerException, TeiidComponentException, QueryMetadataException, QueryResolverException {
        HashMap symbolMap = new HashMap();
        ResultSetInfo rsInfo = contextNode.getResultSetInfo();
        LinkedHashSet resultSets = new LinkedHashSet();
        boolean singleParentage = XMLQueryPlanner.getResultSets(contextNode, rsInfo.getCriteriaResultSets(), resultSets);
        Query contextQuery = null;
        if (rsInfo.isCriteriaRaised()) {
            contextQuery = (Query)QueryUtil.getQueryFromQueryNode(rsInfo.getResultSetName(), planEnv);
            String inlineViewName = planEnv.getAliasName(rsInfo.getResultSetName());
            XMLQueryPlanner.updateSymbolMap(symbolMap, rsInfo.getResultSetName(), inlineViewName, planEnv.getGlobalMetadata());
        } else {
            contextQuery = (Query)rsInfo.getCommand();
        }
        Query currentQuery = contextQuery;
        for (MappingSourceNode rsNode : resultSets) {
            ResultSetInfo childRsInfo = rsNode.getResultSetInfo();
            QueryNode planNode = QueryUtil.getQueryNode(childRsInfo.getResultSetName(), planEnv.getGlobalMetadata());
            Command command = QueryUtil.getQuery(planNode);
            String inlineViewName = planEnv.getAliasName(childRsInfo.getResultSetName());
            XMLQueryPlanner.updateSymbolMap(symbolMap, childRsInfo.getResultSetName(), inlineViewName, planEnv.getGlobalMetadata());
            if (childRsInfo.isCriteriaRaised()) {
                Query transformationQuery = (Query)command;
                SubqueryFromClause sfc = (SubqueryFromClause)transformationQuery.getFrom().getClauses().get(0);
                Criteria joinCriteria = ((Query)childRsInfo.getCommand()).getCriteria();
                if (joinCriteria == null) {
                    joinCriteria = QueryRewriter.TRUE_CRITERIA;
                }
                joinCriteria = (Criteria)joinCriteria.clone();
                FromClause clause = (FromClause)currentQuery.getFrom().getClauses().remove(0);
                JoinPredicate join = null;
                if (clause instanceof JoinPredicate) {
                    join = (JoinPredicate)clause;
                    FromClause right = join.getRightClause();
                    JoinPredicate newRight = new JoinPredicate(right, (FromClause)sfc, JoinType.JOIN_LEFT_OUTER, Criteria.separateCriteriaByAnd(joinCriteria));
                    join.setRightClause(newRight);
                } else {
                    join = new JoinPredicate(clause, (FromClause)sfc, JoinType.JOIN_LEFT_OUTER, Criteria.separateCriteriaByAnd(joinCriteria));
                }
                currentQuery.getFrom().addClause(join);
                currentQuery.getSelect().setDistinct(true);
                continue;
            }
            if (!singleParentage) {
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("XMLQueryPlanner.cannot_plan", new Object[]{rsInfo.getCriteria()}));
            }
            QueryUtil.handleBindings(command, planNode, planEnv);
            Query subQuery = QueryUtil.wrapQuery(new SubqueryFromClause(inlineViewName, command), inlineViewName);
            currentQuery.setCriteria(Criteria.combineCriteria(currentQuery.getCriteria(), new ExistsCriteria(subQuery)));
            currentQuery = subQuery;
        }
        Criteria userCrit = (Criteria)rsInfo.getCriteria().clone();
        currentQuery.setCriteria(Criteria.combineCriteria(currentQuery.getCriteria(), userCrit));
        StaticSymbolMappingVisitor.mapSymbols(contextQuery, symbolMap);
        if (rsInfo.isCriteriaRaised()) {
            XMLQueryPlanner.prepareQuery(contextNode, planEnv, contextQuery);
            QueryUtil.rewriteQuery(contextQuery, planEnv.getGlobalMetadata(), planEnv.context);
            List bindings = QueryUtil.getReferences(contextQuery);
            QueryNode modifiedNode = new QueryNode(rsInfo.getResultSetName(), null);
            modifiedNode.setCommand(contextQuery);
            for (Reference ref : bindings) {
                modifiedNode.addBinding(ref.getExpression().toString());
            }
            GroupSymbol groupSymbol = QueryUtil.createResolvedGroup(rsInfo.getResultSetName(), (QueryMetadataInterface)planEnv.getGlobalMetadata());
            planEnv.addQueryNodeToMetadata(groupSymbol.getMetadataID(), modifiedNode);
        }
    }

    private static void updateSymbolMap(Map symbolMap, String oldGroup, String newGroup, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        GroupSymbol oldGroupSymbol = new GroupSymbol(oldGroup);
        ResolverUtil.resolveGroup(oldGroupSymbol, metadata);
        HashSet<ElementSymbol> projectedElements = new HashSet<ElementSymbol>(ResolverUtil.resolveElementsInGroup(oldGroupSymbol, metadata));
        symbolMap.putAll(QueryUtil.createSymbolMap(oldGroupSymbol, newGroup, projectedElements));
    }

    static void planStagingTable(String groupName, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        ResultSetInfo rsInfo = planEnv.getStagingTableResultsInfo(groupName);
        UnaryFromClause fromClause = new UnaryFromClause(new GroupSymbol(groupName));
        Query query = QueryUtil.wrapQuery(fromClause, groupName);
        if (rsInfo.getCriteria() != null) {
            query.setCriteria(rsInfo.getCriteria());
        }
        XMLQueryPlanner.planStagaingQuery(false, groupName, groupName, query, planEnv);
    }

    static boolean planStagaingQuery(boolean implicit, String srcGroupName, String stageGroupName, Query query, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        Map tempMetadata;
        GroupSymbol srcGroup = QueryUtil.createResolvedGroup(srcGroupName, (QueryMetadataInterface)planEnv.getGlobalMetadata());
        String intoGroupName = "#" + stageGroupName.replace('.', '_');
        GroupSymbol intoGroupSymbol = new GroupSymbol(intoGroupName);
        query.setInto(new Into(intoGroupSymbol));
        QueryUtil.resolveQuery(query, planEnv.getGlobalMetadata());
        Command cmd = QueryUtil.rewriteQuery(query, planEnv.getGlobalMetadata(), planEnv.context);
        ProcessorPlan plan = null;
        boolean debug = planEnv.analysisRecord.recordDebug();
        if (debug) {
            planEnv.analysisRecord.println("Attempting to create plan for staging table " + srcGroupName);
        }
        try {
            plan = XMLQueryPlanner.optimizePlan(cmd, planEnv);
        }
        catch (QueryPlannerException e) {
            if (implicit) {
                if (debug) {
                    planEnv.analysisRecord.println("Failed to create plan for staging table " + srcGroupName + " due to " + e.getMessage());
                }
                return false;
            }
            throw e;
        }
        int cardinality = 0;
        if (plan instanceof RelationalPlan) {
            Number planCardinality;
            RelationalPlan relationalPlan = (RelationalPlan)plan;
            RelationalNode root = relationalPlan.getRootNode();
            if (root.getChildren()[0] != null) {
                root = root.getChildren()[0];
            }
            if ((planCardinality = root.getEstimateNodeCardinality()) == null || planCardinality.floatValue() == -1.0f) {
                if (implicit && query.getCriteria() == null) {
                    return false;
                }
            } else if (planCardinality.floatValue() < (float)planEnv.context.getProcessorBatchSize()) {
                cardinality = planCardinality.intValue();
            } else if (implicit) {
                return false;
            }
        }
        if ((tempMetadata = query.getTemporaryMetadata()) != null && !tempMetadata.isEmpty()) {
            planEnv.addToGlobalMetadata(tempMetadata);
        }
        ResultSetInfo rsInfo = planEnv.getStagingTableResultsInfo(stageGroupName);
        rsInfo.setCommand(cmd);
        rsInfo.setPlan(plan);
        TempMetadataID intoGroupID = (TempMetadataID)intoGroupSymbol.getMetadataID();
        intoGroupID.setCardinality(cardinality);
        planEnv.addStagingTable(srcGroup.getMetadataID(), intoGroupID);
        String unloadName = planEnv.unLoadResultName(stageGroupName);
        ResultSetInfo rsUnloadInfo = planEnv.getStagingTableResultsInfo(unloadName);
        Command command = XMLQueryPlanner.wrapStagingTableUnloadQuery(intoGroupSymbol);
        QueryUtil.resolveQuery(command, planEnv.getGlobalMetadata());
        command = QueryUtil.rewriteQuery(command, planEnv.getGlobalMetadata(), planEnv.context);
        plan = XMLQueryPlanner.optimizePlan(command, planEnv);
        rsUnloadInfo.setCommand(command);
        rsUnloadInfo.setPlan(plan);
        return true;
    }

    private static Command wrapStagingTableUnloadQuery(GroupSymbol intoGroupSymbol) {
        Drop drop = new Drop();
        drop.setTable(intoGroupSymbol);
        return drop;
    }
}

