/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.ProgramInstruction;

public class CreateCursorResultSetInstruction
extends ProgramInstruction {
    public static final String RS_NAME = "EXECSQL_INSTRUCTION";
    protected String rsName;
    protected ProcessorPlan plan;

    public CreateCursorResultSetInstruction(String rsName, ProcessorPlan plan) {
        this.rsName = rsName;
        this.plan = plan;
    }

    @Override
    public void process(ProcedurePlan procEnv) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (procEnv.resultSetExists(this.rsName)) {
            procEnv.removeResults(this.rsName);
        }
        procEnv.executePlan(this.plan, this.rsName);
    }

    @Override
    public CreateCursorResultSetInstruction clone() {
        ProcessorPlan clonedPlan = this.plan.clone();
        return new CreateCursorResultSetInstruction(this.rsName, clonedPlan);
    }

    public String toString() {
        return "CREATE CURSOR RESULTSET INSTRUCTION - " + this.rsName;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("CREATE CURSOR");
        props.addProperty("Result Set", this.rsName);
        props.addProperty("Query", this.plan.getDescriptionProperties());
        return props;
    }

    public ProcessorPlan getCommand() {
        return this.plan;
    }
}

