/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.util.CommandContext;

public class BatchedUpdateNode
extends SubqueryAwareRelationalNode {
    private static final List<Integer> ZERO_COUNT_TUPLE = Arrays.asList(0);
    private List<Command> updateCommands;
    private List<VariableContext> contexts;
    private List<Boolean> shouldEvaluate;
    private String modelName;
    private TupleSource tupleSource;
    private Set<Integer> unexecutedCommands;
    private int commandCount;

    public BatchedUpdateNode(int nodeID, List<Command> commands, List<VariableContext> contexts, List<Boolean> shouldEvaluate, String modelName) {
        super(nodeID);
        this.shouldEvaluate = shouldEvaluate;
        this.contexts = contexts;
        this.updateCommands = commands;
        this.modelName = modelName;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        super.open();
        this.unexecutedCommands = new HashSet<Integer>();
        ArrayList<Command> commandsToExecute = new ArrayList<Command>(this.updateCommands.size());
        for (int i = 0; i < this.updateCommands.size(); ++i) {
            Command updateCommand = (Command)this.updateCommands.get(i).clone();
            CommandContext context = this.getContext();
            if (this.contexts != null && !this.contexts.isEmpty()) {
                context = context.clone();
                context.setVariableContext(this.contexts.get(i));
            }
            boolean needProcessing = false;
            if (this.shouldEvaluate != null && this.shouldEvaluate.get(i).booleanValue()) {
                updateCommand = (Command)updateCommand.clone();
                Evaluator eval = this.getEvaluator(Collections.emptyMap());
                eval.initialize(context, this.getDataManager());
                needProcessing = AccessNode.prepareCommand(updateCommand, eval, context, context.getMetadata());
            } else {
                needProcessing = RelationalNodeUtil.shouldExecute(updateCommand, true);
            }
            if (needProcessing) {
                commandsToExecute.add(updateCommand);
                continue;
            }
            this.unexecutedCommands.add(i);
        }
        if (!commandsToExecute.isEmpty()) {
            BatchedUpdateCommand command = new BatchedUpdateCommand(commandsToExecute);
            this.tupleSource = this.getDataManager().registerRequest(this.getContext(), command, this.modelName, null, this.getID());
        }
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        int numExpectedCounts = this.updateCommands.size();
        while (this.commandCount < numExpectedCounts) {
            if (this.tupleSource == null || this.unexecutedCommands.contains(this.commandCount)) {
                this.addBatchRow(ZERO_COUNT_TUPLE);
            } else {
                List<?> tuple = this.tupleSource.nextTuple();
                if (tuple != null) {
                    this.addBatchRow(Arrays.asList(tuple.get(0)));
                } else {
                    throw new TeiidComponentException(QueryExecPlugin.Util.getString("BatchedUpdateNode.unexpected_end_of_batch", new Object[]{this.commandCount, numExpectedCounts}));
                }
            }
            ++this.commandCount;
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        if (this.tupleSource != null) {
            this.tupleSource.closeSource();
            this.tupleSource = null;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.tupleSource = null;
        this.unexecutedCommands = null;
        this.commandCount = 0;
    }

    @Override
    public Object clone() {
        BatchedUpdateNode clonedNode = new BatchedUpdateNode(this.getID(), this.updateCommands, this.contexts, this.shouldEvaluate, this.modelName);
        super.copy(this, clonedNode);
        return clonedNode;
    }
}

