/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.util.CommandContext;

public class TextTableNode
extends SubqueryAwareRelationalNode {
    private TextTable table;
    private int skip = 0;
    private int header = -1;
    private boolean noQuote;
    private char quote;
    private char delimiter;
    private int lineWidth;
    private int[] projectionIndexes;
    private BufferedReader reader;
    private int textLine = 0;
    private Map<String, Integer> nameIndexes;
    private String systemId;

    public TextTableNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.projectionIndexes != null) {
            return;
        }
        if (this.table.getSkip() != null) {
            this.skip = this.table.getSkip();
        }
        if (this.table.getHeader() != null) {
            this.skip = Math.max(this.table.getHeader(), this.skip);
            this.header = this.table.getHeader() - 1;
        }
        if (this.table.isFixedWidth()) {
            for (TextTable.TextColumn col : this.table.getColumns()) {
                this.lineWidth += col.getWidth().intValue();
            }
        } else {
            this.delimiter = this.table.getDelimiter() == null ? (char)44 : this.table.getDelimiter().charValue();
            if (this.table.getQuote() == null) {
                this.quote = (char)34;
            } else {
                this.noQuote = this.table.isEscape();
                this.quote = this.table.getQuote().charValue();
            }
        }
        Map elementMap = TextTableNode.createLookupMap(this.table.getProjectedSymbols());
        this.projectionIndexes = TextTableNode.getProjectionIndexes(elementMap, this.getElements());
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
        this.nameIndexes = null;
        this.textLine = 0;
    }

    public void setTable(TextTable table) {
        this.table = table;
    }

    @Override
    public TextTableNode clone() {
        TextTableNode clone = new TextTableNode(this.getID());
        this.copy(this, clone);
        clone.setTable(this.table);
        return clone;
    }

    @Override
    protected TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.reader == null) {
            this.initReader();
        }
        if (this.reader == null) {
            this.terminateBatches();
            return this.pullBatch();
        }
        while (!this.isBatchFull()) {
            String line = this.readLine();
            if (line == null) {
                this.terminateBatches();
                break;
            }
            List<String> vals = this.parseLine(line);
            ArrayList<Object> tuple = new ArrayList<Object>(this.projectionIndexes.length);
            for (int output : this.projectionIndexes) {
                TextTable.TextColumn col = this.table.getColumns().get(output);
                String val = null;
                int index = output;
                if (this.nameIndexes != null) {
                    index = this.nameIndexes.get(col.getName());
                }
                if (index >= vals.size()) {
                    throw new TeiidProcessingException(QueryExecPlugin.Util.getString("TextTableNode.no_value", new Object[]{col.getName(), this.textLine, this.systemId}));
                }
                val = vals.get(index);
                try {
                    tuple.add(DataTypeManager.transformValue((Object)val, (Class)this.table.getColumns().get(output).getSymbol().getType()));
                }
                catch (TransformationException e) {
                    throw new TeiidProcessingException((Throwable)e, QueryExecPlugin.Util.getString("TextTableNode.conversion_error", new Object[]{col.getName(), this.textLine, this.systemId}));
                }
            }
            this.addBatchRow(tuple);
        }
        return this.pullBatch();
    }

    private String readLine() throws TeiidProcessingException {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                ++this.textLine;
                if (line.length() == 0) continue;
            }
            return line;
        }
        catch (IOException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
    }

    private void initReader() throws ExpressionEvaluationException, BlockedException, TeiidComponentException, TeiidProcessingException {
        this.setReferenceValues(this.table);
        ClobType file = (ClobType)this.getEvaluator(Collections.emptyMap()).evaluate(this.table.getFile(), null);
        if (file == null) {
            return;
        }
        try {
            Reader r;
            this.systemId = "Unknown";
            if (file.getReference() instanceof ClobImpl) {
                this.systemId = ((ClobImpl)file.getReference()).getStreamFactory().getSystemId();
                if (this.systemId == null) {
                    this.systemId = "Unknown";
                }
            }
            this.reader = !((r = file.getCharacterStream()) instanceof BufferedReader) ? new BufferedReader(r) : (BufferedReader)r;
        }
        catch (SQLException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
        if (this.skip <= 0) {
            return;
        }
        while (this.textLine < this.skip) {
            boolean isHeader = this.textLine == this.header;
            String line = this.readLine();
            if (line == null) {
                this.reset();
                return;
            }
            if (!isHeader) continue;
            this.processHeader(this.parseLine(line));
        }
    }

    private void processHeader(List<String> line) throws TeiidProcessingException {
        this.nameIndexes = new HashMap<String, Integer>();
        for (String string : line) {
            if (string == null) continue;
            this.nameIndexes.put(string.toUpperCase(), this.nameIndexes.size());
        }
        for (TextTable.TextColumn col : this.table.getColumns()) {
            Integer index = this.nameIndexes.get(col.getName().toUpperCase());
            if (index == null) {
                throw new TeiidProcessingException(QueryExecPlugin.Util.getString("TextTableNode.header_missing", new Object[]{col.getName(), this.systemId}));
            }
            this.nameIndexes.put(col.getName(), index);
        }
    }

    private List<String> parseLine(String line) throws TeiidProcessingException {
        if (this.table.isFixedWidth()) {
            return this.parseFixedWidth(line);
        }
        return this.parseDelimitedLine(line);
    }

    private List<String> parseDelimitedLine(String line) throws TeiidProcessingException {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean escaped = false;
        boolean wasQualified = false;
        boolean qualified = false;
        while (true) {
            if (line == null) {
                if (escaped) {
                    builder.append('\n');
                    escaped = false;
                    line = this.readLine();
                    continue;
                }
                if (!qualified) {
                    this.addValue(result, wasQualified, builder.toString());
                    return result;
                }
                line = this.readLine();
                if (line == null) {
                    throw new TeiidProcessingException(QueryExecPlugin.Util.getString("TextTableNode.unclosed", new Object[]{this.systemId}));
                }
            }
            char[] chars = line.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char chr = chars[i];
                if (chr == this.delimiter) {
                    if (escaped || qualified) {
                        builder.append(chr);
                        escaped = false;
                        continue;
                    }
                    this.addValue(result, wasQualified, builder.toString());
                    wasQualified = false;
                    builder = new StringBuilder();
                    continue;
                }
                if (chr == this.quote) {
                    if (this.noQuote) {
                        if (escaped) {
                            builder.append(this.quote);
                        }
                        escaped = !escaped;
                        continue;
                    }
                    if (qualified) {
                        qualified = false;
                        continue;
                    }
                    if (wasQualified) {
                        qualified = true;
                        builder.append(chr);
                        continue;
                    }
                    if (builder.toString().trim().length() != 0) {
                        throw new TeiidProcessingException(QueryExecPlugin.Util.getString("TextTableNode.character_not_allowed", new Object[]{this.textLine, this.systemId}));
                    }
                    qualified = true;
                    builder = new StringBuilder();
                    wasQualified = true;
                    continue;
                }
                if (escaped) {
                    throw new TeiidProcessingException(QueryExecPlugin.Util.getString("TextTableNode.unknown_escape", new Object[]{Character.valueOf(chr), this.textLine, this.systemId}));
                }
                if (wasQualified && !qualified) {
                    if (Character.isWhitespace(chr)) continue;
                    throw new TeiidProcessingException(QueryExecPlugin.Util.getString("TextTableNode.character_not_allowed", new Object[]{this.textLine, this.systemId}));
                }
                builder.append(chr);
            }
            line = null;
        }
    }

    private void addValue(ArrayList<String> result, boolean wasQualified, String val) {
        if (!wasQualified && (val = val.trim()).length() == 0) {
            val = null;
        }
        result.add(val);
    }

    private List<String> parseFixedWidth(String line) throws TeiidProcessingException {
        if (line.length() < this.lineWidth) {
            throw new TeiidProcessingException(QueryExecPlugin.Util.getString("TextTableNode.invalid_width", new Object[]{line.length(), this.lineWidth, this.textLine, this.systemId}));
        }
        ArrayList<String> result = new ArrayList<String>();
        int beginIndex = 0;
        for (TextTable.TextColumn col : this.table.getColumns()) {
            String val = line.substring(beginIndex, beginIndex + col.getWidth());
            this.addValue(result, false, val);
            beginIndex += col.getWidth().intValue();
        }
        return result;
    }
}

