/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.lang.XMLTable;

public class XMLTableNode
extends SubqueryAwareRelationalNode {
    private static Map<Class<?>, BuiltInAtomicType> typeMapping = new HashMap();
    private XMLTable table;
    private List<XMLTable.XMLColumn> projectedColumns;
    private SequenceIterator result;
    private int rowCount = 0;
    private Item item;

    public XMLTableNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
        this.item = null;
        this.rowCount = 0;
    }

    public void setTable(XMLTable table) {
        this.table = table;
    }

    public void setProjectedColumns(List<XMLTable.XMLColumn> projectedColumns) {
        this.projectedColumns = projectedColumns;
    }

    @Override
    public XMLTableNode clone() {
        XMLTableNode clone = new XMLTableNode(this.getID());
        this.copy(this, clone);
        clone.setTable(this.table);
        clone.setProjectedColumns(this.projectedColumns);
        return clone;
    }

    @Override
    protected TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.result == null) {
            this.setReferenceValues(this.table);
            this.result = this.getEvaluator(Collections.emptyMap()).evaluateXQuery(this.table.getXQueryExpression(), this.table.getPassing(), null);
        }
        while (!this.isBatchFull() && !this.isLastBatch()) {
            this.processRow();
        }
        return this.pullBatch();
    }

    private void processRow() throws ExpressionEvaluationException, BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.item == null) {
            try {
                this.item = this.result.next();
            }
            catch (XPathException e) {
                throw new TeiidProcessingException((Throwable)e, QueryExecPlugin.Util.getString("XMLTableNode.error", new Object[]{e.getMessage()}));
            }
            ++this.rowCount;
            if (this.item == null) {
                this.terminateBatches();
                return;
            }
        }
        ArrayList<Object> tuple = new ArrayList<Object>(this.projectedColumns.size());
        for (XMLTable.XMLColumn proColumn : this.projectedColumns) {
            if (proColumn.isOrdinal()) {
                tuple.add(this.rowCount);
                continue;
            }
            try {
                Object value;
                XPathExpression path = proColumn.getPathExpression();
                XPathDynamicContext dynamicContext = path.createDynamicContext(this.item);
                SequenceIterator pathIter = path.iterate(dynamicContext);
                Item colItem = pathIter.next();
                if (colItem == null) {
                    if (proColumn.getDefaultExpression() != null) {
                        tuple.add(this.getEvaluator(Collections.emptyMap()).evaluate(proColumn.getDefaultExpression(), null));
                        continue;
                    }
                    tuple.add(null);
                    continue;
                }
                if (proColumn.getSymbol().getType() == DataTypeManager.DefaultDataClasses.XML) {
                    value = this.table.getXQueryExpression().createXMLType(pathIter.getAnother(), this.getBufferManager(), false);
                    tuple.add(value);
                    continue;
                }
                if (pathIter.next() != null) {
                    throw new TeiidProcessingException(QueryExecPlugin.Util.getString("XMLTableName.multi_value", new Object[]{proColumn.getName()}));
                }
                value = Value.convertToJava((Item)colItem);
                if (value instanceof Item) {
                    Item i = (Item)value;
                    BuiltInAtomicType bat = typeMapping.get(proColumn.getSymbol().getType());
                    if (bat != null) {
                        ConversionResult cr = StringValue.convertStringToBuiltInType((CharSequence)i.getStringValueCS(), (BuiltInAtomicType)bat, null);
                        value = cr.asAtomic();
                        if ((value = Value.convertToJava((Item)((AtomicValue)value))) instanceof Item) {
                            value = ((Item)value).getStringValue();
                        }
                    } else {
                        value = i.getStringValue();
                    }
                }
                value = FunctionDescriptor.importValue(value, proColumn.getSymbol().getType());
                tuple.add(value);
            }
            catch (XPathException e) {
                throw new TeiidProcessingException((Throwable)e, QueryExecPlugin.Util.getString("XMLTableNode.path_error", new Object[]{proColumn.getName()}));
            }
        }
        this.item = null;
        this.addBatchRow(tuple);
    }

    static {
        typeMapping.put(DataTypeManager.DefaultDataClasses.TIMESTAMP, BuiltInAtomicType.DATE_TIME);
        typeMapping.put(DataTypeManager.DefaultDataClasses.TIME, BuiltInAtomicType.TIME);
        typeMapping.put(DataTypeManager.DefaultDataClasses.DATE, BuiltInAtomicType.DATE);
        typeMapping.put(DataTypeManager.DefaultDataClasses.FLOAT, BuiltInAtomicType.FLOAT);
        typeMapping.put(DataTypeManager.DefaultDataClasses.DOUBLE, BuiltInAtomicType.DOUBLE);
    }
}

