/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.processor.xml.Condition;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.ElementSymbol;

public class CriteriaCondition
extends Condition {
    protected Criteria criteria;

    public CriteriaCondition(Criteria criteria, Program thenProgram) {
        super(thenProgram);
        this.criteria = criteria;
    }

    @Override
    public boolean evaluate(XMLProcessorEnvironment env, XMLContext context) throws TeiidComponentException, TeiidProcessingException {
        HashMap<ElementSymbol, Integer> elementMap = new HashMap<ElementSymbol, Integer>();
        ArrayList data = new ArrayList();
        Map referenceValues = context.getReferenceValues();
        int index = 0;
        for (ElementSymbol element : referenceValues.keySet()) {
            elementMap.put(element, new Integer(index));
            data.add(referenceValues.get(element));
            ++index;
        }
        try {
            return new Evaluator(elementMap, env.getDataManager(), env.getProcessorContext()).evaluate(this.criteria, data);
        }
        catch (ExpressionEvaluationException e) {
            throw new TeiidComponentException((Throwable)((Object)e));
        }
    }

    public String toString() {
        return this.criteria.toString();
    }
}

