/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.transform.TransformerException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.FileStore;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLTranslator;

public class XMLUtil {
    public static SQLXMLImpl saveToBufferManager(BufferManager bufferMgr, XMLTranslator translator) throws TeiidComponentException, TeiidProcessingException {
        boolean success = false;
        FileStore lobBuffer = bufferMgr.createFileStore("xml");
        FileStoreInputStreamFactory fsisf = new FileStoreInputStreamFactory(lobBuffer, "UTF-8");
        try {
            Writer writer = fsisf.getWriter();
            translator.translate(writer);
            writer.close();
            success = true;
            SQLXMLImpl sQLXMLImpl = new SQLXMLImpl((InputStreamFactory)fsisf);
            return sQLXMLImpl;
        }
        catch (IOException e) {
            throw new TeiidComponentException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
        finally {
            if (!success && lobBuffer != null) {
                lobBuffer.remove();
            }
        }
    }

    public static final class FileStoreInputStreamFactory
    extends InputStreamFactory {
        private final FileStore lobBuffer;
        private final FileStore.FileStoreOutputStream fsos;
        private String encoding;

        public FileStoreInputStreamFactory(FileStore lobBuffer, String encoding) {
            this.encoding = encoding;
            this.lobBuffer = lobBuffer;
            this.fsos = lobBuffer.createOutputStream(8192);
            this.lobBuffer.setCleanupReference((Object)this);
        }

        public InputStream getInputStream() throws IOException {
            if (!this.fsos.bytesWritten()) {
                return new ByteArrayInputStream(this.fsos.getBuffer(), 0, this.fsos.getCount());
            }
            return new BufferedInputStream(this.lobBuffer.createInputStream(0L));
        }

        public long getLength() {
            return this.lobBuffer.getLength();
        }

        public Writer getWriter() {
            return new OutputStreamWriter((OutputStream)this.fsos, Charset.forName(this.encoding));
        }

        public OutputStream getOuputStream() {
            return this.fsos;
        }

        public void free() throws IOException {
            this.lobBuffer.remove();
        }
    }
}

