/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.rewriter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.processor.relational.DependentValueSource;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.TranslatableProcedureContainer;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.navigator.PostOrderNavigator;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.proc.ExpressionStatement;
import org.teiid.query.sql.proc.HasCriteria;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.TranslateCriteria;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.util.ValueIterator;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.CriteriaTranslatorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.PredicateCollectorVisitor;
import org.teiid.query.util.CommandContext;

public class QueryRewriter {
    public static final CompareCriteria TRUE_CRITERIA = new CompareCriteria(new Constant(new Integer(1), DataTypeManager.DefaultDataClasses.INTEGER), 1, new Constant(new Integer(1), DataTypeManager.DefaultDataClasses.INTEGER));
    public static final CompareCriteria FALSE_CRITERIA = new CompareCriteria(new Constant(new Integer(1), DataTypeManager.DefaultDataClasses.INTEGER), 1, new Constant(new Integer(0), DataTypeManager.DefaultDataClasses.INTEGER));
    public static final CompareCriteria UNKNOWN_CRITERIA = new CompareCriteria(new Constant(null, DataTypeManager.DefaultDataClasses.STRING), 2, new Constant(null, DataTypeManager.DefaultDataClasses.STRING));
    private static final Map<String, String> ALIASED_FUNCTIONS = new HashMap<String, String>();
    private QueryMetadataInterface metadata;
    private CommandContext context;
    private CreateUpdateProcedureCommand procCommand;
    private boolean rewriteSubcommands;
    private boolean processing;
    private Evaluator evaluator;
    private Map variables;
    private int commandType;
    private Integer INTEGER_ZERO = new Integer(0);
    private Double DOUBLE_ZERO = new Double(0.0);
    private Float FLOAT_ZERO = new Float(0.0f);
    private Long LONG_ZERO = new Long(0L);
    private BigInteger BIG_INTEGER_ZERO = new BigInteger("0");
    private BigDecimal BIG_DECIMAL_ZERO = new BigDecimal("0");
    private Short SHORT_ZERO = new Short(0);
    private Byte BYTE_ZERO = new Byte(0);
    private static Map<String, Integer> FUNCTION_MAP;

    private QueryRewriter(QueryMetadataInterface metadata, CommandContext context, CreateUpdateProcedureCommand procCommand) {
        this.metadata = metadata;
        this.context = context;
        this.procCommand = procCommand;
        this.evaluator = new Evaluator(Collections.emptyMap(), null, context);
    }

    public static Command evaluateAndRewrite(Command command, Evaluator eval, CommandContext context, QueryMetadataInterface metadata) throws TeiidProcessingException, TeiidComponentException {
        QueryRewriter queryRewriter = new QueryRewriter(metadata, context, null);
        queryRewriter.evaluator = eval;
        queryRewriter.rewriteSubcommands = true;
        queryRewriter.processing = true;
        return queryRewriter.rewriteCommand(command, false);
    }

    public static Command rewrite(Command command, CreateUpdateProcedureCommand procCommand, QueryMetadataInterface metadata, CommandContext context, Map variableValues, int commandType) throws TeiidComponentException, TeiidProcessingException {
        QueryRewriter rewriter = new QueryRewriter(metadata, context, procCommand);
        rewriter.rewriteSubcommands = true;
        rewriter.variables = variableValues;
        rewriter.commandType = commandType;
        return rewriter.rewriteCommand(command, false);
    }

    public static Command rewrite(Command command, QueryMetadataInterface metadata, CommandContext context) throws TeiidComponentException, TeiidProcessingException {
        return QueryRewriter.rewrite(command, null, metadata, context, null, 0);
    }

    private Command rewriteCommand(Command command, boolean removeOrderBy) throws TeiidComponentException, TeiidProcessingException {
        QueryMetadataInterface oldMetadata = this.metadata;
        CreateUpdateProcedureCommand oldProcCommand = this.procCommand;
        Map tempMetadata = command.getTemporaryMetadata();
        if (tempMetadata != null) {
            this.metadata = new TempMetadataAdapter(this.metadata, new TempMetadataStore(tempMetadata));
        }
        switch (command.getType()) {
            case 1: {
                QueryCommand queryCommand;
                command = command instanceof Query ? this.rewriteQuery((Query)command) : this.rewriteSetQuery((SetQuery)command);
                if (!removeOrderBy || (queryCommand = (QueryCommand)command).getLimit() != null) break;
                queryCommand.setOrderBy(null);
                break;
            }
            case 6: {
                command = this.rewriteExec((StoredProcedure)command);
                break;
            }
            case 2: {
                command = this.rewriteInsert((Insert)command);
                break;
            }
            case 3: {
                command = this.rewriteUpdate((Update)command);
                break;
            }
            case 4: {
                command = this.rewriteDelete((Delete)command);
                break;
            }
            case 7: {
                this.procCommand = (CreateUpdateProcedureCommand)command;
                command = this.rewriteUpdateProcedure((CreateUpdateProcedureCommand)command);
                break;
            }
            case 9: {
                List subCommands = ((BatchedUpdateCommand)command).getUpdateCommands();
                for (int i = 0; i < subCommands.size(); ++i) {
                    Command subCommand = (Command)subCommands.get(i);
                    subCommand = this.rewriteCommand(subCommand, false);
                    subCommands.set(i, subCommand);
                }
                break;
            }
        }
        this.metadata = oldMetadata;
        this.procCommand = oldProcCommand;
        return command;
    }

    private Command rewriteUpdateProcedure(CreateUpdateProcedureCommand command) throws TeiidComponentException, TeiidProcessingException {
        Map oldVariables = this.variables;
        if (command.getUserCommand() != null) {
            this.variables = QueryResolver.getVariableValues(command.getUserCommand(), this.metadata);
            this.commandType = command.getUserCommand().getType();
        }
        Block block = this.rewriteBlock(command.getBlock());
        command.setBlock(block);
        this.variables = oldVariables;
        return command;
    }

    private Block rewriteBlock(Block block) throws TeiidComponentException, TeiidProcessingException {
        List<Statement> statements = block.getStatements();
        Iterator<Statement> stmtIter = statements.iterator();
        ArrayList<Statement> newStmts = new ArrayList<Statement>(statements.size());
        while (stmtIter.hasNext()) {
            Statement stmnt = stmtIter.next();
            Object newStmt = this.rewriteStatement(stmnt);
            if (newStmt instanceof Statement) {
                newStmts.add((Statement)newStmt);
                continue;
            }
            if (!(newStmt instanceof List)) continue;
            newStmts.addAll((List)newStmt);
        }
        block.setStatements(newStmts);
        return block;
    }

    private Object rewriteStatement(Statement statement) throws TeiidComponentException, TeiidProcessingException {
        int stmtType = statement.getType();
        switch (stmtType) {
            case 1: {
                IfStatement ifStmt = (IfStatement)statement;
                Criteria ifCrit = ifStmt.getCondition();
                Criteria evalCrit = this.rewriteCriteria(ifCrit);
                ifStmt.setCondition(evalCrit);
                if (evalCrit.equals(TRUE_CRITERIA)) {
                    Block ifblock = this.rewriteBlock(ifStmt.getIfBlock());
                    return ifblock.getStatements();
                }
                if (evalCrit.equals(FALSE_CRITERIA) || evalCrit.equals(UNKNOWN_CRITERIA)) {
                    if (ifStmt.hasElseBlock()) {
                        Block elseBlock = this.rewriteBlock(ifStmt.getElseBlock());
                        return elseBlock.getStatements();
                    }
                    return null;
                }
                Block ifblock = this.rewriteBlock(ifStmt.getIfBlock());
                ifStmt.setIfBlock(ifblock);
                if (ifStmt.hasElseBlock()) {
                    Block elseBlock = this.rewriteBlock(ifStmt.getElseBlock());
                    ifStmt.setElseBlock(elseBlock);
                }
                return ifStmt;
            }
            case 3: 
            case 4: 
            case 5: {
                ExpressionStatement exprStmt = (ExpressionStatement)((Object)statement);
                Expression expr = exprStmt.getExpression();
                if (expr != null) {
                    Update update;
                    ScalarSubquery ss;
                    expr = this.rewriteExpressionDirect(expr);
                    exprStmt.setExpression(expr);
                    if (expr instanceof ScalarSubquery && (ss = (ScalarSubquery)expr).getCommand().getType() == 3 && (update = (Update)ss.getCommand()).getChangeList().isEmpty()) {
                        exprStmt.setExpression(new Constant(this.INTEGER_ZERO));
                    }
                }
                return exprStmt;
            }
            case 2: {
                Update update;
                CommandStatement cmdStmt = (CommandStatement)statement;
                this.rewriteSubqueryContainer(cmdStmt, false);
                if (cmdStmt.getCommand().getType() == 3 && (update = (Update)cmdStmt.getCommand()).getChangeList().isEmpty()) {
                    return null;
                }
                return statement;
            }
            case 6: {
                LoopStatement loop = (LoopStatement)statement;
                this.rewriteSubqueryContainer(loop, false);
                this.rewriteBlock(loop.getBlock());
                if (loop.getBlock().getStatements().isEmpty()) {
                    return null;
                }
                return loop;
            }
            case 7: {
                WhileStatement whileStatement = (WhileStatement)statement;
                Criteria crit = whileStatement.getCondition();
                crit = this.rewriteCriteria(crit);
                whileStatement.setCondition(crit);
                if (crit.equals(TRUE_CRITERIA)) {
                    throw new QueryValidatorException(QueryExecPlugin.Util.getString("QueryRewriter.infinite_while"));
                }
                if (crit.equals(FALSE_CRITERIA) || crit.equals(UNKNOWN_CRITERIA)) {
                    return null;
                }
                whileStatement.setBlock(this.rewriteBlock(whileStatement.getBlock()));
                if (whileStatement.getBlock().getStatements().isEmpty()) {
                    return null;
                }
                return whileStatement;
            }
        }
        return statement;
    }

    private void rewriteSubqueryContainer(SubqueryContainer container, boolean removeOrderBy) throws TeiidComponentException, TeiidProcessingException {
        if (this.rewriteSubcommands && container.getCommand() != null && container.getCommand().getProcessorPlan() == null) {
            container.setCommand(this.rewriteCommand(container.getCommand(), removeOrderBy));
        }
    }

    private Criteria rewriteCriteria(HasCriteria hasCrit) {
        int selectorType;
        Criteria userCrit = null;
        Command userCommand = this.procCommand.getUserCommand();
        int cmdType = userCommand.getType();
        switch (cmdType) {
            case 4: {
                userCrit = ((Delete)userCommand).getCriteria();
                break;
            }
            case 3: {
                userCrit = ((Update)userCommand).getCriteria();
                break;
            }
            default: {
                return FALSE_CRITERIA;
            }
        }
        if (userCrit == null) {
            return FALSE_CRITERIA;
        }
        CriteriaSelector selector = hasCrit.getSelector();
        List hasCritElmts = null;
        if (selector.hasElements()) {
            hasCritElmts = selector.getElements();
            Collection<ElementSymbol> userElmnts = ElementCollectorVisitor.getElements((LanguageObject)userCrit, true);
            if (!userElmnts.containsAll(hasCritElmts)) {
                return FALSE_CRITERIA;
            }
        }
        if ((selectorType = selector.getSelectorType()) == 0) {
            return TRUE_CRITERIA;
        }
        block10: for (Criteria predicateCriteria : PredicateCollectorVisitor.getPredicates(userCrit)) {
            CompareCriteria compCrit;
            Collection<ElementSymbol> predElmnts = ElementCollectorVisitor.getElements((LanguageObject)predicateCriteria, true);
            if (selector.hasElements()) {
                Iterator hasIter = hasCritElmts.iterator();
                boolean containsElmnt = false;
                while (hasIter.hasNext()) {
                    ElementSymbol hasElmnt = (ElementSymbol)hasIter.next();
                    if (!predElmnts.contains(hasElmnt)) continue;
                    containsElmnt = true;
                }
                if (!containsElmnt) continue;
            }
            switch (selectorType) {
                case 8: {
                    if (!(predicateCriteria instanceof SetCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
                case 7: {
                    if (!(predicateCriteria instanceof MatchCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
                case 9: {
                    if (!(predicateCriteria instanceof IsNullCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
                case 10: {
                    if (!(predicateCriteria instanceof BetweenCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
            }
            if (!(predicateCriteria instanceof CompareCriteria) || (compCrit = (CompareCriteria)predicateCriteria).getOperator() != selectorType) continue;
            return TRUE_CRITERIA;
        }
        return FALSE_CRITERIA;
    }

    private Criteria rewriteCriteria(TranslateCriteria transCrit) throws TeiidComponentException, TeiidProcessingException {
        Criteria translatedCriteria = null;
        Command userCmd = this.procCommand.getUserCommand();
        if (!(userCmd instanceof TranslatableProcedureContainer)) {
            return FALSE_CRITERIA;
        }
        Criteria userCriteria = ((TranslatableProcedureContainer)userCmd).getCriteria();
        if (userCriteria == null) {
            return FALSE_CRITERIA;
        }
        CriteriaTranslatorVisitor translateVisitor = new CriteriaTranslatorVisitor(this.procCommand.getSymbolMap());
        CriteriaSelector selector = transCrit.getSelector();
        HasCriteria hasCrit = new HasCriteria(selector);
        Criteria result = this.rewriteCriteria(hasCrit);
        if (result.equals(FALSE_CRITERIA)) {
            return FALSE_CRITERIA;
        }
        translateVisitor.setCriteriaSelector(selector);
        if (transCrit.hasTranslations()) {
            translateVisitor.setTranslations(transCrit.getTranslations());
        }
        Criteria userClone = (Criteria)userCriteria.clone();
        PreOrderNavigator.doVisit(userClone, translateVisitor);
        translatedCriteria = translateVisitor.getTranslatedCriteria();
        ((TranslatableProcedureContainer)userCmd).addImplicitParameters(translateVisitor.getImplicitParams());
        translatedCriteria = this.rewriteCriteria(translatedCriteria);
        try {
            ResolverVisitor.resolveLanguageObject(translatedCriteria, this.metadata);
        }
        catch (TeiidException ex) {
            throw new QueryValidatorException(ex, "ERR.015.009.0002", QueryExecPlugin.Util.getString("ERR.015.009.0002", new Object[]{translatedCriteria}));
        }
        return translatedCriteria;
    }

    private Command rewriteQuery(Query query) throws TeiidComponentException, TeiidProcessingException {
        Criteria having;
        From from = query.getFrom();
        if (from != null) {
            ArrayList<FromClause> clauses = new ArrayList<FromClause>(from.getClauses().size());
            Iterator clauseIter = from.getClauses().iterator();
            while (clauseIter.hasNext()) {
                clauses.add(this.rewriteFromClause(query, (FromClause)clauseIter.next()));
            }
            from.setClauses(clauses);
        } else {
            query.setOrderBy(null);
        }
        Criteria crit = query.getCriteria();
        if (crit != null) {
            if ((crit = this.rewriteCriteria(crit)) == TRUE_CRITERIA) {
                query.setCriteria(null);
            } else {
                query.setCriteria(crit);
            }
        }
        if ((having = (query = this.rewriteGroupBy(query)).getHaving()) != null) {
            query.setHaving(this.rewriteCriteria(having));
        }
        this.rewriteExpressions(query.getSelect());
        if (!query.getIsXML()) {
            query = (Query)this.rewriteOrderBy(query);
        }
        if (query.getLimit() != null) {
            query.setLimit(this.rewriteLimitClause(query.getLimit()));
        }
        if (query.getInto() != null) {
            return this.rewriteSelectInto(query);
        }
        return query;
    }

    private Query rewriteGroupBy(Query query) throws TeiidComponentException, TeiidProcessingException {
        if (query.getGroupBy() == null) {
            return query;
        }
        if (QueryRewriter.isDistinctWithGroupBy(query)) {
            query.getSelect().setDistinct(false);
        }
        boolean hasExpression = false;
        Iterator iterator = query.getGroupBy().getSymbols().iterator();
        while (!hasExpression && iterator.hasNext()) {
            hasExpression = iterator.next() instanceof ExpressionSymbol;
        }
        if (!hasExpression) {
            return query;
        }
        Select select = query.getSelect();
        GroupBy groupBy = query.getGroupBy();
        query.setGroupBy(null);
        Criteria having = query.getHaving();
        query.setHaving(null);
        OrderBy orderBy = query.getOrderBy();
        query.setOrderBy(null);
        Limit limit = query.getLimit();
        query.setLimit(null);
        Into into = query.getInto();
        query.setInto(null);
        HashSet<Expression> newSelectColumns = new HashSet<Expression>();
        Iterator iterator2 = groupBy.getSymbols().iterator();
        while (iterator2.hasNext()) {
            newSelectColumns.add(SymbolMap.getExpression((SingleElementSymbol)iterator2.next()));
        }
        HashSet<AggregateSymbol> aggs = new HashSet<AggregateSymbol>();
        aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(select, true));
        if (having != null) {
            aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(having, true));
        }
        for (AggregateSymbol aggregateSymbol : aggs) {
            if (aggregateSymbol.getExpression() == null) continue;
            Expression expr = aggregateSymbol.getExpression();
            newSelectColumns.add(SymbolMap.getExpression(expr));
        }
        Select innerSelect = new Select();
        int index = 0;
        for (Expression expr : newSelectColumns) {
            if (expr instanceof SingleElementSymbol) {
                innerSelect.addSymbol((SingleElementSymbol)expr);
                continue;
            }
            innerSelect.addSymbol(new ExpressionSymbol("EXPR" + index++, expr));
        }
        query.setSelect(innerSelect);
        Query outerQuery = null;
        try {
            outerQuery = QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), query, this.metadata, query.getSelect().getProjectedSymbols());
        }
        catch (TeiidException err) {
            throw new TeiidRuntimeException((Throwable)err);
        }
        Iterator iter = outerQuery.getSelect().getProjectedSymbols().iterator();
        HashMap<Expression, SingleElementSymbol> expressionMap = new HashMap<Expression, SingleElementSymbol>();
        for (SingleElementSymbol symbol : query.getSelect().getProjectedSymbols()) {
            expressionMap.put(SymbolMap.getExpression(symbol), (SingleElementSymbol)iter.next());
        }
        ExpressionMappingVisitor.mapExpressions(groupBy, expressionMap);
        outerQuery.setGroupBy(groupBy);
        ExpressionMappingVisitor.mapExpressions(having, expressionMap);
        outerQuery.setHaving(having);
        ExpressionMappingVisitor.mapExpressions(orderBy, expressionMap);
        outerQuery.setOrderBy(orderBy);
        outerQuery.setLimit(limit);
        ExpressionMappingVisitor.mapExpressions(select, expressionMap);
        outerQuery.setSelect(select);
        outerQuery.setInto(into);
        outerQuery.setOption(query.getOption());
        query = outerQuery;
        this.rewriteExpressions(innerSelect);
        return query;
    }

    public static boolean isDistinctWithGroupBy(Query query) {
        GroupBy groupBy = query.getGroupBy();
        if (groupBy == null) {
            return false;
        }
        HashSet<Expression> selectExpressions = new HashSet<Expression>();
        for (SingleElementSymbol selectExpr : query.getSelect().getProjectedSymbols()) {
            selectExpressions.add(SymbolMap.getExpression(selectExpr));
        }
        for (SingleElementSymbol groupByExpr : groupBy.getSymbols()) {
            if (selectExpressions.contains(groupByExpr)) continue;
            return false;
        }
        return true;
    }

    private void rewriteExpressions(LanguageObject obj) throws TeiidComponentException, TeiidProcessingException {
        if (obj == null) {
            return;
        }
        ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(null){

            @Override
            public Expression replaceExpression(Expression element) {
                try {
                    return QueryRewriter.this.rewriteExpressionDirect(element);
                }
                catch (TeiidException err) {
                    throw new TeiidRuntimeException((Throwable)err);
                }
            }
        };
        try {
            PostOrderNavigator.doVisit(obj, visitor);
        }
        catch (TeiidRuntimeException err) {
            if (err.getChild() instanceof TeiidComponentException) {
                throw (TeiidComponentException)err.getChild();
            }
            if (err.getChild() instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)err.getChild();
            }
            throw err;
        }
    }

    public QueryCommand rewriteOrderBy(QueryCommand queryCommand) throws TeiidComponentException {
        OrderBy orderBy = queryCommand.getOrderBy();
        if (orderBy == null) {
            return queryCommand;
        }
        Select select = queryCommand.getProjectedQuery().getSelect();
        List projectedSymbols = select.getProjectedSymbols();
        LinkedList<OrderByItem> unrelatedItems = new LinkedList<OrderByItem>();
        boolean hasUnrelatedExpression = QueryRewriter.rewriteOrderBy(queryCommand, orderBy, projectedSymbols, unrelatedItems);
        if (orderBy.getVariableCount() == 0 || !hasUnrelatedExpression) {
            return queryCommand;
        }
        int originalSymbolCount = select.getProjectedSymbols().size();
        for (OrderByItem orderByItem : unrelatedItems) {
            select.addSymbol(orderByItem.getSymbol());
        }
        QueryRewriter.makeSelectUnique(select, false);
        Query query = queryCommand.getProjectedQuery();
        Into into = query.getInto();
        query.setInto(null);
        Limit limit = query.getLimit();
        query.setLimit(null);
        query.setOrderBy(null);
        Query top = null;
        try {
            top = QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), query, this.metadata, select.getProjectedSymbols());
            Iterator iter = top.getSelect().getProjectedSymbols().iterator();
            HashMap<Expression, SingleElementSymbol> expressionMap = new HashMap<Expression, SingleElementSymbol>();
            for (SingleElementSymbol symbol : select.getProjectedSymbols()) {
                SingleElementSymbol ses = (SingleElementSymbol)iter.next();
                expressionMap.put(SymbolMap.getExpression(symbol), ses);
                expressionMap.put(new ElementSymbol(symbol.getName()), ses);
            }
            ExpressionMappingVisitor.mapExpressions(orderBy, expressionMap);
        }
        catch (TeiidException err) {
            throw new TeiidRuntimeException((Throwable)err);
        }
        List symbols = top.getSelect().getSymbols();
        top.getSelect().setSymbols(symbols.subList(0, originalSymbolCount));
        top.setInto(into);
        top.setLimit(limit);
        top.setOrderBy(orderBy);
        return top;
    }

    public static boolean rewriteOrderBy(QueryCommand queryCommand, OrderBy orderBy, List projectedSymbols, LinkedList<OrderByItem> unrelatedItems) {
        boolean hasUnrelatedExpression = false;
        HashSet<Expression> previousExpressions = new HashSet<Expression>();
        for (int i = 0; i < orderBy.getVariableCount(); ++i) {
            SingleElementSymbol querySymbol = orderBy.getVariable(i);
            int index = orderBy.getExpressionPosition(i);
            if (index == -1) {
                unrelatedItems.add(orderBy.getOrderByItems().get(i));
                hasUnrelatedExpression |= querySymbol instanceof ExpressionSymbol;
                continue;
            }
            querySymbol = (SingleElementSymbol)projectedSymbols.get(index);
            Expression expr = SymbolMap.getExpression(querySymbol);
            if (!previousExpressions.add(expr) || queryCommand instanceof Query && EvaluatableVisitor.isFullyEvaluatable(expr, true)) {
                orderBy.removeOrderByItem(i--);
                continue;
            }
            orderBy.getOrderByItems().get(i).setSymbol((SingleElementSymbol)querySymbol.clone());
        }
        if (orderBy.getVariableCount() == 0) {
            queryCommand.setOrderBy(null);
        }
        return hasUnrelatedExpression;
    }

    private Insert rewriteSelectInto(Query query) throws TeiidComponentException, TeiidProcessingException {
        Into into = query.getInto();
        try {
            ArrayList<ElementSymbol> allIntoElements = LanguageObject.Util.deepClone(ResolverUtil.resolveElementsInGroup(into.getGroup(), this.metadata), ElementSymbol.class);
            Insert insert = new Insert(into.getGroup(), allIntoElements, Collections.emptyList());
            query.setInto(null);
            insert.setQueryExpression(query);
            return this.correctDatatypes(insert);
        }
        catch (QueryMetadataException err) {
            throw new QueryValidatorException((Throwable)((Object)err), err.getMessage());
        }
        catch (TeiidComponentException err) {
            throw new QueryValidatorException(err, err.getMessage());
        }
    }

    private Insert correctDatatypes(Insert insert) throws TeiidComponentException, TeiidProcessingException {
        boolean needsView = false;
        for (int i = 0; !needsView && i < insert.getVariables().size(); ++i) {
            SingleElementSymbol ses = (SingleElementSymbol)insert.getVariables().get(i);
            if (ses.getType() == insert.getQueryExpression().getProjectedSymbols().get(i).getType()) continue;
            needsView = true;
        }
        if (needsView) {
            try {
                insert.setQueryExpression(QueryRewriter.createInlineViewQuery(insert.getGroup(), insert.getQueryExpression(), this.metadata, insert.getVariables()));
            }
            catch (TeiidException err) {
                throw new TeiidRuntimeException((Throwable)err);
            }
        }
        return insert;
    }

    private void correctProjectedTypes(List actualSymbolTypes, Query query) {
        List symbols = query.getSelect().getProjectedSymbols();
        List newSymbols = SetQuery.getTypedProjectedSymbols(symbols, actualSymbolTypes, this.metadata);
        query.getSelect().setSymbols(newSymbols);
    }

    private SetQuery rewriteSetQuery(SetQuery setQuery) throws TeiidComponentException, TeiidProcessingException {
        if (setQuery.getProjectedTypes() != null) {
            for (QueryCommand command : setQuery.getQueryCommands()) {
                if (!(command instanceof Query)) continue;
                this.correctProjectedTypes(setQuery.getProjectedTypes(), (Query)command);
            }
            setQuery.setProjectedTypes(null, null);
        }
        setQuery.setLeftQuery((QueryCommand)this.rewriteCommand(setQuery.getLeftQuery(), true));
        setQuery.setRightQuery((QueryCommand)this.rewriteCommand(setQuery.getRightQuery(), true));
        this.rewriteOrderBy(setQuery);
        if (setQuery.getLimit() != null) {
            setQuery.setLimit(this.rewriteLimitClause(setQuery.getLimit()));
        }
        return setQuery;
    }

    private FromClause rewriteFromClause(Query parent, FromClause clause) throws TeiidComponentException, TeiidProcessingException {
        if (clause instanceof JoinPredicate) {
            return this.rewriteJoinPredicate(parent, (JoinPredicate)clause);
        }
        if (clause instanceof SubqueryFromClause) {
            this.rewriteSubqueryContainer((SubqueryFromClause)clause, true);
        } else if (clause instanceof TextTable) {
            TextTable tt = (TextTable)clause;
            tt.setFile(this.rewriteExpressionDirect(tt.getFile()));
        } else if (clause instanceof XMLTable) {
            XMLTable xt = (XMLTable)clause;
            xt.rewriteDefaultColumn();
            this.rewriteExpressions(clause);
        }
        return clause;
    }

    private JoinPredicate rewriteJoinPredicate(Query parent, JoinPredicate predicate) throws TeiidComponentException, TeiidProcessingException {
        List joinCrits = predicate.getJoinCriteria();
        if (joinCrits != null && joinCrits.size() > 0) {
            Criteria criteria = new CompoundCriteria(new ArrayList(joinCrits));
            joinCrits.clear();
            criteria = this.rewriteCriteria(criteria);
            if (criteria instanceof CompoundCriteria && ((CompoundCriteria)criteria).getOperator() == 0) {
                joinCrits.addAll(((CompoundCriteria)criteria).getCriteria());
            } else {
                joinCrits.add(criteria);
            }
            predicate.setJoinCriteria(joinCrits);
        }
        if (predicate.getJoinType() == JoinType.JOIN_UNION) {
            predicate.setJoinType(JoinType.JOIN_FULL_OUTER);
            predicate.setJoinCriteria(Arrays.asList(FALSE_CRITERIA));
        } else if (predicate.getJoinType() == JoinType.JOIN_RIGHT_OUTER) {
            predicate.setJoinType(JoinType.JOIN_LEFT_OUTER);
            FromClause leftClause = predicate.getLeftClause();
            predicate.setLeftClause(predicate.getRightClause());
            predicate.setRightClause(leftClause);
        }
        predicate.setLeftClause(this.rewriteFromClause(parent, predicate.getLeftClause()));
        predicate.setRightClause(this.rewriteFromClause(parent, predicate.getRightClause()));
        return predicate;
    }

    public static Criteria rewriteCriteria(Criteria criteria, CreateUpdateProcedureCommand procCommand, CommandContext context, QueryMetadataInterface metadata) throws TeiidComponentException, TeiidProcessingException {
        return new QueryRewriter(metadata, context, procCommand).rewriteCriteria(criteria);
    }

    private Criteria rewriteCriteria(Criteria criteria) throws TeiidComponentException, TeiidProcessingException {
        if (criteria instanceof CompoundCriteria) {
            return this.rewriteCriteria((CompoundCriteria)criteria, true);
        }
        if (criteria instanceof NotCriteria) {
            criteria = this.rewriteCriteria((NotCriteria)criteria);
        } else if (criteria instanceof CompareCriteria) {
            criteria = this.rewriteCriteria((CompareCriteria)criteria);
        } else if (criteria instanceof SubqueryCompareCriteria) {
            criteria = this.rewriteCriteria((SubqueryCompareCriteria)criteria);
        } else if (criteria instanceof MatchCriteria) {
            criteria = this.rewriteCriteria((MatchCriteria)criteria);
        } else if (criteria instanceof SetCriteria) {
            criteria = this.rewriteCriteria((SetCriteria)criteria);
        } else if (criteria instanceof IsNullCriteria) {
            criteria = this.rewriteCriteria((IsNullCriteria)criteria);
        } else if (criteria instanceof BetweenCriteria) {
            criteria = this.rewriteCriteria((BetweenCriteria)criteria);
        } else if (criteria instanceof HasCriteria) {
            criteria = this.rewriteCriteria((HasCriteria)criteria);
        } else if (criteria instanceof TranslateCriteria) {
            criteria = this.rewriteCriteria((TranslateCriteria)criteria);
        } else if (criteria instanceof ExistsCriteria) {
            this.rewriteSubqueryContainer((SubqueryContainer)((Object)criteria), true);
        } else if (criteria instanceof SubquerySetCriteria) {
            SubquerySetCriteria sub = (SubquerySetCriteria)criteria;
            if (QueryRewriter.isNull(sub.getExpression())) {
                return UNKNOWN_CRITERIA;
            }
            this.rewriteSubqueryContainer((SubqueryContainer)((Object)criteria), true);
        } else if (criteria instanceof DependentSetCriteria) {
            criteria = this.rewriteDependentSetCriteria((DependentSetCriteria)criteria);
        } else if (criteria instanceof ExpressionCriteria) {
            return new CompareCriteria(((ExpressionCriteria)criteria).getExpression(), 1, new Constant(Boolean.TRUE));
        }
        return this.evaluateCriteria(criteria);
    }

    private Criteria rewriteDependentSetCriteria(DependentSetCriteria dsc) throws TeiidComponentException, TeiidProcessingException {
        if (!this.processing) {
            return this.rewriteCriteria(dsc);
        }
        SetCriteria setCrit = new SetCriteria();
        setCrit.setExpression(dsc.getExpression());
        HashSet<Object> values = new HashSet<Object>();
        try {
            DependentValueSource dvs = (DependentValueSource)this.context.getVariableContext().getGlobalValue(dsc.getContextSymbol());
            ValueIterator iter = dvs.getValueIterator(dsc.getValueExpression());
            while (iter.hasNext()) {
                values.add(iter.next());
            }
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        ArrayList<Constant> constants = new ArrayList<Constant>(values.size());
        for (Object e : values) {
            constants.add(new Constant(e, setCrit.getExpression().getType()));
        }
        setCrit.setValues(constants);
        return this.rewriteCriteria(setCrit);
    }

    public static Criteria optimizeCriteria(CompoundCriteria criteria, QueryMetadataInterface metadata) {
        try {
            return new QueryRewriter(metadata, null, null).rewriteCriteria(criteria, false);
        }
        catch (TeiidException err) {
            return criteria;
        }
    }

    private Criteria rewriteCriteria(CompoundCriteria criteria, boolean rewrite) throws TeiidComponentException, TeiidProcessingException {
        List<Criteria> crits = criteria.getCriteria();
        int operator = criteria.getOperator();
        LinkedHashSet<Criteria> newCrits = new LinkedHashSet<Criteria>(crits.size());
        for (Criteria converted : crits) {
            CompoundCriteria other;
            if (rewrite) {
                converted = this.rewriteCriteria(converted);
            } else if (converted instanceof CompoundCriteria) {
                converted = this.rewriteCriteria((CompoundCriteria)converted, false);
            }
            if (converted == TRUE_CRITERIA) {
                if (operator != 1) continue;
                return converted;
            }
            if (converted == FALSE_CRITERIA) {
                if (operator != 0) continue;
                return converted;
            }
            if (converted == UNKNOWN_CRITERIA) {
                if (operator != 0) continue;
                return FALSE_CRITERIA;
            }
            if (converted instanceof CompoundCriteria && (other = (CompoundCriteria)converted).getOperator() == criteria.getOperator()) {
                newCrits.addAll(other.getCriteria());
                continue;
            }
            newCrits.add(converted);
        }
        if (newCrits.size() == 0) {
            if (operator == 0) {
                return TRUE_CRITERIA;
            }
            return FALSE_CRITERIA;
        }
        if (newCrits.size() == 1) {
            return (Criteria)newCrits.iterator().next();
        }
        criteria.getCriteria().clear();
        criteria.getCriteria().addAll(newCrits);
        return criteria;
    }

    private Criteria evaluateCriteria(Criteria crit) throws TeiidComponentException, TeiidProcessingException {
        if (EvaluatableVisitor.isFullyEvaluatable(crit, !this.processing)) {
            try {
                Boolean eval = this.evaluator.evaluateTVL(crit, Collections.emptyList());
                if (eval == null) {
                    return UNKNOWN_CRITERIA;
                }
                if (Boolean.TRUE.equals(eval)) {
                    return TRUE_CRITERIA;
                }
                return FALSE_CRITERIA;
            }
            catch (ExpressionEvaluationException e) {
                throw new QueryValidatorException((Throwable)((Object)e), "ERR.015.009.0001", QueryExecPlugin.Util.getString("ERR.015.009.0001", new Object[]{crit}));
            }
        }
        return crit;
    }

    private Criteria rewriteCriteria(NotCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Criteria innerCrit = criteria.getCriteria();
        if (innerCrit instanceof CompoundCriteria) {
            return this.rewriteCriteria(Criteria.toConjunctiveNormalForm(criteria));
        }
        if (innerCrit instanceof PredicateCriteria.Negatable) {
            ((PredicateCriteria.Negatable)((Object)innerCrit)).negate();
            return this.rewriteCriteria(innerCrit);
        }
        if (innerCrit instanceof NotCriteria) {
            return this.rewriteCriteria(((NotCriteria)innerCrit).getCriteria());
        }
        if ((innerCrit = this.rewriteCriteria(innerCrit)) == TRUE_CRITERIA) {
            return FALSE_CRITERIA;
        }
        if (innerCrit == FALSE_CRITERIA) {
            return TRUE_CRITERIA;
        }
        if (innerCrit == UNKNOWN_CRITERIA) {
            return UNKNOWN_CRITERIA;
        }
        criteria.setCriteria(innerCrit);
        return criteria;
    }

    private Criteria rewriteCriteria(BetweenCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        CompareCriteria lowerCriteria = new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 3 : 6, criteria.getLowerExpression());
        CompareCriteria upperCriteria = new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 4 : 5, criteria.getUpperExpression());
        CompoundCriteria newCriteria = new CompoundCriteria(criteria.isNegated() ? 1 : 0, lowerCriteria, upperCriteria);
        return this.rewriteCriteria(newCriteria);
    }

    private Criteria rewriteCriteria(CompareCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Expression leftExpr = this.rewriteExpressionDirect(criteria.getLeftExpression());
        Expression rightExpr = this.rewriteExpressionDirect(criteria.getRightExpression());
        criteria.setLeftExpression(leftExpr);
        criteria.setRightExpression(rightExpr);
        if (QueryRewriter.isNull(leftExpr) || QueryRewriter.isNull(rightExpr)) {
            return UNKNOWN_CRITERIA;
        }
        boolean rightConstant = false;
        if (EvaluatableVisitor.willBecomeConstant(rightExpr)) {
            rightConstant = true;
        } else if (EvaluatableVisitor.willBecomeConstant(leftExpr)) {
            criteria.setLeftExpression(rightExpr);
            criteria.setRightExpression(leftExpr);
            switch (criteria.getOperator()) {
                case 3: {
                    criteria.setOperator(4);
                    break;
                }
                case 5: {
                    criteria.setOperator(6);
                    break;
                }
                case 4: {
                    criteria.setOperator(3);
                    break;
                }
                case 6: {
                    criteria.setOperator(5);
                }
            }
            rightConstant = true;
        }
        Function f = null;
        while (rightConstant && f != criteria.getLeftExpression() && criteria.getLeftExpression() instanceof Function) {
            f = (Function)criteria.getLeftExpression();
            Criteria result = this.simplifyWithInverse(criteria);
            if (!(result instanceof CompareCriteria)) {
                return result;
            }
            criteria = (CompareCriteria)result;
        }
        Criteria modCriteria = this.simplifyTimestampMerge(criteria);
        if (modCriteria instanceof CompareCriteria) {
            modCriteria = this.simplifyTimestampMerge2((CompareCriteria)modCriteria);
        }
        return modCriteria;
    }

    public static boolean isNull(Expression expr) {
        return expr instanceof Constant && ((Constant)expr).isNull();
    }

    private Criteria rewriteCriteria(SubqueryCompareCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Expression leftExpr = this.rewriteExpressionDirect(criteria.getLeftExpression());
        if (QueryRewriter.isNull(leftExpr)) {
            return UNKNOWN_CRITERIA;
        }
        criteria.setLeftExpression(leftExpr);
        if (criteria.getPredicateQuantifier() == 3) {
            criteria.setPredicateQuantifier(2);
        }
        this.rewriteSubqueryContainer(criteria, true);
        return criteria;
    }

    private Criteria simplifyWithInverse(CompareCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Expression leftExpr = criteria.getLeftExpression();
        Function leftFunction = (Function)leftExpr;
        if (this.isSimpleMathematicalFunction(leftFunction)) {
            return this.simplifyMathematicalCriteria(criteria);
        }
        if (FunctionLibrary.isConvert(leftFunction)) {
            return this.simplifyConvertFunction(criteria);
        }
        return this.simplifyParseFormatFunction(criteria);
    }

    private boolean isSimpleMathematicalFunction(Function function) {
        Expression[] args;
        String funcName = function.getName();
        return !(!funcName.equals("+") && !funcName.equals("-") && !funcName.equals("*") && !funcName.equals("/") || !((args = function.getArgs())[0] instanceof Constant) && !(args[1] instanceof Constant));
    }

    private CompareCriteria simplifyMathematicalCriteria(CompareCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Object value;
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function function = (Function)leftExpr;
        String funcName = function.getName();
        Expression[] args = function.getArgs();
        Constant const1 = null;
        Expression expr = null;
        if (args[1] instanceof Constant) {
            const1 = (Constant)args[1];
            expr = args[0];
        } else if (funcName.equals("+") || funcName.equals("*")) {
            const1 = (Constant)args[0];
            expr = args[1];
        } else {
            return criteria;
        }
        int operator = criteria.getOperator();
        String oppFunc = null;
        switch (funcName.charAt(0)) {
            case '+': {
                oppFunc = "-";
                break;
            }
            case '-': {
                oppFunc = "+";
                break;
            }
            case '*': {
                oppFunc = "/";
                break;
            }
            case '/': {
                oppFunc = "*";
            }
        }
        Expression combinedConst = null;
        FunctionLibrary funcLib = this.metadata.getFunctionLibrary();
        FunctionDescriptor descriptor = funcLib.findFunction(oppFunc, new Class[]{rightExpr.getType(), const1.getType()});
        if (descriptor == null) {
            return criteria;
        }
        if (rightExpr instanceof Constant) {
            Constant const2 = (Constant)rightExpr;
            try {
                Object result = descriptor.invokeFunction(new Object[]{const2.getValue(), const1.getValue()});
                combinedConst = new Constant(result, descriptor.getReturnType());
            }
            catch (FunctionExecutionException e) {
                throw new QueryValidatorException((Throwable)((Object)e), "ERR.015.009.0003", QueryExecPlugin.Util.getString("ERR.015.009.0003", new Object[]{e.getMessage()}));
            }
        } else {
            Function conversion = new Function(descriptor.getName(), new Expression[]{rightExpr, const1});
            conversion.setType(leftExpr.getType());
            conversion.setFunctionDescriptor(descriptor);
            combinedConst = conversion;
        }
        if (operator != 1 && operator != 2 && (oppFunc.equals("*") || oppFunc.equals("/")) && (value = const1.getValue()) != null) {
            Class<?> type = const1.getType();
            Number comparisonObject = null;
            if (type.equals(DataTypeManager.DefaultDataClasses.INTEGER)) {
                comparisonObject = this.INTEGER_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.DOUBLE)) {
                comparisonObject = this.DOUBLE_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.FLOAT)) {
                comparisonObject = this.FLOAT_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.LONG)) {
                comparisonObject = this.LONG_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER)) {
                comparisonObject = this.BIG_INTEGER_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL)) {
                comparisonObject = this.BIG_DECIMAL_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.SHORT)) {
                comparisonObject = this.SHORT_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BYTE)) {
                comparisonObject = this.BYTE_ZERO;
            } else {
                return criteria;
            }
            if (comparisonObject.compareTo(value) > 0) {
                switch (operator) {
                    case 5: {
                        operator = 6;
                        break;
                    }
                    case 3: {
                        operator = 4;
                        break;
                    }
                    case 6: {
                        operator = 5;
                        break;
                    }
                    case 4: {
                        operator = 3;
                    }
                }
            }
        }
        criteria.setLeftExpression(expr);
        criteria.setRightExpression(combinedConst);
        criteria.setOperator(operator);
        return criteria;
    }

    private Criteria simplifyConvertFunction(CompareCriteria crit) throws TeiidComponentException, TeiidProcessingException {
        Function leftFunction = (Function)crit.getLeftExpression();
        Expression leftExpr = leftFunction.getArgs()[0];
        if (!(crit.getRightExpression() instanceof Constant) || crit.getOperator() != 1 && crit.getOperator() != 2) {
            return crit;
        }
        Constant rightConstant = (Constant)crit.getRightExpression();
        String leftExprTypeName = DataTypeManager.getDataTypeName((Class)leftExpr.getType());
        Constant result = ResolverUtil.convertConstant(DataTypeManager.getDataTypeName(rightConstant.getType()), leftExprTypeName, rightConstant);
        if (result == null) {
            return this.getSimpliedCriteria(crit, leftExpr, crit.getOperator() != 1, true);
        }
        Constant other = ResolverUtil.convertConstant(leftExprTypeName, DataTypeManager.getDataTypeName(rightConstant.getType()), result);
        if (other == null || ((Comparable)rightConstant.getValue()).compareTo(other.getValue()) != 0) {
            return this.getSimpliedCriteria(crit, leftExpr, crit.getOperator() != 1, true);
        }
        if (!DataTypeManager.isImplicitConversion((String)leftExprTypeName, (String)DataTypeManager.getDataTypeName(rightConstant.getType()))) {
            return crit;
        }
        crit.setRightExpression(result);
        crit.setLeftExpression(leftExpr);
        return crit;
    }

    private Criteria simplifyConvertFunction(SetCriteria crit) throws TeiidComponentException, TeiidProcessingException {
        Function leftFunction = (Function)crit.getExpression();
        Expression leftExpr = leftFunction.getArgs()[0];
        String leftExprTypeName = DataTypeManager.getDataTypeName((Class)leftExpr.getType());
        Iterator i = crit.getValues().iterator();
        ArrayList<Constant> newValues = new ArrayList<Constant>(crit.getNumberOfValues());
        boolean convertedAll = true;
        boolean removedSome = false;
        while (i.hasNext()) {
            Constant other;
            Object next = i.next();
            if (!(next instanceof Constant)) {
                convertedAll = false;
                continue;
            }
            Constant rightConstant = (Constant)next;
            Constant result = ResolverUtil.convertConstant(DataTypeManager.getDataTypeName(rightConstant.getType()), leftExprTypeName, rightConstant);
            if (result != null && ((other = ResolverUtil.convertConstant(leftExprTypeName, DataTypeManager.getDataTypeName(rightConstant.getType()), result)) == null || ((Comparable)rightConstant.getValue()).compareTo(other.getValue()) != 0)) {
                result = null;
            }
            if (result == null) {
                removedSome = true;
                i.remove();
                continue;
            }
            if (DataTypeManager.isImplicitConversion((String)leftExprTypeName, (String)DataTypeManager.getDataTypeName(rightConstant.getType()))) {
                newValues.add(result);
                continue;
            }
            convertedAll = false;
        }
        if (!convertedAll) {
            if (!removedSome) {
                return crit;
            }
        } else {
            if (newValues.isEmpty()) {
                return this.getSimpliedCriteria(crit, leftExpr, !crit.isNegated(), true);
            }
            crit.setExpression(leftExpr);
            crit.setValues(newValues);
        }
        return this.rewriteCriteria(crit);
    }

    private Criteria simplifyParseFormatFunction(CompareCriteria crit) throws TeiidComponentException, TeiidProcessingException {
        String type;
        if (crit.getOperator() != 1 && crit.getOperator() != 2) {
            return crit;
        }
        boolean isFormat = false;
        Function leftFunction = (Function)crit.getLeftExpression();
        String funcName = leftFunction.getName().toLowerCase();
        String inverseFunction = null;
        if (funcName.startsWith("parse")) {
            type = funcName.substring(5);
            inverseFunction = "format" + type;
        } else if (funcName.startsWith("format")) {
            type = funcName.substring(6);
            inverseFunction = "parse" + type;
            isFormat = true;
        } else {
            return crit;
        }
        Expression rightExpr = crit.getRightExpression();
        if (!(rightExpr instanceof Constant)) {
            return crit;
        }
        Expression leftExpr = leftFunction.getArgs()[0];
        Expression formatExpr = leftFunction.getArgs()[1];
        if (!(formatExpr instanceof Constant)) {
            return crit;
        }
        String format = (String)((Constant)formatExpr).getValue();
        FunctionLibrary funcLib = this.metadata.getFunctionLibrary();
        FunctionDescriptor descriptor = funcLib.findFunction(inverseFunction, new Class[]{rightExpr.getType(), formatExpr.getType()});
        if (descriptor == null) {
            return crit;
        }
        Object value = ((Constant)rightExpr).getValue();
        try {
            Object result = descriptor.invokeFunction(new Object[]{((Constant)rightExpr).getValue(), format});
            result = leftFunction.getFunctionDescriptor().invokeFunction(new Object[]{result, format});
            if (((Comparable)value).compareTo(result) != 0) {
                return this.getSimpliedCriteria(crit, leftExpr, crit.getOperator() != 1, true);
            }
        }
        catch (FunctionExecutionException e) {
            return crit;
        }
        if (!isFormat) {
            return crit;
        }
        return crit;
    }

    private Criteria simplifyTimestampMerge2(CompareCriteria criteria) {
        if (criteria.getOperator() != 1) {
            return criteria;
        }
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function tsCreateFunction = null;
        Constant timestampConstant = null;
        if (!(leftExpr instanceof Function) || !(rightExpr instanceof Constant)) {
            return criteria;
        }
        tsCreateFunction = (Function)leftExpr;
        timestampConstant = (Constant)rightExpr;
        if (!timestampConstant.getType().equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            return criteria;
        }
        if (!tsCreateFunction.getName().equalsIgnoreCase("timestampCreate")) {
            return criteria;
        }
        Timestamp ts = (Timestamp)timestampConstant.getValue();
        String tsStr = ts.toString();
        java.sql.Date date = java.sql.Date.valueOf(tsStr.substring(0, 10));
        Time time = Time.valueOf(tsStr.substring(11, 19));
        Expression[] args = tsCreateFunction.getArgs();
        CompareCriteria dateCrit = new CompareCriteria(args[0], 1, new Constant(date, DataTypeManager.DefaultDataClasses.DATE));
        CompareCriteria timeCrit = new CompareCriteria(args[1], 1, new Constant(time, DataTypeManager.DefaultDataClasses.TIME));
        CompoundCriteria compCrit = new CompoundCriteria(0, dateCrit, timeCrit);
        return compCrit;
    }

    private Criteria simplifyTimestampMerge(CompareCriteria criteria) {
        if (criteria.getOperator() != 1) {
            return criteria;
        }
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function concatFunction = null;
        Constant timestampConstant = null;
        if (!(leftExpr instanceof Function) || !(rightExpr instanceof Constant)) {
            return criteria;
        }
        concatFunction = (Function)leftExpr;
        timestampConstant = (Constant)rightExpr;
        if (!timestampConstant.getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
            return criteria;
        }
        if (!concatFunction.getName().equalsIgnoreCase("concat") && !concatFunction.getName().equals("||")) {
            return criteria;
        }
        Expression[] args = concatFunction.getArgs();
        if (!(args[0] instanceof Function) || !(args[1] instanceof Function)) {
            return criteria;
        }
        Function formatDateFunction = (Function)args[0];
        Function formatTimeFunction = (Function)args[1];
        if (!formatDateFunction.getName().equalsIgnoreCase("formatdate") || !formatTimeFunction.getName().equalsIgnoreCase("formattime")) {
            return criteria;
        }
        if (!(formatDateFunction.getArgs()[1] instanceof Constant) || !(formatTimeFunction.getArgs()[1] instanceof Constant)) {
            return criteria;
        }
        String dateFormat = (String)((Constant)formatDateFunction.getArgs()[1]).getValue();
        String timeFormat = (String)((Constant)formatTimeFunction.getArgs()[1]).getValue();
        String timestampValue = (String)timestampConstant.getValue();
        try {
            Timestamp ts = FunctionMethods.parseTimestamp(timestampValue, dateFormat + timeFormat);
            Constant dateConstant = new Constant(TimestampWithTimezone.createDate((Date)ts));
            CompareCriteria dateCompare = new CompareCriteria(formatDateFunction.getArgs()[0], 1, dateConstant);
            Constant timeConstant = new Constant(TimestampWithTimezone.createTime((Date)ts));
            CompareCriteria timeCompare = new CompareCriteria(formatTimeFunction.getArgs()[0], 1, timeConstant);
            CompoundCriteria compCrit = new CompoundCriteria(0, dateCompare, timeCompare);
            return compCrit;
        }
        catch (FunctionExecutionException e) {
            return criteria;
        }
    }

    private Criteria rewriteCriteria(MatchCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        criteria.setLeftExpression(this.rewriteExpressionDirect(criteria.getLeftExpression()));
        criteria.setRightExpression(this.rewriteExpressionDirect(criteria.getRightExpression()));
        if (QueryRewriter.isNull(criteria.getLeftExpression()) || QueryRewriter.isNull(criteria.getRightExpression())) {
            return UNKNOWN_CRITERIA;
        }
        Expression rightExpr = criteria.getRightExpression();
        if (rightExpr instanceof Constant && rightExpr.getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
            Constant constant = (Constant)rightExpr;
            String value = (String)constant.getValue();
            char escape = criteria.getEscapeChar();
            if (escape != '\u0000' && value.indexOf(escape) < 0) {
                criteria.setEscapeChar('\u0000');
            }
            if (value.equals(String.valueOf('%'))) {
                return this.getSimpliedCriteria(criteria, criteria.getLeftExpression(), !criteria.isNegated(), true);
            }
            if (DataTypeManager.DefaultDataClasses.STRING.equals(criteria.getLeftExpression().getType()) && value.indexOf(escape) < 0 && value.indexOf(95) < 0 && value.indexOf(37) < 0) {
                return this.rewriteCriteria(new CompareCriteria(criteria.getLeftExpression(), criteria.isNegated() ? 2 : 1, criteria.getRightExpression()));
            }
        }
        return criteria;
    }

    private Criteria getSimpliedCriteria(Criteria crit, Expression a, boolean outcome, boolean nullPossible) {
        if (nullPossible) {
            if (outcome) {
                if (this.processing) {
                    return crit;
                }
                IsNullCriteria inc = new IsNullCriteria(a);
                inc.setNegated(true);
                return inc;
            }
        } else if (outcome) {
            return TRUE_CRITERIA;
        }
        return FALSE_CRITERIA;
    }

    private Criteria rewriteCriteria(AbstractSetCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        criteria.setExpression(this.rewriteExpressionDirect(criteria.getExpression()));
        if (QueryRewriter.isNull(criteria.getExpression())) {
            return UNKNOWN_CRITERIA;
        }
        return criteria;
    }

    private Criteria rewriteCriteria(SetCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Function leftFunction;
        if (criteria.isAllConstants() && criteria.getValues().size() > 1) {
            return criteria;
        }
        criteria.setExpression(this.rewriteExpressionDirect(criteria.getExpression()));
        if (QueryRewriter.isNull(criteria.getExpression())) {
            return UNKNOWN_CRITERIA;
        }
        Collection vals = criteria.getValues();
        LinkedHashSet<Expression> newVals = new LinkedHashSet<Expression>(vals.size());
        Iterator valIter = vals.iterator();
        boolean allConstants = true;
        boolean hasNull = false;
        while (valIter.hasNext()) {
            Expression value = this.rewriteExpressionDirect((Expression)valIter.next());
            if (QueryRewriter.isNull(value)) {
                hasNull = true;
                continue;
            }
            allConstants &= value instanceof Constant;
            newVals.add(value);
        }
        int size = newVals.size();
        if (size == 1) {
            Expression value = (Expression)newVals.iterator().next();
            return this.rewriteCriteria(new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 2 : 1, value));
        }
        criteria.setValues(newVals);
        if (allConstants) {
            criteria.setAllConstants(true);
            criteria.setValues(new TreeSet(newVals));
        }
        if (size == 0) {
            if (hasNull) {
                return UNKNOWN_CRITERIA;
            }
            return this.getSimpliedCriteria(criteria, criteria.getExpression(), !criteria.isNegated(), true);
        }
        if (criteria.getExpression() instanceof Function && FunctionLibrary.isConvert(leftFunction = (Function)criteria.getExpression())) {
            return this.simplifyConvertFunction(criteria);
        }
        return criteria;
    }

    private Criteria rewriteCriteria(IsNullCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        criteria.setExpression(this.rewriteExpressionDirect(criteria.getExpression()));
        return criteria;
    }

    public static Expression rewriteExpression(Expression expression, CreateUpdateProcedureCommand procCommand, CommandContext context, QueryMetadataInterface metadata) throws TeiidComponentException, TeiidProcessingException {
        return new QueryRewriter(metadata, context, procCommand).rewriteExpressionDirect(expression);
    }

    private Expression rewriteExpressionDirect(Expression expression) throws TeiidComponentException, TeiidProcessingException {
        if (expression instanceof Constant) {
            return expression;
        }
        if (expression instanceof ElementSymbol) {
            ElementSymbol es = (ElementSymbol)expression;
            Class type = es.getType();
            if (!this.processing && es.isExternalReference()) {
                String grpName = es.getGroupSymbol().getCanonicalName();
                if (this.variables == null) {
                    return new Reference(es);
                }
                Expression value = (Expression)this.variables.get(es.getCanonicalName());
                if (value == null) {
                    if (grpName.equals("INPUTS")) {
                        return new Constant(null, es.getType());
                    }
                    if (grpName.equals("CHANGING")) {
                        Assertion.failed((String)"Changing value should not be null");
                    }
                } else if (value instanceof Constant) {
                    if (value.getType() == type) {
                        return value;
                    }
                    try {
                        return new Constant(FunctionMethods.convert(((Constant)value).getValue(), DataTypeManager.getDataTypeName((Class)type)), es.getType());
                    }
                    catch (FunctionExecutionException e) {
                        throw new QueryValidatorException((Throwable)((Object)e), e.getMessage());
                    }
                }
                return new Reference(es);
            }
            return expression;
        }
        if (expression instanceof Function) {
            expression = this.rewriteFunction((Function)expression);
        } else if (expression instanceof CaseExpression) {
            expression = this.rewriteCaseExpression((CaseExpression)expression);
        } else if (expression instanceof SearchedCaseExpression) {
            expression = this.rewriteCaseExpression((SearchedCaseExpression)expression);
        } else {
            if (expression instanceof ScalarSubquery) {
                ScalarSubquery subquery = (ScalarSubquery)expression;
                if (subquery.shouldEvaluate() && this.processing) {
                    return new Constant(this.evaluator.evaluate((Expression)subquery, null), subquery.getType());
                }
                this.rewriteSubqueryContainer(subquery, true);
                return expression;
            }
            if (expression instanceof ExpressionSymbol) {
                expression = expression instanceof AggregateSymbol ? this.rewriteExpression((AggregateSymbol)expression) : this.rewriteExpressionDirect(((ExpressionSymbol)expression).getExpression());
            } else if (expression instanceof Criteria) {
                expression = this.rewriteCriteria((Criteria)expression);
            } else {
                this.rewriteExpressions(expression);
            }
        }
        if (!this.processing ? !EvaluatableVisitor.isFullyEvaluatable(expression, true) : !(expression instanceof Reference) && !EvaluatableVisitor.isEvaluatable(expression, EvaluatableVisitor.EvaluationLevel.PROCESSING)) {
            return expression;
        }
        Object value = this.evaluator.evaluate(expression, Collections.emptyList());
        if (value instanceof Constant) {
            return (Constant)value;
        }
        return new Constant(value, expression.getType());
    }

    private Expression rewriteExpression(AggregateSymbol expression) {
        if (expression.isBoolean()) {
            if (expression.getAggregateFunction() == AggregateSymbol.Type.EVERY) {
                expression.setAggregateFunction(AggregateSymbol.Type.MIN);
            } else {
                expression.setAggregateFunction(AggregateSymbol.Type.MAX);
            }
        }
        if ((expression.getAggregateFunction() == AggregateSymbol.Type.MAX || expression.getAggregateFunction() == AggregateSymbol.Type.MIN) && EvaluatableVisitor.willBecomeConstant(expression.getExpression())) {
            try {
                return new ExpressionSymbol(expression.getName(), ResolverUtil.convertExpression(expression.getExpression(), DataTypeManager.getDataTypeName(expression.getType()), this.metadata));
            }
            catch (QueryResolverException e) {
                throw new TeiidRuntimeException((Throwable)((Object)e));
            }
        }
        return expression;
    }

    private Expression rewriteFunction(Function function) throws TeiidComponentException, TeiidProcessingException {
        Expression[] args;
        String functionLowerName = function.getName().toLowerCase();
        String actualName = ALIASED_FUNCTIONS.get(functionLowerName);
        if (actualName != null) {
            function.setName(actualName);
        }
        FunctionLibrary funcLibrary = this.metadata.getFunctionLibrary();
        Integer code = FUNCTION_MAP.get(functionLowerName);
        if (code != null) {
            switch (code) {
                case 0: {
                    Function result = new Function("repeat", new Expression[]{new Constant(" "), function.getArg(0)});
                    FunctionDescriptor descriptor = funcLibrary.findFunction("repeat", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER});
                    result.setFunctionDescriptor(descriptor);
                    result.setType(DataTypeManager.DefaultDataClasses.STRING);
                    function = result;
                    break;
                }
                case 1: {
                    Function result = new Function("timestampadd", new Expression[]{new Constant("SQL_TSI_SECOND"), function.getArg(0), new Constant(new Timestamp(0L))});
                    FunctionDescriptor descriptor = funcLibrary.findFunction("timestampadd", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.TIMESTAMP});
                    result.setFunctionDescriptor(descriptor);
                    result.setType(DataTypeManager.DefaultDataClasses.TIMESTAMP);
                    function = result;
                    break;
                }
                case 2: {
                    List<Criteria> when = Arrays.asList(new CompareCriteria(function.getArg(0), 1, function.getArg(1)));
                    Constant nullConstant = new Constant(null, function.getType());
                    List<Expression> then = Arrays.asList(nullConstant);
                    SearchedCaseExpression caseExpr = new SearchedCaseExpression(when, then);
                    caseExpr.setElseExpression(function.getArg(0));
                    caseExpr.setType(function.getType());
                    return this.rewriteExpressionDirect(caseExpr);
                }
                case 3: {
                    args = function.getArgs();
                    if (args.length != 2) break;
                    Function result = new Function("ifnull", new Expression[]{function.getArg(0), function.getArg(1)});
                    FunctionDescriptor descriptor = funcLibrary.findFunction("ifnull", new Class[]{function.getType(), function.getType()});
                    result.setFunctionDescriptor(descriptor);
                    result.setType(function.getType());
                    function = result;
                    break;
                }
                case 4: {
                    FunctionDescriptor descriptor;
                    Expression[] args2 = function.getArgs();
                    Expression[] newArgs = new Function[args2.length];
                    for (int i = 0; i < args2.length; ++i) {
                        newArgs[i] = new Function("ifnull", new Expression[]{args2[i], new Constant("")});
                        ((Function)newArgs[i]).setType(args2[i].getType());
                        Assertion.assertTrue((args2[i].getType() == DataTypeManager.DefaultDataClasses.STRING ? 1 : 0) != 0);
                        descriptor = funcLibrary.findFunction("ifnull", new Class[]{args2[i].getType(), DataTypeManager.DefaultDataClasses.STRING});
                        ((Function)newArgs[i]).setFunctionDescriptor(descriptor);
                    }
                    Function concat = new Function("concat", newArgs);
                    concat.setType(DataTypeManager.DefaultDataClasses.STRING);
                    descriptor = funcLibrary.findFunction("concat", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
                    concat.setFunctionDescriptor(descriptor);
                    List<Criteria> when = Arrays.asList(new CompoundCriteria(0, new IsNullCriteria(args2[0]), new IsNullCriteria(args2[1])));
                    Constant nullConstant = new Constant(null, DataTypeManager.DefaultDataClasses.STRING);
                    List<Expression> then = Arrays.asList(nullConstant);
                    SearchedCaseExpression caseExpr = new SearchedCaseExpression(when, then);
                    caseExpr.setElseExpression(concat);
                    caseExpr.setType(DataTypeManager.DefaultDataClasses.STRING);
                    return this.rewriteExpressionDirect(caseExpr);
                }
                case 5: {
                    if (function.getType() == DataTypeManager.DefaultDataClasses.TIMESTAMP) break;
                    FunctionDescriptor descriptor = funcLibrary.findFunction("timestampadd", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.TIMESTAMP});
                    function.setFunctionDescriptor(descriptor);
                    Class type = function.getType();
                    function.setType(DataTypeManager.DefaultDataClasses.TIMESTAMP);
                    function.getArgs()[2] = ResolverUtil.getConversion(function.getArg(2), DataTypeManager.getDataTypeName((Class)type), "timestamp", false, funcLibrary);
                    function = ResolverUtil.getConversion(function, "timestamp", DataTypeManager.getDataTypeName((Class)type), false, funcLibrary);
                    break;
                }
                case 6: 
                case 7: {
                    FunctionDescriptor descriptor = funcLibrary.findFunction("parsetimestamp", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
                    function.setName("parsetimestamp");
                    function.setFunctionDescriptor(descriptor);
                    Class type = function.getType();
                    function.setType(DataTypeManager.DefaultDataClasses.TIMESTAMP);
                    function = ResolverUtil.getConversion(function, "timestamp", DataTypeManager.getDataTypeName((Class)type), false, funcLibrary);
                    break;
                }
                case 8: 
                case 9: {
                    FunctionDescriptor descriptor = funcLibrary.findFunction("formattimestamp", new Class[]{DataTypeManager.DefaultDataClasses.TIMESTAMP, DataTypeManager.DefaultDataClasses.STRING});
                    function.setName("formattimestamp");
                    function.setFunctionDescriptor(descriptor);
                    function.getArgs()[0] = ResolverUtil.getConversion(function.getArg(0), DataTypeManager.getDataTypeName((Class)function.getArg(0).getType()), "timestamp", false, funcLibrary);
                    break;
                }
            }
        }
        args = function.getArgs();
        Expression[] newArgs = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = this.rewriteExpressionDirect(args[i]);
            if (!QueryRewriter.isNull(newArgs[i]) || function.getFunctionDescriptor().isNullDependent()) continue;
            return new Constant(null, function.getType());
        }
        function.setArgs(newArgs);
        if (FunctionLibrary.isConvert(function) && newArgs[1] instanceof Constant) {
            Class srcType = newArgs[0].getType();
            String tgtTypeName = (String)((Constant)newArgs[1]).getValue();
            Class tgtType = DataTypeManager.getDataTypeClass((String)tgtTypeName);
            if (srcType != null && tgtType != null && srcType.equals(tgtType)) {
                return newArgs[0];
            }
        }
        if (function.getName().equalsIgnoreCase("decodestring") || function.getName().equalsIgnoreCase("decodeinteger")) {
            return this.convertDecodeFunction(function);
        }
        return function;
    }

    private Expression convertDecodeFunction(Function function) {
        Expression[] exprs = function.getArgs();
        String decodeString = (String)((Constant)exprs[1]).getValue();
        String decodeDelimiter = ",";
        if (exprs.length == 3) {
            decodeDelimiter = (String)((Constant)exprs[2]).getValue();
        }
        ArrayList<IsNullCriteria> newWhens = new ArrayList<IsNullCriteria>();
        ArrayList<Constant> newThens = new ArrayList<Constant>();
        Constant elseConst = null;
        StringTokenizer tokenizer = new StringTokenizer(decodeString, decodeDelimiter);
        while (tokenizer.hasMoreTokens()) {
            String compareString = QueryRewriter.convertString(tokenizer.nextToken().trim());
            if (tokenizer.hasMoreTokens()) {
                String resultString = QueryRewriter.convertString(tokenizer.nextToken().trim());
                PredicateCriteria crit = compareString == null ? new IsNullCriteria((Expression)exprs[0].clone()) : new CompareCriteria((Expression)exprs[0].clone(), 1, new Constant(compareString));
                newWhens.add((IsNullCriteria)crit);
                newThens.add(new Constant(resultString));
                continue;
            }
            elseConst = new Constant(compareString);
        }
        SearchedCaseExpression newCaseExpr = new SearchedCaseExpression(newWhens, newThens);
        if (elseConst != null) {
            newCaseExpr.setElseExpression(elseConst);
        } else {
            newCaseExpr.setElseExpression(exprs[0]);
        }
        newCaseExpr.setType(function.getType());
        return newCaseExpr;
    }

    private static String convertString(String string) {
        if (string.equals("")) {
            return null;
        }
        if (string.equalsIgnoreCase("null")) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            if (string.length() == 2) {
                string = "";
            } else if (!string.equalsIgnoreCase("'") && !string.equalsIgnoreCase("\"")) {
                string = string.substring(1);
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private Expression rewriteCaseExpression(CaseExpression expr) throws TeiidComponentException, TeiidProcessingException {
        ArrayList<CompareCriteria> whens = new ArrayList<CompareCriteria>(expr.getWhenCount());
        for (Expression expression : expr.getWhen()) {
            whens.add(new CompareCriteria((Expression)expr.getExpression().clone(), 1, expression));
        }
        SearchedCaseExpression sce = new SearchedCaseExpression(whens, expr.getThen());
        sce.setElseExpression(expr.getElseExpression());
        sce.setType(expr.getType());
        return this.rewriteCaseExpression(sce);
    }

    private Expression rewriteCaseExpression(SearchedCaseExpression expr) throws TeiidComponentException, TeiidProcessingException {
        int whenCount = expr.getWhenCount();
        ArrayList<Criteria> whens = new ArrayList<Criteria>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            Criteria rewrittenWhen = this.rewriteCriteria(expr.getWhenCriteria(i));
            if (rewrittenWhen == TRUE_CRITERIA) {
                return this.rewriteExpressionDirect(expr.getThenExpression(i));
            }
            if (rewrittenWhen == FALSE_CRITERIA || rewrittenWhen == UNKNOWN_CRITERIA) continue;
            whens.add(rewrittenWhen);
            thens.add(this.rewriteExpressionDirect(expr.getThenExpression(i)));
        }
        if (expr.getElseExpression() != null) {
            expr.setElseExpression(this.rewriteExpressionDirect(expr.getElseExpression()));
        }
        Expression elseExpr = expr.getElseExpression();
        if (whens.size() == 0) {
            if (elseExpr == null) {
                return new Constant(null, expr.getType());
            }
            return elseExpr;
        }
        expr.setWhen(whens, thens);
        if (elseExpr != null) {
            boolean bAllMatch = true;
            for (int i = 0; i < whenCount; ++i) {
                if (((Expression)thens.get(i)).equals(elseExpr)) continue;
                bAllMatch = false;
                break;
            }
            if (bAllMatch) {
                return elseExpr;
            }
        }
        return expr;
    }

    private Command rewriteExec(StoredProcedure storedProcedure) throws TeiidComponentException, TeiidProcessingException {
        storedProcedure.setDisplayNamedParameters(false);
        for (SPParameter param : storedProcedure.getInputParameters()) {
            param.setExpression(this.rewriteExpressionDirect(param.getExpression()));
        }
        return storedProcedure;
    }

    private Insert rewriteInsert(Insert insert) throws TeiidComponentException, TeiidProcessingException {
        if (insert.getQueryExpression() != null) {
            insert.setQueryExpression((QueryCommand)this.rewriteCommand(insert.getQueryExpression(), true));
            return this.correctDatatypes(insert);
        }
        List expressions = insert.getValues();
        ArrayList<Expression> evalExpressions = new ArrayList<Expression>(expressions.size());
        for (Expression exp : expressions) {
            evalExpressions.add(this.rewriteExpressionDirect(exp));
        }
        insert.setValues(evalExpressions);
        return insert;
    }

    public static Query createInlineViewQuery(GroupSymbol group, Command nested, QueryMetadataInterface metadata, List<SingleElementSymbol> actualSymbols) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Query query = new Query();
        Select select = new Select();
        query.setSelect(select);
        From from = new From();
        GroupSymbol inlineGroup = new GroupSymbol(group.getName().replace('.', '_') + "_1");
        from.addClause(new UnaryFromClause(inlineGroup));
        TempMetadataStore store = new TempMetadataStore();
        TempMetadataAdapter tma = new TempMetadataAdapter(metadata, store);
        if (nested instanceof QueryCommand) {
            Query firstProject = ((QueryCommand)nested).getProjectedQuery();
            QueryRewriter.makeSelectUnique(firstProject.getSelect(), false);
        }
        store.addTempGroup(inlineGroup.getName(), nested.getProjectedSymbols());
        inlineGroup.setMetadataID(store.getTempGroupID(inlineGroup.getName()));
        ArrayList<Class> actualTypes = new ArrayList<Class>(nested.getProjectedSymbols().size());
        for (SingleElementSymbol ses : actualSymbols) {
            actualTypes.add(ses.getType());
        }
        List selectSymbols = SetQuery.getTypedProjectedSymbols(ResolverUtil.resolveElementsInGroup(inlineGroup, tma), actualTypes, tma);
        Iterator<SingleElementSymbol> iter = actualSymbols.iterator();
        for (SingleElementSymbol ses : selectSymbols) {
            ses = (SingleElementSymbol)ses.clone();
            SingleElementSymbol actual = iter.next();
            if (!ses.getShortCanonicalName().equals(actual.getShortCanonicalName())) {
                if (ses instanceof AliasSymbol) {
                    ((AliasSymbol)ses).setName(actual.getShortName());
                } else {
                    ses = new AliasSymbol(actual.getShortName(), ses);
                }
            }
            select.addSymbol(ses);
        }
        query.setFrom(from);
        QueryResolver.resolveCommand(query, tma);
        query.setOption(nested.getOption());
        from.getClauses().clear();
        SubqueryFromClause sqfc = new SubqueryFromClause(inlineGroup.getName());
        sqfc.setCommand(nested);
        sqfc.getGroupSymbol().setMetadataID(inlineGroup.getMetadataID());
        from.addClause(sqfc);
        query.getTemporaryMetadata().putAll(store.getData());
        return query;
    }

    public static void makeSelectUnique(Select select, boolean expressionSymbolsOnly) {
        select.setSymbols(select.getProjectedSymbols());
        List symbols = select.getSymbols();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (int i = 0; i < symbols.size(); ++i) {
            String baseName;
            SingleElementSymbol symbol = (SingleElementSymbol)symbols.get(i);
            String name = baseName = symbol.getShortCanonicalName();
            int exprID = 0;
            while (!uniqueNames.add(name)) {
                name = baseName + '_' + exprID++;
            }
            if (expressionSymbolsOnly && !(symbol instanceof ExpressionSymbol)) continue;
            boolean hasAlias = false;
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
                hasAlias = true;
            }
            if ((!(symbol instanceof ExpressionSymbol) || hasAlias) && name.equalsIgnoreCase(baseName)) continue;
            symbols.set(i, new AliasSymbol(name, symbol));
        }
    }

    private Update rewriteUpdate(Update update) throws TeiidComponentException, TeiidProcessingException {
        if (this.commandType == 3 && this.variables != null) {
            SetClauseList newChangeList = new SetClauseList();
            for (SetClause entry : update.getChangeList().getClauses()) {
                Expression rightExpr = entry.getValue();
                boolean retainChange = this.checkInputVariables(rightExpr);
                if (!retainChange) continue;
                newChangeList.addClause(entry.getSymbol(), entry.getValue());
            }
            update.setChangeList(newChangeList);
        }
        for (SetClause entry : update.getChangeList().getClauses()) {
            entry.setValue(this.rewriteExpressionDirect(entry.getValue()));
        }
        Criteria crit = update.getCriteria();
        if (crit != null) {
            update.setCriteria(this.rewriteCriteria(crit));
        }
        return update;
    }

    private boolean checkInputVariables(Expression expr) throws TeiidComponentException, TeiidProcessingException {
        Boolean result = null;
        for (ElementSymbol var : ElementCollectorVisitor.getElements((LanguageObject)expr, false)) {
            String grpName = var.getGroupSymbol().getName();
            if (!var.isExternalReference() || !grpName.equalsIgnoreCase("INPUTS")) continue;
            String changingKey = "CHANGING." + var.getShortCanonicalName();
            Boolean changingValue = (Boolean)((Constant)this.variables.get(changingKey)).getValue();
            if (result == null) {
                result = changingValue;
                continue;
            }
            if (result.equals(changingValue)) continue;
            throw new QueryValidatorException(QueryExecPlugin.Util.getString("VariableSubstitutionVisitor.Input_vars_should_have_same_changing_state", new Object[]{expr}));
        }
        if (result != null) {
            return result;
        }
        return true;
    }

    private Delete rewriteDelete(Delete delete) throws TeiidComponentException, TeiidProcessingException {
        Criteria crit = delete.getCriteria();
        if (crit != null) {
            delete.setCriteria(this.rewriteCriteria(crit));
        }
        return delete;
    }

    private Limit rewriteLimitClause(Limit limit) throws TeiidComponentException, TeiidProcessingException {
        if (limit.getOffset() != null) {
            limit.setOffset(this.rewriteExpressionDirect(limit.getOffset()));
        }
        if (limit.getRowLimit() != null) {
            limit.setRowLimit(this.rewriteExpressionDirect(limit.getRowLimit()));
        }
        return limit;
    }

    static {
        ALIASED_FUNCTIONS.put("lower", "lcase");
        ALIASED_FUNCTIONS.put("upper", "ucase");
        ALIASED_FUNCTIONS.put("cast", "convert");
        ALIASED_FUNCTIONS.put("nvl", "ifnull");
        ALIASED_FUNCTIONS.put("||", "concat");
        ALIASED_FUNCTIONS.put("chr", "char");
        FUNCTION_MAP = new HashMap<String, Integer>();
        FUNCTION_MAP.put("space".toLowerCase(), 0);
        FUNCTION_MAP.put("from_unixtime".toLowerCase(), 1);
        FUNCTION_MAP.put("nullif".toLowerCase(), 2);
        FUNCTION_MAP.put("coalesce".toLowerCase(), 3);
        FUNCTION_MAP.put("CONCAT2".toLowerCase(), 4);
        FUNCTION_MAP.put("timestampadd".toLowerCase(), 5);
        FUNCTION_MAP.put("parsedate".toLowerCase(), 6);
        FUNCTION_MAP.put("parsetime".toLowerCase(), 7);
        FUNCTION_MAP.put("formatdate".toLowerCase(), 8);
        FUNCTION_MAP.put("formattime".toLowerCase(), 9);
    }
}

