/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class GroupBy
implements LanguageObject {
    private List symbols;

    public GroupBy() {
        this.symbols = new ArrayList();
    }

    public GroupBy(List symbols) {
        this.symbols = new ArrayList(symbols);
    }

    public int getCount() {
        return this.symbols.size();
    }

    public List getSymbols() {
        return this.symbols;
    }

    public void addSymbol(Expression symbol) {
        if (symbol != null) {
            this.symbols.add(symbol);
        }
    }

    public void replaceSymbols(Collection symbols) {
        if (symbols == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0003"));
        }
        this.symbols = new ArrayList(symbols);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        List thisSymbols = this.getSymbols();
        ArrayList<Object> copySymbols = new ArrayList<Object>(thisSymbols.size());
        for (Expression es : thisSymbols) {
            copySymbols.add(es.clone());
        }
        return new GroupBy(copySymbols);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GroupBy)) {
            return false;
        }
        return EquivalenceUtil.areEqual((Object)this.getSymbols(), (Object)((GroupBy)obj).getSymbols());
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getSymbols()});
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

