/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class Insert
extends ProcedureContainer {
    private GroupSymbol group;
    private List variables = new LinkedList();
    private List values = new LinkedList();
    private QueryCommand queryExpression;
    private TupleSource tupleSource;

    public Insert() {
    }

    @Override
    public int getType() {
        return 2;
    }

    public Insert(GroupSymbol group, List variables, List values) {
        this.group = group;
        this.variables = variables;
        this.values = values;
    }

    @Override
    public GroupSymbol getGroup() {
        return this.group;
    }

    public void setGroup(GroupSymbol group) {
        this.group = group;
    }

    public boolean isBulk() {
        if (this.values == null) {
            return false;
        }
        if (!(this.values.get(0) instanceof Constant)) {
            return false;
        }
        return ((Constant)this.values.get(0)).isMultiValued();
    }

    public List getVariables() {
        return this.variables;
    }

    public void addVariable(ElementSymbol var) {
        this.variables.add(var);
    }

    public void addVariables(Collection vars) {
        this.variables.addAll(vars);
    }

    public List getValues() {
        return this.values;
    }

    public void setValues(List values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void setVariables(Collection vars) {
        this.variables.clear();
        this.variables.addAll(vars);
    }

    public void addValue(Expression value) {
        this.values.add(value);
    }

    public void setQueryExpression(QueryCommand query) {
        this.queryExpression = query;
    }

    public QueryCommand getQueryExpression() {
        return this.queryExpression;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.group});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.variables});
        return myHash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Insert)) {
            return false;
        }
        Insert other = (Insert)obj;
        return EquivalenceUtil.areEqual((Object)this.getGroup(), (Object)other.getGroup()) && EquivalenceUtil.areEqual((Object)this.getValues(), (Object)other.getValues()) && EquivalenceUtil.areEqual((Object)this.getVariables(), (Object)other.getVariables()) && EquivalenceUtil.areEqual((Object)this.getQueryExpression(), (Object)other.getQueryExpression());
    }

    @Override
    public Map getProcedureParameters() {
        int iSize = this.getVariables().size();
        HashMap map = new HashMap();
        for (int j = 0; j < iSize; ++j) {
            ElementSymbol symbol = (ElementSymbol)((ElementSymbol)this.variables.get(j)).clone();
            symbol = (ElementSymbol)((ElementSymbol)this.variables.get(j)).clone();
            symbol.setName("INPUTS." + symbol.getShortCanonicalName());
            map.put(symbol, this.values.get(j));
        }
        return map;
    }

    @Override
    public Object clone() {
        GroupSymbol copyGroup = null;
        if (this.group != null) {
            copyGroup = (GroupSymbol)this.group.clone();
        }
        LinkedList<Object> copyVars = new LinkedList<Object>();
        for (ElementSymbol element : this.getVariables()) {
            copyVars.add(element.clone());
        }
        LinkedList<Object> copyVals = new LinkedList<Object>();
        if (this.getValues() != null && this.getValues().size() > 0) {
            for (Expression expression : this.getValues()) {
                copyVals.add(expression.clone());
            }
        }
        Insert copy = new Insert(copyGroup, copyVars, copyVals);
        if (this.queryExpression != null) {
            copy.setQueryExpression((QueryCommand)this.queryExpression.clone());
        }
        this.copyMetadataState(copy);
        return copy;
    }

    public List getProjectedSymbols() {
        return Command.getUpdateCommandSymbol();
    }

    @Override
    public boolean areResultsCachable() {
        return false;
    }

    public void setTupleSource(TupleSource tupleSource) {
        this.tupleSource = tupleSource;
    }

    public TupleSource getTupleSource() {
        return this.tupleSource;
    }
}

