/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.TupleBrowser;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.tempdata.IndexCondition;

class TempTable {
    private STree tree;
    private AtomicInteger rowId;
    private List<ElementSymbol> columns;
    private BufferManager bm;
    private String sessionID;
    private TempMetadataID tid;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean updatable = true;
    private int keyBatchSize;
    private int leafBatchSize;

    TempTable(TempMetadataID tid, BufferManager bm, List<ElementSymbol> columns, int primaryKeyLength, String sessionID) {
        this.tid = tid;
        this.bm = bm;
        if (primaryKeyLength == 0) {
            ElementSymbol id = new ElementSymbol("rowId");
            id.setType(DataTypeManager.DefaultDataClasses.INTEGER);
            columns.add(0, id);
            this.rowId = new AtomicInteger();
            this.tree = bm.createSTree(columns, sessionID, 1);
        } else {
            this.tree = bm.createSTree(columns, sessionID, primaryKeyLength);
        }
        this.columns = columns;
        this.sessionID = sessionID;
        this.keyBatchSize = bm.getSchemaSize(columns);
        this.leafBatchSize = bm.getSchemaSize(columns.subList(0, primaryKeyLength));
    }

    private int reserveBuffers() {
        return this.bm.reserveBuffers(this.leafBatchSize + (this.tree.getHeight() - 1) * this.keyBatchSize, BufferManager.BufferReserveMode.WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleSource createTupleSource(List<SingleElementSymbol> projectedCols, Criteria condition, OrderBy orderBy) throws TeiidComponentException, TeiidProcessingException {
        Map map = RelationalNode.createLookupMap(this.getColumns());
        Boolean direction = null;
        boolean orderByUsingIndex = false;
        if (orderBy != null && this.rowId == null) {
            int[] orderByIndexes = RelationalNode.getProjectionIndexes(map, orderBy.getSortKeys());
            if (orderByIndexes.length < this.tree.getKeyLength()) {
                orderByUsingIndex = false;
            } else {
                int i;
                orderByUsingIndex = true;
                for (i = 0; i < this.tree.getKeyLength(); ++i) {
                    if (orderByIndexes[i] == i) continue;
                    orderByUsingIndex = false;
                    break;
                }
                if (orderByUsingIndex) {
                    for (i = 0; i < this.tree.getKeyLength(); ++i) {
                        OrderByItem item = orderBy.getOrderByItems().get(i);
                        if (item.getNullOrdering() != null) {
                            orderByUsingIndex = false;
                            break;
                        }
                        if (item.isAscending()) {
                            if (direction == null) {
                                direction = true;
                                continue;
                            }
                            if (direction.booleanValue()) continue;
                            orderByUsingIndex = false;
                            break;
                        }
                        if (direction == null) {
                            direction = false;
                            continue;
                        }
                        if (!direction.booleanValue()) continue;
                        orderByUsingIndex = false;
                        break;
                    }
                }
            }
        }
        if (!orderByUsingIndex) {
            direction = true;
        }
        TupleBrowser browser = this.createTupleBrower(condition, direction);
        QueryTupleSource ts = new QueryTupleSource(browser, map, projectedCols, condition);
        boolean usingQueryTupleSource = false;
        try {
            TupleBuffer tb = null;
            if (!orderByUsingIndex && orderBy != null) {
                SortUtility sort = new SortUtility(ts, orderBy.getOrderByItems(), SortUtility.Mode.SORT, this.bm, this.sessionID, projectedCols);
                tb = sort.sort();
            } else if (!this.updatable) {
                tb = this.bm.createTupleBuffer(projectedCols, this.sessionID, BufferManager.TupleSourceType.PROCESSOR);
                List<?> next = null;
                while ((next = ts.nextTuple()) != null) {
                    tb.addTuple(next);
                }
            } else {
                usingQueryTupleSource = true;
                QueryTupleSource queryTupleSource = ts;
                return queryTupleSource;
            }
            tb.close();
            IndexedTupleSource indexedTupleSource = tb.createIndexedTupleSource(true);
            return indexedTupleSource;
        }
        finally {
            if (!usingQueryTupleSource) {
                ts.closeSource();
            }
        }
    }

    private TupleBrowser createTupleBrower(Criteria condition, boolean direction) throws TeiidComponentException {
        ArrayList<Object> lower = null;
        ArrayList<Object> upper = null;
        ArrayList values = null;
        if (condition != null && this.rowId == null) {
            IndexCondition[] indexConditions = IndexCondition.getIndexConditions(condition, this.columns.subList(0, this.tree.getKeyLength()));
            for (int i = 0; i < indexConditions.length; ++i) {
                IndexCondition indexCondition = indexConditions[i];
                if (indexCondition.lower != null) {
                    if (i == 0) {
                        lower = new ArrayList<Object>(this.tree.getKeyLength());
                        lower.add(indexCondition.lower.getValue());
                    }
                    if (lower != null && lower.size() == i) {
                        lower.add(indexCondition.lower.getValue());
                    }
                }
                if (indexCondition.upper != null) {
                    if (i == 0) {
                        upper = new ArrayList<Object>(this.tree.getKeyLength());
                        upper.add(indexCondition.upper.getValue());
                    } else if (upper != null && upper.size() == i) {
                        upper.add(indexCondition.upper.getValue());
                    }
                }
                if (indexCondition.valueSet.isEmpty()) continue;
                if (i == 0) {
                    values = new ArrayList();
                    for (Constant constant : indexCondition.valueSet) {
                        ArrayList<Object> value = new ArrayList<Object>(this.tree.getKeyLength());
                        value.add(constant.getValue());
                        values.add(value);
                    }
                    continue;
                }
                if (values == null || values.size() != 1 || indexCondition.valueSet.size() != 1) continue;
                ((List)values.iterator().next()).add(indexCondition.valueSet.first().getValue());
            }
            if (indexConditions.length > 0) {
                if (values != null) {
                    List value = (List)values.iterator().next();
                    if (value.size() != this.tree.getKeyLength()) {
                        values = null;
                        lower = new ArrayList(value);
                        lower.addAll(Collections.nCopies(this.tree.getKeyLength() - value.size(), null));
                        upper = new ArrayList(value);
                    }
                } else if (lower != null) {
                    lower.addAll(Collections.nCopies(this.tree.getKeyLength() - lower.size(), null));
                }
            }
        }
        if (values != null) {
            return new TupleBrowser(this.tree, values, direction);
        }
        return new TupleBrowser(this.tree, lower, upper, direction);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public int truncate() {
        return this.tree.truncate();
    }

    public void remove() {
        this.tree.remove();
    }

    public List<ElementSymbol> getColumns() {
        if (this.rowId != null) {
            return this.columns.subList(1, this.columns.size());
        }
        return this.columns;
    }

    public TupleSource insert(TupleSource tuples, List<ElementSymbol> variables) throws TeiidComponentException, ExpressionEvaluationException, TeiidProcessingException {
        List<ElementSymbol> cols = this.getColumns();
        int[] indexes = new int[cols.size()];
        boolean shouldProject = false;
        for (int i = 0; i < cols.size(); ++i) {
            indexes[i] = variables.indexOf(cols.get(i));
            shouldProject |= indexes[i] != i;
        }
        InsertUpdateProcessor up = new InsertUpdateProcessor(tuples, this.rowId != null, (int[])(shouldProject ? indexes : null));
        int updateCount = up.process();
        this.tid.setCardinality(this.tree.getRowCount());
        return CollectionTupleSource.createUpdateCountTupleSource(updateCount);
    }

    public TupleSource update(Criteria crit, final SetClauseList update) throws TeiidComponentException, ExpressionEvaluationException, TeiidProcessingException {
        final boolean primaryKeyChangePossible = this.canChangePrimaryKey(update);
        final TupleBrowser browser = this.createTupleBrower(crit, true);
        UpdateProcessor up = new UpdateProcessor(crit, browser){
            protected TupleBuffer changeSet;
            protected UpdateProcessor changeSetProcessor;

            @Override
            protected void tuplePassed(List tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
                ArrayList<Object> newTuple = new ArrayList<Object>(tuple);
                for (Map.Entry<ElementSymbol, Expression> entry : update.getClauseMap().entrySet()) {
                    newTuple.set((Integer)this.lookup.get(entry.getKey()), this.eval.evaluate(entry.getValue(), tuple));
                }
                if (primaryKeyChangePossible) {
                    browser.removed();
                    TempTable.this.deleteTuple(tuple);
                    if (this.changeSet == null) {
                        this.changeSet = TempTable.this.bm.createTupleBuffer(TempTable.this.columns, TempTable.this.sessionID, BufferManager.TupleSourceType.PROCESSOR);
                    }
                    this.changeSet.addTuple(newTuple);
                } else {
                    browser.update(newTuple);
                }
            }

            @Override
            protected void undo(List tuple) throws TeiidComponentException, TeiidProcessingException {
                if (primaryKeyChangePossible) {
                    TempTable.this.insertTuple(tuple, false);
                } else {
                    TempTable.this.updateTuple(tuple);
                }
            }

            @Override
            void success() throws TeiidComponentException, ExpressionEvaluationException, TeiidProcessingException {
                if (primaryKeyChangePossible) {
                    if (this.changeSetProcessor == null) {
                        this.changeSetProcessor = new InsertUpdateProcessor(this.changeSet.createIndexedTupleSource(true), false, null);
                    }
                    this.changeSetProcessor.process();
                }
            }

            @Override
            public void close() {
                super.close();
                if (this.changeSetProcessor != null) {
                    this.changeSetProcessor.close();
                }
                if (this.changeSet != null) {
                    this.changeSet.remove();
                }
            }
        };
        int updateCount = up.process();
        return CollectionTupleSource.createUpdateCountTupleSource(updateCount);
    }

    private boolean canChangePrimaryKey(SetClauseList update) {
        if (this.rowId == null) {
            HashSet<ElementSymbol> affectedColumns = new HashSet<ElementSymbol>(update.getClauseMap().keySet());
            affectedColumns.retainAll(this.columns.subList(0, this.tree.getKeyLength()));
            if (!affectedColumns.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public TupleSource delete(Criteria crit) throws TeiidComponentException, ExpressionEvaluationException, TeiidProcessingException {
        final TupleBrowser browser = this.createTupleBrower(crit, true);
        UpdateProcessor up = new UpdateProcessor(crit, browser){

            @Override
            protected void tuplePassed(List tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
                browser.removed();
                TempTable.this.deleteTuple(tuple);
            }

            @Override
            protected void undo(List tuple) throws TeiidComponentException, TeiidProcessingException {
                TempTable.this.insertTuple(tuple, false);
            }
        };
        int updateCount = up.process();
        this.tid.setCardinality(this.tree.getRowCount());
        return CollectionTupleSource.createUpdateCountTupleSource(updateCount);
    }

    private void insertTuple(List<Object> list, boolean ordered) throws TeiidComponentException, TeiidProcessingException {
        if (this.tree.insert(list, ordered ? STree.InsertMode.ORDERED : STree.InsertMode.NEW) != null) {
            throw new TeiidProcessingException(QueryPlugin.Util.getString("TempTable.duplicate_key"));
        }
    }

    private void deleteTuple(List<?> tuple) throws TeiidComponentException {
        if (this.tree.remove(tuple) == null) {
            throw new AssertionError((Object)"Delete failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<?> updateTuple(List<?> tuple, boolean remove) throws TeiidComponentException {
        try {
            this.lock.writeLock().lock();
            if (remove) {
                List list = this.tree.remove(tuple);
                return list;
            }
            List list = this.tree.insert(tuple, STree.InsertMode.UPDATE);
            return list;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void updateTuple(List<?> tuple) throws TeiidComponentException {
        if (this.tree.insert(tuple, STree.InsertMode.UPDATE) == null) {
            throw new AssertionError((Object)"Update failed");
        }
    }

    void setPreferMemory(boolean preferMemory) {
        this.tree.setPreferMemory(preferMemory);
    }

    void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    CacheHint getCacheHint() {
        return this.tid.getCacheHint();
    }

    int getPkLength() {
        if (this.rowId != null) {
            return 0;
        }
        return this.tree.getKeyLength();
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    private abstract class UpdateProcessor {
        private TupleSource ts;
        protected final Map lookup;
        protected final Evaluator eval;
        private final Criteria crit;
        protected int updateCount = 0;
        protected List currentTuple;
        protected TupleBuffer undoLog;

        UpdateProcessor(Criteria crit, TupleSource ts) throws TeiidComponentException {
            this.ts = ts;
            this.lookup = RelationalNode.createLookupMap(TempTable.this.columns);
            this.eval = new Evaluator(this.lookup, null, null);
            this.crit = crit;
            this.undoLog = TempTable.this.bm.createTupleBuffer(TempTable.this.columns, TempTable.this.sessionID, BufferManager.TupleSourceType.PROCESSOR);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int process() throws ExpressionEvaluationException, TeiidComponentException, TeiidProcessingException {
            int reserved = TempTable.this.reserveBuffers();
            boolean held = TempTable.this.lock.writeLock().isHeldByCurrentThread();
            TempTable.this.lock.writeLock().lock();
            boolean success = false;
            try {
                while (this.currentTuple != null || (this.currentTuple = this.ts.nextTuple()) != null) {
                    if (this.crit == null || this.eval.evaluate(this.crit, this.currentTuple)) {
                        this.tuplePassed(this.currentTuple);
                        ++this.updateCount;
                        this.undoLog.addTuple(this.currentTuple);
                    }
                    this.currentTuple = null;
                }
                TempTable.this.bm.releaseBuffers(reserved);
                reserved = 0;
                this.success();
                success = true;
            }
            finally {
                TempTable.this.bm.releaseBuffers(reserved);
                try {
                    if (!success) {
                        this.undoLog.setFinal(true);
                        IndexedTupleSource undoTs = this.undoLog.createIndexedTupleSource();
                        List<?> tuple = null;
                        while ((tuple = undoTs.nextTuple()) != null) {
                            this.undo(tuple);
                        }
                    }
                }
                catch (TeiidException e) {
                    LogManager.logError((String)"org.teiid.PROCESSOR", (Throwable)e, (String)e.getMessage());
                }
                finally {
                    if (!held) {
                        TempTable.this.lock.writeLock().unlock();
                    }
                    this.close();
                }
            }
            return this.updateCount;
        }

        void success() throws TeiidComponentException, ExpressionEvaluationException, TeiidProcessingException {
        }

        protected abstract void tuplePassed(List var1) throws BlockedException, TeiidComponentException, TeiidProcessingException;

        protected abstract void undo(List var1) throws TeiidComponentException, TeiidProcessingException;

        public void close() {
            this.ts.closeSource();
            this.undoLog.remove();
        }
    }

    private final class QueryTupleSource
    implements TupleSource {
        private final Evaluator eval;
        private final Criteria condition;
        private final boolean project;
        private final int[] indexes;
        private int reserved;
        private TupleBrowser browser;

        private QueryTupleSource(TupleBrowser browser, Map map, List<SingleElementSymbol> projectedCols, Criteria condition) {
            this.browser = browser;
            this.indexes = RelationalNode.getProjectionIndexes(map, projectedCols);
            this.eval = new Evaluator(map, null, null);
            this.condition = condition;
            this.project = this.shouldProject();
            this.reserved = TempTable.this.reserveBuffers();
            TempTable.this.lock.readLock().lock();
        }

        @Override
        public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
            List<?> next;
            do {
                if ((next = this.browser.nextTuple()) == null) {
                    TempTable.this.bm.releaseBuffers(this.reserved);
                    this.reserved = 0;
                    return null;
                }
                if (TempTable.this.rowId == null) continue;
                next = next.subList(1, next.size());
            } while (this.condition != null && !this.eval.evaluate(this.condition, next));
            if (this.project) {
                next = RelationalNode.projectTuple(this.indexes, next);
            }
            return next;
        }

        @Override
        public void closeSource() {
            TempTable.this.lock.readLock().unlock();
            TempTable.this.bm.releaseBuffers(this.reserved);
            this.reserved = 0;
            this.browser.closeSource();
        }

        private boolean shouldProject() {
            if (this.indexes.length == TempTable.this.getColumns().size()) {
                for (int i = 0; i < this.indexes.length; ++i) {
                    if (this.indexes[i] == i) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    private final class InsertUpdateProcessor
    extends UpdateProcessor {
        private boolean addRowId;
        private int[] indexes;

        private InsertUpdateProcessor(TupleSource ts, boolean addRowId, int[] indexes) throws TeiidComponentException {
            super(null, ts);
            this.addRowId = addRowId;
            this.indexes = indexes;
        }

        @Override
        protected void tuplePassed(List tuple) throws BlockedException, TeiidComponentException, TeiidProcessingException {
            if (this.indexes != null) {
                ArrayList<Integer> newTuple = new ArrayList<Integer>(TempTable.this.columns.size());
                if (this.addRowId) {
                    newTuple.add(TempTable.this.rowId.getAndIncrement());
                }
                for (int i = 0; i < this.indexes.length; ++i) {
                    if (this.indexes[i] == -1) {
                        newTuple.add(null);
                        continue;
                    }
                    newTuple.add((Integer)tuple.get(this.indexes[i]));
                }
                tuple = newTuple;
            } else if (this.addRowId) {
                tuple = new ArrayList<Integer>(tuple);
                tuple.add(0, TempTable.this.rowId.getAndIncrement());
            }
            this.currentTuple = tuple;
            TempTable.this.insertTuple(tuple, this.addRowId);
        }

        @Override
        protected void undo(List tuple) throws TeiidComponentException, TeiidProcessingException {
            TempTable.this.deleteTuple(tuple);
        }
    }
}

