/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.cache.Cache;
import org.teiid.cache.DefaultCache;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.service.FakeBufferService;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.ElementSymbol;

public class TestCachedResults {
    @Test
    public void testCaching() throws Exception {
        FakeBufferService fbs = new FakeBufferService();
        ElementSymbol x = new ElementSymbol("x");
        x.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        List<ElementSymbol> schema = Arrays.asList(x);
        TupleBuffer tb = new TupleBuffer((BatchManager)new FakeBatchManager(), "x", schema, null, 4);
        tb.setForwardOnly(false);
        tb.addTuple(Arrays.asList(1));
        tb.addTuple(Arrays.asList(2));
        tb.addTuple(Arrays.asList(3));
        tb.addTuple(Arrays.asList(4));
        tb.addTuple(Arrays.asList(5));
        tb.addTuple(Arrays.asList(6));
        tb.addTuple(Arrays.asList(7));
        tb.addTuple(Arrays.asList(8));
        tb.addTuple(Arrays.asList(9));
        tb.addTuple(Arrays.asList(10));
        tb.close();
        CachedResults results = new CachedResults();
        results.setResults(tb);
        results.setCommand((Command)new Query());
        DefaultCache cache = new DefaultCache("dummy");
        results.prepare((Cache)cache, fbs.getBufferManager());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(results);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        CachedResults cachedResults = (CachedResults)ois.readObject();
        ois.close();
        cachedResults.restore((Cache)cache, fbs.getBufferManager());
        cache.clear();
        TupleBuffer cachedTb = cachedResults.getResults();
        Assert.assertEquals((long)tb.getRowCount(), (long)cachedTb.getRowCount());
        Assert.assertEquals((long)tb.getBatchSize(), (long)cachedTb.getBatchSize());
        Assert.assertArrayEquals((Object[])tb.getBatch(1).getAllTuples(), (Object[])cachedTb.getBatch(1).getAllTuples());
        Assert.assertArrayEquals((Object[])tb.getBatch(9).getAllTuples(), (Object[])cachedTb.getBatch(9).getAllTuples());
    }

    private final class FakeBatchManager
    implements BatchManager {
        private FakeBatchManager() {
        }

        public void remove() {
        }

        public BatchManager.ManagedBatch createManagedBatch(final TupleBatch batch, boolean softCache) throws TeiidComponentException {
            return new BatchManager.ManagedBatch(){

                public void remove() {
                }

                public TupleBatch getBatch(boolean cache, String[] types) throws TeiidComponentException {
                    return batch;
                }
            };
        }
    }
}

