/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.util.ResultsFuture;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.FakeTransactionService;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.FakeBufferService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestDQPCore {
    private DQPCore core;

    @Before
    public void setUp() throws Exception {
        DQPWorkContext context = FakeMetadataFactory.buildWorkContext((QueryMetadataInterface)FakeMetadataFactory.exampleBQTCached(), FakeMetadataFactory.exampleBQTVDB());
        context.getVDB().getModel("BQT3").setVisible(Boolean.valueOf(false));
        ConnectorManagerRepository repo = (ConnectorManagerRepository)Mockito.mock(ConnectorManagerRepository.class);
        context.getVDB().addAttchment(ConnectorManagerRepository.class, (Object)repo);
        Mockito.stub((Object)repo.getConnectorManager(Mockito.anyString())).toReturn((Object)new AutoGenDataService());
        this.core = new DQPCore();
        this.core.setBufferService((BufferService)new FakeBufferService());
        this.core.setCacheFactory((CacheFactory)new DefaultCacheFactory());
        this.core.setTransactionService((TransactionService)new FakeTransactionService());
        this.core.start(new DQPConfiguration());
    }

    @After
    public void tearDown() throws Exception {
        DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
        this.core.stop();
    }

    public RequestMessage exampleRequestMessage(String sql) {
        RequestMessage msg = new RequestMessage(sql);
        msg.setCursorType(1004);
        msg.setFetchSize(10);
        msg.setPartialResults(false);
        msg.setExecutionId(100L);
        return msg;
    }

    @Test
    public void testRequest1() throws Exception {
        this.helpExecute("SELECT IntKey FROM BQT1.SmallA", "a");
    }

    @Test
    public void testUser1() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE user() = 'logon'";
        String userName = "logon";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser2() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE user() LIKE 'logon'";
        String userName = "logon";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser3() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE user() IN ('logon3') AND StringKey LIKE '1'";
        String userName = "logon3";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser4() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE 'logon4' = user() AND StringKey = '1'";
        String userName = "logon4";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser5() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE user() IS NULL ";
        String userName = "logon";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser6() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE user() = 'logon33' ";
        String userName = "logon";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser7() throws Exception {
        String sql = "UPDATE BQT1.SmallA SET IntKey = 2 WHERE user() = 'logon' AND StringKey = '1' ";
        String userName = "logon";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser8() throws Exception {
        String sql = "SELECT user(), StringKey FROM BQT1.SmallA WHERE IntKey = 1 ";
        String userName = "logon";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser9() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE user() = StringKey AND StringKey = '1' ";
        String userName = "1";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testEnvSessionId() throws Exception {
        String sql = "SELECT env('sessionid') as SessionID";
        String userName = "1";
        ResultsMessage rm = this.helpExecute(sql, userName);
        Assert.assertEquals((Object)"1", rm.getResults()[0].get(0));
    }

    @Test
    public void testEnvSessionIdMixedCase() throws Exception {
        String sql = "SELECT env('sEsSIonId') as SessionID";
        String userName = "1";
        ResultsMessage rm = this.helpExecute(sql, userName);
        Assert.assertEquals((Object)"1", rm.getResults()[0].get(0));
    }

    @Test
    public void testTxnAutoWrap() throws Exception {
        String sql = "SELECT * FROM BQT1.SmallA";
        this.helpExecute(sql, "a", 1, true);
    }

    @Test
    public void testPlanningException() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.BadIdea ";
        RequestMessage reqMsg = this.exampleRequestMessage(sql);
        ResultsFuture message = this.core.executeRequest(reqMsg.getExecutionId(), reqMsg);
        try {
            message.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof QueryResolverException));
        }
    }

    @Test
    public void testLookupVisibility() throws Exception {
        this.helpTestVisibilityFails("select lookup('bqt3.smalla', 'intkey', 'stringkey', '?')");
    }

    @Test
    public void testCancel() throws Exception {
        Assert.assertFalse((boolean)this.core.cancelRequest(1L));
    }

    public void helpTestVisibilityFails(String sql) throws Exception {
        RequestMessage reqMsg = this.exampleRequestMessage(sql);
        reqMsg.setTxnAutoWrapMode("OFF");
        ResultsFuture message = this.core.executeRequest(reqMsg.getExecutionId(), reqMsg);
        ResultsMessage results = (ResultsMessage)message.get(5000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"[QueryValidatorException]Group does not exist: BQT3.SmallA", (Object)results.getException().toString());
    }

    private ResultsMessage helpExecute(String sql, String userName) throws Exception {
        return this.helpExecute(sql, userName, 1, false);
    }

    private ResultsMessage helpExecute(String sql, String userName, int sessionid, boolean txnAutoWrap) throws Exception {
        ResultsFuture message;
        ResultsMessage results;
        RequestMessage reqMsg = this.exampleRequestMessage(sql);
        DQPWorkContext.getWorkContext().getSession().setSessionId(String.valueOf(sessionid));
        DQPWorkContext.getWorkContext().getSession().setUserName(userName);
        if (txnAutoWrap) {
            reqMsg.setTxnAutoWrapMode("ON");
        }
        if ((results = (ResultsMessage)(message = this.core.executeRequest(reqMsg.getExecutionId(), reqMsg)).get(5000L, TimeUnit.MILLISECONDS)).getException() != null) {
            throw results.getException();
        }
        return results;
    }
}

