/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.RequestMessage;
import org.teiid.client.metadata.MetadataResult;
import org.teiid.client.metadata.ResultsMetadataConstants;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.datamgr.FakeTransactionService;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.MetaDataProcessor;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TestDQPCoreRequestHandling;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.TransactionService;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestMetaDataProcessor
extends TestCase {
    public TestMetaDataProcessor(String name) {
        super(name);
    }

    public Map[] helpGetMetadata(String sql, QueryMetadataInterface metadata, VDBMetaData vdb) throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (Map)Collections.EMPTY_MAP, (QueryMetadataInterface)metadata, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord());
        SessionAwareCache prepPlanCache = new SessionAwareCache();
        DQPCore requestMgr = new DQPCore();
        requestMgr.setTransactionService((TransactionService)new FakeTransactionService());
        DQPWorkContext workContext = FakeMetadataFactory.buildWorkContext(metadata, vdb);
        RequestID requestID = workContext.getRequestID(1L);
        RequestMessage requestMsg = new RequestMessage(sql);
        TestDQPCoreRequestHandling.addRequest(requestMgr, requestMsg, requestID, command, null);
        MetaDataProcessor mdProc = new MetaDataProcessor(requestMgr, prepPlanCache, "MyVDB", 1);
        return mdProc.processMessage(requestID, workContext, null, true).getColumnMetadata();
    }

    public void testSimpleQuery() throws Exception {
        Map[] metadata = this.helpGetMetadata("SELECT e1 FROM pm1.g1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), FakeMetadataFactory.example1VDB());
        TestMetaDataProcessor.assertNotNull((Object)metadata);
        TestMetaDataProcessor.assertEquals((int)1, (int)metadata.length);
    }

    public void testSimpleUpdate() throws Exception {
        Map[] metadata = this.helpGetMetadata("INSERT INTO pm1.g1 (e1) VALUES ('x')", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), FakeMetadataFactory.example1VDB());
        TestMetaDataProcessor.assertNull((Object)metadata);
        metadata = this.helpGetMetadata("DELETE FROM pm1.g1 WHERE e1 = 'x'", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), FakeMetadataFactory.example1VDB());
        TestMetaDataProcessor.assertNull((Object)metadata);
        metadata = this.helpGetMetadata("UPDATE pm1.g1 SET e1='y' WHERE e1 = 'x'", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), FakeMetadataFactory.example1VDB());
        TestMetaDataProcessor.assertNull((Object)metadata);
        metadata = this.helpGetMetadata("SELECT e1, e2, e3, e4 INTO pm1.g2 FROM pm1.g1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), FakeMetadataFactory.example1VDB());
        TestMetaDataProcessor.assertNull((Object)metadata);
    }

    public void testElementLabel() throws Exception {
        Map[] metadata = this.helpGetMetadata("SELECT E2 FROM pm1.g1", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), FakeMetadataFactory.example1VDB());
        TestMetaDataProcessor.assertNotNull((Object)metadata);
        TestMetaDataProcessor.assertEquals((int)1, (int)metadata.length);
        TestMetaDataProcessor.assertEquals((Object)"E2", metadata[0].get(ResultsMetadataConstants.ELEMENT_NAME));
    }

    public void testSimpleExec() throws Exception {
        Map[] metadata = this.helpGetMetadata("EXEC pm1.sq1()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), FakeMetadataFactory.example1VDB());
        TestMetaDataProcessor.assertNotNull((Object)metadata);
        TestMetaDataProcessor.assertEquals((int)2, (int)metadata.length);
    }

    public void testExecNoResultColumns() throws Exception {
        Map[] metadata = this.helpGetMetadata("EXEC pm1.sp5()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), FakeMetadataFactory.example1VDB());
        TestMetaDataProcessor.assertNotNull((Object)metadata);
        TestMetaDataProcessor.assertEquals((int)0, (int)metadata.length);
    }

    private MetadataResult helpTestQuery(QueryMetadataInterface metadata, String sql, VDBMetaData vdb) throws Exception {
        SessionAwareCache prepPlanCache = new SessionAwareCache();
        MetaDataProcessor mdProc = new MetaDataProcessor(new DQPCore(), prepPlanCache, "MyVDB", 1);
        DQPWorkContext workContext = FakeMetadataFactory.buildWorkContext(metadata, vdb);
        return mdProc.processMessage(workContext.getRequestID(1L), workContext, sql, true);
    }

    private void helpCheckNumericAttributes(MetadataResult message, int column, int expectedSize, int expectedPrecision, int expectedScale) {
        Map[] md = message.getColumnMetadata();
        TestMetaDataProcessor.assertNotNull((Object)md);
        TestMetaDataProcessor.assertEquals((Object)new Integer(expectedSize), md[column].get(ResultsMetadataConstants.DISPLAY_SIZE));
        TestMetaDataProcessor.assertEquals((Object)new Integer(expectedPrecision), md[column].get(ResultsMetadataConstants.PRECISION));
        TestMetaDataProcessor.assertEquals((Object)new Integer(expectedScale), md[column].get(ResultsMetadataConstants.SCALE));
    }

    public void testDefect16629_moneyType() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.examplePrivatePhysicalModel();
        String sql = "SELECT e1 FROM pm1.g2";
        MetadataResult response = this.helpTestQuery((QueryMetadataInterface)metadata, sql, FakeMetadataFactory.examplePrivatePhysicalModelVDB());
        this.helpCheckNumericAttributes(response, 0, 21, 19, 4);
    }

    public void testDefect16629_aggregatesOnMoneyType() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.examplePrivatePhysicalModel();
        String sql = "SELECT min(e1), max(e1), sum(e1), avg(e1) FROM pm1.g2";
        MetadataResult response = this.helpTestQuery((QueryMetadataInterface)metadata, sql, FakeMetadataFactory.examplePrivatePhysicalModelVDB());
        this.helpCheckNumericAttributes(response, 0, 21, 19, 4);
        this.helpCheckNumericAttributes(response, 1, 21, 19, 4);
        this.helpCheckNumericAttributes(response, 2, 22, 20, 0);
        this.helpCheckNumericAttributes(response, 3, 22, 20, 0);
    }

    public void testMetadataGenerationForAllTypes() throws Exception {
        Set dataTypes = DataTypeManager.getAllDataTypeNames();
        for (String type : dataTypes) {
            Class typeClass = DataTypeManager.getDataTypeClass((String)type);
            MetaDataProcessor processor = new MetaDataProcessor(null, null, "vdb", 1);
            Map columnMetadata = processor.getDefaultColumn("t", "c", typeClass);
            this.verifyColumn(columnMetadata, type);
        }
    }

    private void verifyColumn(Map column, String dataType) {
        this.verifyAttribute(column, ResultsMetadataConstants.AUTO_INCREMENTING, false, Boolean.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.CASE_SENSITIVE, false, Boolean.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.CURRENCY, false, Boolean.class, dataType);
        Object dt = this.verifyAttribute(column, ResultsMetadataConstants.DATA_TYPE, false, String.class, dataType);
        TestMetaDataProcessor.assertEquals((Object)dataType, (Object)dt);
        this.verifyAttribute(column, ResultsMetadataConstants.DISPLAY_SIZE, false, Integer.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.ELEMENT_LABEL, true, String.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.ELEMENT_NAME, false, String.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.GROUP_NAME, true, String.class, dataType);
        Object nullable = this.verifyAttribute(column, ResultsMetadataConstants.NULLABLE, false, Integer.class, dataType);
        this.verifyNullable((Integer)nullable);
        this.verifyAttribute(column, ResultsMetadataConstants.PRECISION, false, Integer.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.RADIX, false, Integer.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.SCALE, false, Integer.class, dataType);
        Object searchable = this.verifyAttribute(column, ResultsMetadataConstants.SEARCHABLE, false, Integer.class, dataType);
        this.verifySearchable((Integer)searchable);
        this.verifyAttribute(column, ResultsMetadataConstants.SIGNED, false, Boolean.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, false, String.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION, false, Integer.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.WRITABLE, false, Boolean.class, dataType);
    }

    private Object verifyAttribute(Map column, Integer attributeType, boolean nullsAllowed, Class expectedClass, String columnDataType) {
        Object value = column.get(attributeType);
        if (!nullsAllowed) {
            TestMetaDataProcessor.assertNotNull((String)("Got null when not allowed for column of type " + columnDataType), value);
        }
        if (value != null) {
            TestMetaDataProcessor.assertEquals((String)("Got attribute of incorrect class for column of type " + columnDataType), (Object)expectedClass, value.getClass());
        }
        return value;
    }

    private void verifyNullable(Integer nullable) {
        if (!(nullable.equals(ResultsMetadataConstants.NULL_TYPES.NOT_NULL) || nullable.equals(ResultsMetadataConstants.NULL_TYPES.NULLABLE) || nullable.equals(ResultsMetadataConstants.NULL_TYPES.UNKNOWN))) {
            TestMetaDataProcessor.fail((String)("Invalid nullable constant value: " + nullable));
        }
    }

    private void verifySearchable(Integer searchable) {
        if (!(searchable.equals(ResultsMetadataConstants.SEARCH_TYPES.ALLEXCEPTLIKE) || searchable.equals(ResultsMetadataConstants.SEARCH_TYPES.LIKE_ONLY) || searchable.equals(ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE) || searchable.equals(ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE))) {
            TestMetaDataProcessor.fail((String)("Invalid searchable constant value: " + searchable));
        }
    }
}

