/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.lang.Command;

public class TestPreparedPlanCache {
    private static final String EXAMPLE_QUERY = "SELECT * FROM table";
    private static final DQPWorkContext token = new DQPWorkContext();
    private static final DQPWorkContext token2 = new DQPWorkContext();
    private static final ParseInfo pi = new ParseInfo();

    @BeforeClass
    public static void setUpOnce() {
        token.getSession().setVDBName("foo");
        token.getSession().setVDBVersion(1);
        token2.getSession().setVDBName("foo");
        token2.getSession().setVDBVersion(2);
    }

    @Test
    public void testPutPreparedPlan() {
        SessionAwareCache cache = new SessionAwareCache();
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(token, pi, "SELECT * FROM table1");
        Assert.assertNull((Object)cache.get(id));
        cache.put(id, 3, (Object)new PreparedPlan());
        Assert.assertNotNull((String)"Unable to get prepared plan from cache", (Object)cache.get(id));
    }

    @Test
    public void testget() {
        SessionAwareCache cache = new SessionAwareCache();
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token, 0, 10);
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token2, 0, 15);
        PreparedPlan pPlan = (PreparedPlan)cache.get(new SessionAwareCache.CacheID(token2, pi, "SELECT * FROM table12"));
        Assert.assertNotNull((String)"Unable to get prepared plan from cache", (Object)pPlan);
        Assert.assertEquals((String)"Error getting plan from cache", (Object)new RelationalPlan((RelationalNode)new ProjectNode(12)).toString(), (Object)pPlan.getPlan().toString());
        Assert.assertEquals((String)"Error getting command from cache", (Object)"SELECT * FROM table12", (Object)pPlan.getCommand().toString());
        Assert.assertNotNull((String)"Error getting plan description from cache", (Object)pPlan.getAnalysisRecord());
        Assert.assertEquals((String)"Error gettting reference from cache", (Object)"ref12", pPlan.getReferences().get(0));
    }

    @Test
    public void testClearAll() {
        SessionAwareCache cache = new SessionAwareCache();
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token, 1, 1);
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token2, 1, 1);
        Assert.assertNotNull((String)"Unable to get prepared plan from cache for token", (Object)cache.get(new SessionAwareCache.CacheID(token, pi, "SELECT * FROM table1")));
        cache.clearAll();
        Assert.assertNull((String)"Failed remove from cache", (Object)cache.get(new SessionAwareCache.CacheID(token, pi, "SELECT * FROM table1")));
        Assert.assertNull((String)"Unable to get prepared plan from cache for token2", (Object)cache.get(new SessionAwareCache.CacheID(token2, pi, "SELECT * FROM table1")));
    }

    @Test
    public void testMaxSize() {
        SessionAwareCache cache = new SessionAwareCache(100);
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token, 0, 101);
        Assert.assertNull((Object)cache.get(new SessionAwareCache.CacheID(token, pi, "SELECT * FROM table0")));
        Assert.assertNotNull((Object)cache.get(new SessionAwareCache.CacheID(token, pi, "SELECT * FROM table12")));
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token, 102, 50);
        Assert.assertNotNull((Object)cache.get(new SessionAwareCache.CacheID(token, pi, "SELECT * FROM table12")));
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token2, 0, 121);
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token, 0, 50);
        Assert.assertTrue((cache.getSpaceUsed() <= 100 ? 1 : 0) != 0);
    }

    @Test
    public void testZeroSizeCache() {
        SessionAwareCache cache = new SessionAwareCache(0);
        Assert.assertEquals((long)0L, (long)cache.getSpaceAllowed());
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token, 0, 1);
        Assert.assertNull((Object)cache.get(new SessionAwareCache.CacheID(token, pi, "SELECT * FROM table0")));
        Assert.assertEquals((long)0L, (long)cache.getSpaceUsed());
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token, 1, 1);
        Assert.assertNull((Object)cache.get(new SessionAwareCache.CacheID(token, pi, "SELECT * FROM table1")));
        Assert.assertEquals((long)0L, (long)cache.getSpaceUsed());
    }

    @Test
    public void testNegativeSizeCacheUsesDefault() {
        SessionAwareCache negativeSizedCache = new SessionAwareCache(-1000);
        SessionAwareCache defaultSizedCache = new SessionAwareCache();
        Assert.assertEquals((long)defaultSizedCache.getSpaceAllowed(), (long)negativeSizedCache.getSpaceAllowed());
        Assert.assertEquals((long)250L, (long)negativeSizedCache.getSpaceAllowed());
    }

    private void helpPutPreparedPlans(SessionAwareCache<PreparedPlan> cache, DQPWorkContext session, int start, int count) {
        for (int i = 0; i < count; ++i) {
            Command dummy;
            try {
                dummy = QueryParser.getQueryParser().parseCommand(EXAMPLE_QUERY + (start + i));
            }
            catch (QueryParserException e) {
                throw new RuntimeException(e);
            }
            SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(session, pi, dummy.toString());
            PreparedPlan pPlan = new PreparedPlan();
            cache.put(id, 3, (Object)pPlan);
            pPlan.setCommand(dummy);
            pPlan.setPlan((ProcessorPlan)new RelationalPlan((RelationalNode)new ProjectNode(i)));
            AnalysisRecord analysisRecord = new AnalysisRecord(true, false);
            pPlan.setAnalysisRecord(analysisRecord);
            ArrayList<String> refs = new ArrayList<String>();
            refs.add("ref" + i);
            pPlan.setReferences(refs);
        }
    }
}

