/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TestPreparedStatement;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestPreparedStatementBatchedUpdate {
    @Test
    public void testBatchedUpdatePushdown() throws Exception {
        String preparedSql = "UPDATE pm1.g1 SET pm1.g1.e1=?, pm1.g1.e3=? WHERE pm1.g1.e2=?";
        SessionAwareCache prepPlanCache = new SessionAwareCache();
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("UPDATE pm1.g1 SET e1 = ?, e3 = ? WHERE pm1.g1.e2 = ?", new List[]{Arrays.asList(4)});
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.BULK_UPDATE, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>(2);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList(null, Boolean.FALSE, new Integer(1))));
        List[] expected = new List[]{Arrays.asList(4)};
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, FakeMetadataFactory.example1VDB());
        Update update = (Update)dataManager.getCommandHistory().iterator().next();
        Assert.assertTrue((boolean)((Constant)((SetClause)update.getChangeList().getClauses().get(0)).getValue()).isMultiValued());
    }

    @Test
    public void testUpdateSameNumCmds() throws Exception {
        String preparedSql = "UPDATE pm1.g1 SET pm1.g1.e1=?, pm1.g1.e3=? WHERE pm1.g1.e2=?";
        SessionAwareCache prepPlanCache = new SessionAwareCache();
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.BATCHED_UPDATES, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ArrayList<String> finalQueryList = new ArrayList<String>(13);
        List[] expected = new List[]{Arrays.asList(new Integer(2)), Arrays.asList(new Integer(2))};
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>(2);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList(null, Boolean.FALSE, new Integer(1))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = null, e3 = FALSE WHERE pm1.g1.e2 = 1"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, FakeMetadataFactory.example1VDB());
        expected = new List[]{Arrays.asList(new Integer(2)), Arrays.asList(new Integer(0))};
        values = new ArrayList(1);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList("b", Boolean.TRUE, new Integer(5))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'b', e3 = TRUE WHERE pm1.g1.e2 = 5"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, true, FakeMetadataFactory.example1VDB());
        Assert.assertEquals((String)"Unexpected queries executed -", finalQueryList, dataManager.getQueries());
    }

    @Test
    public void testUpdateSameNumCmds_Virtual() throws Exception {
        String preparedSql = "UPDATE vm1.g1 SET vm1.g1.e2=? WHERE vm1.g1.e1=?";
        SessionAwareCache prepPlanCache = new SessionAwareCache();
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.BATCHED_UPDATES, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ArrayList<String> finalQueryList = new ArrayList<String>();
        List[] expected = new List[]{Arrays.asList(3), Arrays.asList(1)};
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>(2);
        values.add(new ArrayList<Object>(Arrays.asList(new Integer(0), "a")));
        values.add(new ArrayList<Object>(Arrays.asList(new Integer(1), "b")));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e2 = 0 WHERE pm1.g1.e1 = 'a'"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e2 = 1 WHERE pm1.g1.e1 = 'b'"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, FakeMetadataFactory.example1VDB());
        expected = new List[]{Arrays.asList(1), Arrays.asList(0)};
        values = new ArrayList(1);
        values.add(new ArrayList<Object>(Arrays.asList(new Integer(2), "c")));
        values.add(new ArrayList<Object>(Arrays.asList(new Integer(3), "d")));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e2 = 2 WHERE pm1.g1.e1 = 'c'"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e2 = 3 WHERE pm1.g1.e1 = 'd'"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, true, FakeMetadataFactory.example1VDB());
        Assert.assertEquals((String)"Unexpected queries executed -", finalQueryList, dataManager.getQueries());
    }

    @Test
    public void testUpdateVarNumCmds() throws Exception {
        String preparedSql = "UPDATE pm1.g1 SET pm1.g1.e1=?, pm1.g1.e3=? WHERE pm1.g1.e2=?";
        SessionAwareCache prepPlanCache = new SessionAwareCache();
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.BATCHED_UPDATES, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ArrayList<String> finalQueryList = new ArrayList<String>(13);
        List[] expected = new List[]{Arrays.asList(new Integer(2)), Arrays.asList(new Integer(2))};
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>(2);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList(null, Boolean.FALSE, new Integer(1))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = null, e3 = FALSE WHERE pm1.g1.e2 = 1"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, FakeMetadataFactory.example1VDB());
        expected = new List[]{Arrays.asList(new Integer(2))};
        values = new ArrayList(1);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, true, FakeMetadataFactory.example1VDB());
        expected = new List[]{Arrays.asList(new Integer(2)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(0)), Arrays.asList(new Integer(0))};
        values = new ArrayList(4);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList(null, Boolean.FALSE, new Integer(1))));
        values.add(new ArrayList<Object>(Arrays.asList("c", Boolean.TRUE, new Integer(4))));
        values.add(new ArrayList<Object>(Arrays.asList("b", Boolean.TRUE, new Integer(5))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = null, e3 = FALSE WHERE pm1.g1.e2 = 1"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'c', e3 = TRUE WHERE pm1.g1.e2 = 4"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'b', e3 = TRUE WHERE pm1.g1.e2 = 5"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, true, FakeMetadataFactory.example1VDB());
        Assert.assertEquals((String)"Unexpected queries executed -", finalQueryList, dataManager.getQueries());
    }

    @Test
    public void testUpdateVarNumCmds_Virtual() throws Exception {
        String preparedSql = "UPDATE vm1.g1 SET vm1.g1.e1=?, vm1.g1.e3=? WHERE vm1.g1.e2=?";
        SessionAwareCache prepPlanCache = new SessionAwareCache();
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.BATCHED_UPDATES, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ArrayList<String> finalQueryList = new ArrayList<String>(13);
        List[] expected = new List[]{Arrays.asList(2), Arrays.asList(2)};
        ArrayList<ArrayList<Object>> values = new ArrayList<ArrayList<Object>>(2);
        values.add(new ArrayList<Object>(Arrays.asList("a", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList("b", Boolean.TRUE, new Integer(1))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'a', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'b', e3 = TRUE WHERE pm1.g1.e2 = 1"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, false, FakeMetadataFactory.example1VDB());
        expected = new List[]{Arrays.asList(new Integer(2))};
        values = new ArrayList(1);
        values.add(new ArrayList<Object>(Arrays.asList("c", Boolean.FALSE, new Integer(1))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'c', e3 = FALSE WHERE pm1.g1.e2 = 1"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, true, FakeMetadataFactory.example1VDB());
        expected = new List[]{Arrays.asList(2), Arrays.asList(2), Arrays.asList(1), Arrays.asList(1)};
        values = new ArrayList(4);
        values.add(new ArrayList<Object>(Arrays.asList("d", Boolean.FALSE, new Integer(1))));
        values.add(new ArrayList<Object>(Arrays.asList("e", Boolean.FALSE, new Integer(0))));
        values.add(new ArrayList<Object>(Arrays.asList("f", Boolean.TRUE, new Integer(2))));
        values.add(new ArrayList<Object>(Arrays.asList("g", Boolean.TRUE, new Integer(3))));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'd', e3 = FALSE WHERE pm1.g1.e2 = 1"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'e', e3 = FALSE WHERE pm1.g1.e2 = 0"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'f', e3 = TRUE WHERE pm1.g1.e2 = 2"));
        finalQueryList.add(new String("UPDATE pm1.g1 SET e1 = 'g', e3 = TRUE WHERE pm1.g1.e2 = 3"));
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, capFinder, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)prepPlanCache, false, false, true, FakeMetadataFactory.example1VDB());
        Assert.assertEquals((String)"Unexpected queries executed -", finalQueryList, dataManager.getQueries());
    }
}

