/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import java.util.HashSet;
import junit.framework.TestCase;
import org.teiid.dqp.internal.process.multisource.MultiSourceElementReplacementVisitor;
import org.teiid.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.navigator.DeepPostOrderNavigator;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestMultiSourceElementReplacementVisitor
extends TestCase {
    public QueryMetadataInterface getMetadata() throws Exception {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleMultiBinding();
        HashSet<String> multiSourceModels = new HashSet<String>();
        multiSourceModels.add("MultiModel");
        MultiSourceMetadataWrapper wrapper = new MultiSourceMetadataWrapper((QueryMetadataInterface)metadata, multiSourceModels);
        return wrapper;
    }

    public void helpTest(String sql, QueryMetadataInterface metadata, String expected) throws Exception {
        QueryParser parser = new QueryParser();
        Command command = parser.parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        MultiSourceElementReplacementVisitor visitor = new MultiSourceElementReplacementVisitor("x");
        DeepPostOrderNavigator.doVisit((LanguageObject)command, (LanguageVisitor)visitor);
        TestMultiSourceElementReplacementVisitor.assertEquals((String)expected, (String)command.toString());
    }

    public void testCommon() throws Exception {
        this.helpTest("SELECT a, b, SOURCE_NAME FROM MultiModel.Phys WHERE SOURCE_NAME = SOURCE_NAME", this.getMetadata(), "SELECT a, b, 'x' FROM MultiModel.Phys WHERE 'x' = 'x'");
    }

    public void testLike() throws Exception {
        this.helpTest("SELECT a, b FROM MultiModel.Phys WHERE SOURCE_NAME LIKE SOURCE_NAME", this.getMetadata(), "SELECT a, b FROM MultiModel.Phys WHERE 'x' LIKE 'x'");
    }

    public void testIn() throws Exception {
        this.helpTest("SELECT a, b FROM MultiModel.Phys WHERE SOURCE_NAME IN ('a', 'b', SOURCE_NAME)", this.getMetadata(), "SELECT a, b FROM MultiModel.Phys WHERE 'x' IN ('a', 'b', 'x')");
    }

    public void testNot() throws Exception {
        this.helpTest("SELECT a, b FROM MultiModel.Phys WHERE NOT (SOURCE_NAME IN ('a', 'b', SOURCE_NAME))", this.getMetadata(), "SELECT a, b FROM MultiModel.Phys WHERE NOT ('x' IN ('a', 'b', 'x'))");
    }

    public void testCompound() throws Exception {
        this.helpTest("SELECT a, b FROM MultiModel.Phys WHERE ('x' IN ('a', 'b', SOURCE_NAME)) AND (SOURCE_NAME = 'y')", this.getMetadata(), "SELECT a, b FROM MultiModel.Phys WHERE ('x' IN ('a', 'b', 'x')) AND ('x' = 'y')");
    }

    public void testFunction() throws Exception {
        this.helpTest("SELECT length(concat(SOURCE_NAME, 'a')) FROM MultiModel.Phys", this.getMetadata(), "SELECT length(concat('x', 'a')) FROM MultiModel.Phys");
    }

    public void testBetween() throws Exception {
        this.helpTest("SELECT SOURCE_NAME FROM MultiModel.Phys WHERE SOURCE_NAME BETWEEN SOURCE_NAME AND SOURCE_NAME", this.getMetadata(), "SELECT 'x' FROM MultiModel.Phys WHERE 'x' BETWEEN 'x' AND 'x'");
    }

    public void testIsNull() throws Exception {
        this.helpTest("SELECT a FROM MultiModel.Phys WHERE SOURCE_NAME IS NULL", this.getMetadata(), "SELECT a FROM MultiModel.Phys WHERE 'x' IS NULL");
    }

    public void testInSubquery() throws Exception {
        this.helpTest("SELECT a FROM MultiModel.Phys WHERE SOURCE_NAME IN (SELECT b FROM MultiModel.Phys WHERE SOURCE_NAME IN ('x'))", this.getMetadata(), "SELECT a FROM MultiModel.Phys WHERE 'x' IN (SELECT b FROM MultiModel.Phys WHERE 'x' IN ('x'))");
    }

    public void testCompareSubquery() throws Exception {
        this.helpTest("SELECT a FROM MultiModel.Phys WHERE SOURCE_NAME = (SELECT b FROM MultiModel.Phys WHERE SOURCE_NAME IN ('x'))", this.getMetadata(), "SELECT a FROM MultiModel.Phys WHERE 'x' = (SELECT b FROM MultiModel.Phys WHERE 'x' IN ('x'))");
    }
}

