/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.service;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.ConnectorWorkItem;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.TranslatorException;

public class AutoGenDataService
extends ConnectorManager {
    private int rows = 10;
    private SourceCapabilities caps = new BasicSourceCapabilities();
    public boolean throwExceptionOnExecute;
    public int dataNotAvailable = -1;
    private static final String STRING_VAL = "ABCDEFG";
    private static final Integer INTEGER_VAL = new Integer(0);
    private static final Long LONG_VAL = new Long(0L);
    private static final Float FLOAT_VAL = new Float(0.0);
    private static final Short SHORT_VAL = new Short(0);
    private static final Double DOUBLE_VAL = new Double(0.0);
    private static final Character CHAR_VAL = new Character('c');
    private static final Byte BYTE_VAL = new Byte(0);
    private static final Boolean BOOLEAN_VAL = Boolean.FALSE;
    private static final BigInteger BIG_INTEGER_VAL = new BigInteger("0");
    private static final BigDecimal BIG_DECIMAL_VAL = new BigDecimal("0");
    private static final Date SQL_DATE_VAL = new Date(0L);
    private static final Time TIME_VAL = new Time(0L);
    private static final Timestamp TIMESTAMP_VAL = new Timestamp(0L);

    public AutoGenDataService() {
        super("FakeConnector", "FakeConnector");
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getRows() {
        return this.rows;
    }

    public ConnectorWork registerRequest(AtomicRequestMessage message) throws TeiidComponentException {
        if (this.throwExceptionOnExecute) {
            throw new TeiidComponentException("Connector Exception");
        }
        List projectedSymbols = message.getCommand().getProjectedSymbols();
        List[] results = this.createResults(projectedSymbols);
        final AtomicResultsMessage msg = ConnectorWorkItem.createResultsMessage((List[])results, (List)projectedSymbols);
        msg.setFinalRow(this.rows);
        return new ConnectorWork(){

            public AtomicResultsMessage more() throws TranslatorException {
                throw new RuntimeException("Should not be called");
            }

            public AtomicResultsMessage execute() throws TranslatorException {
                if (AutoGenDataService.this.dataNotAvailable > -1) {
                    int delay = AutoGenDataService.this.dataNotAvailable;
                    AutoGenDataService.this.dataNotAvailable = -1;
                    throw new DataNotAvailableException((long)delay);
                }
                return msg;
            }

            public void close() {
            }

            public void cancel() {
            }
        };
    }

    private List[] createResults(List symbols) {
        List[] rows = new List[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (SingleElementSymbol symbol : symbols) {
                Class type = symbol.getType();
                row.add(this.getValue(type));
            }
        }
        return rows;
    }

    private Object getValue(Class<?> type) {
        if (type.equals(DataTypeManager.DefaultDataClasses.STRING)) {
            return STRING_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.INTEGER)) {
            return INTEGER_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.SHORT)) {
            return SHORT_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.LONG)) {
            return LONG_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.FLOAT)) {
            return FLOAT_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.DOUBLE)) {
            return DOUBLE_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.CHAR)) {
            return CHAR_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BYTE)) {
            return BYTE_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
            return BOOLEAN_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER)) {
            return BIG_INTEGER_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL)) {
            return BIG_DECIMAL_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
            return SQL_DATE_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
            return TIME_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            return TIMESTAMP_VAL;
        }
        return null;
    }

    public SourceCapabilities getCapabilities() {
        return this.caps;
    }
}

