/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.function.metadata.FunctionMetadataReader;
import org.teiid.query.function.metadata.FunctionMethod;
import org.teiid.query.function.metadata.FunctionParameter;

public class TestFunctionMetadataReader
extends TestCase {
    public void testLoadFunctionMethods() throws Exception {
        List fns = FunctionMetadataReader.loadFunctionMethods((InputStream)new FileInputStream(UnitTestUtil.getTestDataPath() + File.separator + "udf.xmi"));
        TestFunctionMetadataReader.assertEquals((int)3, (int)fns.size());
        for (FunctionMethod m : fns) {
            if (m.getName().equals("GetSystemProperty")) {
                TestFunctionMetadataReader.assertEquals((String)"MyFunctions", (String)m.getCategory());
                TestFunctionMetadataReader.assertEquals((String)"com.metamatrix.dqp.embedded.udf.MyFunctions", (String)m.getInvocationClass());
                TestFunctionMetadataReader.assertEquals((String)"getProperty", (String)m.getInvocationMethod());
                TestFunctionMetadataReader.assertEquals((int)0, (int)m.getPushdown());
                TestFunctionMetadataReader.assertEquals((int)0, (int)m.getDeterministic());
                TestFunctionMetadataReader.assertNull((Object)m.getDescription());
                TestFunctionMetadataReader.assertEquals((int)1, (int)m.getInputParameterCount());
                FunctionParameter in = m.getInputParameters()[0];
                TestFunctionMetadataReader.assertEquals((String)"prop", (String)in.getName());
                TestFunctionMetadataReader.assertEquals((String)"string", (String)in.getType());
                TestFunctionMetadataReader.assertNull((Object)in.getDescription());
                TestFunctionMetadataReader.assertNotNull((Object)m.getOutputParameter());
                TestFunctionMetadataReader.assertEquals((String)"result", (String)m.getOutputParameter().getName());
                TestFunctionMetadataReader.assertEquals((String)"string", (String)m.getOutputParameter().getType());
                continue;
            }
            if (m.getName().equals("getpushdown")) {
                TestFunctionMetadataReader.assertEquals((String)"MyFunctions", (String)m.getCategory());
                TestFunctionMetadataReader.assertEquals((String)"com.metamatrix.dqp.embedded.udf.MyFunctions", (String)m.getInvocationClass());
                TestFunctionMetadataReader.assertEquals((String)"getPropertyNoArgs", (String)m.getInvocationMethod());
                TestFunctionMetadataReader.assertEquals((int)1, (int)m.getPushdown());
                TestFunctionMetadataReader.assertEquals((int)0, (int)m.getDeterministic());
                TestFunctionMetadataReader.assertNull((Object)m.getDescription());
                TestFunctionMetadataReader.assertEquals((int)0, (int)m.getInputParameterCount());
                TestFunctionMetadataReader.assertNotNull((Object)m.getOutputParameter());
                TestFunctionMetadataReader.assertEquals((String)"result", (String)m.getOutputParameter().getName());
                TestFunctionMetadataReader.assertEquals((String)"string", (String)m.getOutputParameter().getType());
                continue;
            }
            if (m.getName().equals("getxyz")) {
                TestFunctionMetadataReader.assertEquals((String)"MyFunctions", (String)m.getCategory());
                TestFunctionMetadataReader.assertEquals((String)"com.metamatrix.dqp.embedded.udf.MyFunctions", (String)m.getInvocationClass());
                TestFunctionMetadataReader.assertEquals((String)"getPropertyNoArgs", (String)m.getInvocationMethod());
                TestFunctionMetadataReader.assertEquals((int)0, (int)m.getPushdown());
                TestFunctionMetadataReader.assertEquals((int)5, (int)m.getDeterministic());
                TestFunctionMetadataReader.assertNull((Object)m.getDescription());
                TestFunctionMetadataReader.assertEquals((int)0, (int)m.getInputParameterCount());
                TestFunctionMetadataReader.assertNotNull((Object)m.getOutputParameter());
                TestFunctionMetadataReader.assertEquals((String)"result", (String)m.getOutputParameter().getName());
                TestFunctionMetadataReader.assertEquals((String)"string", (String)m.getOutputParameter().getType());
                continue;
            }
            TestFunctionMetadataReader.fail((String)"unknown method");
        }
    }
}

