/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.logging.LogManager;
import org.teiid.query.function.FunctionForm;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.function.UDFSource;
import org.teiid.query.function.metadata.FunctionMethod;
import org.teiid.query.function.metadata.FunctionParameter;
import org.teiid.query.function.source.SystemSource;

public class TestFunctionTree
extends TestCase {
    public TestFunctionTree(String name) {
        super(name);
    }

    public void testWalkTree() {
        SystemSource source = new SystemSource();
        FunctionTree ft = new FunctionTree((FunctionMetadataSource)source);
        Collection categories = ft.getCategories();
        for (String category : categories) {
            LogManager.logInfo((String)"test", (String)("Category: " + category));
            Collection functions = ft.getFunctionForms(category);
            for (FunctionForm form : functions) {
                LogManager.logInfo((String)"test", (String)("\tFunction: " + form.getDisplayString()));
            }
        }
    }

    public void testUnloadableFunction() {
        FunctionMetadataSource dummySource = new FunctionMetadataSource(){

            public Collection getFunctionMethods() {
                FunctionMethod method = new FunctionMethod("dummy", null, "no category", "nonexistentClass", "noMethod", new FunctionParameter[0], new FunctionParameter("output", "string"));
                ArrayList<FunctionMethod> methods = new ArrayList<FunctionMethod>();
                methods.add(method);
                return methods;
            }

            public Class getInvocationClass(String className) throws ClassNotFoundException {
                throw new ClassNotFoundException("Could not find class " + className);
            }
        };
        new FunctionLibrary(SystemFunctionManager.getSystemFunctions(), new FunctionTree((FunctionMetadataSource)new UDFSource(dummySource.getFunctionMethods())));
    }

    public void testNullCategory() {
        FunctionMetadataSource fms = (FunctionMetadataSource)Mockito.mock(FunctionMetadataSource.class);
        Mockito.stub((Object)fms.getFunctionMethods()).toReturn(Arrays.asList(new FunctionMethod("dummy", null, null, 2, "nonexistentClass", "noMethod", new FunctionParameter[0], new FunctionParameter("output", "string"))));
        FunctionTree ft = new FunctionTree(fms);
        TestFunctionTree.assertEquals((int)1, (int)ft.getFunctionForms("Miscellaneous").size());
    }
}

