/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.metadata;

import junit.framework.TestCase;
import org.teiid.api.exception.query.FunctionMetadataException;
import org.teiid.query.function.metadata.FunctionMetadataValidator;

public class TestFunctionMetadataValidator
extends TestCase {
    public TestFunctionMetadataValidator(String name) {
        super(name);
    }

    public void helpTestValidateName(String name) {
        try {
            FunctionMetadataValidator.validateName((String)name);
        }
        catch (FunctionMetadataException e) {
            TestFunctionMetadataValidator.fail((String)("Got exception but did not expect it: " + e.getMessage()));
        }
    }

    public void helpTestValidateNameFail(String name) {
        try {
            FunctionMetadataValidator.validateName((String)name);
            TestFunctionMetadataValidator.fail((String)"Expected exception but did not get one");
        }
        catch (FunctionMetadataException functionMetadataException) {
            // empty catch block
        }
    }

    public void helpTestValidateFunction(String className, String methodName, int pushdown) {
        try {
            FunctionMetadataValidator.validateInvocationMethod((String)className, (String)methodName, (int)pushdown);
        }
        catch (FunctionMetadataException e) {
            TestFunctionMetadataValidator.fail((String)("Got exception but did not expect it: " + e.getMessage()));
        }
    }

    public void helpTestValidateFunctionFail(String className, String methodName, int pushdown) {
        try {
            FunctionMetadataValidator.validateInvocationMethod((String)className, (String)methodName, (int)pushdown);
            TestFunctionMetadataValidator.fail((String)"Expected exception but did not get one");
        }
        catch (FunctionMetadataException e) {
            // empty catch block
        }
    }

    public void testValidateName1() {
        this.helpTestValidateName("abc");
    }

    public void testValidateName2() {
        this.helpTestValidateName("a13");
    }

    public void testValidateName3() {
        this.helpTestValidateName("a_c");
    }

    public void testValidateName4() {
        this.helpTestValidateName("a");
    }

    public void testValidateNameFail1() {
        this.helpTestValidateNameFail(null);
    }

    public void testValidateNameFail2() {
        this.helpTestValidateNameFail("123");
    }

    public void testValidateNameFail3() {
        this.helpTestValidateNameFail("a b");
    }

    public void testValidateFunction1() {
        this.helpTestValidateFunction("a", "b", 0);
    }

    public void testValidateFunction2() {
        this.helpTestValidateFunction("a.b", "b", 0);
    }

    public void testValidateFunction3() {
        this.helpTestValidateFunction("a.b.c", "b", 0);
    }

    public void testValidateFunction4() {
        this.helpTestValidateFunction("a$1", "b", 0);
    }

    public void testValidateFunction5() {
        this.helpTestValidateFunction(null, null, 2);
    }

    public void testValidateFunctionFail1() {
        this.helpTestValidateFunctionFail(null, null, 0);
    }

    public void testValidateFunctionFail2() {
        this.helpTestValidateFunctionFail(null, "a", 0);
    }

    public void testValidateFunctionFail3() {
        this.helpTestValidateFunctionFail("a", null, 0);
    }

    public void testValidateFunctionFail4() {
        this.helpTestValidateFunctionFail("1", "b", 0);
    }

    public void testValidateFunctionFail5() {
        this.helpTestValidateFunctionFail("a", "2", 0);
    }

    public void testValidateFunctionFail6() {
        this.helpTestValidateFunctionFail("a@(", "b", 0);
    }

    public void testValidateFunctionFail7() {
        this.helpTestValidateFunctionFail("a.b.", "b", 0);
    }

    public void testValidateFunctionFail8() {
        this.helpTestValidateFunctionFail("a", "b.c", 0);
    }

    public void testValidateFunctionFail9() {
        this.helpTestValidateFunctionFail("a", "b@", 0);
    }

    public void testValidateFunctionFail10() {
        this.helpTestValidateFunctionFail(null, null, 0);
        this.helpTestValidateFunctionFail(null, null, 1);
    }
}

