/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestSortOptimization {
    @Test
    public void testSortDupCombination() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select distinct e1, e2 from pm1.g1 order by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testSortDupCombination1() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select e1, e2 from pm1.g1 union select e1, e2 from pm1.g2 order by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1", "SELECT e1, e2 FROM pm1.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
        TestOptimizer.checkNodeTypes(plan, new int[]{1}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testSortDupCombination2() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select x.*, y.* from (select distinct e1, e2 from pm1.g1) x, (select distinct e1, e2 from pm1.g2) y where x.e1 = y.e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT e1, e2 FROM pm1.g1", "SELECT e1, e2 FROM pm1.g2"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkNodeTypes(plan, new int[]{0}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testGroupDupCombination() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select max(e1), e2 from (select distinct e1, e2 from pm1.g1) x group by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkNodeTypes(plan, new int[]{0}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }

    @Test
    public void testSortGroupCombination() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select max(e1), e2 from pm1.g1 x group by e2 order by e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e2, pm1.g1.e1 FROM pm1.g1"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0});
        TestOptimizer.checkNodeTypes(plan, new int[]{0}, new Class[]{TestOptimizer.DupRemoveSortNode.class});
    }
}

