/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.HashMap;
import java.util.HashSet;
import junit.framework.TestCase;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TestGroupRecontext
extends TestCase {
    public TestGroupRecontext(String name) {
        super(name);
    }

    public void helpTestRecontextGroup(String oldGroupName, String oldGroupDefinition, String[] knownGroupNames, String expectedName) {
        GroupSymbol oldSymbol = null;
        oldSymbol = oldGroupDefinition == null ? new GroupSymbol(oldGroupName) : new GroupSymbol(oldGroupName, oldGroupDefinition);
        oldSymbol.setMetadataID((Object)oldSymbol.getName());
        HashSet<String> known = new HashSet<String>();
        for (int i = 0; i < knownGroupNames.length; ++i) {
            known.add(knownGroupNames[i].toUpperCase());
        }
        GroupSymbol newSymbol = RulePlaceAccess.recontextSymbol((GroupSymbol)oldSymbol, known);
        TestGroupRecontext.assertEquals((String)"New recontexted group name is not as expected: ", (String)expectedName, (String)newSymbol.getName());
    }

    public void testRecontextGroup1() {
        this.helpTestRecontextGroup("abc", "m.g", new String[0], "abc__1");
    }

    public void testRecontextGroup2() {
        this.helpTestRecontextGroup("m.g", null, new String[0], "g__1");
    }

    public void testRecontextGroup3() {
        this.helpTestRecontextGroup("abc__1", "m.g", new String[0], "abc__2");
    }

    public void testRecontextGroup4() {
        this.helpTestRecontextGroup("abc__x", "m.g", new String[0], "abc__x__1");
    }

    public void testRecontextGroup5() {
        this.helpTestRecontextGroup("abc__x", "m.g", new String[0], "abc__x__1");
    }

    public void testRecontextGroup6() {
        this.helpTestRecontextGroup("abc__", "m.g", new String[0], "abc____1");
    }

    public void testRecontextGroup7() {
        this.helpTestRecontextGroup("abc____1", "m.g", new String[0], "abc____2");
    }

    public void testRecontextGroup8() {
        this.helpTestRecontextGroup("abc", "m.g", new String[]{"abc__1"}, "abc__2");
    }

    public void testRecontextGroup9() {
        this.helpTestRecontextGroup("abc__1", "m.g", new String[]{"abc__2", "abc__3"}, "abc__4");
    }

    public void testRecontextGroup10() {
        this.helpTestRecontextGroup("m.c.g", null, new String[]{"g__1"}, "g__2");
    }

    public void testRecontextGroup11() {
        this.helpTestRecontextGroup("m.c.g", null, new String[]{"G__1"}, "g__2");
    }

    public void testConvertSubqueryCompareCriteria() throws Exception {
        ElementSymbol e1 = new ElementSymbol("e1");
        ElementSymbol x1 = new ElementSymbol("x1");
        HashMap<ElementSymbol, ElementSymbol> symbolMap = new HashMap<ElementSymbol, ElementSymbol>();
        symbolMap.put(e1, x1);
        Query query = new Query();
        SubqueryCompareCriteria crit = new SubqueryCompareCriteria((Expression)e1, (Command)query, 1, 4);
        SubqueryCompareCriteria expected = new SubqueryCompareCriteria((Expression)x1, (Command)query, 1, 4);
        FrameUtil.convertCriteria((Criteria)crit, symbolMap, null, (boolean)true);
        TestGroupRecontext.assertEquals((Object)crit, (Object)expected);
    }
}

