/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.processor.FakeTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.util.CommandContext;

public class HardcodedDataManager
implements ProcessorDataManager {
    private Map data = new HashMap();
    private Set validModels;
    private boolean mustRegisterCommands = true;
    private boolean blockOnce;
    private List commandHistory = new ArrayList();

    public HardcodedDataManager() {
        this(true);
    }

    public HardcodedDataManager(boolean mustRegisterCommands) {
        this.mustRegisterCommands = mustRegisterCommands;
    }

    public void addData(String sql, List[] rows) {
        this.data.put(sql, rows);
    }

    public void clearData() {
        this.data.clear();
        this.commandHistory.clear();
    }

    public void setBlockOnce(boolean blockOnce) {
        this.blockOnce = blockOnce;
    }

    public void setValidModels(Set models) {
        this.validModels = models;
    }

    public List getCommandHistory() {
        return this.commandHistory;
    }

    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException {
        return null;
    }

    public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID) throws TeiidComponentException {
        if (modelName != null && this.validModels != null && !this.validModels.contains(modelName)) {
            throw new TeiidComponentException("Detected query against invalid model: " + modelName + ": " + command);
        }
        this.commandHistory.add(command);
        List projectedSymbols = command.getProjectedSymbols();
        List[] rows = (List[])this.data.get(command.toString());
        if (rows == null) {
            if (this.mustRegisterCommands) {
                throw new TeiidComponentException("Unknown command: " + command.toString());
            }
            rows = new List[]{new ArrayList()};
            for (int i = 0; i < projectedSymbols.size(); ++i) {
                rows[0].add(null);
            }
        }
        FakeTupleSource source = new FakeTupleSource(projectedSymbols, rows);
        if (this.blockOnce) {
            source.setBlockOnce();
        }
        return source;
    }

    public void setMustRegisterCommands(boolean mustRegisterCommands) {
        this.mustRegisterCommands = mustRegisterCommands;
    }

    public void clearCodeTables() {
    }
}

