/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestOptionalJoins {
    @Test
    public void testOptionalJoinNode1() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, /* optional */ pm1.g2 where pm1.g1.e1 = 'a'";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode2() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, /* optional */ pm1.g2, pm1.g3 where pm1.g1.e1 = 'a' and pm1.g1.e1 = pm1.g3.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode3() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1 LEFT OUTER JOIN /* optional */ pm1.g2 on pm1.g1.e1 = pm1.g2.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode4() {
        String sql = "SELECT pm1.g1.e1 FROM (pm1.g1 LEFT OUTER JOIN /* optional */ pm1.g2 on pm1.g1.e1 = pm1.g2.e1) LEFT OUTER JOIN /* optional */ pm1.g3 on pm1.g1.e1 = pm1.g3.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode5() {
        String sql = "SELECT pm1.g1.e1 FROM (pm1.g1 LEFT OUTER JOIN pm1.g2 on pm1.g1.e1 = pm1.g2.e1) LEFT OUTER JOIN /* optional */ pm1.g3 on pm1.g1.e1 = pm1.g3.e1";
        List[] expected = new List[]{Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode6() {
        String sql = "SELECT pm1.g1.e1 FROM (pm1.g1 LEFT OUTER JOIN /* optional */ pm1.g2 on pm1.g1.e1 = pm1.g2.e1) LEFT OUTER JOIN pm1.g3 on pm1.g1.e1 = pm1.g3.e1";
        List[] expected = new List[]{Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode7() {
        String sql = "SELECT pm1.g3.e1 FROM /* optional */ (pm1.g1 LEFT OUTER JOIN pm1.g2 on pm1.g1.e1 = pm1.g2.e1) LEFT OUTER JOIN pm1.g3 on pm1.g1.e1 = pm1.g3.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode8() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1 LEFT OUTER JOIN /* optional */ (select * from pm1.g2) as X on pm1.g1.e1 = x.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode9() {
        String sql = "SELECT pm1.g2.e1 FROM pm1.g2, /* optional */ vm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode10() {
        String sql = "SELECT pm1.g1.e1 FROM /* optional */ vm1.g1, pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode11() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1 LEFT OUTER JOIN /* optional */ vm1.g2 on pm1.g1.e1 = vm1.g2.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode12() {
        String sql = "SELECT pm1.g3.e1 FROM /* optional */ (pm1.g1 LEFT OUTER JOIN vm1.g1 on pm1.g1.e1 = vm1.g1.e1) LEFT OUTER JOIN pm1.g3 on pm1.g1.e1 = pm1.g3.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode13() {
        String sql = "SELECT count(pm1.g1.e1) FROM pm1.g1 LEFT OUTER JOIN /* optional */ pm1.g2 on pm1.g1.e1 = pm1.g2.e1";
        List[] expected = new List[]{Arrays.asList(new Integer(5))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode15() {
        String sql = "SELECT x.e1 FROM (select vm1.g1.e1, vm1.g2.e2 from vm1.g1 LEFT OUTER JOIN /* optional */vm1.g2 on vm1.g1.e2 = vm1.g2.e2) AS x";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode16() {
        String sql = "SELECT x.e1 FROM (select vm1.g1.e1, vm1.g2.e2 from vm1.g1 LEFT OUTER JOIN /* optional */vm1.g2 on vm1.g1.e2 = vm1.g2.e2) AS x order by x.e1";
        List[] expected = new List[]{Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode17() {
        String sql = "SELECT length(z) FROM /* optional */ pm1.g1, (select distinct e2 as y, e3 || 'x' as z from pm1.g1 ORDER BY y, z) AS x";
        List[] expected = new List[]{Arrays.asList(new Integer(6)), Arrays.asList(new Integer(6)), Arrays.asList(new Integer(5)), Arrays.asList(new Integer(6)), Arrays.asList(new Integer(5))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode18() {
        String sql = "SELECT x.e1 FROM (select vm1.g1.e1, vm1.g2.e2 from vm1.g1 LEFT OUTER JOIN /* optional */vm1.g2 on vm1.g1.e2 = vm1.g2.e2) AS x";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOptionalJoinNode19() {
        String sql = "SELECT length(z) FROM /* optional */ pm1.g1 inner join (select e2 as y, e3 || 'x' as z from pm1.g1 ORDER BY z) AS x on pm1.g1.e2=x.y";
        List[] expected = new List[]{Arrays.asList(new Integer(6)), Arrays.asList(new Integer(6)), Arrays.asList(new Integer(5)), Arrays.asList(new Integer(5)), Arrays.asList(new Integer(6)), Arrays.asList(new Integer(6))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }
}

